/* The following code was generated by JFlex 1.7.0 tweaked for IntelliJ platform */

package org.jetbrains.kotlin.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>/Users/jetbrains/projects/dup_kotlin/kotlin/compiler/psi/src/org/jetbrains/kotlin/lexer/Kotlin.flex</tt>
 */
class _JetLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRING = 2;
  public static final int RAW_STRING = 4;
  public static final int SHORT_TEMPLATE_ENTRY = 6;
  public static final int BLOCK_COMMENT = 8;
  public static final int DOC_COMMENT = 10;
  public static final int LONG_TEMPLATE_ENTRY = 12;
  public static final int UNMATCHED_BACKTICK = 14;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  4,  4,  5,  5,  0, 0
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [11, 6, 4]
   * Total runtime size is 14336 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[(ZZ_CMAP_Z[ch>>10]<<6)|((ch>>4)&0x3f)]<<4)|(ch&0xf)];
  }

  /* The ZZ_CMAP_Z table has 1088 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\2\11\1\12\1\13\6\14\1\15\23\14\1\16"+
    "\1\14\1\17\1\20\12\14\1\21\10\11\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1"+
    "\32\1\33\1\34\1\35\2\11\1\14\1\36\3\11\1\37\10\11\1\40\1\41\5\14\1\42\1\43"+
    "\11\11\1\44\2\11\1\45\5\11\1\46\4\11\1\47\1\50\4\11\51\14\1\51\3\14\1\52\1"+
    "\53\4\14\1\54\12\11\1\55\u0381\11");

  /* The ZZ_CMAP_Y table has 2944 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\1\1\11\1\12\1\13\1\14\1\13\1\14\34"+
    "\13\1\15\1\16\1\17\10\1\1\20\1\21\1\13\1\22\4\13\1\23\10\13\1\24\12\13\1\25"+
    "\1\13\1\26\1\25\1\13\1\27\4\1\1\13\1\30\1\31\2\1\2\13\1\30\1\1\1\32\1\25\5"+
    "\13\1\33\1\34\1\35\1\1\1\36\1\13\1\1\1\37\5\13\1\40\1\41\1\42\1\13\1\30\1"+
    "\43\1\13\1\44\1\45\1\1\1\13\1\46\4\1\1\13\1\47\4\1\1\50\2\13\1\51\1\1\1\52"+
    "\1\53\1\25\1\54\1\55\1\56\1\57\1\60\1\61\1\53\1\16\1\62\1\55\1\56\1\63\1\1"+
    "\1\64\1\65\1\66\1\67\1\22\1\56\1\70\1\1\1\71\1\53\1\72\1\73\1\55\1\56\1\70"+
    "\1\1\1\61\1\53\1\41\1\74\1\75\1\76\1\77\1\1\1\71\1\65\1\1\1\100\1\36\1\56"+
    "\1\51\1\1\1\101\1\53\1\1\1\102\1\36\1\56\1\103\1\1\1\60\1\53\1\104\1\100\1"+
    "\36\1\13\1\105\1\60\1\106\1\53\1\107\1\110\1\111\1\13\1\112\1\113\1\1\1\65"+
    "\1\1\1\25\2\13\1\114\1\113\1\115\2\1\1\116\1\117\1\120\1\121\1\122\1\123\2"+
    "\1\1\71\1\1\1\115\1\1\1\124\1\13\1\125\1\1\1\126\7\1\2\13\1\30\1\127\1\115"+
    "\1\130\1\131\1\132\1\133\1\115\2\13\1\134\2\13\1\135\24\13\1\136\1\137\2\13"+
    "\1\136\2\13\1\140\1\141\1\14\3\13\1\141\3\13\1\30\2\1\1\13\1\1\5\13\1\142"+
    "\1\25\45\13\1\143\1\13\1\25\1\30\4\13\1\30\1\144\1\145\1\16\1\13\1\16\1\13"+
    "\1\16\1\145\1\71\3\13\1\146\1\1\1\147\1\115\2\1\1\115\5\13\1\27\1\150\1\13"+
    "\1\151\4\13\1\40\1\13\1\152\2\1\1\65\1\13\1\153\1\154\2\13\1\155\1\13\1\77"+
    "\1\115\2\1\1\13\1\113\3\13\1\154\2\1\2\115\1\156\5\1\1\110\2\13\1\146\1\157"+
    "\1\115\2\1\1\160\1\13\1\161\1\42\2\13\1\40\1\1\2\13\1\146\1\1\1\162\1\42\1"+
    "\13\1\153\1\46\5\1\1\163\1\164\14\13\4\1\21\13\1\142\2\13\1\142\1\165\1\13"+
    "\1\153\3\13\1\166\1\167\1\170\1\125\1\167\2\1\1\171\4\1\1\172\1\1\1\125\6"+
    "\1\1\173\1\174\1\175\1\176\1\177\3\1\1\200\147\1\2\13\1\152\2\13\1\152\10"+
    "\13\1\201\1\202\2\13\1\134\3\13\1\203\1\1\1\13\1\113\4\204\4\1\1\127\35\1"+
    "\1\205\2\1\1\206\1\25\4\13\1\207\1\25\4\13\1\135\1\110\1\13\1\153\1\25\4\13"+
    "\1\152\1\1\1\13\1\30\3\1\1\13\40\1\133\13\1\40\4\1\135\13\1\40\2\1\10\13\1"+
    "\125\4\1\2\13\1\153\20\13\1\125\1\13\1\210\1\1\2\13\1\152\1\127\1\13\1\153"+
    "\4\13\1\40\2\1\1\211\1\212\5\13\1\213\1\13\1\152\1\27\3\1\1\211\1\214\1\13"+
    "\1\31\1\1\3\13\1\146\1\212\2\13\1\146\1\1\1\115\1\1\1\215\1\42\1\13\1\40\1"+
    "\13\1\113\1\1\1\13\1\125\1\50\2\13\1\31\1\127\1\115\1\216\1\217\2\13\1\46"+
    "\1\1\1\220\1\115\1\13\1\221\3\13\1\222\1\223\1\224\1\30\1\66\1\225\1\226\1"+
    "\204\2\13\1\135\1\40\7\13\1\31\1\115\72\13\1\146\1\13\1\227\2\13\1\155\20"+
    "\1\26\13\1\153\6\13\1\77\2\1\1\113\1\230\1\56\1\231\1\232\6\13\1\16\1\1\1"+
    "\160\25\13\1\153\1\1\4\13\1\212\2\13\1\27\2\1\1\155\7\1\1\216\7\13\1\125\1"+
    "\1\1\115\1\25\1\30\1\25\1\30\1\233\4\13\1\152\1\234\1\235\2\1\1\236\1\13\1"+
    "\14\1\237\2\153\2\1\7\13\1\30\30\1\1\13\1\125\3\13\1\71\2\1\2\13\1\1\1\13"+
    "\1\240\2\13\1\40\1\13\1\153\2\13\1\241\3\1\11\13\1\153\1\115\2\13\1\241\1"+
    "\13\1\155\2\13\1\27\3\13\1\146\11\1\23\13\1\113\1\13\1\40\1\27\11\1\1\242"+
    "\2\13\1\243\1\13\1\40\1\13\1\113\1\13\1\152\4\1\1\13\1\244\1\13\1\40\1\13"+
    "\1\77\4\1\3\13\1\245\4\1\1\71\1\246\1\13\1\146\2\1\1\13\1\125\1\13\1\125\2"+
    "\1\1\124\1\13\1\154\1\1\3\13\1\40\1\13\1\40\1\13\1\31\1\13\1\16\6\1\4\13\1"+
    "\46\3\1\3\13\1\31\3\13\1\31\60\1\1\160\2\13\1\27\2\1\1\65\1\1\1\160\2\13\2"+
    "\1\1\13\1\46\1\115\1\160\1\13\1\113\1\65\1\1\2\13\1\247\1\160\2\13\1\31\1"+
    "\250\1\251\2\1\1\13\1\22\1\155\5\1\1\252\1\253\1\46\2\13\1\152\1\1\1\115\1"+
    "\73\1\55\1\56\1\70\1\1\1\254\1\16\11\1\3\13\1\154\1\255\1\115\2\1\3\13\1\1"+
    "\1\256\1\115\12\1\2\13\1\152\2\1\1\257\2\1\3\13\1\1\1\260\1\115\2\1\2\13\1"+
    "\30\1\1\1\115\3\1\1\13\1\77\1\1\1\115\26\1\4\13\1\115\1\127\34\1\3\13\1\46"+
    "\20\1\1\56\1\13\1\152\1\1\1\71\1\115\1\1\1\212\1\13\67\1\71\13\1\77\16\1\14"+
    "\13\1\146\53\1\2\13\1\152\75\1\44\13\1\113\33\1\43\13\1\46\1\13\1\152\1\115"+
    "\6\1\1\13\1\153\1\1\3\13\1\1\1\146\1\115\1\160\1\261\1\13\67\1\4\13\1\154"+
    "\1\71\3\1\1\160\4\1\1\71\1\1\76\13\1\125\1\1\57\13\1\31\20\1\1\16\77\1\6\13"+
    "\1\30\1\125\1\46\1\77\66\1\5\13\1\216\3\13\1\145\1\262\1\263\1\264\3\13\1"+
    "\265\1\266\1\13\1\267\1\270\1\36\24\13\1\271\1\13\1\36\1\135\1\13\1\135\1"+
    "\13\1\216\1\13\1\216\1\152\1\13\1\152\1\13\1\56\1\13\1\56\1\13\1\272\3\273"+
    "\14\13\1\154\3\1\4\13\1\146\1\115\112\1\1\264\1\13\1\274\1\275\1\276\1\277"+
    "\1\300\1\301\1\302\1\155\1\303\1\155\24\1\55\13\1\113\2\1\103\13\1\154\15"+
    "\13\1\153\150\13\1\16\25\1\41\13\1\153\36\1");

  /* The ZZ_CMAP_A table has 3136 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\1\4\1\10\1\102\1\103\1\102\22\0\1\4\1\14\1\31\1\13\1\11\1\71\1\67\1"+
    "\26\1\75\1\76\1\40\1\64\1\100\1\25\1\22\1\12\1\15\11\1\1\72\1\77\1\65\1\62"+
    "\1\66\1\63\1\101\1\3\1\17\2\3\1\24\1\23\5\5\1\20\10\5\1\21\2\5\1\16\2\5\1"+
    "\73\1\27\1\74\1\0\1\2\1\7\1\44\1\55\1\51\1\61\1\43\1\50\1\54\1\34\1\35\1\56"+
    "\1\53\1\45\1\5\1\46\1\52\1\42\1\5\1\47\1\36\1\33\1\30\1\60\1\57\1\16\1\41"+
    "\1\5\1\32\1\70\1\37\7\0\1\102\24\0\1\5\12\0\1\5\4\0\1\5\5\0\27\5\1\0\12\5"+
    "\4\0\14\5\16\0\5\5\7\0\1\5\1\0\1\5\1\0\5\5\1\0\2\5\2\0\4\5\1\0\1\5\6\0\1\5"+
    "\1\0\3\5\1\0\1\5\1\0\4\5\1\0\23\5\1\0\13\5\10\0\6\5\1\0\26\5\2\0\1\5\6\0\10"+
    "\5\10\0\13\5\5\0\3\5\15\0\12\6\4\0\6\5\1\0\1\5\17\0\2\5\7\0\2\5\12\6\3\5\2"+
    "\0\2\5\1\0\16\5\15\0\11\5\13\0\1\5\16\0\12\6\6\5\4\0\2\5\4\0\1\5\5\0\6\5\4"+
    "\0\1\5\11\0\1\5\3\0\1\5\7\0\11\5\7\0\5\5\1\0\10\5\6\0\26\5\3\0\1\5\2\0\1\5"+
    "\7\0\12\5\4\0\12\6\1\5\4\0\10\5\2\0\2\5\2\0\26\5\1\0\7\5\1\0\1\5\3\0\4\5\3"+
    "\0\1\5\20\0\1\5\15\0\2\5\1\0\1\5\5\0\6\5\4\0\2\5\1\0\2\5\1\0\2\5\1\0\2\5\17"+
    "\0\4\5\1\0\1\5\7\0\12\6\2\0\3\5\20\0\11\5\1\0\2\5\1\0\2\5\1\0\5\5\3\0\1\5"+
    "\2\0\1\5\30\0\1\5\13\0\10\5\2\0\1\5\3\0\1\5\1\0\6\5\3\0\3\5\1\0\4\5\3\0\2"+
    "\5\1\0\1\5\1\0\2\5\3\0\2\5\3\0\3\5\3\0\14\5\13\0\10\5\1\0\2\5\10\0\3\5\5\0"+
    "\1\5\4\0\10\5\1\0\6\5\1\0\5\5\3\0\1\5\3\0\2\5\15\0\13\5\2\0\1\5\6\0\3\5\10"+
    "\0\1\5\12\0\6\5\5\0\22\5\3\0\10\5\1\0\11\5\1\0\1\5\2\0\7\5\11\0\1\5\1\0\2"+
    "\5\14\0\12\6\7\0\2\5\1\0\1\5\2\0\2\5\1\0\1\5\2\0\1\5\6\0\4\5\1\0\7\5\1\0\3"+
    "\5\1\0\1\5\1\0\1\5\2\0\2\5\1\0\4\5\1\0\2\5\11\0\1\5\2\0\5\5\1\0\1\5\11\0\12"+
    "\6\2\0\14\5\1\0\24\5\13\0\5\5\22\0\7\5\4\0\4\5\3\0\1\5\3\0\2\5\7\0\3\5\4\0"+
    "\15\5\14\0\1\5\1\0\6\5\1\0\1\5\5\0\1\5\2\0\13\5\1\0\15\5\1\0\4\5\2\0\7\5\1"+
    "\0\1\5\1\0\4\5\2\0\1\5\1\0\4\5\2\0\7\5\1\0\1\5\1\0\4\5\2\0\16\5\2\0\6\5\2"+
    "\0\15\5\2\0\1\5\1\0\10\5\7\0\15\5\1\0\6\5\23\0\1\5\4\0\1\5\3\0\5\5\2\0\22"+
    "\5\1\0\1\5\5\0\17\5\1\0\16\5\2\0\5\5\13\0\14\5\13\0\1\5\15\0\7\5\7\0\16\5"+
    "\15\0\2\5\12\6\3\0\3\5\11\0\4\5\1\0\4\5\3\0\2\5\11\0\10\5\1\0\1\5\1\0\1\5"+
    "\1\0\1\5\1\0\6\5\1\0\7\5\1\0\1\5\3\0\3\5\1\0\7\5\3\0\4\5\2\0\6\5\14\0\2\102"+
    "\7\0\1\5\15\0\1\5\2\0\1\5\4\0\1\5\2\0\12\5\1\0\1\5\3\0\5\5\6\0\1\5\1\0\1\5"+
    "\1\0\1\5\1\0\4\5\1\0\13\5\2\0\4\5\5\0\5\5\4\0\1\5\4\0\2\5\13\0\5\5\6\0\4\5"+
    "\3\0\2\5\14\0\10\5\7\0\10\5\1\0\7\5\6\0\2\5\12\0\5\5\5\0\2\5\3\0\7\5\6\0\3"+
    "\5\12\6\2\5\13\0\11\5\2\0\27\5\2\0\7\5\1\0\3\5\1\0\4\5\1\0\4\5\2\0\6\5\3\0"+
    "\1\5\1\0\1\5\2\0\5\5\1\0\12\5\12\6\5\5\1\0\3\5\1\0\10\5\4\0\7\5\3\0\1\5\3"+
    "\0\2\5\1\0\1\5\3\0\2\5\2\0\5\5\2\0\1\5\1\0\1\5\30\0\3\5\3\0\6\5\2\0\6\5\2"+
    "\0\6\5\11\0\7\5\4\0\5\5\3\0\5\5\5\0\1\5\1\0\10\5\1\0\5\5\1\0\1\5\1\0\2\5\1"+
    "\0\2\5\1\0\12\5\6\0\12\5\2\0\6\5\2\0\6\5\2\0\6\5\2\0\3\5\3\0\14\5\1\0\16\5"+
    "\1\0\2\5\1\0\2\5\1\0\10\5\6\0\4\5\4\0\16\5\2\0\1\5\1\0\14\5\1\0\2\5\3\0\1"+
    "\5\2\0\4\5\1\0\2\5\12\0\10\5\6\0\6\5\1\0\3\5\1\0\12\5\3\0\1\5\12\0\4\5\13"+
    "\0\12\6\1\5\1\0\1\5\3\0\7\5\1\0\1\5\1\0\4\5\1\0\17\5\1\0\2\5\14\0\3\5\7\0"+
    "\4\5\11\0\2\5\1\0\1\5\20\0\4\5\10\0\1\5\13\0\10\5\5\0\3\5\2\0\1\5\2\0\2\5"+
    "\2\0\4\5\1\0\14\5\1\0\1\5\1\0\7\5\1\0\21\5\1\0\4\5\2\0\10\5\1\0\7\5\1\0\14"+
    "\5\1\0\4\5\1\0\5\5\1\0\1\5\3\0\14\5\2\0\13\5\1\0\10\5\2\0\22\6\1\0\2\5\1\0"+
    "\1\5\2\0\1\5\1\0\12\5\1\0\4\5\1\0\1\5\1\0\1\5\6\0\1\5\4\0\1\5\1\0\1\5\1\0"+
    "\1\5\1\0\3\5\1\0\2\5\1\0\1\5\2\0\1\5\1\0\1\5\1\0\1\5\1\0\1\5\1\0\1\5\1\0\2"+
    "\5\1\0\1\5\2\0\4\5\1\0\7\5\1\0\4\5\1\0\4\5\1\0\1\5\1\0\12\5\1\0\5\5\1\0\3"+
    "\5\1\0\5\5\1\0\5\5");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\6\0\1\1\1\2\1\3\1\4\1\5\1\1\1\6"+
    "\1\7\1\10\1\2\1\11\1\12\1\13\1\14\1\15"+
    "\3\3\1\16\1\17\14\3\1\20\1\21\1\22\1\23"+
    "\1\24\2\1\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\1\37\1\36\1\1\1\40"+
    "\2\36\1\41\1\1\1\41\3\42\1\43\1\44\2\2"+
    "\1\0\2\45\1\0\1\46\1\0\1\47\1\50\1\51"+
    "\1\52\1\0\1\53\1\0\2\2\1\45\1\54\1\55"+
    "\1\56\1\57\2\13\1\0\3\3\1\60\1\61\1\62"+
    "\1\3\1\63\2\3\1\64\13\3\1\65\1\66\1\67"+
    "\1\70\1\71\1\72\1\73\1\74\1\75\1\76\1\77"+
    "\1\100\1\101\1\0\1\102\2\103\2\0\1\41\1\104"+
    "\1\105\1\0\1\106\1\45\1\3\1\0\1\107\1\110"+
    "\1\111\1\112\1\0\1\113\1\114\4\3\1\115\4\3"+
    "\1\116\2\3\1\117\1\3\1\120\6\3\1\121\1\122"+
    "\1\123\2\0\1\124\2\41\1\46\1\125\1\126\1\127"+
    "\2\3\1\130\3\3\1\131\1\132\7\3\1\133\1\101"+
    "\1\0\1\134\1\135\3\3\1\136\2\3\1\137\1\140"+
    "\2\3\1\141\1\142\1\0\1\3\1\143\2\3\1\144"+
    "\1\3\1\145\2\3\1\146\3\3\1\147\1\150\1\151";

  private static int [] zzUnpackAction() {
    int [] result = new int[232];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\104\0\210\0\314\0\u0110\0\u0154\0\u0198\0\u01dc"+
    "\0\u0220\0\u0264\0\u02a8\0\u02ec\0\u0330\0\u0374\0\u03b8\0\u03fc"+
    "\0\u0440\0\u0484\0\u04c8\0\u050c\0\u0198\0\u0550\0\u0594\0\u05d8"+
    "\0\u0198\0\u061c\0\u0660\0\u06a4\0\u06e8\0\u072c\0\u0770\0\u07b4"+
    "\0\u07f8\0\u083c\0\u0880\0\u08c4\0\u0908\0\u094c\0\u0990\0\u0198"+
    "\0\u09d4\0\u0a18\0\u0a5c\0\u0aa0\0\u0ae4\0\u0b28\0\u0b6c\0\u0198"+
    "\0\u0198\0\u0198\0\u0198\0\u0bb0\0\u0198\0\u0198\0\u0bf4\0\u0198"+
    "\0\u0c38\0\u0c7c\0\u0198\0\u0198\0\u0cc0\0\u0d04\0\u0d48\0\u0d8c"+
    "\0\u0198\0\u0dd0\0\u0e14\0\u0198\0\u0198\0\u0e58\0\u0e9c\0\u0ee0"+
    "\0\u0198\0\u0f24\0\u0f68\0\u0fac\0\u0ff0\0\u1034\0\u1078\0\u0198"+
    "\0\u10bc\0\u1100\0\u1144\0\u1188\0\u11cc\0\u1210\0\u1254\0\u1298"+
    "\0\u0198\0\u0198\0\u0198\0\u0198\0\u12dc\0\u1320\0\u1364\0\u13a8"+
    "\0\u13ec\0\u0220\0\u1430\0\u0220\0\u1474\0\u0198\0\u14b8\0\u14fc"+
    "\0\u1540\0\u1584\0\u15c8\0\u160c\0\u1650\0\u1694\0\u16d8\0\u171c"+
    "\0\u1760\0\u17a4\0\u17e8\0\u182c\0\u0220\0\u1870\0\u0198\0\u0198"+
    "\0\u0198\0\u0198\0\u0198\0\u0198\0\u0198\0\u0198\0\u0198\0\u0198"+
    "\0\u18b4\0\u18f8\0\u0198\0\u0198\0\u193c\0\u1980\0\u19c4\0\u1a08"+
    "\0\u0198\0\u0198\0\u1a4c\0\u0198\0\u1a90\0\u0198\0\u1ad4\0\u1b18"+
    "\0\u1b5c\0\u1b5c\0\u0198\0\u1ba0\0\u0198\0\u0198\0\u1be4\0\u1c28"+
    "\0\u1c6c\0\u1cb0\0\u0220\0\u1cf4\0\u1d38\0\u1d7c\0\u1dc0\0\u0198"+
    "\0\u1e04\0\u1e48\0\u0220\0\u1e8c\0\u0220\0\u1ed0\0\u1f14\0\u1f58"+
    "\0\u1f9c\0\u1fe0\0\u2024\0\u0220\0\u0220\0\u0198\0\u2068\0\u20ac"+
    "\0\u1980\0\u0198\0\u20f0\0\u0198\0\u0198\0\u0198\0\u0220\0\u2134"+
    "\0\u2178\0\u0220\0\u21bc\0\u2200\0\u2244\0\u0220\0\u0220\0\u2288"+
    "\0\u22cc\0\u2310\0\u2354\0\u2398\0\u23dc\0\u2420\0\u0220\0\u0198"+
    "\0\u2464\0\u0d04\0\u0220\0\u24a8\0\u24ec\0\u2530\0\u0220\0\u2574"+
    "\0\u25b8\0\u0220\0\u0220\0\u25fc\0\u2640\0\u0220\0\u0220\0\u2684"+
    "\0\u26c8\0\u0220\0\u270c\0\u2750\0\u0220\0\u2794\0\u0220\0\u27d8"+
    "\0\u281c\0\u0220\0\u2860\0\u28a4\0\u28e8\0\u0220\0\u0220\0\u0220";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[232];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\1\10\2\11\1\12\1\11\1\7\1\13\1\12"+
    "\1\14\1\15\1\16\1\17\1\20\4\11\1\21\2\11"+
    "\1\22\1\23\1\7\1\11\1\24\1\25\1\26\1\11"+
    "\1\27\1\30\1\31\1\32\1\11\1\33\1\34\1\35"+
    "\1\11\1\36\1\37\1\40\1\41\1\42\2\11\1\43"+
    "\1\11\1\44\1\45\1\46\1\47\1\50\1\51\1\52"+
    "\1\53\1\54\1\55\1\56\1\57\1\60\1\61\1\62"+
    "\1\63\1\64\1\65\1\66\1\7\1\12\10\67\1\70"+
    "\1\71\15\67\1\72\1\67\1\73\62\67\1\74\1\71"+
    "\15\67\1\74\1\67\1\75\52\67\2\7\2\76\1\7"+
    "\1\76\1\7\1\77\1\0\5\7\4\76\1\7\2\76"+
    "\3\7\1\76\2\7\1\100\3\76\2\7\21\76\20\7"+
    "\2\0\12\101\1\102\25\101\1\103\43\101\1\7\1\10"+
    "\2\11\1\12\1\11\1\7\1\13\1\12\1\14\1\15"+
    "\1\16\1\17\1\20\4\11\1\21\2\11\1\22\1\23"+
    "\1\7\1\11\1\24\1\104\1\26\1\11\1\27\1\30"+
    "\1\105\1\32\1\11\1\33\1\34\1\35\1\11\1\36"+
    "\1\37\1\40\1\41\1\42\2\11\1\43\1\11\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\1\7\1\12\105\0\2\10\12\0\1\10"+
    "\2\0\1\106\1\107\1\110\1\111\1\112\3\0\1\107"+
    "\12\0\1\112\1\0\1\106\2\0\1\111\34\0\3\11"+
    "\1\0\2\11\6\0\5\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\21\11\26\0\1\12\3\0\1\12"+
    "\72\0\1\12\7\113\2\0\73\113\2\0\2\114\1\0"+
    "\1\114\1\0\1\115\6\0\4\114\1\0\2\114\3\0"+
    "\1\114\2\0\4\114\2\0\21\114\34\0\1\116\25\0"+
    "\1\117\21\0\1\120\35\0\1\121\124\0\1\122\24\0"+
    "\1\123\22\0\2\124\12\0\1\124\1\125\1\126\1\106"+
    "\1\107\1\110\1\111\1\112\3\0\1\107\12\0\1\112"+
    "\1\0\1\106\2\0\1\111\4\0\1\126\27\0\1\127"+
    "\13\0\1\127\4\0\1\130\106\0\1\131\34\0\1\132"+
    "\3\0\1\133\15\0\10\23\1\0\15\23\1\134\1\135"+
    "\54\23\31\0\1\136\53\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\1\11\1\137"+
    "\2\11\2\0\1\140\5\11\1\141\12\11\23\0\3\11"+
    "\1\0\2\11\6\0\5\11\1\0\2\11\3\0\1\11"+
    "\2\0\3\11\1\142\2\0\5\11\1\143\1\11\1\144"+
    "\11\11\23\0\3\11\1\0\2\11\6\0\5\11\1\0"+
    "\2\11\3\0\1\145\2\0\4\11\2\0\21\11\104\0"+
    "\1\146\22\0\3\11\1\0\2\11\6\0\5\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\3\11\1\147"+
    "\15\11\23\0\3\11\1\0\2\11\6\0\5\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\4\11\1\150"+
    "\14\11\23\0\3\11\1\0\2\11\6\0\5\11\1\0"+
    "\2\11\3\0\1\11\2\0\3\11\1\151\2\0\21\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\152\2\0\4\11\2\0\21\11\23\0\3\11"+
    "\1\0\2\11\6\0\5\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\2\11\1\153\16\11\23\0\3\11"+
    "\1\0\2\11\6\0\5\11\1\0\2\11\3\0\1\154"+
    "\2\0\4\11\2\0\3\11\1\155\5\11\1\156\7\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\4\11\2\0\4\11\1\157\4\11"+
    "\1\160\7\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\14\11"+
    "\1\161\4\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\6\11"+
    "\1\162\12\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\1\11\1\163\2\11"+
    "\2\0\21\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\3\11"+
    "\1\164\15\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\11\11"+
    "\1\165\7\11\104\0\1\166\3\0\1\167\77\0\1\170"+
    "\1\0\1\171\101\0\1\172\103\0\1\173\110\0\1\174"+
    "\104\0\1\175\75\0\1\176\113\0\1\177\110\0\1\200"+
    "\4\0\10\67\2\0\15\67\1\0\1\67\1\0\52\67"+
    "\2\0\2\201\1\0\1\201\1\0\1\202\6\0\4\201"+
    "\1\0\2\201\3\0\1\201\1\0\1\203\4\201\2\0"+
    "\21\201\22\0\10\204\1\0\17\204\1\205\53\204\31\0"+
    "\1\206\53\0\3\76\1\0\2\76\6\0\5\76\1\0"+
    "\2\76\3\0\1\76\2\0\4\76\2\0\21\76\22\0"+
    "\7\207\2\0\73\207\1\0\3\76\1\0\2\76\6\0"+
    "\5\76\1\0\2\76\3\0\1\76\2\0\1\76\1\210"+
    "\2\76\2\0\21\76\62\0\1\211\55\0\1\212\113\0"+
    "\1\213\101\0\1\106\1\0\1\213\22\0\1\106\37\0"+
    "\1\127\13\0\1\127\4\0\1\214\62\0\2\215\12\0"+
    "\1\215\5\0\1\111\1\0\1\215\22\0\1\111\13\0"+
    "\1\215\17\0\7\113\1\216\1\0\73\113\1\0\3\114"+
    "\1\0\2\114\6\0\5\114\1\0\2\114\3\0\1\114"+
    "\2\0\4\114\2\0\21\114\22\0\7\217\2\0\73\217"+
    "\10\116\1\0\73\116\40\0\1\220\43\0\10\121\1\0"+
    "\73\121\36\0\1\221\7\0\1\222\117\0\1\223\22\0"+
    "\2\124\12\0\1\124\4\0\1\224\1\111\1\112\16\0"+
    "\1\112\4\0\1\111\34\0\3\125\11\0\1\125\1\0"+
    "\1\125\1\106\1\107\1\213\2\125\3\0\1\107\12\0"+
    "\2\125\1\106\2\0\2\125\3\0\1\125\3\0\1\125"+
    "\23\0\2\126\12\0\1\126\2\0\1\106\1\107\1\213"+
    "\5\0\1\107\14\0\1\106\37\0\2\127\12\0\1\127"+
    "\5\0\1\111\1\112\16\0\1\112\4\0\1\111\55\0"+
    "\1\225\61\0\10\23\1\0\73\23\31\0\1\226\53\0"+
    "\3\11\1\0\2\11\6\0\5\11\1\0\2\11\3\0"+
    "\1\11\2\0\2\11\1\227\1\11\2\0\6\11\1\230"+
    "\12\11\23\0\3\11\1\0\2\11\6\0\5\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\1\11\1\231"+
    "\17\11\23\0\3\11\1\0\2\11\6\0\5\11\1\0"+
    "\2\11\3\0\1\232\2\0\4\11\2\0\1\233\20\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\1\234\3\11\2\0\21\11\23\0"+
    "\3\11\1\0\2\11\6\0\5\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\1\11\1\235\17\11\23\0"+
    "\3\11\1\0\2\11\6\0\5\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\10\11\1\236\10\11\23\0"+
    "\3\11\1\0\2\11\6\0\5\11\1\0\2\11\3\0"+
    "\1\11\2\0\3\11\1\237\2\0\21\11\23\0\3\11"+
    "\1\0\2\11\6\0\5\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\21\11\1\0\1\240\21\0\3\11"+
    "\1\0\2\11\6\0\5\11\1\0\2\11\3\0\1\11"+
    "\2\0\4\11\2\0\4\11\1\241\14\11\23\0\3\11"+
    "\1\0\2\11\6\0\5\11\1\0\2\11\3\0\1\11"+
    "\2\0\1\242\3\11\2\0\21\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\5\11\1\243\13\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\4\11\1\244\14\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\6\11\1\245\12\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\3\11\1\246\15\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\5\11\1\247\13\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\15\11\1\250\3\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\2\11\1\251\16\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\2\11\1\252\1\11\2\0\2\11\1\253\16\11\23\0"+
    "\3\11\1\0\2\11\6\0\5\11\1\0\2\11\3\0"+
    "\1\11\2\0\4\11\2\0\4\11\1\254\1\11\1\255"+
    "\12\11\104\0\1\256\22\0\3\201\1\0\2\201\6\0"+
    "\5\201\1\0\2\201\3\0\1\201\2\0\4\201\2\0"+
    "\21\201\22\0\7\257\2\0\73\257\1\0\1\260\1\0"+
    "\1\260\11\0\1\260\1\0\1\260\3\0\2\260\16\0"+
    "\2\260\3\0\2\260\3\0\1\260\3\0\1\260\53\0"+
    "\1\261\52\0\7\207\1\262\1\0\73\207\1\0\3\76"+
    "\1\0\2\76\6\0\5\76\1\0\2\76\3\0\1\76"+
    "\2\0\2\76\1\263\1\76\2\0\21\76\44\0\1\214"+
    "\62\0\2\215\12\0\1\215\5\0\1\111\24\0\1\111"+
    "\33\0\7\217\1\264\1\0\73\217\12\0\1\265\72\0"+
    "\3\266\1\0\2\266\6\0\5\266\1\0\2\266\3\0"+
    "\1\266\2\0\4\266\2\0\21\266\23\0\1\127\13\0"+
    "\1\127\67\0\3\11\1\0\2\11\6\0\5\11\1\0"+
    "\2\11\3\0\1\11\2\0\3\11\1\267\2\0\21\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\4\11\2\0\11\11\1\270\7\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\4\11\2\0\2\11\1\271\16\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\4\11\2\0\2\11\1\272\16\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\4\11\2\0\2\11\1\273\16\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\4\11\2\0\2\11\1\274\16\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\4\11\2\0\12\11\1\275\6\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\4\11\2\0\2\11\1\276\16\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\11\2\0\4\11\2\0\4\11\1\277\14\11"+
    "\23\0\3\11\1\0\2\11\6\0\5\11\1\0\2\11"+
    "\3\0\1\300\2\0\4\11\2\0\21\11\23\0\3\11"+
    "\1\0\2\11\6\0\5\11\1\0\2\11\3\0\1\11"+
    "\2\0\3\11\1\301\2\0\21\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\3\11\1\302\2\0\21\11\23\0\3\11\1\0\2\11"+
    "\6\0\5\11\1\0\2\11\3\0\1\11\2\0\1\303"+
    "\3\11\2\0\21\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\2\11\1\304\16\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\3\11\1\305\15\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\4\11\1\306\14\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\5\11\1\307\13\11\22\0\7\257\1\310\1\0\73\257"+
    "\1\0\1\311\1\0\1\311\11\0\1\311\1\0\1\311"+
    "\3\0\2\311\16\0\2\311\3\0\2\311\3\0\1\311"+
    "\3\0\1\311\23\0\3\76\1\0\2\76\6\0\5\76"+
    "\1\0\2\76\3\0\1\76\2\0\3\76\1\312\2\0"+
    "\21\76\23\0\3\11\1\0\2\11\6\0\5\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\16\11\1\313"+
    "\2\11\23\0\3\11\1\0\2\11\6\0\5\11\1\0"+
    "\2\11\3\0\1\11\2\0\4\11\2\0\3\11\1\314"+
    "\5\11\1\315\7\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\6\11\1\316\12\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\6\11\1\317\12\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\3\11\1\320\15\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\6\11\1\321\12\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\2\11\1\322\16\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\3\11\1\323"+
    "\2\0\21\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\2\11\1\324\1\11"+
    "\2\0\21\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\10\11"+
    "\1\325\10\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\12\11"+
    "\1\326\6\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\2\11"+
    "\1\327\16\11\23\0\1\330\1\0\1\330\11\0\1\330"+
    "\1\0\1\330\3\0\2\330\16\0\2\330\3\0\2\330"+
    "\3\0\1\330\3\0\1\330\23\0\3\11\1\0\2\11"+
    "\6\0\5\11\1\0\2\11\3\0\1\11\2\0\4\11"+
    "\2\0\4\11\1\331\14\11\23\0\3\11\1\0\2\11"+
    "\6\0\5\11\1\0\2\11\3\0\1\11\2\0\4\11"+
    "\2\0\7\11\1\332\11\11\23\0\3\11\1\0\2\11"+
    "\6\0\5\11\1\0\2\11\3\0\1\11\2\0\4\11"+
    "\2\0\7\11\1\333\11\11\23\0\3\11\1\0\2\11"+
    "\6\0\5\11\1\0\2\11\3\0\1\11\2\0\4\11"+
    "\2\0\13\11\1\334\5\11\23\0\3\11\1\0\2\11"+
    "\6\0\5\11\1\0\2\11\3\0\1\11\2\0\4\11"+
    "\2\0\5\11\1\335\13\11\23\0\3\11\1\0\2\11"+
    "\6\0\5\11\1\0\2\11\3\0\1\11\2\0\4\11"+
    "\2\0\5\11\1\336\13\11\23\0\3\11\1\0\2\11"+
    "\6\0\5\11\1\0\2\11\3\0\1\11\2\0\1\337"+
    "\3\11\2\0\21\11\23\0\1\204\1\0\1\204\11\0"+
    "\1\204\1\0\1\204\3\0\2\204\16\0\2\204\3\0"+
    "\2\204\3\0\1\204\3\0\1\204\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\2\11\1\340\1\11\2\0\21\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\3\11\1\341\15\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\11\2\0"+
    "\4\11\2\0\2\11\1\342\16\11\23\0\3\11\1\0"+
    "\2\11\6\0\5\11\1\0\2\11\3\0\1\343\2\0"+
    "\4\11\2\0\21\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\3\11\1\344\15\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\10\11\1\345\10\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\4\11\2\0"+
    "\2\11\1\346\16\11\23\0\3\11\1\0\2\11\6\0"+
    "\5\11\1\0\2\11\3\0\1\11\2\0\3\11\1\347"+
    "\2\0\21\11\23\0\3\11\1\0\2\11\6\0\5\11"+
    "\1\0\2\11\3\0\1\11\2\0\4\11\2\0\2\11"+
    "\1\350\16\11\22\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[10540];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\6\0\1\11\15\1\1\11\3\1\1\11\16\1\1\11"+
    "\7\1\4\11\1\1\2\11\1\1\1\11\2\1\2\11"+
    "\4\1\1\11\2\1\2\11\2\1\1\0\1\11\1\1"+
    "\1\0\1\1\1\0\2\1\1\11\1\1\1\0\1\1"+
    "\1\0\4\1\4\11\1\1\1\0\7\1\1\11\20\1"+
    "\12\11\1\1\1\0\2\11\1\1\2\0\1\1\2\11"+
    "\1\0\1\11\1\1\1\11\1\0\3\1\1\11\1\0"+
    "\2\11\11\1\1\11\15\1\1\11\2\0\1\1\1\11"+
    "\1\1\3\11\21\1\1\11\1\0\16\1\1\0\20\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[232];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private static final class State {
        final int lBraceCount;
        final int state;

        public State(int state, int lBraceCount) {
            this.state = state;
            this.lBraceCount = lBraceCount;
        }

        @Override
        public String toString() {
            return "yystate = " + state + (lBraceCount == 0 ? "" : "lBraceCount = " + lBraceCount);
        }
    }

    private final Stack<State> states = new Stack<State>();
    private int lBraceCount;

    private int commentStart;
    private int commentDepth;

    private void pushState(int state) {
        states.push(new State(yystate(), lBraceCount));
        lBraceCount = 0;
        yybegin(state);
    }

    private void popState() {
        State state = states.pop();
        lBraceCount = state.lBraceCount;
        yybegin(state.state);
    }

    private IElementType commentStateToTokenType(int state) {
        switch (state) {
            case BLOCK_COMMENT:
                return KtTokens.BLOCK_COMMENT;
            case DOC_COMMENT:
                return KtTokens.DOC_COMMENT;
            default:
                throw new IllegalArgumentException("Unexpected state: " + state);
        }
    }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _JetLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) throws KotlinLexerException {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new KotlinLexerException(message + "\n at '" + yytext() + "'\n" + zzBuffer);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  throws KotlinLexerException {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
      return;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException, KotlinLexerException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        zzDoEOF();
        switch (zzLexicalState) {
            case BLOCK_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }  // fall though
            case 233: break;
            case DOC_COMMENT: {
              int state = yystate();
        popState();
        zzStartRead = commentStart;
        return commentStateToTokenType(state);
            }  // fall though
            case 234: break;
            default:
        return null;
        }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return TokenType.BAD_CHARACTER;
            } 
            // fall through
          case 106: break;
          case 2: 
            { return KtTokens.INTEGER_LITERAL;
            } 
            // fall through
          case 107: break;
          case 3: 
            { return KtTokens.IDENTIFIER;
            } 
            // fall through
          case 108: break;
          case 4: 
            { return KtTokens.WHITE_SPACE;
            } 
            // fall through
          case 109: break;
          case 5: 
            { pushState(UNMATCHED_BACKTICK); return TokenType.BAD_CHARACTER;
            } 
            // fall through
          case 110: break;
          case 6: 
            { return KtTokens.DIV       ;
            } 
            // fall through
          case 111: break;
          case 7: 
            { return KtTokens.HASH      ;
            } 
            // fall through
          case 112: break;
          case 8: 
            { return KtTokens.EXCL      ;
            } 
            // fall through
          case 113: break;
          case 9: 
            { return KtTokens.DOT       ;
            } 
            // fall through
          case 114: break;
          case 10: 
            { return KtTokens.MINUS     ;
            } 
            // fall through
          case 115: break;
          case 11: 
            { return KtTokens.CHARACTER_LITERAL;
            } 
            // fall through
          case 116: break;
          case 12: 
            { pushState(STRING); return KtTokens.OPEN_QUOTE;
            } 
            // fall through
          case 117: break;
          case 13: 
            { return KtTokens.LBRACE    ;
            } 
            // fall through
          case 118: break;
          case 14: 
            { return KtTokens.RBRACE    ;
            } 
            // fall through
          case 119: break;
          case 15: 
            { return KtTokens.MUL       ;
            } 
            // fall through
          case 120: break;
          case 16: 
            { return KtTokens.EQ        ;
            } 
            // fall through
          case 121: break;
          case 17: 
            { return KtTokens.QUEST     ;
            } 
            // fall through
          case 122: break;
          case 18: 
            { return KtTokens.PLUS      ;
            } 
            // fall through
          case 123: break;
          case 19: 
            { return KtTokens.LT        ;
            } 
            // fall through
          case 124: break;
          case 20: 
            { return KtTokens.GT        ;
            } 
            // fall through
          case 125: break;
          case 21: 
            { return KtTokens.PERC      ;
            } 
            // fall through
          case 126: break;
          case 22: 
            { return KtTokens.COLON     ;
            } 
            // fall through
          case 127: break;
          case 23: 
            { return KtTokens.LBRACKET  ;
            } 
            // fall through
          case 128: break;
          case 24: 
            { return KtTokens.RBRACKET  ;
            } 
            // fall through
          case 129: break;
          case 25: 
            { return KtTokens.LPAR      ;
            } 
            // fall through
          case 130: break;
          case 26: 
            { return KtTokens.RPAR      ;
            } 
            // fall through
          case 131: break;
          case 27: 
            { return KtTokens.SEMICOLON ;
            } 
            // fall through
          case 132: break;
          case 28: 
            { return KtTokens.COMMA     ;
            } 
            // fall through
          case 133: break;
          case 29: 
            { return KtTokens.AT        ;
            } 
            // fall through
          case 134: break;
          case 30: 
            { return KtTokens.REGULAR_STRING_PART;
            } 
            // fall through
          case 135: break;
          case 31: 
            { popState(); yypushback(1); return KtTokens.DANGLING_NEWLINE;
            } 
            // fall through
          case 136: break;
          case 32: 
            { popState(); return KtTokens.CLOSING_QUOTE;
            } 
            // fall through
          case 137: break;
          case 33: 
            { popState(); return KtTokens.IDENTIFIER;
            } 
            // fall through
          case 138: break;
          case 34: 
            { 
            } 
            // fall through
          case 139: break;
          case 35: 
            { lBraceCount++; return KtTokens.LBRACE;
            } 
            // fall through
          case 140: break;
          case 36: 
            { if (lBraceCount == 0) {
                                             popState();
                                             return KtTokens.LONG_TEMPLATE_ENTRY_END;
                                           }
                                           lBraceCount--;
                                           return KtTokens.RBRACE;
            } 
            // fall through
          case 141: break;
          case 37: 
            { return KtTokens.FLOAT_LITERAL;
            } 
            // fall through
          case 142: break;
          case 38: 
            { return KtTokens.FIELD_IDENTIFIER;
            } 
            // fall through
          case 143: break;
          case 39: 
            { return KtTokens.EOL_COMMENT;
            } 
            // fall through
          case 144: break;
          case 40: 
            { pushState(BLOCK_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
            } 
            // fall through
          case 145: break;
          case 41: 
            { return KtTokens.DIVEQ     ;
            } 
            // fall through
          case 146: break;
          case 42: 
            { if (zzCurrentPos == 0) {
                return KtTokens.SHEBANG_COMMENT;
            }
            else {
                yypushback(yylength() - 1);
                return KtTokens.HASH;
            }
            } 
            // fall through
          case 147: break;
          case 43: 
            { return KtTokens.EXCLEQ    ;
            } 
            // fall through
          case 148: break;
          case 44: 
            { return KtTokens.RANGE     ;
            } 
            // fall through
          case 149: break;
          case 45: 
            { return KtTokens.MINUSMINUS;
            } 
            // fall through
          case 150: break;
          case 46: 
            { return KtTokens.MINUSEQ   ;
            } 
            // fall through
          case 151: break;
          case 47: 
            { return KtTokens.ARROW     ;
            } 
            // fall through
          case 152: break;
          case 48: 
            { return KtTokens.IS_KEYWORD ;
            } 
            // fall through
          case 153: break;
          case 49: 
            { return KtTokens.IN_KEYWORD ;
            } 
            // fall through
          case 154: break;
          case 50: 
            { return KtTokens.IF_KEYWORD ;
            } 
            // fall through
          case 155: break;
          case 51: 
            { return KtTokens.MULTEQ    ;
            } 
            // fall through
          case 156: break;
          case 52: 
            { return KtTokens.AS_KEYWORD ;
            } 
            // fall through
          case 157: break;
          case 53: 
            { return KtTokens.DO_KEYWORD ;
            } 
            // fall through
          case 158: break;
          case 54: 
            { return KtTokens.EQEQ      ;
            } 
            // fall through
          case 159: break;
          case 55: 
            { return KtTokens.DOUBLE_ARROW;
            } 
            // fall through
          case 160: break;
          case 56: 
            { return KtTokens.PLUSEQ    ;
            } 
            // fall through
          case 161: break;
          case 57: 
            { return KtTokens.PLUSPLUS  ;
            } 
            // fall through
          case 162: break;
          case 58: 
            { return KtTokens.LTEQ      ;
            } 
            // fall through
          case 163: break;
          case 59: 
            { return KtTokens.GTEQ      ;
            } 
            // fall through
          case 164: break;
          case 60: 
            { return KtTokens.ANDAND    ;
            } 
            // fall through
          case 165: break;
          case 61: 
            { return KtTokens.OROR      ;
            } 
            // fall through
          case 166: break;
          case 62: 
            { return KtTokens.PERCEQ    ;
            } 
            // fall through
          case 167: break;
          case 63: 
            { return KtTokens.COLONCOLON;
            } 
            // fall through
          case 168: break;
          case 64: 
            { return KtTokens.DOUBLE_SEMICOLON;
            } 
            // fall through
          case 169: break;
          case 65: 
            { pushState(SHORT_TEMPLATE_ENTRY);
                                                        yypushback(yylength() - 1);
                                                        return KtTokens.SHORT_TEMPLATE_ENTRY_START;
            } 
            // fall through
          case 170: break;
          case 66: 
            { pushState(LONG_TEMPLATE_ENTRY); return KtTokens.LONG_TEMPLATE_ENTRY_START;
            } 
            // fall through
          case 171: break;
          case 67: 
            { return KtTokens.ESCAPE_SEQUENCE;
            } 
            // fall through
          case 172: break;
          case 68: 
            { commentDepth++;
            } 
            // fall through
          case 173: break;
          case 69: 
            { if (commentDepth > 0) {
            commentDepth--;
        }
        else {
             int state = yystate();
             popState();
             zzStartRead = commentStart;
             return commentStateToTokenType(state);
        }
            } 
            // fall through
          case 174: break;
          case 70: 
            { yypushback(2); return KtTokens.INTEGER_LITERAL;
            } 
            // fall through
          case 175: break;
          case 71: 
            { pushState(DOC_COMMENT);
    commentDepth = 0;
    commentStart = getTokenStart();
            } 
            // fall through
          case 176: break;
          case 72: 
            { return KtTokens.NOT_IS;
            } 
            // fall through
          case 177: break;
          case 73: 
            { return KtTokens.NOT_IN;
            } 
            // fall through
          case 178: break;
          case 74: 
            { return KtTokens.EXCLEQEQEQ;
            } 
            // fall through
          case 179: break;
          case 75: 
            { return KtTokens.RESERVED  ;
            } 
            // fall through
          case 180: break;
          case 76: 
            { pushState(RAW_STRING); return KtTokens.OPEN_QUOTE;
            } 
            // fall through
          case 181: break;
          case 77: 
            { return KtTokens.TRY_KEYWORD ;
            } 
            // fall through
          case 182: break;
          case 78: 
            { return KtTokens.AS_SAFE;
            } 
            // fall through
          case 183: break;
          case 79: 
            { return KtTokens.FUN_KEYWORD ;
            } 
            // fall through
          case 184: break;
          case 80: 
            { return KtTokens.FOR_KEYWORD ;
            } 
            // fall through
          case 185: break;
          case 81: 
            { return KtTokens.VAL_KEYWORD ;
            } 
            // fall through
          case 186: break;
          case 82: 
            { return KtTokens.VAR_KEYWORD ;
            } 
            // fall through
          case 187: break;
          case 83: 
            { return KtTokens.EQEQEQ    ;
            } 
            // fall through
          case 188: break;
          case 84: 
            { int length = yytext().length();
                                    if (length <= 3) { // closing """
                                        popState();
                                        return KtTokens.CLOSING_QUOTE;
                                    }
                                    else { // some quotes at the end of a string, e.g. """ "foo""""
                                        yypushback(3); // return the closing quotes (""") to the stream
                                        return KtTokens.REGULAR_STRING_PART;
                                    }
            } 
            // fall through
          case 189: break;
          case 85: 
            { return KtTokens.BLOCK_COMMENT;
            } 
            // fall through
          case 190: break;
          case 86: 
            { yypushback(3); return KtTokens.EXCL;
            } 
            // fall through
          case 191: break;
          case 87: 
            { return KtTokens.THIS_KEYWORD ;
            } 
            // fall through
          case 192: break;
          case 88: 
            { return KtTokens.TRUE_KEYWORD ;
            } 
            // fall through
          case 193: break;
          case 89: 
            { return KtTokens.ELSE_KEYWORD ;
            } 
            // fall through
          case 194: break;
          case 90: 
            { return KtTokens.NULL_KEYWORD ;
            } 
            // fall through
          case 195: break;
          case 91: 
            { return KtTokens.WHEN_KEYWORD ;
            } 
            // fall through
          case 196: break;
          case 92: 
            { popState(); return KtTokens.THIS_KEYWORD;
            } 
            // fall through
          case 197: break;
          case 93: 
            { return KtTokens.THROW_KEYWORD ;
            } 
            // fall through
          case 198: break;
          case 94: 
            { return KtTokens.SUPER_KEYWORD ;
            } 
            // fall through
          case 199: break;
          case 95: 
            { return KtTokens.FALSE_KEYWORD ;
            } 
            // fall through
          case 200: break;
          case 96: 
            { return KtTokens.CLASS_KEYWORD ;
            } 
            // fall through
          case 201: break;
          case 97: 
            { return KtTokens.BREAK_KEYWORD ;
            } 
            // fall through
          case 202: break;
          case 98: 
            { return KtTokens.WHILE_KEYWORD ;
            } 
            // fall through
          case 203: break;
          case 99: 
            { return KtTokens.TYPEOF_KEYWORD ;
            } 
            // fall through
          case 204: break;
          case 100: 
            { return KtTokens.RETURN_KEYWORD ;
            } 
            // fall through
          case 205: break;
          case 101: 
            { return KtTokens.OBJECT_KEYWORD ;
            } 
            // fall through
          case 206: break;
          case 102: 
            { return KtTokens.PACKAGE_KEYWORD ;
            } 
            // fall through
          case 207: break;
          case 103: 
            { return KtTokens.CONTINUE_KEYWORD ;
            } 
            // fall through
          case 208: break;
          case 104: 
            { return KtTokens.TYPE_ALIAS_KEYWORD ;
            } 
            // fall through
          case 209: break;
          case 105: 
            { return KtTokens.INTERFACE_KEYWORD ;
            } 
            // fall through
          case 210: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
