// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2024 Konrad Twardowski

// A file shortcut creator

#pragma once

#include <QCheckBox>
#include <QComboBox>
#include <QLineEdit>
#include <QPlainTextEdit>
#include <QRadioButton>
#include <QWizard>

class Action;
class Trigger;

class FileShortcutDialog final: public QWizard {
public:
	explicit FileShortcutDialog(QWidget *parent);
	virtual bool validateCurrentPage() override;
private:
	Q_DISABLE_COPY(FileShortcutDialog)
	enum class LocationType { AUTOSTART_MINIMIZED, AUTOSTART, MENU, DESKTOP };
	enum class ScaleType { DEFAULT, X15, X2 };

	Action *m_action;
	Trigger *m_trigger;

	bool m_triggerOptionSupported;
	QCheckBox *m_confirm;
	QCheckBox *m_hideUI;
	QCheckBox *m_init;
	QComboBox *m_location;
	QComboBox *m_scale;
	QLineEdit *m_file;
	QLineEdit *m_name;
	QPlainTextEdit *m_commandLine;
	QRadioButton *m_selectedAction;
	QRadioButton *m_selectedTrigger;
	QRadioButton *m_noAction;
	QRadioButton *m_noTrigger;
	QWizardPage *m_namePage;

	void createActionPage();
	void createAdvancedPage();
	void createNamePage();
	void createTriggerPage();

	void createFile();
	QString getCommandLine();
	UPath getFile();
	UPath getLocationDir();
};
