// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2021 Konrad Twardowski

#include "ulabel.h"
#include "utils.h"

#include <QDebug>

// public:

ULabel::ULabel(QWidget *parent)
	: QFrame(parent) {

	m_iconLabel = new QLabel();
	m_textLabel = new QLabel();

	auto *layout = new QHBoxLayout(this);
	setMarginAndSpacing(0_px, 0_px);

	layout->addWidget(m_iconLabel);
	layout->addWidget(m_textLabel);
	layout->addStretch();
}

QHBoxLayout *ULabel::labelLayout() {
	return dynamic_cast<QHBoxLayout *>(layout());
}

void ULabel::setIcon(const QIcon &value, const int size) {
	if (value.isNull()) {
		m_iconLabel->hide();
		m_iconLabel->setPixmap(QPixmap());
	}
	else {
		m_iconLabel->show();
		m_iconLabel->setPixmap(value.pixmap(size));
	}
}

void ULabel::setIcon(const QString &iconName, const int size) {
	setIcon(QIcon::fromTheme(iconName), size);
}

void ULabel::setIcon(const QStyle::StandardPixmap standardIcon, const int size) {
	setIcon(QApplication::style()->standardIcon(standardIcon), size);
}

void ULabel::setText(const QString &value) {
	m_textLabel->setText(value);
}

void ULabel::setMarginAndSpacing(const int margin, const int spacing) {
	//qDebug() << labelLayout()->contentsMargins();
	//qDebug() << labelLayout()->spacing();
	Utils::setMargin(labelLayout(), margin);
	labelLayout()->setSpacing(spacing);
}
