// Reconcile DEP-5 debian/copyright to licensecheck
//
// Copyright : 2024 P Blackman
// License   : BSD-2-clause
//
// Extract the license for an appstream metadata file
//  (workaround for https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=1051840 )

unit appstream;
{$mode delphi}

interface

function GetMetadataLicense (Fname : AnsiString) : String;


implementation uses StrUtils, support;

function GetMetadataLicense (Fname : AnsiString) : String;

const Maxlines : Integer = 100;
var Lines,
    lpos : Integer;
    Line : AnsiString;
    afile : Text;

begin
    result := '';
    Lines := 0;
    if OpenFile (FName, afile) then
    begin
        while not EOF (afile) and (Lines < MaxLines) do
        begin
            Readln (afile, Line);
            lpos := NPos ('<metadata_license>', Line, 1);

            if lpos > 0 then
            begin
                Result := ExtractSubstr(Line, lpos, ['<']);

                Lines := MaxLines // terminate loop
            end
            else
                inc (Lines);
        end;
        Close (afile);
     end;
end;

end.
