/*
 * Copyright 2016 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "plugin.h"

#include <QtQml/QQmlEngine>
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
#include <LomiriToolkit-Qt6/lomiritoolkitmodule.h>
#else
#include <LomiriToolkit/lomiritoolkitmodule.h>
#endif
#if QT_VERSION >= QT_VERSION_CHECK(6, 0, 0)
#include <LomiriGestures-Qt6/lomirigesturesmodule.h>
#else
#include <LomiriGestures/lomirigesturesmodule.h>
#endif

LomiriComponentsPlugin::~LomiriComponentsPlugin()
{
    UT_PREPEND_NAMESPACE(LomiriToolkitModule)::undefineModule();
    UG_PREPEND_NAMESPACE(LomiriGesturesModule)::undefineModule();
}

void LomiriComponentsPlugin::registerTypes(const char *uri)
{
    Q_ASSERT(uri == QLatin1String("Lomiri.Components"));
    Q_UNUSED(uri);

    UG_PREPEND_NAMESPACE(LomiriGesturesModule)::defineModule(uri);
    UT_PREPEND_NAMESPACE(LomiriToolkitModule)::defineModule(uri);
}

void LomiriComponentsPlugin::initializeEngine(QQmlEngine *engine, const char *uri)
{
    UT_PREPEND_NAMESPACE(LomiriToolkitModule)::initializeModule(engine, baseUrl());
    QQmlExtensionPlugin::initializeEngine(engine, uri);
}
