/*
 * Copyright (C) 2025 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2025 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins
 * Created on: 08 апр. 2016 г.
 *
 * lsp-plugins is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef GENERATED_ISO226_ROBINSON_DADSON_H_
#define GENERATED_ISO226_ROBINSON_DADSON_H_

#include <generated/iso226/defs.h>

namespace lsp
{
    static const int16_t robinson_dadson_curve_0_phons[1468] =
    {
        -4122, -4116, -4117, -4117, -4116, -4118, -4128, -4136, -4144, -4150,
        -4162, -4169, -4175, -4186, -4185, -4193, -4202, -4206, -4212, -4213,
        -4223, -4226, -4242, -4251, -4255, -4256, -4256, -4253, -4253, -4263,
        -4268, -4274, -4290, -4308, -4324, -4334, -4339, -4353, -4359, -4369,
        -4373, -4378, -4382, -4379, -4387, -4391, -4391, -4394, -4395, -4399,
        -4405, -4409, -4418, -4420, -4420, -4420, -4424, -4430, -4431, -4441,
        -4454, -4456, -4463, -4471, -4477, -4495, -4506, -4511, -4506, -4517,
        -4522, -4528, -4528, -4538, -4542, -4540, -4543, -4545, -4548, -4554,
        -4552, -4555, -4569, -4581, -4578, -4576, -4587, -4600, -4602, -4602,
        -4616, -4629, -4638, -4647, -4648, -4650, -4656, -4658, -4660, -4669,
        -4674, -4676, -4680, -4688, -4698, -4700, -4702, -4705, -4707, -4708,
        -4714, -4724, -4733, -4738, -4742, -4751, -4759, -4763, -4770, -4769,
        -4774, -4781, -4791, -4792, -4801, -4816, -4831, -4837, -4840, -4847,
        -4854, -4858, -4865, -4868, -4871, -4876, -4885, -4890, -4901, -4912,
        -4913, -4926, -4932, -4943, -4950, -4961, -4965, -4967, -4970, -4983,
        -4983, -4986, -4989, -4999, -5000, -5010, -5012, -5014, -5024, -5036,
        -5041, -5050, -5065, -5079, -5093, -5101, -5109, -5119, -5123, -5126,
        -5137, -5147, -5150, -5153, -5160, -5163, -5166, -5168, -5174, -5181,
        -5186, -5192, -5201, -5209, -5216, -5223, -5232, -5248, -5262, -5266,
        -5261, -5274, -5293, -5298, -5305, -5311, -5329, -5346, -5355, -5364,
        -5371, -5376, -5378, -5383, -5380, -5386, -5392, -5396, -5404, -5409,
        -5414, -5414, -5422, -5426, -5431, -5437, -5444, -5449, -5456, -5463,
        -5466, -5480, -5491, -5500, -5506, -5514, -5537, -5544, -5552, -5558,
        -5562, -5566, -5575, -5583, -5581, -5594, -5596, -5608, -5611, -5621,
        -5628, -5634, -5634, -5641, -5650, -5649, -5654, -5660, -5657, -5665,
        -5673, -5682, -5686, -5688, -5698, -5704, -5709, -5723, -5728, -5732,
        -5732, -5745, -5745, -5761, -5762, -5772, -5774, -5786, -5788, -5800,
        -5810, -5822, -5824, -5822, -5830, -5841, -5847, -5849, -5854, -5861,
        -5865, -5868, -5871, -5881, -5885, -5894, -5897, -5908, -5910, -5912,
        -5920, -5925, -5931, -5934, -5936, -5935, -5938, -5937, -5945, -5954,
        -5951, -5955, -5961, -5963, -5977, -5987, -5987, -5999, -6004, -6007,
        -6012, -6020, -6025, -6024, -6029, -6031, -6031, -6022, -6023, -6035,
        -6046, -6057, -6059, -6070, -6071, -6079, -6089, -6090, -6096, -6096,
        -6097, -6103, -6106, -6108, -6110, -6110, -6127, -6129, -6138, -6139,
        -6148, -6148, -6158, -6152, -6160, -6161, -6160, -6162, -6165, -6167,
        -6169, -6176, -6178, -6177, -6180, -6187, -6191, -6196, -6205, -6207,
        -6225, -6225, -6222, -6219, -6221, -6229, -6232, -6236, -6242, -6251,
        -6259, -6262, -6269, -6278, -6279, -6279, -6284, -6292, -6300, -6302,
        -6304, -6309, -6307, -6316, -6318, -6324, -6329, -6331, -6336, -6333,
        -6339, -6340, -6347, -6350, -6355, -6364, -6366, -6373, -6377, -6383,
        -6383, -6387, -6392, -6399, -6396, -6396, -6395, -6399, -6401, -6408,
        -6422, -6420, -6427, -6426, -6430, -6425, -6429, -6426, -6432, -6431,
        -6437, -6435, -6440, -6438, -6443, -6450, -6458, -6465, -6467, -6470,
        -6471, -6476, -6474, -6483, -6488, -6485, -6487, -6487, -6495, -6497,
        -6501, -6507, -6516, -6514, -6517, -6523, -6531, -6539, -6535, -6536,
        -6533, -6540, -6540, -6548, -6551, -6555, -6560, -6558, -6563, -6562,
        -6568, -6568, -6577, -6577, -6582, -6580, -6578, -6573, -6581, -6578,
        -6576, -6579, -6584, -6597, -6600, -6602, -6608, -6614, -6622, -6628,
        -6630, -6629, -6628, -6625, -6626, -6624, -6623, -6621, -6628, -6631,
        -6640, -6645, -6648, -6644, -6646, -6651, -6649, -6644, -6647, -6656,
        -6652, -6656, -6656, -6662, -6671, -6677, -6685, -6694, -6697, -6700,
        -6706, -6707, -6715, -6712, -6720, -6717, -6725, -6719, -6726, -6722,
        -6726, -6727, -6730, -6727, -6735, -6734, -6729, -6735, -6733, -6739,
        -6736, -6742, -6749, -6756, -6756, -6755, -6760, -6765, -6773, -6769,
        -6775, -6776, -6775, -6780, -6781, -6784, -6791, -6794, -6784, -6785,
        -6785, -6795, -6795, -6804, -6808, -6811, -6803, -6807, -6811, -6816,
        -6817, -6826, -6825, -6820, -6821, -6820, -6829, -6835, -6839, -6843,
        -6840, -6841, -6847, -6851, -6858, -6860, -6864, -6864, -6873, -6874,
        -6883, -6886, -6891, -6893, -6893, -6899, -6904, -6901, -6899, -6904,
        -6905, -6908, -6912, -6915, -6919, -6923, -6925, -6931, -6928, -6931,
        -6934, -6942, -6941, -6938, -6946, -6954, -6962, -6966, -6969, -6976,
        -6978, -6978, -6971, -6970, -6975, -6979, -6985, -6986, -6993, -6995,
        -7002, -7008, -7012, -7013, -7021, -7026, -7033, -7036, -7038, -7044,
        -7042, -7043, -7045, -7043, -7049, -7049, -7056, -7054, -7060, -7062,
        -7063, -7067, -7074, -7077, -7080, -7084, -7092, -7093, -7094, -7098,
        -7101, -7102, -7106, -7110, -7111, -7113, -7115, -7118, -7119, -7122,
        -7128, -7132, -7136, -7136, -7137, -7143, -7146, -7153, -7155, -7155,
        -7155, -7155, -7155, -7155, -7159, -7164, -7177, -7179, -7188, -7189,
        -7189, -7194, -7198, -7204, -7211, -7216, -7221, -7229, -7235, -7239,
        -7243, -7243, -7243, -7243, -7243, -7243, -7248, -7252, -7256, -7268,
        -7271, -7271, -7276, -7280, -7285, -7290, -7293, -7298, -7301, -7305,
        -7310, -7313, -7315, -7319, -7322, -7322, -7324, -7326, -7328, -7328,
        -7333, -7339, -7339, -7338, -7344, -7348, -7348, -7347, -7347, -7351,
        -7356, -7362, -7364, -7364, -7364, -7369, -7379, -7390, -7397, -7403,
        -7412, -7413, -7423, -7423, -7422, -7422, -7426, -7431, -7436, -7438,
        -7438, -7444, -7454, -7466, -7476, -7477, -7476, -7476, -7475, -7475,
        -7480, -7485, -7481, -7486, -7490, -7492, -7499, -7503, -7507, -7512,
        -7518, -7521, -7529, -7531, -7538, -7545, -7550, -7555, -7557, -7564,
        -7572, -7574, -7581, -7587, -7589, -7590, -7589, -7589, -7589, -7588,
        -7595, -7602, -7607, -7607, -7613, -7620, -7625, -7630, -7639, -7639,
        -7644, -7649, -7653, -7653, -7657, -7662, -7671, -7673, -7677, -7685,
        -7689, -7697, -7698, -7702, -7702, -7706, -7706, -7721, -7720, -7729,
        -7733, -7734, -7734, -7733, -7737, -7737, -7745, -7747, -7752, -7757,
        -7759, -7762, -7766, -7767, -7771, -7773, -7774, -7782, -7784, -7789,
        -7793, -7795, -7794, -7800, -7808, -7810, -7817, -7816, -7822, -7827,
        -7831, -7831, -7830, -7836, -7840, -7839, -7849, -7854, -7863, -7862,
        -7867, -7880, -7885, -7885, -7885, -7884, -7888, -7894, -7893, -7888,
        -7890, -7888, -7889, -7898, -7904, -7916, -7917, -7917, -7922, -7923,
        -7922, -7922, -7922, -7921, -7921, -7922, -7925, -7928, -7934, -7937,
        -7936, -7934, -7933, -7934, -7934, -7934, -7934, -7932, -7930, -7929,
        -7929, -7929, -7930, -7933, -7937, -7937, -7938, -7942, -7944, -7945,
        -7945, -7947, -7939, -7940, -7929, -7929, -7929, -7929, -7934, -7936,
        -7940, -7948, -7948, -7948, -7943, -7939, -7935, -7939, -7944, -7944,
        -7944, -7944, -7949, -7949, -7949, -7944, -7944, -7942, -7937, -7939,
        -7941, -7941, -7946, -7947, -7948, -7943, -7939, -7933, -7932, -7933,
        -7943, -7949, -7945, -7940, -7936, -7934, -7936, -7938, -7940, -7935,
        -7933, -7929, -7925, -7925, -7919, -7921, -7926, -7924, -7926, -7925,
        -7922, -7925, -7923, -7926, -7919, -7923, -7916, -7920, -7923, -7923,
        -7917, -7919, -7909, -7905, -7896, -7898, -7900, -7895, -7894, -7885,
        -7880, -7879, -7882, -7884, -7882, -7879, -7878, -7878, -7872, -7871,
        -7868, -7872, -7862, -7862, -7856, -7859, -7853, -7856, -7863, -7862,
        -7859, -7862, -7860, -7860, -7860, -7860, -7859, -7859, -7859, -7858,
        -7856, -7855, -7856, -7852, -7858, -7852, -7850, -7850, -7851, -7854,
        -7847, -7850, -7845, -7843, -7842, -7837, -7841, -7841, -7837, -7833,
        -7821, -7815, -7813, -7809, -7802, -7800, -7801, -7795, -7802, -7789,
        -7783, -7782, -7782, -7791, -7787, -7796, -7792, -7792, -7790, -7789,
        -7785, -7781, -7774, -7777, -7774, -7772, -7775, -7773, -7768, -7767,
        -7772, -7766, -7765, -7758, -7753, -7757, -7755, -7758, -7757, -7751,
        -7752, -7753, -7747, -7751, -7749, -7748, -7747, -7740, -7734, -7727,
        -7722, -7716, -7713, -7713, -7711, -7710, -7710, -7715, -7718, -7719,
        -7721, -7721, -7719, -7721, -7719, -7721, -7726, -7726, -7720, -7720,
        -7724, -7724, -7720, -7718, -7722, -7717, -7719, -7715, -7716, -7715,
        -7716, -7714, -7716, -7708, -7708, -7703, -7706, -7704, -7706, -7705,
        -7708, -7712, -7714, -7713, -7717, -7715, -7718, -7717, -7713, -7711,
        -7710, -7708, -7699, -7696, -7690, -7686, -7688, -7690, -7693, -7695,
        -7697, -7697, -7698, -7699, -7699, -7701, -7702, -7705, -7707, -7709,
        -7708, -7706, -7706, -7706, -7706, -7706, -7705, -7705, -7705, -7705,
        -7710, -7711, -7721, -7726, -7726, -7724, -7720, -7716, -7710, -7708,
        -7713, -7722, -7726, -7729, -7726, -7729, -7724, -7728, -7727, -7726,
        -7725, -7726, -7728, -7728, -7729, -7729, -7725, -7732, -7732, -7739,
        -7733, -7734, -7733, -7742, -7737, -7737, -7740, -7744, -7748, -7746,
        -7743, -7741, -7740, -7732, -7732, -7736, -7737, -7736, -7739, -7736,
        -7729, -7739, -7744, -7745, -7748, -7749, -7756, -7763, -7758, -7754,
        -7773, -7778, -7770, -7765, -7770, -7772, -7767, -7771, -7764, -7768,
        -7767, -7762, -7763, -7760, -7755, -7755, -7744, -7741, -7738, -7747,
        -7761, -7758, -7754, -7747, -7752, -7768, -7746, -7741, -7736, -7747,
        -7742, -7743, -7740, -7728, -7709, -7705, -7691, -7683, -7689, -7681,
        -7681, -7678, -7675, -7661, -7655, -7652, -7648, -7647, -7636, -7629,
        -7626, -7627, -7632, -7634, -7629, -7624, -7633, -7635, -7631, -7626,
        -7629, -7618, -7593, -7593, -7597, -7595, -7566, -7560, -7556, -7557,
        -7553, -7548, -7543, -7540, -7535, -7525, -7518, -7521, -7513, -7509,
        -7503, -7503, -7502, -7504, -7497, -7490, -7482, -7475, -7467, -7463,
        -7459, -7446, -7435, -7424, -7421, -7414, -7403, -7396, -7389, -7383,
        -7373, -7360, -7346, -7341, -7339, -7339, -7343, -7343, -7336, -7331,
        -7325, -7316, -7311, -7306, -7301, -7296, -7287, -7279, -7275, -7265,
        -7252, -7252, -7247, -7240, -7229, -7230, -7229, -7221, -7222, -7222,
        -7222, -7218, -7212, -7207, -7201, -7196, -7189, -7181, -7174, -7171,
        -7164, -7165, -7164, -7156, -7155, -7156, -7151, -7148, -7143, -7135,
        -7135, -7133, -7134, -7126, -7117, -7119, -7115, -7111, -7107, -7111,
        -7107, -7105, -7102, -7104, -7105, -7096, -7096, -7098, -7102, -7090,
        -7084, -7083, -7081, -7079, -7078, -7075, -7070, -7063, -7066, -7072,
        -7063, -7057, -7052, -7052, -7048, -7045, -7040, -7036, -7031, -7028,
        -7025, -7015, -7002, -6994, -6986, -6981, -6957, -6948, -6940, -6935,
        -6917, -6913, -6894, -6887, -6873, -6868, -6852, -6833, -6817, -6803,
        -6792, -6776, -6760, -6752, -6731, -6704, -6684, -6658, -6636, -6618,
        -6578, -6553, -6532, -6491, -6478, -6425, -6414, -6342, -6313, -6280,
        -6254, -6206, -6162, -6122, -6096, -6073, -6036, -6000
    };

    static const int16_t robinson_dadson_curve_10_phons[1468] =
    {
        -3761, -3758, -3758, -3761, -3763, -3766, -3776, -3783, -3790, -3795,
        -3805, -3810, -3815, -3823, -3823, -3831, -3841, -3846, -3850, -3852,
        -3862, -3865, -3875, -3884, -3888, -3889, -3890, -3889, -3886, -3896,
        -3900, -3908, -3922, -3940, -3953, -3959, -3964, -3977, -3986, -3991,
        -3993, -3997, -4004, -4001, -4005, -4005, -4008, -4017, -4017, -4018,
        -4024, -4027, -4036, -4038, -4040, -4039, -4044, -4051, -4053, -4059,
        -4066, -4068, -4075, -4080, -4083, -4097, -4104, -4112, -4109, -4125,
        -4127, -4132, -4134, -4145, -4149, -4145, -4146, -4147, -4149, -4157,
        -4152, -4159, -4171, -4186, -4182, -4177, -4189, -4195, -4195, -4201,
        -4208, -4219, -4227, -4237, -4238, -4241, -4248, -4250, -4252, -4258,
        -4262, -4265, -4267, -4275, -4283, -4287, -4290, -4292, -4294, -4295,
        -4301, -4311, -4319, -4321, -4325, -4333, -4340, -4343, -4348, -4347,
        -4352, -4359, -4368, -4369, -4376, -4389, -4404, -4411, -4413, -4417,
        -4424, -4430, -4436, -4439, -4442, -4448, -4456, -4462, -4470, -4478,
        -4481, -4493, -4498, -4504, -4511, -4522, -4524, -4525, -4527, -4540,
        -4539, -4542, -4547, -4557, -4560, -4572, -4575, -4577, -4584, -4594,
        -4599, -4608, -4620, -4633, -4641, -4648, -4658, -4666, -4670, -4674,
        -4680, -4688, -4693, -4696, -4701, -4704, -4708, -4709, -4717, -4723,
        -4729, -4735, -4742, -4750, -4755, -4760, -4767, -4780, -4792, -4796,
        -4791, -4804, -4816, -4817, -4821, -4828, -4844, -4858, -4867, -4876,
        -4882, -4887, -4888, -4893, -4893, -4901, -4908, -4911, -4920, -4923,
        -4925, -4924, -4932, -4937, -4942, -4948, -4957, -4964, -4969, -4975,
        -4980, -4992, -5003, -5010, -5015, -5019, -5035, -5039, -5050, -5054,
        -5058, -5061, -5069, -5077, -5077, -5086, -5087, -5099, -5103, -5111,
        -5115, -5122, -5124, -5136, -5144, -5143, -5147, -5155, -5150, -5159,
        -5164, -5170, -5177, -5179, -5186, -5190, -5195, -5206, -5208, -5210,
        -5209, -5217, -5217, -5233, -5235, -5245, -5248, -5262, -5264, -5275,
        -5281, -5292, -5294, -5294, -5302, -5309, -5315, -5317, -5325, -5330,
        -5332, -5334, -5337, -5348, -5349, -5357, -5359, -5372, -5375, -5377,
        -5385, -5391, -5394, -5398, -5401, -5399, -5401, -5401, -5406, -5412,
        -5413, -5419, -5424, -5427, -5438, -5449, -5449, -5460, -5461, -5460,
        -5465, -5476, -5483, -5481, -5484, -5490, -5492, -5485, -5484, -5490,
        -5498, -5505, -5507, -5518, -5518, -5524, -5534, -5535, -5540, -5540,
        -5540, -5545, -5549, -5552, -5554, -5554, -5568, -5570, -5580, -5581,
        -5589, -5590, -5600, -5596, -5605, -5608, -5609, -5613, -5616, -5617,
        -5619, -5623, -5623, -5623, -5627, -5634, -5637, -5640, -5649, -5648,
        -5659, -5657, -5657, -5655, -5658, -5664, -5668, -5672, -5676, -5685,
        -5691, -5693, -5698, -5707, -5709, -5709, -5709, -5718, -5726, -5730,
        -5732, -5736, -5736, -5743, -5746, -5751, -5756, -5757, -5762, -5759,
        -5765, -5767, -5771, -5775, -5781, -5789, -5790, -5797, -5798, -5803,
        -5800, -5804, -5808, -5815, -5812, -5811, -5810, -5816, -5815, -5822,
        -5835, -5833, -5840, -5847, -5848, -5845, -5847, -5844, -5851, -5849,
        -5854, -5850, -5857, -5852, -5859, -5868, -5875, -5881, -5882, -5888,
        -5890, -5893, -5891, -5899, -5901, -5896, -5898, -5898, -5901, -5901,
        -5905, -5913, -5920, -5919, -5925, -5930, -5938, -5944, -5941, -5945,
        -5942, -5947, -5946, -5950, -5953, -5954, -5960, -5958, -5964, -5962,
        -5968, -5966, -5975, -5977, -5984, -5983, -5985, -5981, -5989, -5984,
        -5984, -5987, -5993, -6001, -6003, -6004, -6009, -6016, -6022, -6029,
        -6031, -6028, -6029, -6025, -6027, -6026, -6026, -6023, -6027, -6028,
        -6035, -6040, -6044, -6041, -6046, -6050, -6048, -6048, -6050, -6055,
        -6053, -6059, -6060, -6066, -6074, -6079, -6088, -6094, -6098, -6099,
        -6104, -6105, -6110, -6108, -6113, -6112, -6118, -6114, -6121, -6120,
        -6124, -6123, -6128, -6124, -6132, -6129, -6127, -6132, -6131, -6136,
        -6129, -6133, -6138, -6144, -6144, -6146, -6151, -6154, -6163, -6156,
        -6160, -6161, -6159, -6166, -6167, -6170, -6177, -6178, -6172, -6174,
        -6173, -6181, -6185, -6190, -6195, -6197, -6192, -6195, -6202, -6207,
        -6209, -6214, -6216, -6211, -6209, -6207, -6213, -6219, -6221, -6222,
        -6220, -6223, -6225, -6228, -6233, -6234, -6239, -6239, -6248, -6249,
        -6255, -6260, -6265, -6268, -6270, -6277, -6280, -6279, -6277, -6284,
        -6284, -6290, -6293, -6294, -6299, -6303, -6304, -6307, -6304, -6306,
        -6311, -6317, -6314, -6310, -6316, -6322, -6330, -6335, -6338, -6345,
        -6347, -6348, -6339, -6336, -6341, -6348, -6351, -6354, -6360, -6363,
        -6367, -6372, -6377, -6379, -6383, -6387, -6393, -6396, -6397, -6402,
        -6401, -6401, -6400, -6398, -6402, -6403, -6406, -6408, -6411, -6416,
        -6419, -6421, -6425, -6427, -6428, -6433, -6441, -6444, -6447, -6452,
        -6453, -6457, -6459, -6461, -6461, -6464, -6467, -6469, -6472, -6476,
        -6479, -6481, -6483, -6483, -6483, -6486, -6488, -6492, -6492, -6493,
        -6494, -6494, -6498, -6498, -6504, -6508, -6520, -6523, -6534, -6535,
        -6535, -6537, -6539, -6542, -6546, -6548, -6551, -6559, -6565, -6570,
        -6574, -6575, -6575, -6575, -6577, -6577, -6580, -6584, -6588, -6596,
        -6598, -6599, -6601, -6604, -6606, -6609, -6610, -6615, -6617, -6621,
        -6628, -6632, -6635, -6637, -6638, -6639, -6643, -6645, -6648, -6650,
        -6655, -6660, -6660, -6660, -6665, -6669, -6669, -6668, -6669, -6670,
        -6673, -6676, -6676, -6676, -6676, -6681, -6691, -6699, -6703, -6706,
        -6718, -6722, -6733, -6735, -6734, -6734, -6736, -6738, -6740, -6741,
        -6741, -6746, -6754, -6764, -6771, -6771, -6771, -6770, -6769, -6769,
        -6774, -6779, -6775, -6780, -6784, -6786, -6791, -6793, -6796, -6800,
        -6804, -6806, -6813, -6814, -6819, -6825, -6828, -6833, -6834, -6840,
        -6846, -6847, -6853, -6858, -6859, -6859, -6859, -6859, -6858, -6858,
        -6864, -6872, -6876, -6877, -6883, -6890, -6894, -6899, -6908, -6908,
        -6913, -6918, -6923, -6922, -6927, -6929, -6936, -6937, -6938, -6943,
        -6945, -6951, -6949, -6953, -6951, -6955, -6953, -6968, -6965, -6974,
        -6978, -6977, -6976, -6976, -6980, -6980, -6987, -6990, -6994, -6999,
        -7002, -7005, -7008, -7010, -7014, -7016, -7018, -7025, -7026, -7030,
        -7030, -7030, -7026, -7028, -7035, -7036, -7041, -7041, -7046, -7050,
        -7054, -7053, -7051, -7056, -7060, -7057, -7067, -7069, -7074, -7073,
        -7078, -7087, -7091, -7091, -7091, -7090, -7095, -7102, -7102, -7098,
        -7101, -7100, -7098, -7105, -7108, -7119, -7118, -7118, -7125, -7126,
        -7126, -7126, -7126, -7125, -7125, -7126, -7127, -7129, -7132, -7136,
        -7136, -7133, -7132, -7133, -7133, -7134, -7134, -7131, -7130, -7130,
        -7130, -7130, -7130, -7132, -7134, -7135, -7135, -7137, -7138, -7139,
        -7138, -7139, -7130, -7130, -7120, -7120, -7120, -7120, -7123, -7123,
        -7126, -7130, -7132, -7132, -7129, -7128, -7123, -7126, -7128, -7128,
        -7128, -7128, -7130, -7130, -7130, -7125, -7125, -7119, -7114, -7115,
        -7116, -7116, -7119, -7121, -7123, -7119, -7114, -7109, -7110, -7111,
        -7119, -7124, -7121, -7118, -7113, -7113, -7114, -7115, -7115, -7110,
        -7108, -7105, -7100, -7102, -7098, -7098, -7101, -7100, -7103, -7101,
        -7094, -7095, -7092, -7094, -7086, -7088, -7080, -7081, -7083, -7084,
        -7080, -7081, -7074, -7069, -7062, -7063, -7063, -7059, -7059, -7049,
        -7045, -7044, -7047, -7048, -7046, -7041, -7040, -7044, -7041, -7038,
        -7035, -7039, -7029, -7029, -7022, -7024, -7018, -7021, -7025, -7027,
        -7025, -7025, -7024, -7022, -7022, -7021, -7020, -7018, -7020, -7017,
        -7016, -7013, -7015, -7012, -7015, -7010, -7010, -7009, -7009, -7015,
        -7007, -7012, -7004, -7001, -7002, -6996, -7000, -6998, -6996, -6993,
        -6984, -6979, -6977, -6971, -6967, -6961, -6959, -6956, -6963, -6952,
        -6950, -6949, -6950, -6955, -6951, -6960, -6958, -6954, -6952, -6950,
        -6945, -6943, -6940, -6941, -6940, -6935, -6938, -6932, -6930, -6926,
        -6933, -6925, -6926, -6921, -6914, -6919, -6914, -6917, -6915, -6912,
        -6912, -6913, -6910, -6914, -6910, -6913, -6912, -6906, -6899, -6892,
        -6890, -6882, -6881, -6881, -6879, -6878, -6879, -6886, -6889, -6891,
        -6894, -6891, -6892, -6891, -6888, -6886, -6890, -6889, -6884, -6882,
        -6884, -6883, -6883, -6885, -6892, -6887, -6890, -6885, -6887, -6886,
        -6885, -6881, -6883, -6878, -6879, -6874, -6877, -6875, -6877, -6875,
        -6876, -6880, -6880, -6882, -6884, -6882, -6884, -6884, -6883, -6882,
        -6881, -6882, -6874, -6873, -6869, -6868, -6871, -6872, -6873, -6874,
        -6875, -6875, -6876, -6876, -6877, -6877, -6878, -6879, -6880, -6881,
        -6881, -6880, -6880, -6880, -6880, -6880, -6880, -6880, -6880, -6880,
        -6885, -6885, -6895, -6900, -6900, -6899, -6897, -6895, -6892, -6891,
        -6896, -6905, -6907, -6910, -6905, -6911, -6906, -6911, -6909, -6911,
        -6911, -6909, -6910, -6910, -6911, -6912, -6908, -6914, -6911, -6919,
        -6912, -6917, -6915, -6925, -6922, -6924, -6925, -6927, -6932, -6930,
        -6927, -6928, -6930, -6924, -6926, -6929, -6929, -6928, -6932, -6930,
        -6925, -6936, -6941, -6944, -6941, -6944, -6952, -6960, -6956, -6951,
        -6968, -6969, -6963, -6960, -6963, -6965, -6956, -6959, -6952, -6957,
        -6959, -6959, -6963, -6960, -6956, -6958, -6948, -6947, -6940, -6949,
        -6962, -6958, -6953, -6947, -6948, -6966, -6951, -6947, -6945, -6950,
        -6948, -6951, -6948, -6936, -6920, -6919, -6909, -6905, -6912, -6906,
        -6908, -6909, -6912, -6902, -6899, -6897, -6890, -6889, -6881, -6876,
        -6874, -6874, -6878, -6877, -6870, -6867, -6872, -6874, -6870, -6865,
        -6869, -6857, -6845, -6843, -6846, -6845, -6824, -6823, -6821, -6818,
        -6811, -6808, -6805, -6802, -6796, -6789, -6783, -6784, -6783, -6784,
        -6783, -6784, -6783, -6784, -6781, -6774, -6768, -6760, -6753, -6748,
        -6746, -6735, -6725, -6715, -6713, -6707, -6697, -6690, -6688, -6682,
        -6672, -6661, -6650, -6645, -6644, -6644, -6646, -6649, -6643, -6639,
        -6632, -6628, -6623, -6616, -6611, -6609, -6602, -6595, -6593, -6584,
        -6573, -6573, -6568, -6564, -6558, -6559, -6559, -6550, -6550, -6550,
        -6551, -6548, -6544, -6539, -6534, -6527, -6523, -6514, -6511, -6507,
        -6503, -6504, -6505, -6500, -6500, -6502, -6500, -6497, -6493, -6488,
        -6488, -6489, -6494, -6489, -6481, -6481, -6478, -6479, -6477, -6479,
        -6474, -6475, -6474, -6473, -6475, -6469, -6469, -6468, -6471, -6465,
        -6459, -6458, -6456, -6457, -6457, -6455, -6447, -6443, -6446, -6449,
        -6445, -6439, -6437, -6439, -6437, -6437, -6433, -6434, -6434, -6432,
        -6431, -6423, -6413, -6409, -6401, -6396, -6374, -6370, -6362, -6360,
        -6344, -6340, -6326, -6320, -6306, -6301, -6285, -6269, -6255, -6246,
        -6238, -6222, -6211, -6201, -6181, -6161, -6141, -6123, -6108, -6092,
        -6057, -6035, -6018, -5985, -5970, -5921, -5904, -5848, -5809, -5781,
        -5753, -5725, -5689, -5646, -5620, -5594, -5565, -5540
    };

    static const int16_t robinson_dadson_curve_20_phons[1468] =
    {
        -3400, -3399, -3400, -3405, -3410, -3415, -3424, -3430, -3436, -3440,
        -3448, -3451, -3455, -3460, -3461, -3469, -3480, -3485, -3489, -3491,
        -3501, -3504, -3509, -3516, -3521, -3522, -3525, -3525, -3519, -3528,
        -3533, -3542, -3554, -3572, -3583, -3585, -3588, -3601, -3612, -3614,
        -3613, -3616, -3626, -3624, -3622, -3619, -3626, -3640, -3639, -3637,
        -3643, -3645, -3653, -3656, -3659, -3658, -3664, -3672, -3676, -3677,
        -3678, -3680, -3686, -3689, -3689, -3698, -3702, -3712, -3712, -3733,
        -3732, -3735, -3740, -3752, -3755, -3749, -3749, -3750, -3749, -3759,
        -3753, -3764, -3773, -3790, -3786, -3779, -3790, -3790, -3789, -3799,
        -3801, -3809, -3816, -3827, -3828, -3832, -3841, -3841, -3844, -3846,
        -3851, -3853, -3855, -3862, -3868, -3874, -3878, -3878, -3880, -3882,
        -3889, -3898, -3904, -3904, -3907, -3915, -3922, -3923, -3927, -3925,
        -3929, -3936, -3946, -3946, -3951, -3961, -3976, -3984, -3985, -3988,
        -3994, -4001, -4007, -4010, -4013, -4020, -4028, -4033, -4039, -4044,
        -4050, -4060, -4064, -4066, -4073, -4083, -4084, -4083, -4083, -4097,
        -4096, -4099, -4105, -4115, -4121, -4134, -4138, -4139, -4145, -4153,
        -4158, -4166, -4175, -4187, -4190, -4196, -4206, -4213, -4218, -4223,
        -4224, -4229, -4237, -4238, -4242, -4245, -4249, -4250, -4259, -4265,
        -4272, -4277, -4283, -4290, -4294, -4297, -4302, -4313, -4322, -4327,
        -4321, -4334, -4339, -4335, -4338, -4345, -4359, -4369, -4379, -4388,
        -4394, -4397, -4398, -4403, -4406, -4417, -4423, -4425, -4436, -4437,
        -4436, -4433, -4442, -4448, -4452, -4459, -4470, -4478, -4482, -4487,
        -4493, -4505, -4515, -4519, -4525, -4525, -4534, -4535, -4548, -4551,
        -4554, -4555, -4563, -4572, -4573, -4578, -4578, -4590, -4594, -4602,
        -4603, -4611, -4615, -4631, -4638, -4636, -4641, -4650, -4643, -4653,
        -4654, -4658, -4667, -4669, -4674, -4676, -4682, -4689, -4688, -4689,
        -4686, -4689, -4689, -4705, -4708, -4718, -4721, -4737, -4741, -4750,
        -4751, -4762, -4764, -4765, -4774, -4777, -4783, -4785, -4795, -4800,
        -4798, -4800, -4804, -4816, -4813, -4819, -4822, -4836, -4839, -4842,
        -4849, -4856, -4857, -4862, -4865, -4862, -4865, -4865, -4867, -4871,
        -4876, -4882, -4887, -4891, -4900, -4911, -4911, -4920, -4919, -4913,
        -4918, -4932, -4941, -4938, -4940, -4950, -4954, -4948, -4944, -4945,
        -4950, -4953, -4955, -4965, -4965, -4969, -4979, -4979, -4983, -4983,
        -4983, -4988, -4992, -4995, -4998, -4998, -5009, -5012, -5022, -5022,
        -5031, -5031, -5043, -5040, -5050, -5055, -5058, -5065, -5067, -5067,
        -5069, -5069, -5068, -5068, -5074, -5080, -5083, -5084, -5092, -5089,
        -5092, -5088, -5092, -5091, -5095, -5100, -5104, -5108, -5110, -5118,
        -5123, -5124, -5126, -5136, -5138, -5138, -5134, -5144, -5153, -5158,
        -5160, -5163, -5164, -5169, -5175, -5179, -5183, -5184, -5188, -5186,
        -5191, -5194, -5195, -5200, -5207, -5215, -5213, -5220, -5220, -5222,
        -5217, -5221, -5224, -5231, -5228, -5225, -5225, -5233, -5229, -5237,
        -5248, -5247, -5254, -5267, -5266, -5266, -5264, -5262, -5271, -5266,
        -5271, -5266, -5275, -5267, -5275, -5286, -5291, -5297, -5297, -5306,
        -5309, -5310, -5308, -5314, -5314, -5307, -5309, -5308, -5308, -5305,
        -5310, -5318, -5324, -5324, -5333, -5338, -5344, -5349, -5347, -5353,
        -5352, -5353, -5352, -5352, -5354, -5353, -5360, -5358, -5364, -5362,
        -5368, -5364, -5372, -5377, -5386, -5387, -5391, -5390, -5396, -5390,
        -5391, -5395, -5401, -5405, -5406, -5406, -5411, -5417, -5422, -5430,
        -5431, -5427, -5430, -5425, -5429, -5428, -5429, -5425, -5426, -5425,
        -5431, -5436, -5439, -5439, -5446, -5449, -5447, -5451, -5452, -5453,
        -5454, -5461, -5464, -5470, -5476, -5481, -5491, -5493, -5498, -5499,
        -5502, -5504, -5506, -5504, -5507, -5507, -5511, -5509, -5516, -5517,
        -5522, -5520, -5525, -5521, -5529, -5525, -5524, -5528, -5528, -5532,
        -5523, -5523, -5528, -5532, -5533, -5536, -5543, -5544, -5552, -5543,
        -5544, -5545, -5544, -5551, -5553, -5556, -5563, -5562, -5561, -5562,
        -5561, -5567, -5576, -5576, -5582, -5582, -5581, -5584, -5593, -5598,
        -5602, -5603, -5607, -5602, -5598, -5595, -5597, -5602, -5603, -5602,
        -5600, -5605, -5603, -5605, -5609, -5608, -5614, -5614, -5623, -5623,
        -5628, -5635, -5640, -5644, -5647, -5654, -5655, -5658, -5655, -5664,
        -5664, -5672, -5673, -5673, -5679, -5683, -5683, -5683, -5680, -5681,
        -5687, -5692, -5687, -5683, -5686, -5691, -5699, -5703, -5708, -5714,
        -5715, -5717, -5708, -5702, -5707, -5716, -5718, -5723, -5727, -5732,
        -5732, -5736, -5742, -5745, -5745, -5748, -5753, -5755, -5755, -5760,
        -5760, -5760, -5755, -5753, -5754, -5757, -5756, -5761, -5763, -5771,
        -5776, -5776, -5776, -5776, -5776, -5781, -5790, -5795, -5801, -5806,
        -5806, -5812, -5812, -5812, -5812, -5815, -5819, -5820, -5825, -5830,
        -5830, -5830, -5830, -5829, -5830, -5830, -5830, -5830, -5830, -5832,
        -5833, -5833, -5842, -5842, -5849, -5851, -5862, -5866, -5880, -5881,
        -5881, -5881, -5881, -5881, -5881, -5881, -5881, -5889, -5894, -5900,
        -5905, -5907, -5908, -5908, -5910, -5911, -5913, -5915, -5919, -5924,
        -5926, -5927, -5927, -5927, -5927, -5928, -5928, -5932, -5933, -5938,
        -5946, -5950, -5956, -5955, -5955, -5955, -5962, -5964, -5968, -5973,
        -5977, -5982, -5981, -5981, -5986, -5990, -5990, -5990, -5990, -5989,
        -5989, -5989, -5989, -5988, -5988, -5994, -6003, -6009, -6009, -6009,
        -6023, -6031, -6043, -6047, -6046, -6046, -6046, -6044, -6043, -6043,
        -6043, -6048, -6054, -6061, -6066, -6066, -6065, -6064, -6064, -6064,
        -6069, -6073, -6069, -6074, -6078, -6080, -6083, -6082, -6086, -6087,
        -6090, -6091, -6096, -6096, -6100, -6105, -6106, -6110, -6110, -6115,
        -6120, -6120, -6125, -6129, -6129, -6129, -6128, -6128, -6127, -6127,
        -6134, -6141, -6146, -6146, -6152, -6159, -6164, -6169, -6178, -6178,
        -6183, -6188, -6192, -6192, -6196, -6196, -6201, -6200, -6199, -6201,
        -6201, -6204, -6200, -6203, -6200, -6204, -6200, -6214, -6210, -6218,
        -6223, -6220, -6219, -6218, -6223, -6222, -6230, -6232, -6237, -6242,
        -6244, -6247, -6251, -6252, -6256, -6260, -6261, -6268, -6268, -6270,
        -6267, -6265, -6257, -6257, -6262, -6261, -6266, -6266, -6270, -6274,
        -6276, -6275, -6271, -6276, -6280, -6275, -6285, -6284, -6285, -6284,
        -6289, -6293, -6298, -6298, -6298, -6297, -6302, -6311, -6311, -6307,
        -6312, -6311, -6307, -6311, -6313, -6321, -6319, -6320, -6328, -6330,
        -6330, -6330, -6330, -6330, -6329, -6329, -6329, -6329, -6330, -6336,
        -6336, -6333, -6332, -6332, -6332, -6334, -6334, -6329, -6331, -6330,
        -6330, -6330, -6330, -6331, -6332, -6332, -6332, -6332, -6332, -6332,
        -6331, -6331, -6321, -6321, -6311, -6311, -6311, -6311, -6311, -6311,
        -6311, -6312, -6316, -6316, -6315, -6316, -6312, -6312, -6312, -6312,
        -6312, -6312, -6312, -6312, -6312, -6307, -6307, -6297, -6291, -6291,
        -6291, -6292, -6292, -6296, -6298, -6295, -6289, -6285, -6287, -6290,
        -6296, -6299, -6296, -6295, -6291, -6291, -6291, -6293, -6290, -6286,
        -6283, -6280, -6276, -6279, -6276, -6275, -6276, -6276, -6281, -6276,
        -6267, -6266, -6262, -6262, -6253, -6252, -6243, -6243, -6243, -6246,
        -6243, -6243, -6239, -6234, -6228, -6228, -6227, -6224, -6224, -6214,
        -6210, -6208, -6211, -6212, -6210, -6203, -6202, -6210, -6209, -6205,
        -6201, -6206, -6197, -6196, -6188, -6190, -6183, -6186, -6188, -6191,
        -6191, -6187, -6189, -6184, -6185, -6183, -6182, -6177, -6181, -6175,
        -6176, -6171, -6173, -6172, -6172, -6168, -6170, -6168, -6166, -6176,
        -6168, -6173, -6164, -6159, -6162, -6155, -6159, -6156, -6154, -6153,
        -6147, -6143, -6140, -6132, -6132, -6123, -6118, -6118, -6124, -6114,
        -6117, -6115, -6118, -6120, -6115, -6124, -6124, -6115, -6113, -6110,
        -6106, -6104, -6106, -6105, -6105, -6097, -6100, -6092, -6092, -6086,
        -6093, -6084, -6087, -6083, -6074, -6081, -6073, -6076, -6073, -6073,
        -6073, -6073, -6073, -6077, -6071, -6077, -6077, -6072, -6063, -6058,
        -6057, -6048, -6048, -6048, -6047, -6046, -6047, -6057, -6059, -6062,
        -6066, -6062, -6065, -6062, -6057, -6052, -6054, -6052, -6048, -6044,
        -6044, -6043, -6046, -6053, -6063, -6058, -6061, -6056, -6057, -6057,
        -6053, -6048, -6050, -6049, -6050, -6045, -6049, -6046, -6048, -6045,
        -6044, -6048, -6047, -6050, -6050, -6050, -6050, -6052, -6052, -6053,
        -6053, -6056, -6049, -6051, -6049, -6049, -6053, -6054, -6054, -6054,
        -6054, -6054, -6054, -6054, -6054, -6054, -6054, -6054, -6054, -6054,
        -6054, -6054, -6054, -6054, -6054, -6054, -6054, -6054, -6054, -6054,
        -6059, -6059, -6069, -6074, -6074, -6074, -6074, -6074, -6074, -6074,
        -6079, -6088, -6088, -6090, -6085, -6094, -6089, -6094, -6091, -6096,
        -6096, -6092, -6093, -6093, -6093, -6095, -6091, -6097, -6091, -6099,
        -6092, -6099, -6097, -6108, -6106, -6110, -6111, -6111, -6115, -6113,
        -6112, -6114, -6119, -6116, -6119, -6123, -6120, -6120, -6124, -6124,
        -6120, -6134, -6139, -6143, -6135, -6139, -6147, -6158, -6153, -6148,
        -6164, -6160, -6156, -6156, -6156, -6159, -6146, -6146, -6141, -6145,
        -6151, -6156, -6163, -6159, -6157, -6161, -6153, -6154, -6143, -6152,
        -6163, -6159, -6152, -6147, -6144, -6164, -6155, -6154, -6154, -6154,
        -6155, -6159, -6156, -6145, -6131, -6132, -6126, -6127, -6136, -6131,
        -6135, -6141, -6150, -6142, -6143, -6142, -6133, -6130, -6126, -6123,
        -6122, -6120, -6124, -6120, -6110, -6109, -6111, -6112, -6109, -6104,
        -6109, -6096, -6096, -6094, -6096, -6095, -6081, -6086, -6087, -6078,
        -6070, -6068, -6067, -6064, -6056, -6054, -6047, -6047, -6053, -6059,
        -6063, -6064, -6063, -6063, -6064, -6058, -6053, -6046, -6039, -6033,
        -6032, -6023, -6015, -6005, -6005, -6000, -5990, -5985, -5987, -5980,
        -5971, -5962, -5953, -5949, -5949, -5949, -5950, -5954, -5951, -5947,
        -5940, -5940, -5935, -5926, -5921, -5921, -5916, -5911, -5911, -5903,
        -5894, -5894, -5889, -5889, -5888, -5889, -5888, -5879, -5878, -5878,
        -5879, -5878, -5876, -5871, -5866, -5858, -5856, -5847, -5847, -5842,
        -5842, -5843, -5847, -5843, -5845, -5848, -5850, -5846, -5844, -5841,
        -5841, -5844, -5853, -5852, -5844, -5843, -5840, -5847, -5847, -5848,
        -5842, -5845, -5846, -5841, -5845, -5841, -5842, -5839, -5841, -5840,
        -5833, -5833, -5831, -5835, -5836, -5836, -5825, -5822, -5825, -5827,
        -5827, -5821, -5822, -5827, -5827, -5830, -5826, -5832, -5838, -5836,
        -5836, -5831, -5824, -5825, -5817, -5812, -5792, -5792, -5784, -5784,
        -5771, -5767, -5758, -5753, -5740, -5735, -5717, -5706, -5693, -5689,
        -5685, -5667, -5662, -5650, -5631, -5617, -5599, -5587, -5580, -5565,
        -5536, -5517, -5503, -5479, -5462, -5417, -5394, -5353, -5304, -5283,
        -5253, -5244, -5217, -5169, -5143, -5116, -5093, -5081
    };

    static const int16_t robinson_dadson_curve_30_phons[1468] =
    {
        -2925, -2922, -2921, -2923, -2923, -2926, -2935, -2941, -2945, -2948,
        -2956, -2959, -2961, -2970, -2971, -2977, -2985, -2990, -2996, -2996,
        -3006, -3006, -3011, -3021, -3024, -3025, -3027, -3031, -3026, -3031,
        -3039, -3047, -3058, -3074, -3083, -3082, -3083, -3091, -3102, -3104,
        -3100, -3099, -3109, -3107, -3104, -3103, -3110, -3118, -3111, -3113,
        -3120, -3128, -3137, -3141, -3141, -3140, -3146, -3154, -3157, -3158,
        -3158, -3160, -3167, -3171, -3169, -3178, -3180, -3184, -3184, -3200,
        -3205, -3206, -3204, -3210, -3213, -3208, -3209, -3210, -3214, -3221,
        -3219, -3230, -3238, -3248, -3247, -3239, -3246, -3246, -3244, -3259,
        -3259, -3266, -3268, -3279, -3280, -3286, -3292, -3293, -3294, -3299,
        -3301, -3306, -3310, -3317, -3319, -3324, -3325, -3323, -3323, -3324,
        -3332, -3337, -3342, -3347, -3350, -3357, -3360, -3358, -3367, -3364,
        -3366, -3371, -3382, -3381, -3382, -3388, -3402, -3408, -3413, -3416,
        -3420, -3425, -3430, -3431, -3435, -3439, -3446, -3450, -3459, -3462,
        -3465, -3476, -3480, -3483, -3489, -3500, -3499, -3498, -3498, -3510,
        -3509, -3508, -3512, -3521, -3525, -3536, -3540, -3539, -3542, -3548,
        -3552, -3561, -3568, -3576, -3580, -3584, -3590, -3597, -3601, -3608,
        -3610, -3614, -3619, -3621, -3624, -3627, -3633, -3638, -3646, -3650,
        -3650, -3653, -3656, -3662, -3664, -3669, -3674, -3682, -3689, -3693,
        -3690, -3701, -3705, -3699, -3701, -3709, -3719, -3731, -3740, -3748,
        -3751, -3756, -3757, -3762, -3764, -3772, -3780, -3783, -3791, -3793,
        -3792, -3788, -3795, -3803, -3805, -3811, -3821, -3826, -3830, -3835,
        -3839, -3847, -3852, -3856, -3861, -3862, -3873, -3874, -3885, -3888,
        -3891, -3891, -3896, -3904, -3905, -3913, -3913, -3924, -3926, -3932,
        -3930, -3935, -3938, -3948, -3955, -3955, -3960, -3966, -3962, -3969,
        -3971, -3975, -3981, -3981, -3988, -3989, -3991, -3996, -3998, -3999,
        -3995, -4004, -4003, -4016, -4018, -4027, -4029, -4038, -4041, -4049,
        -4052, -4060, -4063, -4060, -4066, -4071, -4076, -4076, -4084, -4087,
        -4090, -4092, -4094, -4102, -4101, -4107, -4111, -4121, -4123, -4123,
        -4129, -4134, -4137, -4142, -4145, -4143, -4147, -4147, -4149, -4153,
        -4155, -4161, -4165, -4171, -4180, -4191, -4191, -4200, -4197, -4189,
        -4194, -4206, -4211, -4209, -4212, -4219, -4221, -4213, -4211, -4213,
        -4222, -4225, -4227, -4237, -4237, -4238, -4247, -4246, -4248, -4248,
        -4248, -4253, -4255, -4255, -4259, -4261, -4270, -4272, -4282, -4281,
        -4289, -4289, -4302, -4299, -4307, -4311, -4312, -4314, -4316, -4316,
        -4319, -4322, -4319, -4315, -4319, -4324, -4326, -4326, -4337, -4335,
        -4341, -4339, -4343, -4344, -4346, -4349, -4353, -4356, -4354, -4358,
        -4361, -4360, -4363, -4370, -4372, -4372, -4372, -4384, -4393, -4396,
        -4399, -4401, -4402, -4405, -4408, -4413, -4417, -4417, -4422, -4421,
        -4425, -4426, -4430, -4432, -4440, -4446, -4445, -4449, -4449, -4454,
        -4453, -4454, -4458, -4464, -4462, -4459, -4459, -4464, -4462, -4469,
        -4476, -4476, -4485, -4491, -4489, -4488, -4487, -4484, -4491, -4486,
        -4492, -4488, -4497, -4491, -4498, -4505, -4509, -4513, -4515, -4522,
        -4522, -4524, -4522, -4527, -4531, -4526, -4528, -4527, -4528, -4524,
        -4528, -4535, -4541, -4542, -4547, -4549, -4552, -4557, -4552, -4558,
        -4557, -4560, -4557, -4563, -4568, -4568, -4571, -4571, -4579, -4574,
        -4581, -4575, -4582, -4585, -4592, -4589, -4593, -4588, -4593, -4590,
        -4588, -4595, -4601, -4607, -4608, -4610, -4615, -4623, -4628, -4635,
        -4637, -4633, -4634, -4627, -4627, -4624, -4625, -4621, -4625, -4628,
        -4634, -4640, -4642, -4643, -4649, -4653, -4649, -4649, -4652, -4651,
        -4652, -4658, -4658, -4663, -4669, -4674, -4680, -4685, -4687, -4688,
        -4691, -4694, -4694, -4698, -4700, -4698, -4700, -4702, -4705, -4705,
        -4708, -4706, -4707, -4705, -4711, -4708, -4706, -4709, -4708, -4712,
        -4705, -4707, -4712, -4717, -4717, -4721, -4724, -4730, -4734, -4729,
        -4730, -4732, -4732, -4736, -4737, -4743, -4747, -4745, -4743, -4744,
        -4744, -4749, -4755, -4758, -4761, -4762, -4758, -4761, -4766, -4770,
        -4775, -4776, -4779, -4777, -4771, -4769, -4775, -4780, -4782, -4782,
        -4779, -4782, -4780, -4780, -4784, -4784, -4789, -4792, -4799, -4801,
        -4803, -4806, -4808, -4810, -4813, -4823, -4824, -4823, -4819, -4825,
        -4828, -4834, -4839, -4842, -4847, -4851, -4851, -4851, -4848, -4846,
        -4849, -4854, -4853, -4851, -4853, -4856, -4860, -4863, -4867, -4871,
        -4872, -4874, -4865, -4861, -4865, -4871, -4874, -4877, -4881, -4884,
        -4885, -4888, -4894, -4895, -4895, -4897, -4904, -4905, -4906, -4909,
        -4906, -4905, -4901, -4901, -4902, -4905, -4907, -4908, -4909, -4915,
        -4920, -4922, -4924, -4924, -4924, -4927, -4933, -4936, -4938, -4941,
        -4941, -4946, -4948, -4950, -4950, -4954, -4956, -4956, -4959, -4962,
        -4962, -4962, -4961, -4961, -4963, -4964, -4964, -4968, -4968, -4970,
        -4970, -4970, -4974, -4972, -4976, -4977, -4987, -4990, -5002, -5003,
        -5004, -5004, -5004, -5004, -5005, -5005, -5005, -5011, -5016, -5021,
        -5026, -5026, -5026, -5027, -5028, -5028, -5029, -5030, -5033, -5038,
        -5040, -5041, -5041, -5042, -5042, -5042, -5043, -5046, -5047, -5050,
        -5055, -5058, -5061, -5061, -5061, -5061, -5064, -5065, -5067, -5069,
        -5074, -5078, -5078, -5077, -5083, -5087, -5087, -5086, -5086, -5086,
        -5086, -5085, -5085, -5085, -5085, -5090, -5100, -5105, -5105, -5106,
        -5117, -5122, -5133, -5134, -5132, -5132, -5131, -5130, -5128, -5127,
        -5126, -5131, -5135, -5142, -5146, -5146, -5145, -5145, -5144, -5144,
        -5149, -5154, -5150, -5153, -5157, -5156, -5156, -5156, -5157, -5159,
        -5162, -5163, -5168, -5168, -5171, -5174, -5176, -5175, -5175, -5178,
        -5183, -5182, -5188, -5192, -5192, -5191, -5187, -5186, -5184, -5181,
        -5187, -5195, -5199, -5198, -5202, -5208, -5211, -5213, -5223, -5223,
        -5228, -5232, -5234, -5234, -5238, -5237, -5240, -5239, -5238, -5241,
        -5243, -5247, -5245, -5247, -5244, -5247, -5243, -5257, -5253, -5258,
        -5263, -5258, -5257, -5255, -5256, -5253, -5256, -5258, -5259, -5262,
        -5264, -5267, -5271, -5272, -5276, -5280, -5281, -5288, -5288, -5289,
        -5287, -5282, -5275, -5277, -5281, -5281, -5285, -5281, -5283, -5285,
        -5287, -5284, -5282, -5282, -5286, -5284, -5289, -5288, -5291, -5288,
        -5293, -5297, -5302, -5299, -5299, -5294, -5299, -5304, -5305, -5301,
        -5302, -5302, -5299, -5302, -5304, -5312, -5309, -5309, -5316, -5317,
        -5317, -5317, -5317, -5316, -5315, -5318, -5317, -5318, -5318, -5323,
        -5322, -5320, -5319, -5317, -5315, -5314, -5311, -5308, -5308, -5307,
        -5308, -5308, -5308, -5308, -5312, -5314, -5314, -5316, -5318, -5318,
        -5318, -5317, -5307, -5307, -5297, -5297, -5297, -5297, -5297, -5297,
        -5298, -5298, -5300, -5297, -5295, -5294, -5289, -5289, -5287, -5287,
        -5288, -5290, -5290, -5290, -5291, -5286, -5286, -5278, -5274, -5274,
        -5275, -5275, -5276, -5279, -5282, -5278, -5271, -5266, -5266, -5268,
        -5274, -5279, -5275, -5277, -5272, -5271, -5270, -5270, -5267, -5263,
        -5260, -5257, -5255, -5256, -5251, -5254, -5255, -5253, -5258, -5253,
        -5244, -5243, -5239, -5239, -5230, -5230, -5221, -5222, -5225, -5228,
        -5222, -5222, -5219, -5215, -5211, -5209, -5210, -5207, -5205, -5198,
        -5194, -5190, -5192, -5191, -5187, -5182, -5181, -5185, -5184, -5180,
        -5178, -5181, -5173, -5175, -5168, -5170, -5164, -5167, -5169, -5170,
        -5171, -5168, -5170, -5163, -5163, -5160, -5161, -5155, -5160, -5156,
        -5156, -5151, -5152, -5149, -5149, -5147, -5145, -5144, -5145, -5151,
        -5143, -5148, -5143, -5141, -5144, -5140, -5144, -5144, -5142, -5139,
        -5131, -5124, -5124, -5118, -5116, -5107, -5104, -5101, -5108, -5101,
        -5101, -5101, -5102, -5106, -5101, -5107, -5108, -5102, -5099, -5098,
        -5092, -5093, -5090, -5091, -5089, -5085, -5087, -5082, -5082, -5079,
        -5084, -5077, -5082, -5078, -5069, -5073, -5070, -5070, -5066, -5064,
        -5063, -5061, -5061, -5068, -5064, -5068, -5070, -5065, -5056, -5050,
        -5050, -5045, -5044, -5044, -5040, -5039, -5038, -5048, -5052, -5052,
        -5057, -5053, -5054, -5051, -5047, -5044, -5047, -5045, -5041, -5039,
        -5042, -5041, -5040, -5046, -5052, -5049, -5050, -5047, -5046, -5047,
        -5046, -5044, -5046, -5043, -5045, -5042, -5044, -5039, -5039, -5038,
        -5038, -5042, -5044, -5048, -5049, -5046, -5048, -5051, -5051, -5051,
        -5051, -5052, -5045, -5043, -5039, -5037, -5040, -5044, -5045, -5049,
        -5049, -5049, -5049, -5049, -5049, -5053, -5053, -5053, -5058, -5058,
        -5058, -5058, -5058, -5058, -5059, -5058, -5058, -5058, -5058, -5058,
        -5061, -5058, -5066, -5067, -5067, -5065, -5065, -5064, -5064, -5065,
        -5069, -5076, -5077, -5080, -5078, -5087, -5085, -5091, -5091, -5096,
        -5098, -5094, -5093, -5094, -5093, -5097, -5095, -5101, -5099, -5105,
        -5098, -5101, -5099, -5106, -5108, -5115, -5115, -5115, -5121, -5121,
        -5120, -5123, -5125, -5120, -5124, -5128, -5129, -5128, -5130, -5128,
        -5126, -5136, -5138, -5139, -5134, -5136, -5147, -5157, -5154, -5148,
        -5165, -5169, -5163, -5160, -5161, -5163, -5152, -5152, -5149, -5152,
        -5156, -5161, -5167, -5164, -5162, -5169, -5163, -5161, -5152, -5160,
        -5175, -5172, -5168, -5163, -5164, -5184, -5175, -5173, -5171, -5177,
        -5174, -5179, -5178, -5170, -5156, -5157, -5152, -5151, -5159, -5153,
        -5154, -5157, -5165, -5160, -5161, -5160, -5151, -5148, -5147, -5147,
        -5144, -5145, -5150, -5149, -5143, -5143, -5149, -5152, -5147, -5146,
        -5149, -5136, -5135, -5135, -5140, -5135, -5123, -5129, -5132, -5125,
        -5117, -5117, -5117, -5116, -5112, -5110, -5106, -5107, -5111, -5116,
        -5118, -5118, -5117, -5120, -5122, -5119, -5117, -5112, -5108, -5100,
        -5103, -5095, -5093, -5083, -5083, -5077, -5071, -5067, -5069, -5063,
        -5056, -5047, -5040, -5036, -5038, -5038, -5041, -5046, -5042, -5038,
        -5037, -5034, -5031, -5027, -5024, -5024, -5021, -5019, -5019, -5013,
        -5006, -5006, -5001, -4999, -4996, -4997, -4999, -4994, -4997, -4999,
        -5000, -5001, -5000, -4999, -4994, -4989, -4987, -4983, -4984, -4982,
        -4981, -4984, -4987, -4983, -4986, -4989, -4989, -4987, -4985, -4982,
        -4986, -4988, -4994, -4993, -4985, -4989, -4986, -4991, -4994, -4996,
        -4992, -4997, -5000, -5000, -5005, -5003, -4999, -4996, -5004, -5000,
        -4993, -4993, -4993, -4996, -4994, -4993, -4990, -4990, -4994, -4995,
        -4997, -4995, -5000, -5003, -5007, -5010, -5008, -5012, -5013, -5017,
        -5024, -5017, -5006, -5009, -5008, -5005, -4987, -4988, -4986, -4989,
        -4975, -4975, -4970, -4968, -4957, -4953, -4938, -4931, -4922, -4920,
        -4917, -4907, -4906, -4897, -4883, -4873, -4858, -4847, -4837, -4823,
        -4810, -4789, -4778, -4754, -4741, -4699, -4685, -4643, -4609, -4593,
        -4574, -4559, -4536, -4503, -4478, -4456, -4437, -4429
    };

    static const int16_t robinson_dadson_curve_40_phons[1468] =
    {
        -2450, -2445, -2441, -2441, -2437, -2438, -2447, -2453, -2455, -2455,
        -2465, -2467, -2467, -2480, -2481, -2484, -2489, -2496, -2504, -2502,
        -2510, -2508, -2513, -2526, -2527, -2529, -2529, -2537, -2533, -2534,
        -2546, -2553, -2562, -2577, -2582, -2578, -2578, -2581, -2591, -2594,
        -2588, -2583, -2592, -2590, -2587, -2586, -2594, -2597, -2583, -2589,
        -2597, -2611, -2621, -2625, -2622, -2622, -2628, -2635, -2638, -2638,
        -2639, -2641, -2648, -2653, -2650, -2658, -2659, -2656, -2656, -2667,
        -2679, -2677, -2669, -2669, -2671, -2666, -2669, -2671, -2678, -2684,
        -2686, -2697, -2703, -2706, -2707, -2700, -2702, -2702, -2699, -2720,
        -2717, -2724, -2720, -2731, -2731, -2740, -2743, -2744, -2743, -2751,
        -2752, -2760, -2765, -2771, -2771, -2774, -2772, -2769, -2766, -2766,
        -2775, -2775, -2780, -2789, -2792, -2799, -2798, -2794, -2808, -2802,
        -2802, -2806, -2818, -2817, -2814, -2815, -2829, -2833, -2841, -2845,
        -2846, -2848, -2854, -2852, -2857, -2858, -2864, -2867, -2878, -2879,
        -2880, -2893, -2895, -2899, -2904, -2917, -2915, -2912, -2913, -2923,
        -2923, -2918, -2918, -2928, -2929, -2938, -2941, -2938, -2940, -2943,
        -2947, -2956, -2961, -2965, -2971, -2972, -2974, -2981, -2985, -2994,
        -2996, -2999, -3000, -3004, -3007, -3009, -3017, -3027, -3032, -3034,
        -3028, -3028, -3028, -3033, -3034, -3041, -3045, -3051, -3056, -3060,
        -3059, -3067, -3070, -3063, -3065, -3073, -3078, -3092, -3102, -3107,
        -3108, -3116, -3116, -3121, -3121, -3127, -3138, -3141, -3146, -3149,
        -3149, -3144, -3149, -3158, -3158, -3164, -3172, -3174, -3179, -3183,
        -3185, -3189, -3189, -3192, -3197, -3199, -3212, -3213, -3222, -3225,
        -3227, -3226, -3229, -3237, -3236, -3248, -3247, -3257, -3258, -3262,
        -3258, -3258, -3261, -3264, -3273, -3274, -3280, -3283, -3281, -3286,
        -3288, -3291, -3295, -3292, -3301, -3303, -3299, -3304, -3309, -3309,
        -3304, -3318, -3318, -3327, -3328, -3337, -3337, -3339, -3341, -3347,
        -3353, -3359, -3361, -3354, -3358, -3365, -3368, -3368, -3373, -3374,
        -3381, -3383, -3384, -3389, -3388, -3394, -3400, -3406, -3406, -3404,
        -3409, -3412, -3418, -3421, -3425, -3425, -3430, -3430, -3431, -3435,
        -3435, -3440, -3443, -3450, -3460, -3470, -3471, -3479, -3476, -3465,
        -3470, -3479, -3482, -3480, -3483, -3488, -3489, -3479, -3479, -3482,
        -3494, -3496, -3498, -3509, -3508, -3508, -3514, -3512, -3513, -3513,
        -3513, -3517, -3517, -3516, -3520, -3523, -3532, -3533, -3542, -3539,
        -3547, -3547, -3561, -3557, -3564, -3566, -3565, -3564, -3566, -3566,
        -3570, -3574, -3570, -3562, -3563, -3567, -3568, -3569, -3581, -3581,
        -3589, -3589, -3593, -3597, -3597, -3598, -3602, -3604, -3599, -3598,
        -3599, -3596, -3600, -3605, -3605, -3605, -3610, -3625, -3633, -3634,
        -3639, -3639, -3639, -3641, -3642, -3646, -3650, -3651, -3655, -3655,
        -3659, -3657, -3664, -3665, -3673, -3677, -3676, -3679, -3678, -3685,
        -3688, -3688, -3693, -3698, -3697, -3692, -3692, -3696, -3696, -3701,
        -3705, -3706, -3716, -3716, -3711, -3711, -3710, -3706, -3711, -3706,
        -3712, -3711, -3719, -3715, -3721, -3725, -3727, -3728, -3733, -3737,
        -3735, -3738, -3736, -3741, -3747, -3745, -3748, -3745, -3747, -3743,
        -3747, -3752, -3759, -3759, -3761, -3759, -3759, -3764, -3757, -3764,
        -3762, -3766, -3762, -3774, -3781, -3783, -3782, -3785, -3794, -3786,
        -3794, -3786, -3791, -3793, -3799, -3791, -3795, -3786, -3791, -3790,
        -3786, -3795, -3801, -3810, -3810, -3814, -3819, -3829, -3834, -3839,
        -3844, -3839, -3838, -3829, -3825, -3820, -3820, -3818, -3825, -3830,
        -3838, -3844, -3845, -3847, -3853, -3856, -3851, -3847, -3851, -3850,
        -3851, -3855, -3851, -3856, -3862, -3867, -3868, -3878, -3875, -3877,
        -3879, -3884, -3883, -3893, -3893, -3889, -3889, -3895, -3893, -3892,
        -3894, -3893, -3889, -3889, -3893, -3892, -3888, -3891, -3887, -3891,
        -3886, -3891, -3896, -3903, -3901, -3905, -3906, -3915, -3916, -3914,
        -3917, -3918, -3920, -3921, -3921, -3930, -3931, -3929, -3924, -3926,
        -3927, -3931, -3934, -3939, -3940, -3943, -3935, -3938, -3938, -3941,
        -3948, -3949, -3952, -3951, -3944, -3943, -3952, -3958, -3961, -3961,
        -3958, -3959, -3957, -3955, -3959, -3961, -3964, -3969, -3974, -3978,
        -3978, -3977, -3976, -3976, -3979, -3991, -3992, -3987, -3982, -3987,
        -3993, -3996, -4005, -4010, -4015, -4019, -4019, -4020, -4015, -4010,
        -4011, -4015, -4019, -4020, -4020, -4021, -4022, -4023, -4027, -4027,
        -4029, -4031, -4023, -4020, -4023, -4026, -4031, -4032, -4035, -4036,
        -4039, -4041, -4045, -4046, -4046, -4046, -4054, -4056, -4056, -4057,
        -4052, -4051, -4047, -4049, -4051, -4053, -4057, -4055, -4055, -4059,
        -4064, -4068, -4072, -4072, -4072, -4073, -4076, -4077, -4075, -4075,
        -4076, -4080, -4084, -4089, -4089, -4093, -4093, -4093, -4093, -4093,
        -4093, -4093, -4093, -4093, -4097, -4098, -4098, -4107, -4107, -4107,
        -4107, -4107, -4106, -4103, -4102, -4102, -4112, -4113, -4124, -4126,
        -4127, -4127, -4127, -4127, -4130, -4130, -4128, -4133, -4137, -4142,
        -4146, -4145, -4145, -4145, -4145, -4145, -4145, -4145, -4148, -4153,
        -4155, -4155, -4156, -4156, -4156, -4156, -4157, -4161, -4161, -4162,
        -4165, -4166, -4166, -4166, -4166, -4166, -4166, -4166, -4165, -4165,
        -4170, -4174, -4174, -4174, -4179, -4183, -4183, -4182, -4182, -4182,
        -4182, -4182, -4181, -4181, -4181, -4186, -4196, -4202, -4202, -4202,
        -4211, -4212, -4222, -4220, -4217, -4217, -4217, -4216, -4212, -4210,
        -4209, -4213, -4217, -4222, -4227, -4227, -4226, -4226, -4225, -4225,
        -4230, -4234, -4231, -4232, -4235, -4232, -4230, -4229, -4229, -4231,
        -4233, -4234, -4239, -4239, -4243, -4243, -4245, -4240, -4239, -4240,
        -4245, -4245, -4250, -4255, -4254, -4254, -4246, -4244, -4240, -4235,
        -4241, -4249, -4253, -4249, -4251, -4257, -4258, -4258, -4267, -4268,
        -4273, -4275, -4277, -4276, -4279, -4278, -4279, -4278, -4277, -4282,
        -4285, -4290, -4289, -4290, -4287, -4289, -4285, -4299, -4296, -4299,
        -4303, -4296, -4294, -4292, -4289, -4284, -4283, -4285, -4281, -4282,
        -4284, -4287, -4291, -4292, -4296, -4299, -4301, -4308, -4308, -4308,
        -4306, -4298, -4292, -4297, -4301, -4301, -4304, -4296, -4296, -4297,
        -4298, -4292, -4292, -4289, -4292, -4292, -4293, -4292, -4297, -4293,
        -4297, -4301, -4306, -4301, -4301, -4292, -4297, -4297, -4298, -4296,
        -4293, -4293, -4291, -4292, -4294, -4302, -4299, -4298, -4303, -4303,
        -4303, -4303, -4303, -4302, -4301, -4306, -4305, -4306, -4307, -4310,
        -4309, -4307, -4306, -4302, -4298, -4294, -4289, -4287, -4285, -4285,
        -4285, -4285, -4285, -4285, -4291, -4296, -4296, -4300, -4305, -4304,
        -4304, -4303, -4294, -4293, -4283, -4283, -4283, -4283, -4284, -4283,
        -4284, -4284, -4284, -4279, -4275, -4271, -4266, -4266, -4262, -4262,
        -4264, -4267, -4268, -4268, -4271, -4266, -4266, -4259, -4256, -4257,
        -4259, -4259, -4260, -4262, -4267, -4262, -4253, -4247, -4246, -4246,
        -4252, -4258, -4254, -4258, -4254, -4250, -4250, -4247, -4244, -4240,
        -4237, -4234, -4234, -4233, -4226, -4234, -4235, -4231, -4235, -4230,
        -4222, -4221, -4216, -4217, -4207, -4207, -4198, -4202, -4206, -4209,
        -4202, -4201, -4200, -4196, -4194, -4191, -4192, -4190, -4186, -4182,
        -4177, -4172, -4173, -4171, -4165, -4162, -4161, -4161, -4160, -4156,
        -4155, -4155, -4150, -4154, -4147, -4149, -4145, -4147, -4151, -4149,
        -4150, -4150, -4150, -4142, -4142, -4138, -4141, -4133, -4138, -4137,
        -4135, -4132, -4132, -4127, -4127, -4125, -4120, -4121, -4124, -4127,
        -4118, -4123, -4123, -4123, -4126, -4125, -4129, -4132, -4131, -4125,
        -4115, -4106, -4108, -4105, -4100, -4091, -4090, -4085, -4092, -4088,
        -4085, -4087, -4086, -4092, -4087, -4090, -4092, -4088, -4086, -4086,
        -4078, -4081, -4074, -4077, -4073, -4072, -4073, -4073, -4072, -4072,
        -4075, -4070, -4076, -4073, -4065, -4066, -4068, -4063, -4060, -4055,
        -4053, -4050, -4050, -4059, -4056, -4058, -4063, -4058, -4049, -4043,
        -4043, -4043, -4040, -4039, -4033, -4032, -4029, -4038, -4045, -4043,
        -4047, -4043, -4043, -4040, -4036, -4036, -4039, -4038, -4034, -4034,
        -4040, -4038, -4035, -4039, -4041, -4039, -4039, -4038, -4034, -4038,
        -4039, -4039, -4043, -4037, -4041, -4038, -4039, -4032, -4031, -4030,
        -4031, -4035, -4041, -4046, -4048, -4042, -4045, -4051, -4050, -4050,
        -4048, -4047, -4040, -4036, -4030, -4026, -4026, -4035, -4035, -4044,
        -4044, -4044, -4044, -4044, -4044, -4053, -4053, -4053, -4062, -4062,
        -4062, -4063, -4063, -4063, -4063, -4063, -4062, -4062, -4062, -4062,
        -4062, -4056, -4064, -4061, -4060, -4056, -4056, -4054, -4053, -4055,
        -4059, -4065, -4066, -4070, -4071, -4079, -4080, -4088, -4090, -4095,
        -4100, -4096, -4092, -4095, -4092, -4099, -4099, -4106, -4107, -4111,
        -4104, -4103, -4101, -4105, -4110, -4119, -4119, -4120, -4128, -4128,
        -4129, -4131, -4131, -4124, -4128, -4133, -4138, -4137, -4137, -4132,
        -4132, -4137, -4138, -4134, -4134, -4134, -4146, -4157, -4155, -4148,
        -4167, -4177, -4170, -4164, -4165, -4168, -4159, -4159, -4158, -4158,
        -4161, -4165, -4172, -4168, -4168, -4177, -4173, -4169, -4161, -4169,
        -4187, -4185, -4183, -4178, -4184, -4204, -4195, -4192, -4189, -4200,
        -4193, -4199, -4199, -4195, -4180, -4182, -4178, -4176, -4183, -4175,
        -4173, -4174, -4180, -4177, -4180, -4178, -4169, -4166, -4168, -4171,
        -4167, -4169, -4176, -4179, -4177, -4178, -4187, -4192, -4186, -4189,
        -4189, -4176, -4175, -4176, -4185, -4175, -4166, -4171, -4177, -4171,
        -4163, -4166, -4167, -4169, -4167, -4167, -4166, -4168, -4169, -4174,
        -4174, -4172, -4170, -4176, -4180, -4181, -4180, -4178, -4176, -4167,
        -4174, -4167, -4171, -4161, -4161, -4155, -4152, -4149, -4151, -4146,
        -4141, -4132, -4127, -4123, -4128, -4128, -4133, -4138, -4134, -4130,
        -4133, -4128, -4128, -4127, -4127, -4127, -4127, -4127, -4127, -4122,
        -4117, -4118, -4113, -4108, -4104, -4105, -4109, -4110, -4115, -4120,
        -4122, -4124, -4124, -4126, -4123, -4120, -4118, -4119, -4120, -4123,
        -4120, -4126, -4126, -4124, -4127, -4131, -4129, -4128, -4126, -4123,
        -4132, -4132, -4136, -4134, -4126, -4135, -4133, -4135, -4140, -4145,
        -4142, -4150, -4155, -4159, -4164, -4164, -4156, -4153, -4168, -4160,
        -4152, -4152, -4155, -4156, -4151, -4151, -4155, -4158, -4163, -4164,
        -4167, -4168, -4178, -4179, -4187, -4189, -4190, -4193, -4188, -4199,
        -4213, -4203, -4188, -4192, -4199, -4198, -4183, -4183, -4188, -4193,
        -4180, -4184, -4181, -4184, -4175, -4170, -4159, -4155, -4151, -4151,
        -4148, -4147, -4149, -4144, -4135, -4128, -4116, -4106, -4094, -4080,
        -4084, -4061, -4053, -4030, -4019, -3982, -3977, -3933, -3915, -3903,
        -3896, -3873, -3855, -3836, -3813, -3796, -3780, -3778
    };

    static const int16_t robinson_dadson_curve_50_phons[1468] =
    {
        -1912, -1907, -1908, -1910, -1908, -1909, -1916, -1921, -1921, -1921,
        -1928, -1932, -1931, -1939, -1938, -1942, -1945, -1948, -1952, -1949,
        -1956, -1955, -1962, -1971, -1972, -1975, -1975, -1983, -1981, -1986,
        -1992, -1999, -2007, -2017, -2023, -2021, -2018, -2024, -2027, -2027,
        -2023, -2020, -2028, -2025, -2022, -2019, -2026, -2030, -2021, -2024,
        -2035, -2042, -2050, -2054, -2051, -2053, -2064, -2072, -2071, -2074,
        -2073, -2072, -2076, -2075, -2069, -2076, -2077, -2073, -2065, -2074,
        -2079, -2073, -2068, -2068, -2071, -2066, -2067, -2069, -2076, -2084,
        -2083, -2090, -2096, -2097, -2096, -2091, -2093, -2094, -2091, -2102,
        -2106, -2117, -2121, -2131, -2131, -2133, -2139, -2140, -2137, -2148,
        -2151, -2156, -2159, -2163, -2165, -2166, -2163, -2162, -2159, -2160,
        -2167, -2166, -2170, -2176, -2178, -2183, -2184, -2181, -2190, -2185,
        -2187, -2189, -2199, -2198, -2198, -2200, -2208, -2208, -2212, -2213,
        -2214, -2221, -2223, -2222, -2223, -2224, -2233, -2235, -2243, -2244,
        -2244, -2256, -2257, -2259, -2262, -2271, -2272, -2269, -2268, -2276,
        -2274, -2271, -2271, -2280, -2281, -2288, -2288, -2285, -2288, -2294,
        -2295, -2299, -2303, -2306, -2314, -2316, -2318, -2320, -2324, -2328,
        -2326, -2330, -2330, -2332, -2334, -2337, -2343, -2348, -2351, -2352,
        -2349, -2349, -2349, -2352, -2354, -2359, -2366, -2372, -2379, -2380,
        -2377, -2383, -2383, -2380, -2382, -2389, -2395, -2406, -2412, -2417,
        -2420, -2424, -2422, -2427, -2427, -2432, -2440, -2443, -2448, -2449,
        -2446, -2441, -2446, -2450, -2450, -2456, -2464, -2466, -2471, -2473,
        -2474, -2481, -2479, -2480, -2485, -2484, -2495, -2496, -2502, -2505,
        -2508, -2504, -2509, -2515, -2513, -2523, -2523, -2533, -2534, -2537,
        -2534, -2535, -2535, -2537, -2544, -2542, -2547, -2550, -2548, -2553,
        -2554, -2556, -2557, -2557, -2562, -2562, -2561, -2564, -2567, -2566,
        -2563, -2569, -2569, -2579, -2579, -2589, -2587, -2593, -2591, -2597,
        -2605, -2613, -2613, -2608, -2610, -2616, -2619, -2619, -2623, -2627,
        -2633, -2635, -2631, -2637, -2633, -2639, -2639, -2646, -2644, -2646,
        -2651, -2655, -2658, -2661, -2662, -2661, -2664, -2664, -2665, -2669,
        -2669, -2674, -2675, -2682, -2688, -2698, -2699, -2705, -2702, -2693,
        -2697, -2704, -2705, -2701, -2703, -2708, -2708, -2698, -2698, -2703,
        -2711, -2714, -2716, -2726, -2724, -2723, -2731, -2730, -2731, -2728,
        -2729, -2733, -2733, -2731, -2736, -2738, -2744, -2744, -2753, -2751,
        -2756, -2756, -2768, -2761, -2767, -2771, -2771, -2770, -2771, -2770,
        -2772, -2775, -2773, -2769, -2772, -2775, -2777, -2779, -2786, -2784,
        -2789, -2786, -2788, -2789, -2787, -2786, -2787, -2789, -2785, -2787,
        -2789, -2789, -2796, -2801, -2801, -2801, -2803, -2815, -2820, -2823,
        -2825, -2828, -2828, -2832, -2835, -2839, -2841, -2841, -2846, -2846,
        -2847, -2846, -2853, -2851, -2855, -2860, -2860, -2861, -2862, -2866,
        -2865, -2865, -2868, -2873, -2870, -2866, -2863, -2867, -2867, -2872,
        -2875, -2874, -2884, -2883, -2879, -2879, -2876, -2874, -2878, -2874,
        -2878, -2877, -2883, -2882, -2889, -2891, -2896, -2901, -2906, -2908,
        -2906, -2908, -2902, -2905, -2912, -2907, -2906, -2904, -2907, -2903,
        -2907, -2910, -2918, -2916, -2918, -2917, -2920, -2925, -2921, -2929,
        -2926, -2930, -2923, -2929, -2932, -2936, -2937, -2940, -2949, -2943,
        -2949, -2943, -2950, -2948, -2951, -2948, -2952, -2944, -2951, -2948,
        -2945, -2951, -2958, -2964, -2965, -2967, -2971, -2978, -2982, -2987,
        -2991, -2987, -2986, -2977, -2976, -2973, -2975, -2971, -2978, -2982,
        -2987, -2992, -2990, -2989, -2990, -2994, -2988, -2984, -2988, -2987,
        -2986, -2990, -2988, -2991, -2999, -3004, -3010, -3017, -3019, -3018,
        -3021, -3025, -3024, -3028, -3031, -3027, -3030, -3032, -3032, -3030,
        -3030, -3029, -3028, -3028, -3030, -3027, -3022, -3024, -3022, -3024,
        -3017, -3024, -3026, -3032, -3031, -3032, -3036, -3043, -3046, -3041,
        -3046, -3046, -3047, -3049, -3050, -3056, -3056, -3053, -3046, -3051,
        -3049, -3056, -3058, -3061, -3063, -3063, -3056, -3055, -3055, -3059,
        -3065, -3066, -3067, -3066, -3060, -3057, -3062, -3070, -3071, -3073,
        -3071, -3076, -3073, -3076, -3078, -3079, -3080, -3085, -3090, -3090,
        -3093, -3093, -3092, -3092, -3093, -3100, -3097, -3095, -3090, -3092,
        -3095, -3097, -3101, -3106, -3111, -3114, -3114, -3114, -3111, -3109,
        -3109, -3112, -3114, -3114, -3114, -3118, -3122, -3123, -3127, -3130,
        -3130, -3130, -3121, -3117, -3121, -3122, -3130, -3133, -3134, -3135,
        -3136, -3137, -3140, -3140, -3140, -3140, -3144, -3149, -3150, -3155,
        -3150, -3150, -3145, -3146, -3145, -3145, -3147, -3145, -3144, -3147,
        -3149, -3150, -3153, -3153, -3153, -3153, -3157, -3160, -3162, -3165,
        -3165, -3167, -3169, -3172, -3172, -3174, -3174, -3174, -3174, -3174,
        -3174, -3174, -3173, -3172, -3174, -3175, -3176, -3180, -3180, -3180,
        -3181, -3181, -3180, -3179, -3178, -3178, -3188, -3189, -3199, -3201,
        -3201, -3201, -3201, -3201, -3202, -3203, -3202, -3207, -3209, -3211,
        -3213, -3210, -3210, -3210, -3210, -3210, -3210, -3210, -3212, -3218,
        -3220, -3220, -3221, -3221, -3221, -3221, -3222, -3225, -3226, -3227,
        -3230, -3230, -3231, -3231, -3231, -3231, -3231, -3231, -3228, -3228,
        -3232, -3233, -3231, -3230, -3234, -3237, -3237, -3234, -3234, -3233,
        -3232, -3231, -3229, -3228, -3226, -3233, -3243, -3248, -3249, -3249,
        -3258, -3259, -3269, -3266, -3262, -3261, -3261, -3259, -3254, -3253,
        -3252, -3257, -3261, -3267, -3272, -3271, -3268, -3266, -3262, -3262,
        -3268, -3272, -3268, -3271, -3273, -3270, -3270, -3267, -3266, -3268,
        -3269, -3268, -3273, -3270, -3271, -3274, -3276, -3275, -3274, -3277,
        -3283, -3281, -3286, -3288, -3287, -3285, -3279, -3278, -3273, -3268,
        -3273, -3279, -3282, -3278, -3280, -3282, -3284, -3285, -3292, -3290,
        -3295, -3298, -3297, -3296, -3299, -3297, -3298, -3294, -3292, -3297,
        -3298, -3303, -3303, -3303, -3299, -3303, -3298, -3310, -3304, -3307,
        -3310, -3306, -3305, -3301, -3300, -3295, -3296, -3298, -3299, -3301,
        -3301, -3304, -3306, -3305, -3307, -3310, -3307, -3314, -3312, -3311,
        -3309, -3305, -3296, -3298, -3301, -3299, -3301, -3297, -3298, -3299,
        -3302, -3297, -3296, -3295, -3297, -3296, -3299, -3297, -3301, -3295,
        -3299, -3301, -3303, -3301, -3301, -3294, -3299, -3303, -3302, -3301,
        -3302, -3298, -3296, -3297, -3298, -3306, -3305, -3305, -3310, -3310,
        -3307, -3307, -3307, -3304, -3301, -3303, -3301, -3301, -3302, -3305,
        -3304, -3302, -3301, -3299, -3298, -3296, -3293, -3289, -3282, -3280,
        -3280, -3280, -3280, -3283, -3291, -3294, -3293, -3295, -3297, -3296,
        -3294, -3294, -3284, -3283, -3273, -3273, -3274, -3274, -3276, -3275,
        -3277, -3277, -3278, -3276, -3272, -3272, -3268, -3270, -3269, -3269,
        -3270, -3271, -3271, -3272, -3273, -3268, -3268, -3259, -3255, -3255,
        -3257, -3257, -3257, -3261, -3268, -3266, -3257, -3251, -3250, -3250,
        -3254, -3258, -3254, -3254, -3249, -3246, -3249, -3247, -3245, -3242,
        -3239, -3236, -3234, -3233, -3228, -3231, -3237, -3232, -3237, -3235,
        -3228, -3227, -3225, -3228, -3219, -3220, -3212, -3215, -3218, -3220,
        -3213, -3215, -3209, -3207, -3203, -3200, -3202, -3197, -3197, -3192,
        -3186, -3185, -3190, -3187, -3180, -3177, -3174, -3174, -3171, -3168,
        -3166, -3168, -3161, -3162, -3157, -3160, -3156, -3159, -3166, -3165,
        -3164, -3165, -3166, -3162, -3164, -3158, -3158, -3152, -3157, -3155,
        -3155, -3152, -3152, -3147, -3149, -3146, -3142, -3144, -3146, -3149,
        -3145, -3150, -3145, -3147, -3148, -3146, -3149, -3151, -3146, -3141,
        -3131, -3124, -3123, -3122, -3118, -3112, -3111, -3105, -3113, -3107,
        -3105, -3108, -3108, -3116, -3112, -3118, -3121, -3117, -3113, -3113,
        -3106, -3106, -3103, -3105, -3104, -3101, -3106, -3107, -3106, -3108,
        -3112, -3108, -3111, -3106, -3100, -3102, -3099, -3098, -3097, -3093,
        -3089, -3087, -3088, -3094, -3092, -3093, -3097, -3091, -3084, -3079,
        -3076, -3076, -3074, -3074, -3070, -3071, -3068, -3075, -3079, -3078,
        -3081, -3078, -3079, -3077, -3071, -3073, -3080, -3076, -3072, -3074,
        -3077, -3075, -3074, -3077, -3083, -3080, -3079, -3074, -3072, -3074,
        -3075, -3077, -3084, -3081, -3085, -3082, -3084, -3079, -3078, -3075,
        -3076, -3078, -3083, -3087, -3089, -3083, -3088, -3091, -3091, -3091,
        -3093, -3094, -3087, -3083, -3077, -3073, -3073, -3077, -3078, -3082,
        -3081, -3081, -3082, -3082, -3082, -3086, -3086, -3087, -3091, -3092,
        -3093, -3094, -3094, -3094, -3095, -3094, -3091, -3091, -3091, -3091,
        -3094, -3091, -3099, -3100, -3100, -3098, -3098, -3097, -3097, -3098,
        -3100, -3105, -3107, -3110, -3108, -3117, -3118, -3125, -3128, -3133,
        -3138, -3134, -3129, -3133, -3129, -3133, -3130, -3135, -3132, -3138,
        -3135, -3134, -3135, -3141, -3142, -3148, -3148, -3151, -3154, -3155,
        -3153, -3156, -3158, -3150, -3152, -3158, -3160, -3157, -3157, -3155,
        -3155, -3162, -3164, -3162, -3162, -3162, -3171, -3179, -3176, -3170,
        -3191, -3197, -3191, -3188, -3191, -3194, -3181, -3181, -3178, -3179,
        -3182, -3185, -3191, -3188, -3190, -3200, -3193, -3192, -3184, -3193,
        -3211, -3207, -3203, -3198, -3206, -3224, -3215, -3213, -3212, -3225,
        -3220, -3224, -3223, -3219, -3206, -3210, -3203, -3202, -3208, -3203,
        -3201, -3202, -3207, -3204, -3207, -3206, -3199, -3198, -3201, -3205,
        -3201, -3199, -3208, -3213, -3209, -3207, -3216, -3219, -3213, -3213,
        -3214, -3204, -3204, -3205, -3210, -3203, -3195, -3200, -3204, -3200,
        -3194, -3195, -3198, -3203, -3205, -3205, -3203, -3205, -3207, -3212,
        -3214, -3214, -3215, -3220, -3225, -3226, -3224, -3224, -3222, -3218,
        -3224, -3216, -3218, -3210, -3210, -3207, -3203, -3203, -3204, -3198,
        -3192, -3188, -3183, -3181, -3186, -3189, -3193, -3196, -3190, -3188,
        -3191, -3188, -3187, -3185, -3185, -3184, -3183, -3184, -3185, -3181,
        -3177, -3178, -3174, -3173, -3171, -3174, -3179, -3177, -3185, -3190,
        -3193, -3194, -3194, -3198, -3196, -3194, -3189, -3189, -3192, -3193,
        -3190, -3195, -3197, -3194, -3201, -3208, -3208, -3209, -3208, -3211,
        -3217, -3218, -3221, -3217, -3213, -3217, -3215, -3218, -3220, -3224,
        -3222, -3230, -3235, -3236, -3239, -3240, -3238, -3236, -3242, -3243,
        -3239, -3239, -3241, -3241, -3247, -3247, -3247, -3250, -3256, -3259,
        -3260, -3261, -3263, -3265, -3274, -3281, -3284, -3289, -3292, -3302,
        -3314, -3307, -3294, -3296, -3301, -3301, -3287, -3289, -3293, -3298,
        -3287, -3291, -3288, -3293, -3288, -3285, -3274, -3270, -3267, -3272,
        -3273, -3272, -3272, -3271, -3265, -3262, -3253, -3242, -3239, -3230,
        -3229, -3211, -3208, -3186, -3181, -3157, -3155, -3112, -3102, -3098,
        -3095, -3076, -3063, -3044, -3032, -3022, -3008, -3005
    };

    static const int16_t robinson_dadson_curve_60_phons[1468] =
    {
        -1375, -1370, -1375, -1379, -1380, -1381, -1386, -1389, -1386, -1386,
        -1391, -1398, -1396, -1398, -1395, -1400, -1402, -1400, -1401, -1397,
        -1402, -1402, -1411, -1416, -1417, -1421, -1422, -1430, -1429, -1437,
        -1438, -1445, -1452, -1458, -1463, -1464, -1459, -1466, -1463, -1461,
        -1459, -1458, -1463, -1461, -1458, -1452, -1459, -1464, -1458, -1459,
        -1474, -1473, -1478, -1482, -1479, -1485, -1500, -1510, -1505, -1510,
        -1506, -1503, -1505, -1498, -1489, -1494, -1494, -1491, -1475, -1480,
        -1478, -1469, -1467, -1468, -1471, -1465, -1465, -1466, -1474, -1484,
        -1481, -1483, -1489, -1488, -1484, -1483, -1484, -1485, -1484, -1484,
        -1495, -1510, -1521, -1530, -1530, -1526, -1535, -1536, -1531, -1545,
        -1551, -1552, -1553, -1555, -1560, -1558, -1555, -1556, -1551, -1554,
        -1558, -1557, -1561, -1564, -1564, -1568, -1571, -1567, -1572, -1569,
        -1572, -1572, -1580, -1580, -1583, -1586, -1588, -1583, -1583, -1582,
        -1583, -1593, -1593, -1593, -1590, -1590, -1601, -1603, -1607, -1608,
        -1608, -1618, -1619, -1618, -1619, -1625, -1629, -1625, -1623, -1629,
        -1625, -1623, -1624, -1633, -1634, -1638, -1635, -1631, -1637, -1644,
        -1643, -1642, -1644, -1648, -1657, -1660, -1661, -1659, -1663, -1662,
        -1657, -1660, -1659, -1660, -1662, -1665, -1668, -1669, -1670, -1670,
        -1670, -1670, -1670, -1671, -1673, -1676, -1686, -1692, -1701, -1701,
        -1696, -1700, -1696, -1696, -1699, -1705, -1711, -1720, -1722, -1727,
        -1732, -1732, -1728, -1733, -1732, -1738, -1743, -1746, -1749, -1749,
        -1743, -1738, -1743, -1743, -1742, -1747, -1756, -1758, -1762, -1763,
        -1764, -1773, -1768, -1769, -1773, -1769, -1778, -1779, -1783, -1786,
        -1789, -1783, -1790, -1793, -1791, -1799, -1799, -1810, -1810, -1812,
        -1810, -1812, -1810, -1810, -1815, -1810, -1815, -1818, -1816, -1821,
        -1821, -1821, -1820, -1822, -1824, -1821, -1823, -1825, -1825, -1823,
        -1821, -1821, -1820, -1830, -1831, -1841, -1837, -1846, -1841, -1846,
        -1856, -1866, -1864, -1861, -1861, -1867, -1869, -1871, -1873, -1879,
        -1885, -1887, -1878, -1885, -1878, -1884, -1878, -1887, -1883, -1888,
        -1894, -1897, -1899, -1901, -1898, -1897, -1898, -1898, -1899, -1903,
        -1903, -1908, -1907, -1913, -1916, -1925, -1928, -1932, -1929, -1921,
        -1924, -1929, -1929, -1923, -1923, -1928, -1928, -1917, -1918, -1924,
        -1929, -1932, -1934, -1944, -1939, -1939, -1949, -1949, -1949, -1944,
        -1944, -1949, -1949, -1946, -1951, -1953, -1957, -1955, -1964, -1962,
        -1966, -1965, -1974, -1965, -1970, -1975, -1978, -1976, -1975, -1974,
        -1974, -1975, -1975, -1975, -1981, -1983, -1985, -1990, -1991, -1988,
        -1989, -1983, -1983, -1980, -1977, -1975, -1971, -1975, -1972, -1976,
        -1980, -1983, -1991, -1996, -1996, -1996, -1996, -2006, -2007, -2011,
        -2012, -2017, -2017, -2022, -2027, -2032, -2032, -2032, -2036, -2037,
        -2035, -2034, -2042, -2037, -2037, -2042, -2044, -2043, -2046, -2046,
        -2043, -2042, -2043, -2047, -2043, -2040, -2035, -2039, -2037, -2042,
        -2045, -2042, -2052, -2051, -2047, -2047, -2043, -2042, -2046, -2043,
        -2044, -2043, -2047, -2048, -2057, -2058, -2065, -2074, -2078, -2078,
        -2076, -2078, -2068, -2069, -2077, -2068, -2065, -2063, -2066, -2063,
        -2068, -2069, -2078, -2072, -2075, -2074, -2080, -2086, -2085, -2094,
        -2090, -2094, -2085, -2083, -2083, -2088, -2092, -2095, -2104, -2100,
        -2104, -2100, -2109, -2104, -2104, -2105, -2110, -2103, -2111, -2105,
        -2104, -2107, -2115, -2119, -2119, -2119, -2122, -2127, -2131, -2135,
        -2138, -2135, -2134, -2125, -2127, -2125, -2130, -2125, -2130, -2134,
        -2136, -2140, -2135, -2130, -2128, -2132, -2124, -2122, -2125, -2125,
        -2121, -2125, -2125, -2127, -2137, -2141, -2151, -2156, -2162, -2160,
        -2163, -2167, -2165, -2163, -2169, -2166, -2171, -2169, -2171, -2168,
        -2166, -2166, -2167, -2167, -2166, -2161, -2157, -2156, -2156, -2156,
        -2148, -2156, -2156, -2162, -2161, -2159, -2166, -2170, -2176, -2167,
        -2176, -2173, -2174, -2177, -2178, -2182, -2182, -2177, -2167, -2177,
        -2172, -2182, -2182, -2182, -2186, -2184, -2177, -2172, -2171, -2177,
        -2182, -2182, -2181, -2180, -2177, -2171, -2173, -2182, -2182, -2185,
        -2183, -2192, -2190, -2197, -2196, -2198, -2197, -2201, -2206, -2203,
        -2207, -2209, -2209, -2208, -2207, -2209, -2203, -2202, -2197, -2198,
        -2198, -2198, -2198, -2202, -2208, -2208, -2208, -2209, -2207, -2207,
        -2208, -2208, -2209, -2208, -2208, -2215, -2223, -2223, -2227, -2232,
        -2231, -2228, -2219, -2213, -2218, -2219, -2229, -2234, -2234, -2234,
        -2234, -2234, -2234, -2234, -2234, -2234, -2234, -2242, -2244, -2253,
        -2249, -2248, -2244, -2242, -2239, -2237, -2236, -2234, -2234, -2234,
        -2234, -2233, -2233, -2234, -2234, -2234, -2237, -2242, -2249, -2254,
        -2254, -2254, -2254, -2254, -2254, -2254, -2254, -2254, -2254, -2254,
        -2254, -2254, -2253, -2251, -2252, -2253, -2254, -2254, -2254, -2254,
        -2254, -2254, -2254, -2254, -2254, -2254, -2264, -2265, -2274, -2275,
        -2275, -2275, -2275, -2275, -2275, -2275, -2275, -2281, -2281, -2281,
        -2280, -2275, -2275, -2275, -2275, -2275, -2275, -2275, -2277, -2282,
        -2285, -2285, -2285, -2286, -2286, -2286, -2287, -2290, -2291, -2292,
        -2295, -2295, -2296, -2296, -2296, -2296, -2296, -2295, -2291, -2291,
        -2293, -2292, -2289, -2286, -2288, -2290, -2290, -2285, -2285, -2283,
        -2281, -2279, -2276, -2274, -2272, -2280, -2290, -2295, -2296, -2296,
        -2305, -2306, -2316, -2311, -2306, -2306, -2306, -2301, -2296, -2296,
        -2296, -2301, -2306, -2312, -2316, -2316, -2309, -2306, -2300, -2300,
        -2305, -2310, -2306, -2310, -2311, -2308, -2311, -2306, -2304, -2306,
        -2305, -2301, -2306, -2301, -2300, -2305, -2307, -2310, -2309, -2313,
        -2320, -2316, -2321, -2322, -2320, -2315, -2311, -2311, -2305, -2301,
        -2306, -2309, -2311, -2306, -2308, -2307, -2311, -2312, -2316, -2312,
        -2316, -2321, -2317, -2316, -2319, -2316, -2316, -2311, -2306, -2312,
        -2312, -2315, -2316, -2316, -2312, -2316, -2311, -2320, -2312, -2316,
        -2316, -2316, -2316, -2310, -2311, -2305, -2309, -2312, -2316, -2321,
        -2319, -2321, -2321, -2318, -2318, -2321, -2314, -2320, -2316, -2314,
        -2311, -2311, -2300, -2300, -2301, -2297, -2299, -2298, -2299, -2301,
        -2306, -2301, -2299, -2302, -2301, -2300, -2306, -2301, -2304, -2297,
        -2301, -2301, -2301, -2301, -2301, -2296, -2301, -2310, -2306, -2306,
        -2310, -2304, -2301, -2301, -2303, -2311, -2311, -2311, -2316, -2316,
        -2311, -2311, -2311, -2306, -2301, -2301, -2296, -2296, -2297, -2300,
        -2299, -2297, -2296, -2297, -2297, -2297, -2297, -2291, -2280, -2275,
        -2275, -2275, -2275, -2280, -2290, -2292, -2291, -2290, -2290, -2288,
        -2285, -2284, -2274, -2273, -2263, -2263, -2264, -2265, -2268, -2267,
        -2270, -2270, -2273, -2273, -2270, -2273, -2270, -2275, -2275, -2275,
        -2275, -2275, -2275, -2275, -2275, -2270, -2269, -2259, -2254, -2254,
        -2254, -2254, -2254, -2259, -2270, -2269, -2261, -2255, -2254, -2254,
        -2256, -2258, -2253, -2249, -2244, -2241, -2249, -2247, -2245, -2244,
        -2241, -2238, -2234, -2233, -2230, -2229, -2238, -2234, -2239, -2239,
        -2234, -2234, -2234, -2238, -2231, -2233, -2227, -2228, -2229, -2231,
        -2225, -2228, -2219, -2218, -2212, -2209, -2212, -2203, -2207, -2203,
        -2195, -2198, -2208, -2203, -2195, -2193, -2187, -2187, -2182, -2180,
        -2177, -2181, -2172, -2171, -2166, -2170, -2167, -2172, -2182, -2180,
        -2177, -2181, -2181, -2182, -2186, -2178, -2176, -2172, -2176, -2172,
        -2175, -2172, -2172, -2167, -2171, -2167, -2163, -2167, -2169, -2171,
        -2171, -2177, -2167, -2172, -2171, -2167, -2169, -2171, -2162, -2157,
        -2146, -2143, -2139, -2140, -2135, -2133, -2132, -2125, -2135, -2127,
        -2125, -2130, -2131, -2140, -2136, -2146, -2150, -2146, -2140, -2140,
        -2135, -2130, -2132, -2133, -2136, -2130, -2140, -2140, -2141, -2143,
        -2150, -2146, -2147, -2139, -2135, -2137, -2131, -2134, -2135, -2130,
        -2126, -2125, -2126, -2130, -2128, -2127, -2130, -2125, -2120, -2114,
        -2110, -2110, -2109, -2110, -2107, -2109, -2106, -2111, -2112, -2113,
        -2114, -2112, -2114, -2114, -2106, -2110, -2120, -2114, -2110, -2113,
        -2115, -2113, -2113, -2115, -2125, -2120, -2120, -2110, -2110, -2110,
        -2111, -2115, -2125, -2125, -2130, -2125, -2128, -2126, -2125, -2120,
        -2120, -2120, -2126, -2127, -2130, -2123, -2130, -2132, -2132, -2131,
        -2138, -2141, -2133, -2130, -2124, -2120, -2120, -2120, -2120, -2119,
        -2119, -2119, -2119, -2120, -2120, -2120, -2120, -2120, -2121, -2122,
        -2124, -2125, -2125, -2125, -2126, -2125, -2120, -2120, -2120, -2120,
        -2125, -2126, -2135, -2140, -2140, -2140, -2140, -2140, -2140, -2140,
        -2140, -2145, -2148, -2150, -2146, -2155, -2156, -2163, -2166, -2171,
        -2176, -2172, -2166, -2171, -2166, -2167, -2161, -2163, -2156, -2165,
        -2166, -2166, -2170, -2178, -2174, -2177, -2177, -2182, -2181, -2181,
        -2178, -2180, -2184, -2175, -2177, -2182, -2182, -2177, -2177, -2178,
        -2177, -2186, -2190, -2190, -2190, -2190, -2196, -2202, -2197, -2192,
        -2214, -2216, -2211, -2211, -2216, -2221, -2203, -2203, -2198, -2201,
        -2204, -2205, -2210, -2208, -2212, -2222, -2213, -2215, -2208, -2218,
        -2234, -2229, -2223, -2218, -2228, -2244, -2236, -2234, -2235, -2250,
        -2247, -2248, -2248, -2243, -2231, -2238, -2228, -2228, -2232, -2231,
        -2229, -2230, -2234, -2231, -2234, -2233, -2229, -2230, -2234, -2238,
        -2235, -2228, -2241, -2248, -2242, -2236, -2245, -2246, -2239, -2236,
        -2238, -2232, -2234, -2233, -2235, -2231, -2224, -2228, -2231, -2228,
        -2224, -2224, -2228, -2238, -2243, -2243, -2241, -2243, -2245, -2250,
        -2253, -2257, -2259, -2265, -2270, -2270, -2268, -2270, -2268, -2270,
        -2274, -2265, -2265, -2259, -2259, -2258, -2255, -2256, -2256, -2250,
        -2244, -2244, -2239, -2239, -2244, -2249, -2253, -2254, -2247, -2246,
        -2249, -2249, -2246, -2243, -2243, -2241, -2239, -2242, -2243, -2240,
        -2237, -2239, -2236, -2237, -2238, -2243, -2249, -2244, -2254, -2259,
        -2265, -2265, -2263, -2270, -2269, -2268, -2260, -2259, -2264, -2263,
        -2259, -2264, -2268, -2265, -2276, -2284, -2287, -2291, -2290, -2298,
        -2302, -2304, -2306, -2301, -2300, -2300, -2298, -2301, -2301, -2303,
        -2302, -2311, -2315, -2312, -2314, -2317, -2320, -2319, -2317, -2327,
        -2327, -2326, -2327, -2326, -2342, -2344, -2340, -2342, -2349, -2353,
        -2354, -2353, -2348, -2352, -2360, -2373, -2378, -2385, -2395, -2405,
        -2414, -2410, -2400, -2399, -2403, -2404, -2391, -2394, -2397, -2404,
        -2395, -2399, -2394, -2403, -2400, -2399, -2388, -2384, -2384, -2392,
        -2399, -2396, -2394, -2399, -2395, -2396, -2389, -2379, -2384, -2380,
        -2374, -2361, -2363, -2343, -2342, -2333, -2333, -2290, -2290, -2293,
        -2295, -2278, -2270, -2251, -2251, -2248, -2235, -2232
    };

    static const int16_t robinson_dadson_curve_70_phons[1468] =
    {
        -777, -774, -777, -779, -780, -780, -783, -785, -784, -783,
        -786, -790, -789, -790, -788, -791, -792, -791, -792, -789,
        -792, -792, -798, -800, -801, -803, -804, -808, -807, -812,
        -813, -817, -821, -824, -827, -828, -825, -829, -827, -826,
        -825, -824, -827, -826, -824, -821, -824, -827, -824, -825,
        -833, -833, -835, -838, -836, -839, -848, -853, -851, -853,
        -851, -849, -851, -847, -842, -844, -845, -842, -833, -837,
        -836, -831, -829, -830, -831, -828, -828, -829, -833, -839,
        -837, -838, -842, -841, -839, -838, -839, -840, -839, -839,
        -845, -854, -859, -865, -865, -863, -867, -868, -865, -873,
        -877, -877, -878, -879, -882, -881, -879, -879, -877, -878,
        -881, -880, -882, -884, -884, -886, -888, -886, -889, -887,
        -888, -888, -893, -893, -894, -896, -897, -895, -894, -894,
        -895, -901, -900, -900, -899, -899, -905, -906, -909, -909,
        -909, -915, -915, -915, -915, -919, -921, -919, -917, -921,
        -918, -918, -918, -923, -924, -926, -924, -922, -925, -929,
        -929, -928, -929, -931, -936, -938, -939, -938, -940, -939,
        -936, -938, -938, -938, -940, -941, -943, -943, -944, -944,
        -944, -944, -944, -945, -946, -948, -953, -956, -961, -962,
        -959, -961, -959, -959, -960, -964, -967, -972, -973, -976,
        -979, -979, -976, -980, -979, -982, -985, -987, -989, -988,
        -985, -983, -985, -985, -985, -988, -993, -994, -996, -996,
        -997, -1002, -1000, -1000, -1002, -1000, -1005, -1006, -1008, -1009,
        -1011, -1008, -1011, -1014, -1012, -1017, -1017, -1023, -1023, -1024,
        -1023, -1024, -1023, -1023, -1026, -1023, -1026, -1027, -1026, -1029,
        -1029, -1029, -1029, -1030, -1031, -1029, -1031, -1031, -1031, -1030,
        -1029, -1029, -1029, -1034, -1035, -1040, -1038, -1043, -1041, -1043,
        -1049, -1055, -1054, -1052, -1052, -1055, -1057, -1058, -1059, -1062,
        -1065, -1066, -1061, -1065, -1061, -1065, -1062, -1066, -1064, -1067,
        -1070, -1072, -1073, -1075, -1073, -1072, -1073, -1073, -1073, -1076,
        -1076, -1078, -1078, -1081, -1083, -1088, -1090, -1092, -1090, -1086,
        -1087, -1091, -1090, -1087, -1087, -1090, -1090, -1083, -1084, -1087,
        -1090, -1092, -1093, -1099, -1096, -1096, -1102, -1102, -1101, -1099,
        -1099, -1102, -1101, -1100, -1103, -1104, -1106, -1105, -1110, -1109,
        -1111, -1111, -1116, -1111, -1113, -1116, -1118, -1117, -1116, -1116,
        -1116, -1116, -1116, -1116, -1120, -1121, -1122, -1125, -1125, -1123,
        -1124, -1121, -1121, -1119, -1118, -1116, -1114, -1116, -1115, -1117,
        -1119, -1121, -1126, -1128, -1128, -1128, -1128, -1134, -1134, -1137,
        -1137, -1140, -1140, -1143, -1146, -1149, -1149, -1149, -1151, -1151,
        -1150, -1150, -1154, -1152, -1151, -1154, -1155, -1154, -1156, -1157,
        -1155, -1154, -1155, -1157, -1154, -1153, -1150, -1153, -1152, -1154,
        -1156, -1154, -1160, -1159, -1157, -1157, -1155, -1154, -1156, -1154,
        -1155, -1155, -1157, -1157, -1163, -1163, -1167, -1172, -1175, -1175,
        -1174, -1174, -1169, -1169, -1174, -1169, -1167, -1166, -1168, -1166,
        -1169, -1169, -1174, -1171, -1173, -1172, -1176, -1179, -1178, -1184,
        -1181, -1183, -1178, -1178, -1177, -1180, -1183, -1184, -1189, -1187,
        -1189, -1187, -1192, -1189, -1189, -1190, -1192, -1189, -1193, -1190,
        -1189, -1191, -1195, -1198, -1198, -1198, -1200, -1202, -1204, -1207,
        -1209, -1207, -1206, -1201, -1202, -1201, -1204, -1201, -1204, -1206,
        -1207, -1210, -1207, -1204, -1203, -1205, -1201, -1199, -1201, -1201,
        -1199, -1201, -1201, -1202, -1208, -1210, -1216, -1219, -1222, -1221,
        -1222, -1225, -1224, -1223, -1226, -1224, -1227, -1226, -1227, -1225,
        -1224, -1224, -1225, -1225, -1224, -1222, -1219, -1219, -1219, -1219,
        -1214, -1218, -1219, -1222, -1221, -1220, -1224, -1227, -1230, -1225,
        -1230, -1228, -1229, -1230, -1231, -1233, -1233, -1230, -1225, -1230,
        -1228, -1233, -1233, -1233, -1236, -1234, -1230, -1227, -1227, -1230,
        -1233, -1233, -1233, -1232, -1230, -1227, -1228, -1233, -1233, -1235,
        -1234, -1239, -1238, -1242, -1241, -1242, -1242, -1244, -1247, -1245,
        -1247, -1249, -1248, -1248, -1248, -1249, -1245, -1244, -1242, -1242,
        -1242, -1242, -1242, -1245, -1248, -1248, -1248, -1248, -1248, -1248,
        -1248, -1248, -1249, -1248, -1248, -1252, -1257, -1257, -1259, -1261,
        -1261, -1259, -1254, -1251, -1254, -1254, -1260, -1263, -1263, -1263,
        -1263, -1263, -1263, -1263, -1263, -1263, -1263, -1267, -1268, -1273,
        -1271, -1271, -1268, -1267, -1265, -1264, -1264, -1263, -1263, -1263,
        -1263, -1262, -1262, -1262, -1262, -1263, -1265, -1267, -1271, -1274,
        -1274, -1274, -1274, -1274, -1274, -1274, -1274, -1274, -1274, -1274,
        -1274, -1274, -1273, -1272, -1273, -1274, -1274, -1274, -1274, -1274,
        -1274, -1274, -1274, -1274, -1274, -1274, -1280, -1280, -1286, -1286,
        -1286, -1286, -1286, -1286, -1286, -1286, -1286, -1289, -1289, -1289,
        -1289, -1286, -1286, -1286, -1286, -1286, -1286, -1286, -1287, -1290,
        -1291, -1292, -1292, -1292, -1292, -1292, -1292, -1295, -1295, -1295,
        -1297, -1297, -1298, -1298, -1298, -1298, -1298, -1297, -1295, -1295,
        -1296, -1296, -1294, -1292, -1293, -1295, -1295, -1292, -1291, -1290,
        -1289, -1288, -1286, -1285, -1284, -1288, -1294, -1297, -1297, -1298,
        -1303, -1304, -1309, -1306, -1303, -1303, -1303, -1301, -1297, -1297,
        -1297, -1300, -1303, -1307, -1309, -1309, -1305, -1303, -1300, -1300,
        -1303, -1305, -1303, -1306, -1306, -1305, -1306, -1303, -1302, -1303,
        -1303, -1301, -1303, -1301, -1300, -1303, -1304, -1306, -1305, -1307,
        -1311, -1309, -1312, -1312, -1311, -1309, -1306, -1306, -1303, -1301,
        -1303, -1305, -1306, -1304, -1305, -1304, -1306, -1307, -1309, -1307,
        -1309, -1312, -1310, -1309, -1311, -1309, -1309, -1306, -1303, -1307,
        -1307, -1309, -1309, -1309, -1307, -1309, -1306, -1311, -1307, -1309,
        -1309, -1309, -1309, -1306, -1306, -1303, -1305, -1307, -1309, -1312,
        -1311, -1312, -1312, -1310, -1310, -1312, -1308, -1312, -1309, -1308,
        -1306, -1306, -1300, -1300, -1300, -1298, -1299, -1299, -1300, -1301,
        -1303, -1300, -1299, -1301, -1301, -1300, -1303, -1300, -1302, -1298,
        -1300, -1301, -1300, -1300, -1300, -1298, -1300, -1305, -1303, -1303,
        -1306, -1302, -1301, -1300, -1301, -1306, -1306, -1306, -1309, -1309,
        -1306, -1306, -1306, -1303, -1300, -1300, -1298, -1298, -1298, -1300,
        -1299, -1298, -1298, -1298, -1299, -1299, -1298, -1295, -1289, -1286,
        -1286, -1286, -1286, -1289, -1295, -1296, -1295, -1295, -1295, -1293,
        -1291, -1291, -1285, -1285, -1279, -1279, -1280, -1280, -1282, -1281,
        -1283, -1283, -1284, -1285, -1283, -1285, -1283, -1286, -1286, -1286,
        -1286, -1286, -1286, -1286, -1286, -1283, -1283, -1277, -1274, -1274,
        -1274, -1274, -1274, -1277, -1283, -1283, -1278, -1275, -1274, -1274,
        -1275, -1276, -1274, -1271, -1268, -1267, -1271, -1270, -1269, -1268,
        -1267, -1265, -1263, -1262, -1260, -1260, -1265, -1263, -1265, -1266,
        -1263, -1262, -1263, -1265, -1261, -1262, -1259, -1259, -1260, -1261,
        -1257, -1259, -1254, -1254, -1251, -1249, -1250, -1245, -1248, -1245,
        -1241, -1242, -1248, -1245, -1241, -1239, -1236, -1236, -1233, -1232,
        -1230, -1233, -1227, -1227, -1224, -1226, -1225, -1227, -1233, -1232,
        -1231, -1233, -1233, -1233, -1236, -1231, -1230, -1228, -1230, -1228,
        -1230, -1228, -1228, -1225, -1227, -1225, -1223, -1225, -1226, -1227,
        -1227, -1230, -1225, -1227, -1227, -1225, -1226, -1227, -1222, -1219,
        -1213, -1211, -1209, -1209, -1207, -1205, -1205, -1201, -1207, -1202,
        -1201, -1204, -1204, -1209, -1207, -1213, -1215, -1213, -1209, -1209,
        -1207, -1204, -1205, -1206, -1207, -1204, -1210, -1210, -1210, -1211,
        -1215, -1213, -1213, -1209, -1207, -1208, -1205, -1206, -1207, -1204,
        -1202, -1201, -1201, -1204, -1203, -1202, -1204, -1201, -1198, -1195,
        -1193, -1193, -1192, -1193, -1191, -1192, -1191, -1193, -1194, -1194,
        -1195, -1194, -1195, -1195, -1191, -1192, -1198, -1195, -1192, -1194,
        -1195, -1194, -1194, -1195, -1201, -1198, -1198, -1193, -1193, -1193,
        -1193, -1195, -1201, -1201, -1204, -1201, -1203, -1202, -1201, -1198,
        -1198, -1199, -1202, -1202, -1204, -1200, -1204, -1205, -1205, -1205,
        -1208, -1210, -1206, -1204, -1200, -1198, -1198, -1198, -1198, -1198,
        -1198, -1198, -1198, -1198, -1198, -1198, -1198, -1198, -1199, -1199,
        -1200, -1201, -1201, -1201, -1202, -1201, -1198, -1198, -1198, -1198,
        -1201, -1201, -1207, -1210, -1210, -1210, -1210, -1210, -1210, -1210,
        -1210, -1212, -1214, -1215, -1213, -1218, -1219, -1223, -1224, -1227,
        -1230, -1227, -1224, -1227, -1224, -1225, -1222, -1223, -1219, -1224,
        -1224, -1224, -1226, -1231, -1229, -1230, -1230, -1233, -1233, -1233,
        -1231, -1232, -1235, -1230, -1230, -1233, -1233, -1230, -1230, -1231,
        -1230, -1236, -1238, -1238, -1238, -1238, -1241, -1244, -1242, -1239,
        -1251, -1253, -1250, -1250, -1253, -1255, -1245, -1245, -1242, -1244,
        -1246, -1246, -1249, -1248, -1250, -1256, -1251, -1252, -1248, -1254,
        -1263, -1260, -1257, -1254, -1259, -1268, -1264, -1263, -1263, -1272,
        -1270, -1271, -1271, -1268, -1261, -1265, -1259, -1260, -1262, -1261,
        -1260, -1260, -1263, -1261, -1263, -1262, -1260, -1260, -1263, -1265,
        -1263, -1259, -1266, -1270, -1267, -1264, -1269, -1269, -1266, -1264,
        -1265, -1262, -1263, -1262, -1263, -1261, -1257, -1259, -1261, -1259,
        -1257, -1257, -1259, -1265, -1268, -1268, -1267, -1268, -1269, -1272,
        -1273, -1276, -1277, -1280, -1283, -1283, -1282, -1283, -1282, -1283,
        -1285, -1280, -1280, -1277, -1277, -1276, -1274, -1275, -1275, -1272,
        -1268, -1268, -1265, -1265, -1268, -1271, -1274, -1274, -1270, -1270,
        -1271, -1271, -1270, -1268, -1268, -1266, -1266, -1267, -1268, -1266,
        -1265, -1266, -1264, -1264, -1265, -1268, -1271, -1268, -1274, -1277,
        -1280, -1280, -1279, -1283, -1283, -1282, -1278, -1277, -1280, -1279,
        -1277, -1280, -1282, -1280, -1286, -1291, -1293, -1295, -1294, -1299,
        -1301, -1302, -1303, -1301, -1300, -1300, -1299, -1300, -1300, -1302,
        -1301, -1306, -1309, -1307, -1308, -1309, -1311, -1311, -1309, -1315,
        -1315, -1315, -1315, -1315, -1324, -1325, -1323, -1324, -1328, -1330,
        -1331, -1330, -1327, -1329, -1334, -1341, -1344, -1348, -1354, -1359,
        -1365, -1362, -1357, -1356, -1358, -1359, -1351, -1353, -1355, -1359,
        -1354, -1356, -1353, -1358, -1356, -1356, -1350, -1347, -1347, -1352,
        -1356, -1354, -1353, -1356, -1353, -1354, -1350, -1345, -1347, -1345,
        -1342, -1335, -1336, -1324, -1324, -1319, -1319, -1295, -1294, -1296,
        -1297, -1288, -1283, -1272, -1272, -1271, -1263, -1261
    };

    static const int16_t robinson_dadson_curve_80_phons[1468] =
    {
        -179, -179, -179, -180, -180, -180, -181, -181, -181, -181,
        -181, -182, -182, -182, -182, -183, -183, -183, -183, -182,
        -183, -183, -184, -185, -185, -185, -185, -186, -186, -187,
        -188, -188, -189, -190, -191, -191, -190, -191, -191, -191,
        -190, -190, -191, -191, -190, -189, -190, -191, -190, -190,
        -192, -192, -193, -193, -193, -194, -196, -197, -196, -197,
        -196, -196, -196, -195, -194, -195, -195, -194, -192, -193,
        -193, -192, -191, -191, -192, -191, -191, -191, -192, -194,
        -193, -193, -194, -194, -194, -193, -194, -194, -194, -194,
        -195, -197, -198, -200, -200, -199, -200, -200, -200, -202,
        -202, -202, -203, -203, -203, -203, -203, -203, -202, -203,
        -203, -203, -204, -204, -204, -204, -205, -204, -205, -205,
        -205, -205, -206, -206, -206, -207, -207, -206, -206, -206,
        -206, -208, -208, -208, -207, -207, -209, -209, -210, -210,
        -210, -211, -211, -211, -211, -212, -212, -212, -212, -212,
        -212, -212, -212, -213, -213, -214, -213, -213, -213, -214,
        -214, -214, -214, -215, -216, -216, -217, -216, -217, -217,
        -216, -217, -216, -216, -217, -217, -218, -218, -218, -218,
        -218, -218, -218, -218, -218, -219, -220, -221, -222, -222,
        -221, -222, -221, -221, -222, -222, -223, -224, -225, -225,
        -226, -226, -225, -226, -226, -227, -227, -228, -228, -228,
        -227, -227, -227, -227, -227, -228, -229, -229, -230, -230,
        -230, -231, -231, -231, -231, -231, -232, -232, -233, -233,
        -233, -233, -233, -234, -234, -235, -235, -236, -236, -236,
        -236, -236, -236, -236, -237, -236, -237, -237, -237, -237,
        -237, -238, -237, -238, -238, -238, -238, -238, -238, -238,
        -238, -238, -237, -239, -239, -240, -240, -241, -240, -241,
        -242, -243, -243, -243, -243, -244, -244, -244, -244, -245,
        -246, -246, -245, -246, -245, -246, -245, -246, -246, -246,
        -247, -247, -248, -248, -248, -247, -248, -248, -248, -248,
        -248, -249, -249, -250, -250, -251, -251, -252, -252, -251,
        -251, -252, -252, -251, -251, -251, -251, -250, -250, -251,
        -252, -252, -252, -254, -253, -253, -254, -254, -254, -254,
        -254, -254, -254, -254, -254, -255, -255, -255, -256, -256,
        -256, -256, -258, -256, -257, -258, -258, -258, -258, -258,
        -258, -258, -258, -258, -258, -259, -259, -260, -260, -259,
        -259, -259, -259, -258, -258, -258, -257, -258, -257, -258,
        -258, -259, -260, -260, -260, -260, -260, -262, -262, -262,
        -262, -263, -263, -264, -264, -265, -265, -265, -266, -266,
        -265, -265, -266, -266, -266, -266, -267, -266, -267, -267,
        -266, -266, -266, -267, -266, -266, -265, -266, -266, -266,
        -267, -266, -268, -268, -267, -267, -266, -266, -267, -266,
        -267, -266, -267, -267, -268, -268, -269, -270, -271, -271,
        -271, -271, -270, -270, -271, -270, -269, -269, -270, -269,
        -270, -270, -271, -270, -271, -270, -271, -272, -272, -273,
        -273, -273, -272, -272, -272, -272, -273, -273, -274, -274,
        -274, -274, -275, -274, -274, -275, -275, -274, -275, -275,
        -274, -275, -276, -276, -276, -276, -277, -277, -278, -279,
        -279, -278, -278, -277, -277, -277, -278, -277, -278, -278,
        -279, -279, -278, -278, -278, -278, -277, -277, -277, -277,
        -277, -277, -277, -277, -279, -279, -281, -281, -282, -282,
        -282, -283, -282, -282, -283, -283, -283, -283, -283, -283,
        -283, -283, -283, -283, -283, -282, -281, -281, -281, -281,
        -280, -281, -281, -282, -282, -282, -283, -283, -284, -283,
        -284, -283, -284, -284, -284, -285, -285, -284, -283, -284,
        -283, -285, -285, -285, -285, -285, -284, -283, -283, -284,
        -285, -285, -284, -284, -284, -283, -283, -285, -285, -285,
        -285, -286, -286, -287, -286, -287, -287, -287, -288, -287,
        -288, -288, -288, -288, -288, -288, -287, -287, -287, -287,
        -287, -287, -287, -287, -288, -288, -288, -288, -288, -288,
        -288, -288, -288, -288, -288, -289, -290, -290, -290, -291,
        -291, -291, -289, -289, -289, -289, -291, -291, -291, -291,
        -291, -291, -291, -291, -291, -291, -291, -292, -293, -294,
        -293, -293, -293, -292, -292, -292, -292, -291, -291, -291,
        -291, -291, -291, -291, -291, -291, -292, -292, -293, -294,
        -294, -294, -294, -294, -294, -294, -294, -294, -294, -294,
        -294, -294, -294, -294, -294, -294, -294, -294, -294, -294,
        -294, -294, -294, -294, -294, -294, -295, -295, -297, -297,
        -297, -297, -297, -297, -297, -297, -297, -297, -298, -298,
        -297, -297, -297, -297, -297, -297, -297, -297, -297, -298,
        -298, -298, -298, -298, -298, -298, -298, -299, -299, -299,
        -299, -299, -299, -299, -299, -299, -299, -299, -299, -299,
        -299, -299, -299, -298, -298, -299, -299, -298, -298, -298,
        -298, -297, -297, -297, -296, -297, -299, -299, -299, -299,
        -301, -301, -302, -301, -301, -301, -301, -300, -299, -299,
        -299, -300, -301, -302, -302, -302, -301, -301, -300, -300,
        -301, -301, -301, -301, -301, -301, -301, -301, -301, -301,
        -301, -300, -301, -300, -300, -301, -301, -301, -301, -302,
        -303, -302, -303, -303, -303, -302, -301, -301, -301, -300,
        -301, -301, -301, -301, -301, -301, -301, -302, -302, -302,
        -302, -303, -302, -302, -302, -302, -302, -301, -301, -302,
        -302, -302, -302, -302, -302, -302, -301, -303, -302, -302,
        -302, -302, -302, -301, -301, -301, -301, -302, -302, -303,
        -302, -303, -303, -302, -302, -303, -302, -303, -302, -302,
        -301, -301, -300, -300, -300, -300, -300, -300, -300, -300,
        -301, -300, -300, -300, -300, -300, -301, -300, -301, -300,
        -300, -300, -300, -300, -300, -299, -300, -301, -301, -301,
        -301, -300, -300, -300, -300, -301, -301, -301, -302, -302,
        -301, -301, -301, -301, -300, -300, -299, -299, -300, -300,
        -300, -300, -300, -300, -300, -300, -300, -299, -297, -297,
        -297, -297, -297, -297, -299, -299, -299, -299, -299, -298,
        -298, -298, -297, -296, -295, -295, -295, -295, -296, -296,
        -296, -296, -296, -296, -296, -297, -296, -297, -297, -297,
        -297, -297, -297, -297, -297, -296, -296, -295, -294, -294,
        -294, -294, -294, -295, -296, -296, -295, -294, -294, -294,
        -294, -294, -294, -293, -293, -292, -293, -293, -293, -293,
        -292, -292, -291, -291, -291, -291, -292, -291, -292, -292,
        -291, -291, -291, -292, -291, -291, -290, -291, -291, -291,
        -290, -291, -289, -289, -289, -288, -289, -287, -288, -287,
        -286, -287, -288, -287, -286, -286, -285, -285, -285, -284,
        -284, -285, -283, -283, -283, -283, -283, -283, -285, -284,
        -284, -284, -285, -285, -285, -284, -284, -283, -284, -283,
        -284, -283, -283, -283, -283, -283, -282, -283, -283, -283,
        -283, -284, -283, -283, -283, -283, -283, -283, -282, -281,
        -280, -279, -279, -279, -278, -278, -278, -277, -278, -277,
        -277, -278, -278, -279, -279, -280, -280, -280, -279, -279,
        -279, -278, -278, -278, -279, -278, -279, -279, -279, -280,
        -280, -280, -280, -279, -279, -279, -278, -278, -279, -278,
        -277, -277, -277, -278, -278, -277, -278, -277, -277, -276,
        -275, -275, -275, -275, -275, -275, -275, -275, -276, -276,
        -276, -276, -276, -276, -275, -275, -276, -276, -275, -276,
        -276, -276, -276, -276, -277, -277, -276, -275, -275, -275,
        -275, -276, -277, -277, -278, -277, -278, -277, -277, -277,
        -277, -277, -277, -277, -278, -277, -278, -278, -278, -278,
        -279, -279, -278, -278, -277, -276, -276, -276, -276, -276,
        -276, -276, -276, -276, -276, -276, -277, -277, -277, -277,
        -277, -277, -277, -277, -277, -277, -276, -276, -276, -276,
        -277, -277, -279, -279, -279, -279, -279, -279, -279, -279,
        -279, -280, -280, -280, -280, -281, -281, -282, -283, -283,
        -284, -283, -283, -283, -283, -283, -282, -282, -281, -282,
        -283, -282, -283, -284, -284, -284, -284, -285, -284, -285,
        -284, -284, -285, -284, -284, -285, -285, -284, -284, -284,
        -284, -285, -286, -286, -286, -286, -286, -287, -287, -286,
        -289, -289, -288, -288, -289, -290, -287, -287, -287, -287,
        -287, -288, -288, -288, -289, -290, -289, -289, -288, -289,
        -291, -291, -290, -289, -291, -293, -292, -291, -292, -293,
        -293, -293, -293, -293, -291, -292, -291, -291, -291, -291,
        -291, -291, -291, -291, -291, -291, -291, -291, -291, -292,
        -292, -291, -292, -293, -292, -292, -293, -293, -292, -292,
        -292, -291, -291, -291, -291, -291, -290, -291, -291, -291,
        -290, -290, -291, -292, -293, -293, -292, -293, -293, -293,
        -294, -294, -295, -295, -296, -296, -296, -296, -296, -296,
        -297, -295, -295, -295, -295, -295, -294, -294, -294, -294,
        -293, -293, -292, -292, -293, -293, -294, -294, -293, -293,
        -293, -293, -293, -293, -293, -292, -292, -292, -293, -292,
        -292, -292, -292, -292, -292, -293, -293, -293, -294, -295,
        -295, -295, -295, -296, -296, -296, -295, -295, -295, -295,
        -295, -295, -296, -295, -297, -298, -298, -299, -299, -300,
        -300, -300, -301, -300, -300, -300, -300, -300, -300, -300,
        -300, -301, -302, -302, -302, -302, -303, -302, -302, -303,
        -303, -303, -304, -303, -305, -306, -305, -305, -306, -307,
        -307, -307, -306, -307, -308, -310, -310, -311, -312, -314,
        -315, -314, -313, -313, -313, -314, -312, -312, -313, -314,
        -312, -313, -312, -313, -313, -313, -311, -311, -311, -312,
        -313, -313, -312, -313, -312, -312, -312, -310, -311, -310,
        -310, -308, -308, -306, -306, -304, -304, -299, -299, -299,
        -299, -297, -296, -294, -294, -293, -292, -291
    };

    static const int16_t robinson_dadson_curve_90_phons[1468] =
    {
        418, 417, 419, 420, 420, 420, 422, 423, 422, 422,
        423, 425, 425, 426, 424, 426, 427, 426, 427, 425,
        427, 427, 430, 431, 431, 432, 433, 435, 435, 437,
        438, 440, 442, 444, 445, 446, 444, 446, 445, 445,
        444, 444, 445, 445, 444, 442, 444, 446, 444, 444,
        448, 448, 450, 451, 450, 452, 457, 459, 458, 459,
        458, 457, 458, 456, 453, 455, 455, 454, 449, 451,
        450, 447, 447, 447, 448, 446, 446, 446, 449, 452,
        451, 451, 453, 453, 452, 451, 452, 452, 452, 452,
        455, 460, 463, 466, 466, 464, 467, 467, 466, 470,
        472, 472, 473, 473, 475, 474, 473, 473, 472, 473,
        474, 474, 475, 476, 476, 477, 478, 477, 478, 478,
        478, 478, 481, 481, 482, 483, 483, 482, 482, 482,
        482, 485, 485, 485, 484, 484, 487, 488, 489, 489,
        489, 492, 493, 493, 493, 495, 496, 495, 494, 496,
        495, 494, 494, 497, 497, 499, 498, 496, 498, 500,
        500, 500, 500, 501, 504, 505, 506, 505, 506, 506,
        504, 505, 505, 505, 506, 507, 508, 508, 508, 508,
        508, 508, 508, 509, 509, 510, 513, 515, 518, 518,
        516, 517, 516, 516, 517, 519, 521, 523, 524, 526,
        527, 527, 526, 528, 527, 529, 530, 531, 532, 532,
        531, 529, 530, 530, 530, 532, 534, 535, 536, 536,
        537, 540, 538, 538, 540, 538, 541, 541, 543, 544,
        545, 543, 545, 546, 545, 548, 548, 551, 551, 551,
        551, 551, 551, 551, 552, 551, 552, 553, 553, 554,
        554, 554, 554, 555, 555, 554, 555, 555, 555, 555,
        554, 554, 554, 557, 557, 560, 559, 562, 560, 562,
        565, 568, 567, 566, 566, 568, 569, 570, 570, 572,
        574, 574, 572, 574, 572, 573, 572, 574, 573, 575,
        576, 577, 578, 579, 578, 577, 578, 578, 578, 579,
        579, 581, 580, 582, 583, 586, 587, 588, 587, 585,
        585, 587, 587, 585, 585, 587, 587, 583, 584, 585,
        587, 588, 589, 592, 590, 590, 593, 593, 593, 592,
        592, 593, 593, 592, 594, 594, 596, 595, 598, 597,
        598, 598, 601, 598, 600, 601, 602, 601, 601, 601,
        601, 601, 601, 601, 603, 604, 604, 606, 606, 605,
        605, 603, 604, 603, 602, 601, 600, 601, 600, 601,
        603, 603, 606, 608, 607, 607, 608, 611, 611, 612,
        612, 614, 614, 615, 617, 618, 618, 618, 620, 620,
        619, 619, 622, 620, 620, 621, 622, 622, 623, 623,
        622, 622, 622, 623, 622, 621, 619, 621, 620, 622,
        623, 622, 625, 624, 623, 623, 622, 621, 623, 622,
        622, 622, 623, 623, 626, 626, 628, 631, 633, 633,
        632, 632, 629, 630, 632, 629, 628, 628, 629, 628,
        629, 630, 632, 631, 631, 631, 633, 635, 634, 637,
        636, 637, 635, 634, 634, 636, 637, 637, 640, 639,
        640, 639, 642, 640, 640, 641, 642, 640, 643, 641,
        640, 641, 644, 645, 645, 645, 646, 647, 649, 650,
        651, 650, 649, 647, 647, 647, 648, 647, 648, 649,
        650, 651, 650, 648, 648, 649, 647, 646, 647, 647,
        646, 647, 647, 647, 650, 652, 655, 656, 658, 657,
        658, 659, 659, 658, 660, 659, 661, 660, 661, 660,
        659, 659, 659, 659, 659, 658, 656, 656, 656, 656,
        654, 656, 656, 658, 658, 657, 659, 661, 662, 660,
        662, 661, 662, 662, 663, 664, 664, 662, 660, 662,
        661, 664, 664, 664, 665, 665, 662, 661, 661, 662,
        664, 664, 664, 664, 662, 661, 661, 664, 664, 665,
        664, 667, 667, 669, 668, 669, 669, 670, 671, 670,
        672, 672, 672, 672, 672, 672, 671, 670, 669, 669,
        669, 669, 669, 670, 672, 672, 672, 672, 672, 672,
        672, 672, 672, 672, 672, 674, 677, 677, 678, 679,
        679, 678, 675, 674, 675, 675, 678, 680, 680, 680,
        680, 680, 680, 680, 680, 680, 680, 682, 683, 686,
        684, 684, 683, 682, 681, 681, 681, 680, 680, 680,
        680, 680, 680, 680, 680, 680, 681, 682, 685, 686,
        686, 686, 686, 686, 686, 686, 686, 686, 686, 686,
        686, 686, 686, 685, 685, 686, 686, 686, 686, 686,
        686, 686, 686, 686, 686, 686, 689, 689, 692, 692,
        692, 692, 692, 692, 692, 692, 692, 694, 694, 694,
        694, 692, 692, 692, 692, 692, 692, 692, 693, 695,
        695, 695, 696, 696, 696, 696, 696, 697, 697, 698,
        698, 699, 699, 699, 699, 699, 699, 699, 697, 697,
        698, 698, 697, 696, 696, 697, 697, 696, 695, 695,
        694, 694, 693, 692, 691, 694, 697, 699, 699, 699,
        702, 702, 705, 703, 702, 702, 702, 700, 699, 699,
        699, 700, 702, 704, 705, 705, 703, 702, 700, 700,
        702, 703, 702, 703, 703, 702, 703, 702, 701, 702,
        701, 700, 702, 700, 700, 702, 702, 703, 703, 704,
        706, 705, 706, 707, 706, 705, 703, 703, 702, 700,
        702, 703, 703, 702, 702, 702, 703, 704, 705, 704,
        705, 706, 705, 705, 706, 705, 705, 703, 702, 704,
        704, 705, 705, 705, 704, 705, 703, 706, 704, 705,
        705, 705, 705, 703, 703, 702, 703, 704, 705, 707,
        706, 706, 707, 706, 706, 706, 704, 706, 705, 704,
        703, 703, 700, 700, 700, 699, 700, 699, 700, 700,
        702, 700, 700, 700, 700, 700, 702, 700, 701, 699,
        700, 700, 700, 700, 700, 699, 700, 703, 702, 702,
        703, 701, 700, 700, 701, 703, 703, 703, 705, 705,
        703, 703, 703, 702, 700, 700, 699, 699, 699, 700,
        700, 699, 699, 699, 699, 699, 699, 697, 694, 692,
        692, 692, 692, 694, 697, 698, 697, 697, 697, 696,
        695, 695, 692, 692, 689, 689, 689, 689, 690, 690,
        691, 691, 692, 692, 691, 692, 691, 692, 692, 692,
        692, 692, 692, 692, 692, 691, 691, 688, 686, 686,
        686, 686, 686, 688, 691, 691, 688, 686, 686, 686,
        686, 687, 686, 684, 683, 682, 684, 684, 683, 683,
        682, 681, 680, 680, 679, 678, 681, 680, 681, 681,
        680, 680, 680, 681, 679, 680, 678, 678, 678, 679,
        677, 678, 675, 675, 673, 672, 673, 671, 672, 670,
        668, 669, 672, 670, 668, 667, 666, 665, 664, 663,
        662, 664, 661, 661, 659, 660, 659, 661, 664, 663,
        663, 664, 664, 664, 665, 663, 662, 661, 662, 661,
        662, 661, 661, 660, 661, 659, 658, 659, 660, 661,
        661, 662, 660, 661, 661, 659, 660, 661, 658, 657,
        653, 652, 651, 651, 650, 649, 649, 647, 650, 647,
        647, 648, 648, 651, 650, 653, 654, 653, 651, 651,
        650, 648, 649, 649, 650, 648, 651, 651, 652, 652,
        654, 653, 653, 651, 650, 650, 649, 649, 650, 648,
        647, 647, 647, 648, 648, 647, 648, 647, 645, 644,
        642, 642, 642, 642, 641, 642, 641, 643, 643, 643,
        644, 643, 644, 643, 641, 642, 645, 643, 642, 643,
        644, 643, 643, 644, 647, 645, 645, 642, 642, 642,
        642, 644, 647, 647, 648, 647, 648, 647, 647, 645,
        645, 645, 647, 647, 648, 646, 648, 649, 649, 649,
        651, 652, 649, 648, 646, 645, 645, 645, 645, 645,
        645, 645, 645, 645, 645, 645, 645, 645, 645, 646,
        646, 647, 647, 647, 647, 647, 645, 645, 645, 645,
        647, 647, 650, 651, 651, 651, 651, 651, 651, 651,
        651, 653, 654, 654, 653, 656, 656, 658, 659, 661,
        662, 661, 659, 661, 659, 660, 658, 658, 656, 659,
        659, 659, 660, 663, 662, 662, 662, 664, 664, 664,
        663, 664, 665, 662, 662, 664, 664, 662, 663, 663,
        663, 665, 666, 666, 667, 666, 668, 670, 669, 667,
        674, 675, 673, 673, 674, 676, 670, 670, 669, 670,
        671, 671, 673, 672, 673, 676, 674, 674, 672, 675,
        680, 678, 677, 675, 678, 683, 681, 680, 680, 685,
        684, 684, 684, 683, 679, 681, 678, 678, 679, 679,
        678, 679, 680, 679, 680, 680, 679, 679, 680, 681,
        680, 678, 682, 684, 682, 681, 683, 684, 682, 681,
        681, 679, 680, 680, 680, 679, 677, 678, 679, 678,
        677, 677, 678, 681, 683, 683, 682, 683, 683, 685,
        686, 687, 688, 689, 691, 691, 690, 691, 690, 691,
        692, 689, 689, 688, 688, 687, 686, 687, 687, 685,
        683, 683, 681, 681, 683, 684, 686, 686, 684, 684,
        684, 684, 684, 683, 683, 682, 681, 682, 683, 682,
        681, 681, 681, 681, 681, 683, 684, 683, 686, 688,
        689, 689, 689, 691, 691, 690, 688, 688, 689, 689,
        687, 689, 690, 689, 693, 695, 696, 697, 697, 699,
        701, 701, 702, 700, 700, 700, 699, 700, 700, 701,
        701, 703, 705, 704, 704, 705, 706, 706, 705, 708,
        708, 708, 708, 708, 713, 713, 712, 713, 715, 716,
        717, 716, 715, 716, 718, 722, 724, 726, 729, 732,
        735, 734, 731, 730, 731, 732, 728, 729, 730, 732,
        729, 730, 729, 731, 730, 730, 727, 726, 725, 728,
        730, 729, 729, 730, 729, 729, 727, 724, 726, 724,
        722, 719, 719, 713, 713, 710, 710, 697, 697, 698,
        698, 693, 691, 685, 685, 684, 680, 679
    };

    static const int16_t * const robinson_dadson_curves[] =
    {
        robinson_dadson_curve_0_phons,
        robinson_dadson_curve_10_phons,
        robinson_dadson_curve_20_phons,
        robinson_dadson_curve_30_phons,
        robinson_dadson_curve_40_phons,
        robinson_dadson_curve_50_phons,
        robinson_dadson_curve_60_phons,
        robinson_dadson_curve_70_phons,
        robinson_dadson_curve_80_phons,
        robinson_dadson_curve_90_phons
    };

    static const freq_curve_t robinson_dadson_curve =
    {
        19.96, // fmin
        15087.35, // fmax
        0.00, // amin
        90.00, // amax
        1468, // hdots
        10, // curves
        robinson_dadson_curves // curve data
    };

} /* namespace lsp */

#endif /* GENERATED_ISO226_ROBINSON_DADSON_H_ */

