% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-isoform.R
\name{isoformProportions}
\alias{isoformProportions}
\title{Create isoform proportions from scaled data}
\usage{
isoformProportions(y, geneCol = "gene_id", quiet = FALSE)
}
\arguments{
\item{y}{a SummarizedExperiment}

\item{geneCol}{the name of the gene ID column in the
metadata columns for the rows of \code{y}}

\item{quiet}{display no messages}
}
\value{
a SummarizedExperiment, with single-isoform
transcripts removed, and transcripts now ordered by
gene
}
\description{
Takes output of scaled (and optionally filtered) counts
and returns isoform proportions by dividing out the
total scaled count for the gene for each sample.
The operation is performed on the \code{counts} assay,
then creating a new assay called \code{isoProp},
and on all of the inferential replicates, turning them
from counts into isoform proportions. Any transcripts
(rows) from single isoform genes are removed, and the
transcripts will be re-ordered by gene ID.
}
