# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from EventEngine.idl.

use strict;

package Raritan::RPC::event::Engine_1_0_1;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "event.Engine:1.0.1";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::event::Engine_1_0_1::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use Raritan::RPC::event::Engine_1_0_1::EventDesc;

sub listEventDescs($$$) {
    my ($self, $eventIdPrefix, $eventDescs) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'eventIdPrefix'} = [];
    for (my $i0 = 0; $i0 <= $#{$eventIdPrefix}; $i0++) {
        $args->{'eventIdPrefix'}->[$i0] = "$eventIdPrefix->[$i0]";
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listEventDescs', $args);
    $$eventDescs = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'eventDescs'}}; $i0++) {
        $$eventDescs->[$i0] = Raritan::RPC::event::Engine_1_0_1::EventDesc::decode($agent, $rsp->{'eventDescs'}->[$i0]);
    }
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub listActionTypes($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listActionTypes', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

use Raritan::RPC::event::Engine_1_0_1::Action;

sub addAction($$$) {
    my ($self, $action, $actionId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'action'} = Raritan::RPC::event::Engine_1_0_1::Action::encode($action);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addAction', $args);
    $$actionId = $rsp->{'actionId'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::Engine_1_0_1::Action;

sub modifyAction($$) {
    my ($self, $action) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'action'} = Raritan::RPC::event::Engine_1_0_1::Action::encode($action);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'modifyAction', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub deleteAction($$) {
    my ($self, $actionId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'actionId'} = "$actionId";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'deleteAction', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::Engine_1_0_1::Action;

sub listActions($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listActions', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::event::Engine_1_0_1::Action::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::event::KeyValue;

sub triggerAction($$$$) {
    my ($self, $actionId, $errMsg, $context) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'actionId'} = "$actionId";
    $args->{'context'} = [];
    for (my $i0 = 0; $i0 <= $#{$context}; $i0++) {
        $args->{'context'}->[$i0] = Raritan::RPC::event::KeyValue::encode($context->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'triggerAction', $args);
    $$errMsg = $rsp->{'errMsg'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::KeyValue;
use Raritan::RPC::event::Engine_1_0_1::Action;

sub testAction($$$$) {
    my ($self, $action, $errMsg, $context) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'action'} = Raritan::RPC::event::Engine_1_0_1::Action::encode($action);
    $args->{'context'} = [];
    for (my $i0 = 0; $i0 <= $#{$context}; $i0++) {
        $args->{'context'}->[$i0] = Raritan::RPC::event::KeyValue::encode($context->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'testAction', $args);
    $$errMsg = $rsp->{'errMsg'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::Engine_1_0_1::Rule;

sub addRule($$$) {
    my ($self, $rule, $ruleId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'rule'} = Raritan::RPC::event::Engine_1_0_1::Rule::encode($rule);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addRule', $args);
    $$ruleId = $rsp->{'ruleId'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::Engine_1_0_1::Rule;

sub modifyRule($$) {
    my ($self, $rule) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'rule'} = Raritan::RPC::event::Engine_1_0_1::Rule::encode($rule);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'modifyRule', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub enableRule($$) {
    my ($self, $ruleId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'ruleId'} = "$ruleId";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'enableRule', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub disableRule($$) {
    my ($self, $ruleId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'ruleId'} = "$ruleId";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'disableRule', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub deleteRule($$) {
    my ($self, $ruleId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'ruleId'} = "$ruleId";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'deleteRule', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::Engine_1_0_1::Rule;

sub listRules($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listRules', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::event::Engine_1_0_1::Rule::decode($agent, $rsp->{'_ret_'}->[$i0]);
    }
    return $_ret_;
}

use Raritan::RPC::event::Event;

sub deliverEvent($$) {
    my ($self, $event) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'event'} = Raritan::RPC::event::Event::encode($event);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'deliverEvent', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub rearmRule($$) {
    my ($self, $ruleId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'ruleId'} = "$ruleId";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'rearmRule', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('event.Engine', 1, 0, 1, 'Raritan::RPC::event::Engine_1_0_1');
1;
