/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#include "upm_brightness.h"

UpmBrightness::UpmBrightness(QObject *parent) : QObject(parent)
{
    QStringList valueRange = {QString::number(0), QString::number(100)};
    m_brightnessPercentage = UpmCheckConfig::checkConfig(
                GSETTINGS_KEY_BRIGHTNESS_AC,
                DEFAULE_BRIGHTNESS_PERCNET, QVariant::Int,
                valueRange, true).toInt();

    connect(UpmGsettings::self(), &UpmGsettings::brightnessAcChanged,
            this, &UpmBrightness::dealBrightnessAcChanged);
}

void UpmBrightness::dealBrightnessAcChanged(QVariant value)
{
    int percentage = value.toInt();

    if (percentage >= 0 && percentage <= 100) {
        qDebug() << "brightness percentage:" << percentage;
        m_brightnessPercentage = percentage;
        UpmControlDBus::self()->controlPowerManagement(
                    UPM_DBUS_METHOD_SET_BRIGHTNESS_PERCENT, m_brightnessPercentage);
        UpmControlDBus::self()->setUpmSystemConfig(
                    GSETTINGS_KEY_BRIGHTNESS_AC, QString::number(percentage));
    } else {
        qDebug() << "brightness percentage error:" << percentage;
    }
}

int UpmBrightness::getBrightnessPercentage(void)
{
    return m_brightnessPercentage;
}

void UpmBrightness::setBrightnessPercentage(int percentage)
{
    qDebug() << "set brightness percentage:" << percentage;
    if (percentage >= 0 && percentage <= 100) {
        UpmControlDBus::self()->controlPowerManagement(
                    UPM_DBUS_METHOD_SET_BRIGHTNESS_PERCENT, percentage);
    } else {
        if (percentage < 0) {
            UpmControlDBus::self()->controlPowerManagement(
                        UPM_DBUS_METHOD_SET_BRIGHTNESS_PERCENT, 0);
        } else {
            UpmControlDBus::self()->controlPowerManagement(
                        UPM_DBUS_METHOD_SET_BRIGHTNESS_PERCENT, 100);
        }
    }
}
