/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#ifndef UPM_LID_H
#define UPM_LID_H

#include <QObject>

#include "common.h"

class UpmLid : public QObject
{
    Q_OBJECT
public:
    explicit UpmLid(QObject *parent = nullptr);

    typedef void (UpmLid::*pCloseLidActionFun)(void);

private:
    bool m_lidIsClosed;
    bool m_displayIsOn;

    QString m_closeLidActionAc;
    QString m_closeLidActionBattery;

    QMap<QString, pCloseLidActionFun> m_closeLidActionFun;

    void initLidActionFun();
    void addLidActionFun(const QString &action, pCloseLidActionFun actionFun);

    void closeLidNothingToDo();
    void closeLidTurnOffDisplay();
    void closeLidToSuspend();
    void closeLidToShutdown();
    void closeLidToHibernate();

private slots:
    void dealLidStateChanged(bool);
    void dealSystemSleepStatus(bool);

};

#endif // UPM_LID_H
