/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.constructors.ObjectConstructor;

public class ZoomerTool
extends ObjectConstructor {
    boolean Dragging = false;
    boolean Zoom = false;
    double X;
    double Y;
    double W;
    double X0;
    double Y0;
    ObjectConstructor OC;

    public ZoomerTool() {
    }

    public ZoomerTool(ObjectConstructor objectConstructor, MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        this.OC = objectConstructor;
        this.X0 = zirkelCanvas.x(mouseEvent.getX());
        this.Y0 = zirkelCanvas.y(mouseEvent.getY());
        Construction construction = zirkelCanvas.getConstruction();
        this.X = construction.getX();
        this.Y = construction.getY();
        this.W = construction.getW();
        this.Zoom = false;
        zirkelCanvas.setCursor(new Cursor(13));
        this.Dragging = true;
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        this.X0 = zirkelCanvas.x(mouseEvent.getX());
        this.Y0 = zirkelCanvas.y(mouseEvent.getY());
        Construction construction = zirkelCanvas.getConstruction();
        this.X = construction.getX();
        this.Y = construction.getY();
        this.W = construction.getW();
        boolean bl = this.Zoom = Math.abs(this.X - this.X0) > this.W / 4.0 || Math.abs(this.Y - this.Y0) > this.W / 4.0;
        if (!this.Zoom) {
            zirkelCanvas.setCursor(new Cursor(13));
        }
        this.Dragging = true;
        this.OC = null;
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!this.Dragging) {
            return;
        }
        Construction construction = zirkelCanvas.getConstruction();
        construction.setXYW(this.X, this.Y, this.W);
        zirkelCanvas.recompute();
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        if (this.Zoom) {
            construction.setXYW(this.X, this.Y, Math.sqrt((this.X0 - this.X) * (this.X0 - this.X) + (this.Y0 - this.Y) * (this.Y0 - this.Y)) / Math.sqrt((d2 - this.X) * (d2 - this.X) + (d3 - this.Y) * (d3 - this.Y)) * this.W);
        } else {
            construction.setXYW(this.X - (d2 - this.X0), this.Y - (d3 - this.Y0), this.W);
        }
        zirkelCanvas.recompute();
        zirkelCanvas.validate();
        zirkelCanvas.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        this.Zoom = false;
        this.Dragging = false;
        zirkelCanvas.setCursor(Cursor.getDefaultCursor());
        zirkelCanvas.repaint();
        if (this.OC != null) {
            zirkelCanvas.setTool(this.OC);
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.zoom"));
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.clearSelected();
        zirkelCanvas.setCursor(new Cursor(0));
        this.Dragging = false;
        this.Zoom = false;
    }

    public void invalidate(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.setCursor(new Cursor(0));
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        this.X0 = zirkelCanvas.x(mouseEvent.getX());
        this.Y0 = zirkelCanvas.y(mouseEvent.getY());
        Construction construction = zirkelCanvas.getConstruction();
        this.X = construction.getX();
        this.Y = construction.getY();
        this.W = construction.getW();
        boolean bl2 = this.Zoom = Math.abs(this.X - this.X0) > this.W / 4.0 || Math.abs(this.Y - this.Y0) > this.W / 4.0;
        if (!this.Zoom) {
            zirkelCanvas.setCursor(new Cursor(13));
        } else {
            zirkelCanvas.setCursor(new Cursor(0));
        }
    }

    public boolean useSmartBoard() {
        return false;
    }
}

