/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.FileExtFilter;
import WIMSchem.MainWindow;
import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import WIMSchem.Util;
import WIMSchem.ds.DataSheet;
import WIMSchem.ds.DataSheetCache;
import WIMSchem.ds.DataSheetStream;
import WIMSchem.ds.DataTableModel;
import WIMSchem.ds.DialogEditColumns;
import WIMSchem.ds.DialogEditSummary;
import WIMSchem.ds.TableMoleculeEditor;
import WIMSchem.ds.TableMoleculeRenderer;
import WIMSchem.ds.TitleListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.TableModelEvent;

public class DataWindow
extends JFrame
implements ActionListener,
WindowListener,
KeyListener,
TitleListener {
    public static final boolean ALLOW = true;
    String filename = null;
    JMenuBar menubar = null;
    JSplitPane splitter = null;
    DataSheet ds = null;
    DataSheetCache cache = null;
    DataTableModel model = null;
    JTable table = null;
    ImageIcon mainIcon = null;
    ImageIcon mainLogo = null;
    int unitRowHeight;
    int curRowMag;

    public DataWindow(String LoadFN) {
        super("WIMSchem DataSheet");
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.setDefaultCloseOperation(0);
        this.mainIcon = new ImageIcon(this.getClass().getResource("/images/MainIcon.png"));
        this.mainLogo = new ImageIcon(this.getClass().getResource("/images/MainLogo.png"));
        this.setIconImage(this.mainIcon.getImage());
        this.filename = LoadFN;
        if (this.filename == null) {
            this.ds = new DataSheet();
            this.cache = new DataSheetCache();
            this.ds.appendColumn("Molecule", 1, "Molecular structure");
        } else {
            this.loadDataSheet(this.filename);
        }
        this.setLayout(new BorderLayout());
        this.menubar = new JMenuBar();
        this.createMenuBar();
        this.model = new DataTableModel(this.ds, this.cache, this);
        this.table = new JTable(this.model){

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (ks.getKeyCode() == 27) {
                    return false;
                }
                if ((e.getModifiersEx() & 0x200) != 0) {
                    return false;
                }
                if ((e.getModifiersEx() & 0x80) != 0) {
                    return false;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        this.table.setPreferredScrollableViewportSize(new Dimension(720, 530));
        this.table.setDefaultRenderer(Molecule.class, new TableMoleculeRenderer());
        this.table.setDefaultEditor(Molecule.class, new TableMoleculeEditor());
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.addKeyListener(this);
        this.table.setTransferHandler(new TransferTableData(this.table, this.model));
        this.unitRowHeight = this.table.getRowHeight();
        this.updateRowHeight(2);
        this.add((Component)this.menubar, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.pack();
        this.addWindowListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataSheet(String FN) {
        DataSheet newDS = null;
        FileInputStream istr = null;
        try {
            istr = new FileInputStream(FN);
            if (DataSheetStream.examineIsXMLDS(istr)) {
                newDS = DataSheetStream.readXML(istr);
            } else if (DataSheetStream.examineIsMDLSDF(istr)) {
                newDS = DataSheetStream.readSDF(istr);
                FN = null;
            } else {
                String msg = "[" + FN + "]\n" + "The file does not appear to be of the XML\n" + "WIMSchem DataSheet format, an MDL SD file.";
                JOptionPane.showMessageDialog(null, msg, "Open Failed", 0);
            }
            this.cache = new DataSheetCache();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Open Failed", 0);
        }
        finally {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (newDS == null) {
            this.ds = new DataSheet();
            this.replaceTitle();
            return;
        }
        this.ds = newDS;
        this.setFilename(FN);
        if (this.model != null) {
            this.model.setDataSheet(this.ds, this.cache);
            this.model.fireTableStructureChanged();
        }
    }

    private void createMenuBar() {
        boolean allKeys = true;
        JMenu menufile = new JMenu("File");
        menufile.setMnemonic(70);
        menufile.add(this.menuItem("New", 78, null, this.key('N', 2, allKeys)));
        menufile.add(this.menuItem("New Molecule", 77));
        menufile.add(this.menuItem("Open", 79, null, this.key('O', 2, allKeys)));
        menufile.add(this.menuItem("Save", 83, null, this.key('S', 2, allKeys)));
        menufile.add(this.menuItem("Save As", 65));
        JMenu menuexport = new JMenu("Export");
        menuexport.setMnemonic(88);
        menuexport.add(this.menuItem("as MDL SDF", 83, null, this.key('S', 3, allKeys)));
        menufile.add(menuexport);
        menufile.addSeparator();
        menufile.add(this.menuItem("Quit", 81, null, this.key('Q', 2, allKeys)));
        JMenu menuedit = new JMenu("Edit");
        menuedit.setMnemonic(69);
        menuedit.add(this.menuItem("Undo", 85, null, this.key('Z', 2, allKeys)));
        menuedit.add(this.menuItem("Redo", 82, null, this.key('Z', 3, allKeys)));
        menuedit.addSeparator();
        menuedit.add(this.menuItem("Add Row", 65, null, this.key(155, 0, allKeys)));
        menuedit.add(this.menuItem("Delete Rows", 68));
        menuedit.add(this.menuItem("Move Rows Up", 85, null, this.key(38, 8, allKeys)));
        menuedit.add(this.menuItem("Move Rows Down", 68, null, this.key(40, 8, allKeys)));
        menuedit.addSeparator();
        menuedit.add(this.menuItem("Copy Rows", 67, null, this.key('C', 3, allKeys)));
        menuedit.add(this.menuItem("Cut Rows", 84, null, this.key('X', 3, allKeys)));
        menuedit.add(this.menuItem("Paste Rows", 80, null, this.key('V', 3, allKeys)));
        menuedit.addSeparator();
        menuedit.add(this.menuItem("Sheet Summary", 83));
        menuedit.add(this.menuItem("Edit Columns", 67));
        JMenu menuview = new JMenu("View");
        menuview.setMnemonic(86);
        menuview.add(this.menuItem("Single Line", 76, null, this.key('1', 2, allKeys)));
        menuview.add(this.menuItem("Small Height", 83, null, this.key('2', 2, allKeys)));
        menuview.add(this.menuItem("Medium Height", 77, null, this.key('3', 2, allKeys)));
        menuview.add(this.menuItem("Large Height", 76, null, this.key('4', 2, allKeys)));
        JMenu menuhelp = new JMenu("Help");
        menuhelp.setMnemonic(72);
        menuhelp.add(this.menuItem("About", 65));
        this.menubar.removeAll();
        this.menubar.add(menufile);
        this.menubar.add(menuedit);
        this.menubar.add(menuview);
        this.menubar.add(Box.createHorizontalGlue());
        this.menubar.add(menuhelp);
    }

    private KeyStroke key(char key, int mods, boolean really) {
        return really ? KeyStroke.getKeyStroke((int)key, mods) : null;
    }

    private KeyStroke key(int key, int mods, boolean really) {
        return really ? KeyStroke.getKeyStroke(key, mods) : null;
    }

    private JMenuItem menuItem(String txt, int key) {
        return this.menuItem(txt, key, null, null, true);
    }

    private JMenuItem menuItem(String txt, int key, Icon icon) {
        return this.menuItem(txt, key, icon, null, true);
    }

    private JMenuItem menuItem(String txt, int key, Icon icon, KeyStroke accel) {
        return this.menuItem(txt, key, icon, accel, true);
    }

    private JMenuItem menuItem(String txt, int key, Icon icon, KeyStroke accel, boolean enabled) {
        JMenuItem mi = new JMenuItem(txt, key);
        mi.addActionListener(this);
        mi.setEnabled(enabled);
        if (icon != null) {
            mi.setIcon(icon);
        }
        if (accel != null) {
            mi.setAccelerator(accel);
        }
        return mi;
    }

    private JRadioButtonMenuItem radioMenuItem(String txt, int key, boolean sel, ButtonGroup bg) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(txt, sel);
        mi.addActionListener(this);
        mi.setMnemonic(key);
        bg.add(mi);
        return mi;
    }

    private void updateRowHeight(int Mag) {
        this.curRowMag = Mag;
        this.table.setRowHeight(this.unitRowHeight * (this.curRowMag == 2 ? 3 : (this.curRowMag == 3 ? 6 : (this.curRowMag == 4 ? 12 : 1))));
    }

    private void setFilename(String FN) {
        this.filename = FN;
        this.replaceTitle();
    }

    public void replaceTitle() {
        String title = "WIMSchem DataSheet";
        if (this.ds != null && this.ds.isDirty()) {
            title = "*" + title;
        }
        if (this.filename != null) {
            title = title + " - " + new File(this.filename).getName();
        }
        if (this.ds != null && this.ds.getTitle().length() > 0) {
            title = title + ":" + this.ds.getTitle();
        }
        this.setTitle(title);
    }

    private void saveCurrent() {
        if (this.filename == null) {
            return;
        }
        try {
            FileOutputStream ostr = new FileOutputStream(this.filename);
            DataSheetStream.writeXML(ostr, this.ds);
            ostr.close();
            this.ds.clearDirty();
            this.replaceTitle();
        }
        catch (IOException e) {
            Util.errmsg("Save Failed", e.toString());
        }
    }

    private boolean sameColumns(DataSheet DS1, DataSheet DS2) {
        if (DS1.numCols() != DS2.numCols()) {
            return false;
        }
        for (int n = 0; n < DS1.numCols(); ++n) {
            if (DS1.colName(n).compareTo(DS2.colName(n)) != 0) {
                return false;
            }
            if (DS1.colType(n) != DS2.colType(n)) {
                return false;
            }
            if (DS1.colDescr(n).compareTo(DS2.colDescr(n)) == 0) continue;
            return false;
        }
        return true;
    }

    private void fileQuit() {
        if (this.ds.isDirty() && JOptionPane.showConfirmDialog(null, "Current datasheet has been modified. Exit without saving?", "Quit", 0) != 0) {
            return;
        }
        this.dispose();
    }

    private void fileNew() {
        new DataWindow(null).setVisible(true);
    }

    private void fileNewMolecule() {
        new MainWindow(null, false).setVisible(true);
    }

    private void fileOpen() {
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("DataSheet Formats", ".xml;.sdf"));
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        String newfn = chooser.getSelectedFile().getPath();
        if (this.ds.numRows() == 0 && !this.ds.isDirty()) {
            this.loadDataSheet(newfn);
        } else {
            new DataWindow(newfn).setVisible(true);
        }
    }

    private void fileSave() {
        if (this.filename == null) {
            this.fileSaveAs();
            return;
        }
        this.saveCurrent();
    }

    private void fileSaveAs() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("WIMSchem DataSheets", ".xml"));
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".xml";
        }
        if ((newf = new File(fn)).exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file [" + newf.getName() + "]?", "Save As", 0) != 0) {
            return;
        }
        this.setFilename(fn);
        this.saveCurrent();
    }

    private void fileExportSDF() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("MDL SD files", ".sdf"));
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".sdf";
        }
        if ((newf = new File(fn)).exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file [" + newf.getName() + "]?", "Save As", 0) != 0) {
            return;
        }
        try {
            FileOutputStream ostr = new FileOutputStream(fn);
            DataSheetStream.writeSDF(ostr, this.ds);
            ostr.close();
        }
        catch (IOException e) {
            Util.errmsg("Export Failed", e.toString());
        }
    }

    private void editUndo() {
        if (!this.cache.canUndo()) {
            return;
        }
        DataSheet newds = this.cache.performUndo(this.ds);
        boolean colmod = !this.sameColumns(this.ds, newds);
        this.ds = newds;
        this.ds.setDirty();
        this.replaceTitle();
        this.model.setDataSheet(this.ds, this.cache);
        if (colmod) {
            this.model.fireTableStructureChanged();
        } else {
            this.model.fireTableDataChanged();
        }
    }

    private void editRedo() {
        if (!this.cache.canRedo()) {
            return;
        }
        DataSheet newds = this.cache.performRedo(this.ds);
        boolean colmod = !this.sameColumns(this.ds, newds);
        this.ds = newds;
        this.ds.setDirty();
        this.replaceTitle();
        this.model.setDataSheet(this.ds, this.cache);
        if (colmod) {
            this.model.fireTableStructureChanged();
        } else {
            this.model.fireTableDataChanged();
        }
    }

    private void editSummary() {
        DialogEditSummary edsumm = new DialogEditSummary((Frame)this, this.ds);
        if (!edsumm.execute()) {
            return;
        }
        if (edsumm.resultTitle().equals(this.ds.getTitle()) && edsumm.resultDescr().equals(this.ds.getDescription())) {
            return;
        }
        this.ds.setTitle(edsumm.resultTitle());
        this.ds.setDescription(edsumm.resultDescr());
        this.ds.setDirty();
        this.replaceTitle();
    }

    private void editColumns() {
        DialogEditColumns edcols = new DialogEditColumns((Frame)this, this.ds);
        if (!edcols.execute()) {
            return;
        }
        this.modifyColumns(edcols.resultOldPos(), edcols.resultNewPos(), edcols.resultName(), edcols.resultType(), edcols.resultDescr());
        this.model.fireTableStructureChanged();
        this.ds.setDirty();
        this.replaceTitle();
    }

    private void addRow() {
        this.cache.cacheUndo(this.ds);
        this.ds.appendRow();
        int selcol = this.table.getSelectedColumn();
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.table.changeSelection(this.ds.numRows() - 1, selcol < 0 ? 0 : selcol, false, false);
        this.ds.setDirty();
        this.replaceTitle();
    }

    private void deleteRows() {
        if (this.table.getSelectedRowCount() == 0) {
            return;
        }
        this.cache.cacheUndo(this.ds);
        int[] todel = this.table.getSelectedRows();
        for (int i = todel.length - 1; i >= 0; --i) {
            this.ds.deleteRow(i);
            for (int j = i + 1; j < todel.length; ++j) {
                if (todel[j] <= todel[i]) continue;
                int n = j;
                todel[n] = todel[n] - 1;
            }
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.ds.setDirty();
        this.replaceTitle();
    }

    private void moveRowsUp() {
        int n;
        if (this.table.getSelectedRowCount() == 0 || this.ds.numCols() == 0) {
            return;
        }
        int[] rows = this.table.getSelectedRows();
        if (rows[0] == 0) {
            return;
        }
        this.cache.cacheUndo(this.ds);
        for (n = 0; n < rows.length; ++n) {
            this.ds.moveRowUp(rows[n]);
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
        for (n = 0; n < rows.length; ++n) {
            this.table.changeSelection(rows[n] - 1, 0, n != 0, false);
        }
        this.table.setColumnSelectionInterval(0, this.ds.numCols() - 1);
        this.ds.setDirty();
        this.replaceTitle();
    }

    private void moveRowsDown() {
        int n;
        if (this.table.getSelectedRowCount() == 0 || this.ds.numCols() == 0) {
            return;
        }
        int[] rows = this.table.getSelectedRows();
        if (rows[rows.length - 1] == this.ds.numRows() - 1) {
            return;
        }
        this.cache.cacheUndo(this.ds);
        for (n = rows.length - 1; n >= 0; --n) {
            this.ds.moveRowDown(rows[n]);
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
        for (n = 0; n < rows.length; ++n) {
            this.table.changeSelection(rows[n] + 1, 0, n != 0, false);
        }
        this.table.setColumnSelectionInterval(0, this.ds.numCols() - 1);
        this.ds.setDirty();
        this.replaceTitle();
    }

    private void copyRows() {
        if (this.table.getSelectedRowCount() == 0) {
            return;
        }
        int[] rn = this.table.getSelectedRows();
        DataSheet copy = new DataSheet();
        for (int n = 0; n < this.ds.numCols(); ++n) {
            copy.appendColumn(this.ds.colName(n), this.ds.colType(n), this.ds.colDescr(n));
        }
        for (int i = 0; i < rn.length; ++i) {
            copy.appendRow();
            for (int j = 0; j < this.ds.numCols(); ++j) {
                copy.setObject(i, j, this.ds.getObject(rn[i], j));
            }
        }
        StringWriter sw = new StringWriter();
        try {
            DataSheetStream.writeXML(new BufferedWriter(sw), copy);
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new StringSelection(sw.toString()), null);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Copy Failed", 0);
        }
    }

    private void cutRows() {
        this.copyRows();
        this.deleteRows();
    }

    private void pasteRows() {
        int i;
        String cliptext = "";
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clip.getContents(null);
            if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                cliptext = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (UnsupportedFlavorException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Clipboard Read Failed", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Paste Failed", 0);
        }
        DataSheet paste = null;
        try {
            if (DataSheetStream.examineIsXMLDS(new BufferedReader(new StringReader(cliptext)))) {
                paste = DataSheetStream.readXML(new BufferedReader(new StringReader(cliptext)));
            } else if (DataSheetStream.examineIsMDLSDF(new BufferedReader(new StringReader(cliptext)))) {
                paste = DataSheetStream.readSDF(new BufferedReader(new StringReader(cliptext)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (paste == null) {
            JOptionPane.showMessageDialog(null, "Unknown format: must be DataSheet XML or MDL SDF", "Paste Failed", 0);
            return;
        }
        this.cache.cacheUndo(this.ds);
        int[] newcolpos = new int[paste.numCols()];
        for (i = 0; i < paste.numCols(); ++i) {
            newcolpos[i] = -1;
            for (int j = 0; j < this.ds.numCols(); ++j) {
                if (this.ds.colName(j).compareTo(paste.colName(i)) != 0) continue;
                newcolpos[i] = j;
                break;
            }
            if (newcolpos[i] >= 0) continue;
            newcolpos[i] = this.ds.appendColumn(paste.colName(i), paste.colType(i), paste.colDescr(i));
        }
        for (i = 0; i < paste.numRows(); ++i) {
            int rn = this.ds.appendRow();
            for (int j = 0; j < paste.numCols(); ++j) {
                int cn = newcolpos[j];
                int ptype = paste.colType(j);
                int dtype = this.ds.colType(j);
                String strval = "";
                if (ptype == 1 && dtype == 1) {
                    this.ds.setMolecule(rn, cn, paste.getMolecule(i, j));
                    continue;
                }
                if (ptype == 1 || dtype == 1) continue;
                String val = "";
                if (ptype == 2) {
                    val = paste.getString(i, j);
                } else if (ptype == 3) {
                    val = String.valueOf(paste.getInteger(i, j));
                } else if (ptype == 4) {
                    val = String.valueOf(paste.getReal(i, j));
                } else if (ptype == 5) {
                    val = paste.getBoolean(i, j) ? "true" : "false";
                }
                try {
                    if (dtype == 2) {
                        this.ds.setString(rn, cn, val);
                        continue;
                    }
                    if (dtype == 3) {
                        this.ds.setInteger(rn, cn, new Integer(val));
                        continue;
                    }
                    if (dtype == 4) {
                        this.ds.setReal(rn, cn, new Double(val));
                        continue;
                    }
                    if (dtype != 5) continue;
                    this.ds.setBoolean(rn, cn, val.toLowerCase().compareTo("true") == 0);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void helpAbout() {
        String msg = "WIMSchem vSketchEl 1.21 WIMSversion 0.2 SVG export\nMolecule drawing tool\n\u00a9 2005-2008 Dr. Alex M. Clark\nReleased under the Gnu Public\nLicense (GPL), see www.gnu.org\nHome page and documentation:\nhttp://sketchel.sf.net\n";
        JOptionPane.showMessageDialog(null, msg, "About WIMSchem", 1, this.mainLogo);
    }

    private void modifyColumns(int[] OldPos, int[] NewPos, String[] Name, int[] Type2, String[] Descr) {
        int n;
        int sz = OldPos.length;
        for (n = 0; n < sz; ++n) {
            int i;
            if (NewPos[n] >= 0) continue;
            this.ds.deleteColumn(OldPos[n]);
            for (i = 0; i < sz; ++i) {
                if (OldPos[i] <= OldPos[n]) continue;
                int n2 = i;
                OldPos[n2] = OldPos[n2] - 1;
            }
            for (i = n; i < sz - 1; ++i) {
                OldPos[i] = OldPos[i + 1];
                NewPos[i] = NewPos[i + 1];
                Name[i] = Name[i + 1];
                Type2[i] = Type2[i + 1];
                Descr[i] = Descr[i + 1];
            }
            --n;
            --sz;
        }
        for (n = 0; n < sz; ++n) {
            if (OldPos[n] >= 0) continue;
            OldPos[n] = this.ds.appendColumn(Name[n], Type2[n], Descr[n]);
        }
        for (n = 0; n < sz; ++n) {
            this.ds.changeColumnName(OldPos[n], Name[n], Descr[n]);
            this.ds.changeColumnType(OldPos[n], Type2[n], true);
        }
        int[] reord = new int[sz];
        for (int n3 = 0; n3 < sz; ++n3) {
            reord[NewPos[n3]] = OldPos[n3];
        }
        this.cache.cacheUndo(this.ds);
        this.ds.reorderColumns(reord);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (e.getSource() != this.table) {
            if (cmd == "Quit") {
                this.fileQuit();
            } else if (cmd == "New") {
                this.fileNew();
            } else if (cmd == "New Molecule") {
                this.fileNewMolecule();
            } else if (cmd == "Open") {
                this.fileOpen();
            } else if (cmd == "Save") {
                this.fileSave();
            } else if (cmd == "Save As") {
                this.fileSaveAs();
            } else if (cmd == "as MDL SDF") {
                this.fileExportSDF();
            } else if (cmd == "Undo") {
                this.editUndo();
            } else if (cmd == "Redo") {
                this.editRedo();
            } else if (cmd == "Add Row") {
                this.addRow();
            } else if (cmd == "Delete Rows") {
                this.deleteRows();
            } else if (cmd == "Move Rows Up") {
                this.moveRowsUp();
            } else if (cmd == "Move Rows Down") {
                this.moveRowsDown();
            } else if (cmd == "Copy Rows") {
                this.copyRows();
            } else if (cmd == "Cut Rows") {
                this.cutRows();
            } else if (cmd == "Paste Rows") {
                this.pasteRows();
            } else if (cmd == "Sheet Summary") {
                this.editSummary();
            } else if (cmd == "Edit Columns") {
                this.editColumns();
            } else if (cmd == "Single Line") {
                this.updateRowHeight(1);
            } else if (cmd == "Small Height") {
                this.updateRowHeight(2);
            } else if (cmd == "Medium Height") {
                this.updateRowHeight(3);
            } else if (cmd == "Large Height") {
                this.updateRowHeight(4);
            } else if (cmd == "About") {
                this.helpAbout();
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.fileQuit();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    class TransferTableData
    extends TransferHandler {
        JTable table;
        DataTableModel model;

        public TransferTableData(JTable table, DataTableModel model) {
            this.table = table;
            this.model = model;
        }

        public boolean canImport(TransferHandler.TransferSupport info) {
            if (!info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            String data = null;
            try {
                data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
            }
            catch (InvalidDnDOperationException e) {
                return true;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                Molecule mol = MoleculeStream.readUnknown(new BufferedReader(new StringReader(data)));
                if (mol != null) {
                    Point pos = info.getDropLocation().getDropPoint();
                    int col = this.table.columnAtPoint(pos);
                    int row = this.table.rowAtPoint(pos);
                    return col >= 0 && row >= 0 && this.model.getDataSheet().colType(col) == 1;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            String data = null;
            try {
                data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
            }
            catch (InvalidDnDOperationException e) {
                return false;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                Molecule mol = MoleculeStream.readUnknown(new BufferedReader(new StringReader(data)));
                if (mol != null) {
                    Point pos = info.getDropLocation().getDropPoint();
                    int row = this.table.rowAtPoint(pos);
                    int col = this.table.columnAtPoint(pos);
                    DataSheet ds = this.model.getDataSheet();
                    if (row >= 0 && col >= 0 && ds.colType(col) == 1) {
                        this.model.setValueAt(mol, row, col);
                        this.model.fireTableDataChanged();
                        return true;
                    }
                    return false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }
}

