/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.IInlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RepeatableLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableAreaLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.TableRegionLayout;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class TableLayout
extends RepeatableLayout {
    private ITableContent tableContent;
    protected int columnNumber;
    protected int startCol = -1;
    protected int endCol = -1;
    protected int tableWidth;
    protected TableLayoutInfo layoutInfo = null;
    protected TableContext tableContext = null;
    protected ColumnWidthResolver columnWidthResolver;
    protected TableAreaLayout regionLayout = null;

    public TableLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
        this.tableContent = (ITableContent)content;
        this.columnWidthResolver = new ColumnWidthResolver(this.tableContent);
        this.columnNumber = this.tableContent.getColumnCount();
        boolean isBlock = !PropertyUtil.isInlineElement(content);
        this.isInBlockStacking &= isBlock;
    }

    @Override
    protected void createRoot() {
        this.currentContext.root = AreaFactory.createTableArea((ITableContent)this.content);
        this.currentContext.root.setWidth(this.tableWidth);
    }

    public TableLayoutInfo getLayoutInfo() {
        return this.layoutInfo;
    }

    protected void buildTableLayoutInfo() {
        this.layoutInfo = this.resolveTableFixedLayout((TableArea)this.currentContext.root);
    }

    public int getColumnCount() {
        if (this.tableContent != null) {
            return this.tableContent.getColumnCount();
        }
        return 0;
    }

    protected void checkInlineBlock() throws BirtException {
        if (PropertyUtil.isInlineElement(this.tableContent) && this.parent instanceof IInlineStackingLayout) {
            int avaWidth = this.parent.getCurrentMaxContentWidth();
            this.calculateSpecifiedWidth();
            if (avaWidth < this.specifiedWidth && this.specifiedWidth > 0 && this.specifiedWidth < this.parent.getMaxAvaWidth()) {
                ((IInlineStackingLayout)((Object)this.parent)).endLine();
            }
        }
    }

    @Override
    protected void initialize() throws BirtException {
        this.checkInlineBlock();
        this.currentContext = new TableContext();
        this.contextList.add(this.currentContext);
        this.tableContext = (TableContext)this.currentContext;
        this.createRoot();
        this.buildTableLayoutInfo();
        this.currentContext.root.setWidth(this.layoutInfo.getTableWidth());
        this.currentContext.maxAvaWidth = this.layoutInfo.getTableWidth();
        if (this.columnNumber < this.layoutInfo.columnNumber) {
            this.addDummyColumnForRTL();
        }
        if (this.parent != null) {
            this.currentContext.root.setAllocatedHeight(this.parent.getCurrentMaxContentHeight());
        } else {
            this.currentContext.root.setAllocatedHeight(this.context.getMaxHeight());
        }
        if (this.tableContext.layout == null) {
            int start = 0;
            int end = this.tableContent.getColumnCount() - 1;
            this.tableContext.layout = new TableAreaLayout(this.tableContent, this.layoutInfo, start, end);
        }
        this.currentContext.maxAvaHeight = this.currentContext.root.getContentHeight() - this.getBottomBorderWidth();
        this.addCaption(this.tableContent.getCaption());
        this.repeatHeader();
    }

    @Override
    protected void setCurrentContext(int index) {
        super.setCurrentContext(index);
        this.tableContext = (TableContext)this.currentContext;
    }

    @Override
    protected void closeLayout(ContainerLayout.ContainerContext currentContext, int index, boolean finished) {
        if (currentContext.root == null || currentContext.root.getChildrenCount() == 0) {
            return;
        }
        TableContext tableContext = (TableContext)currentContext;
        int borderHeight = 0;
        if (tableContext.layout != null) {
            int height = tableContext.layout.resolveAll();
            if (height != 0) {
                currentContext.currentBP += height;
            }
            borderHeight = tableContext.layout.resolveBottomBorder();
            tableContext.layout.remove((TableArea)currentContext.root);
        }
        currentContext.root.setHeight(currentContext.currentBP + this.getOffsetY() + borderHeight);
        this.parent.addToRoot((AbstractArea)currentContext.root, index);
        this.regionLayout = null;
    }

    private int getBottomBorderWidth() {
        IStyle style = this.currentContext.root.getContent().getComputedStyle();
        int borderHeight = PropertyUtil.getDimensionValue(style.getProperty(11));
        return borderHeight;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void resolveBorderConflict(CellArea cellArea, boolean isFirst) {
        if (this.tableContext.layout != null) {
            this.tableContext.layout.resolveBorderConflict(cellArea, isFirst);
        }
    }

    private void addDummyColumnForRTL() {
        this.tableContent.addColumn(new Column(this.tableContent.getReportContent()));
        ++this.columnNumber;
    }

    private TableLayoutInfo resolveTableFixedLayout(TableArea area) {
        assert (this.parent != null);
        int parentMaxWidth = this.parent.currentContext.maxAvaWidth;
        IStyle style = area.getStyle();
        int marginWidth = this.getDimensionValue(style.getProperty(16)) + this.getDimensionValue(style.getProperty(17));
        return new TableLayoutInfo(this.columnWidthResolver.resolveFixedLayout(parentMaxWidth - marginWidth));
    }

    public void addRow(RowArea row, int specifiedHeight, int index, int size) {
        if (this.isInBlockStacking) {
            this.tableContext = (TableContext)this.contextList.get(index);
            if (this.tableContext.layout != null) {
                this.tableContext.layout.addRow(row, specifiedHeight);
            }
        } else {
            int tableSize = this.contextList.size();
            this.tableContext = (TableContext)this.contextList.get(tableSize - size + index);
            if (this.tableContext.layout != null) {
                this.tableContext.layout.addRow(row, specifiedHeight);
            }
        }
    }

    public int getXPos(int columnID) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getXPosition(columnID);
        }
        return 0;
    }

    public int getCellWidth(int startColumn, int endColumn) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getCellWidth(startColumn, endColumn);
        }
        return 0;
    }

    public TableRegionLayout getTableRegionLayout() {
        if (this.regionLayout == null) {
            this.regionLayout = new TableAreaLayout(this.tableContent, this.layoutInfo, this.startCol, this.endCol);
        }
        return new TableRegionLayout(this.context, this.tableContent, this.layoutInfo, this.regionLayout);
    }

    protected IContent generateCaptionRow(String caption) {
        IReportContent report = this.tableContent.getReportContent();
        ILabelContent captionLabel = report.createLabelContent();
        captionLabel.setText(caption);
        captionLabel.getStyle().setProperty(23, IStyle.CENTER_VALUE);
        ICellContent cell = report.createCellContent();
        cell.setColSpan(this.tableContent.getColumnCount());
        cell.setRowSpan(1);
        cell.setColumn(0);
        cell.getStyle().setProperty(49, IStyle.HIDDEN_VALUE);
        cell.getStyle().setProperty(22, IStyle.HIDDEN_VALUE);
        cell.getStyle().setProperty(52, IStyle.HIDDEN_VALUE);
        cell.getStyle().setProperty(21, IStyle.HIDDEN_VALUE);
        captionLabel.setParent(cell);
        cell.getChildren().add(captionLabel);
        IRowContent row = report.createRowContent();
        row.getChildren().add(cell);
        cell.setParent(row);
        row.setParent(this.tableContent);
        return row;
    }

    @Override
    protected void repeatHeader() throws BirtException {
        if (this.bandStatus == 1) {
            return;
        }
        ITableBandContent header = this.context.getWrappedTableHeader(this.content.getInstanceID());
        if (header == null || !this.tableContent.isHeaderRepeat() || header.getChildren().isEmpty()) {
            return;
        }
        TableRegionLayout rLayout = this.getTableRegionLayout();
        rLayout.initialize(header);
        rLayout.layout();
        TableArea tableRegion = (TableArea)header.getExtension(1);
        if (tableRegion != null && tableRegion.getAllocatedHeight() < this.getCurrentMaxContentHeight()) {
            TableContext tableContext = (TableContext)this.contextList.getLast();
            tableContext.layout.addRows(rLayout.getTableAreaLayout().getRows());
            Iterator iter = tableRegion.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                this.addArea(area);
            }
        }
        this.content.setExtension(1, null);
    }

    protected void addCaption(String caption) throws BirtException {
        if (caption == null || "".equals(caption)) {
            return;
        }
        TableRegionLayout rLayout = this.getTableRegionLayout();
        IContent row = this.generateCaptionRow(this.tableContent.getCaption());
        rLayout.initialize(row);
        rLayout.layout();
        TableArea tableRegion = (TableArea)row.getExtension(1);
        if (tableRegion != null) {
            Iterator iter = tableRegion.getChildren();
            while (iter.hasNext()) {
                RowArea rowArea = (RowArea)iter.next();
                this.addArea(rowArea);
            }
        }
        row.setExtension(1, null);
        this.regionLayout = null;
    }

    @Override
    public boolean addArea(AbstractArea area) {
        return super.addArea(area);
    }

    private class ColumnWidthResolver {
        ITableContent table;

        public ColumnWidthResolver(ITableContent table) {
            this.table = table;
        }

        protected int[] formalize(DimensionType[] columns, int tableWidth, boolean isTableWidthDefined) {
            int[] resolvedColumnWidth;
            block24: {
                int left;
                int fixedLength;
                double total;
                ArrayList<Integer> unsetList;
                ArrayList<Integer> percentageList;
                block22: {
                    block23: {
                        percentageList = new ArrayList<Integer>();
                        unsetList = new ArrayList<Integer>();
                        ArrayList<Integer> preFixedList = new ArrayList<Integer>();
                        resolvedColumnWidth = new int[columns.length];
                        total = 0.0;
                        fixedLength = 0;
                        int i = 0;
                        while (i < columns.length) {
                            int len;
                            if (columns[i] == null) {
                                unsetList.add(i);
                            } else if ("%".equals(columns[i].getUnits())) {
                                percentageList.add(i);
                                total += columns[i].getMeasure();
                            } else if ("em".equals(columns[i].getUnits()) || "ex".equals(columns[i].getUnits())) {
                                resolvedColumnWidth[i] = len = TableLayout.this.getDimensionValue(columns[i], PropertyUtil.getDimensionValue(this.table.getComputedStyle().getProperty(39)));
                                fixedLength += len;
                            } else {
                                resolvedColumnWidth[i] = len = TableLayout.this.getDimensionValue(columns[i], tableWidth);
                                preFixedList.add(i);
                                fixedLength += len;
                            }
                            ++i;
                        }
                        if (!isTableWidthDefined && unsetList.isEmpty() && percentageList.isEmpty()) {
                            return resolvedColumnWidth;
                        }
                        if (fixedLength >= tableWidth) {
                            i = 0;
                            while (i < unsetList.size()) {
                                Integer index = (Integer)unsetList.get(i);
                                resolvedColumnWidth[index.intValue()] = 0;
                                ++i;
                            }
                            i = 0;
                            while (i < percentageList.size()) {
                                Integer index = (Integer)percentageList.get(i);
                                resolvedColumnWidth[index.intValue()] = 0;
                                ++i;
                            }
                            return resolvedColumnWidth;
                        }
                        if (!unsetList.isEmpty()) break block22;
                        if (!percentageList.isEmpty()) break block23;
                        left = tableWidth - fixedLength;
                        if (preFixedList.isEmpty()) break block24;
                        int delta = left / preFixedList.size();
                        int i2 = 0;
                        while (i2 < preFixedList.size()) {
                            Integer index = (Integer)preFixedList.get(i2);
                            int n = index;
                            resolvedColumnWidth[n] = resolvedColumnWidth[n] + delta;
                            ++i2;
                        }
                        break block24;
                    }
                    float leftPercentage = (float)(tableWidth - fixedLength) / (float)tableWidth * 100.0f;
                    double ratio = (double)leftPercentage / total;
                    int i = 0;
                    while (i < percentageList.size()) {
                        Integer index = (Integer)percentageList.get(i);
                        columns[index.intValue()] = new DimensionType(columns[index].getMeasure() * ratio, columns[index].getUnits());
                        resolvedColumnWidth[index.intValue()] = TableLayout.this.getDimensionValue(columns[index], tableWidth);
                        ++i;
                    }
                    break block24;
                }
                if (percentageList.isEmpty()) {
                    left = tableWidth - fixedLength;
                    int eachWidth = left / unsetList.size();
                    int i = 0;
                    while (i < unsetList.size()) {
                        Integer index = (Integer)unsetList.get(i);
                        resolvedColumnWidth[index.intValue()] = eachWidth;
                        ++i;
                    }
                } else {
                    float leftPercentage = (float)(tableWidth - fixedLength) / (float)tableWidth * 100.0f;
                    if ((double)leftPercentage <= total) {
                        Integer index;
                        double ratio = (double)leftPercentage / total;
                        int i = 0;
                        while (i < unsetList.size()) {
                            index = (Integer)unsetList.get(i);
                            resolvedColumnWidth[index.intValue()] = 0;
                            ++i;
                        }
                        i = 0;
                        while (i < percentageList.size()) {
                            index = (Integer)percentageList.get(i);
                            columns[index.intValue()] = new DimensionType(columns[index].getMeasure() * ratio, columns[index].getUnits());
                            resolvedColumnWidth[index.intValue()] = TableLayout.this.getDimensionValue(columns[index], tableWidth);
                            ++i;
                        }
                    } else {
                        int usedLength = fixedLength;
                        int i = 0;
                        while (i < percentageList.size()) {
                            Integer index = (Integer)percentageList.get(i);
                            int width = TableLayout.this.getDimensionValue(columns[index], tableWidth);
                            usedLength += width;
                            resolvedColumnWidth[index.intValue()] = width;
                            ++i;
                        }
                        int left2 = tableWidth - usedLength;
                        int eachWidth = left2 / unsetList.size();
                        int i3 = 0;
                        while (i3 < unsetList.size()) {
                            Integer index = (Integer)unsetList.get(i3);
                            resolvedColumnWidth[index.intValue()] = eachWidth;
                            ++i3;
                        }
                    }
                }
            }
            return resolvedColumnWidth;
        }

        public int[] resolveFixedLayout(int maxWidth) {
            int tableWidth;
            int columnNumber = this.table.getColumnCount();
            DimensionType[] columns = new DimensionType[columnNumber];
            int i = 0;
            while (i < columnNumber) {
                IColumn column = this.table.getColumn(i);
                DimensionType w = column.getWidth();
                if (TableLayout.this.startCol < 0) {
                    TableLayout.this.startCol = i;
                }
                TableLayout.this.endCol = i;
                columns[i] = w == null ? null : new DimensionType(w.getMeasure(), w.getUnits());
                ++i;
            }
            if (TableLayout.this.startCol < 0) {
                TableLayout.this.startCol = 0;
            }
            if (TableLayout.this.endCol < 0) {
                TableLayout.this.endCol = 0;
            }
            boolean isTableWidthDefined = false;
            int specifiedWidth = TableLayout.this.getDimensionValue(TableLayout.this.tableContent.getWidth(), maxWidth);
            if (specifiedWidth > 0) {
                tableWidth = specifiedWidth;
                isTableWidthDefined = true;
            } else {
                tableWidth = maxWidth;
                isTableWidthDefined = false;
            }
            return this.formalize(columns, tableWidth, isTableWidthDefined);
        }

        public int[] resolve(int specifiedWidth, int maxWidth) {
            assert (specifiedWidth <= maxWidth);
            int columnNumber = this.table.getColumnCount();
            int[] columns = new int[columnNumber];
            int columnWithWidth = 0;
            int colSum = 0;
            int j = 0;
            while (j < this.table.getColumnCount()) {
                IColumn column = this.table.getColumn(j);
                int columnWidth = TableLayout.this.getDimensionValue(column.getWidth(), TableLayout.this.tableWidth);
                if (columnWidth > 0) {
                    columns[j] = columnWidth;
                    colSum += columnWidth;
                    ++columnWithWidth;
                } else {
                    columns[j] = -1;
                }
                ++j;
            }
            if (columnWithWidth == columnNumber) {
                if (colSum <= maxWidth) {
                    return columns;
                }
                float delta = colSum - maxWidth;
                int i = 0;
                while (i < columnNumber) {
                    int n = i;
                    columns[n] = columns[n] - (int)(delta * (float)columns[i] / (float)colSum);
                    ++i;
                }
                return columns;
            }
            if (specifiedWidth == 0) {
                if (colSum < maxWidth) {
                    this.distributeLeftWidth(columns, (maxWidth - colSum) / (columnNumber - columnWithWidth));
                } else {
                    this.redistributeWidth(columns, colSum - maxWidth + (columnNumber - columnWithWidth) * maxWidth / columnNumber, maxWidth, colSum);
                }
            } else if (colSum < specifiedWidth) {
                this.distributeLeftWidth(columns, (specifiedWidth - colSum) / (columnNumber - columnWithWidth));
            } else if (colSum < maxWidth) {
                this.distributeLeftWidth(columns, (maxWidth - colSum) / (columnNumber - columnWithWidth));
            } else {
                this.redistributeWidth(columns, colSum - specifiedWidth + (columnNumber - columnWithWidth) * specifiedWidth / columnNumber, specifiedWidth, colSum);
            }
            return columns;
        }

        private void redistributeWidth(int[] cols, int delta, int sum, int currentSum) {
            int avaWidth = sum / cols.length;
            int i = 0;
            while (i < cols.length) {
                if (cols[i] < 0) {
                    cols[i] = avaWidth;
                } else {
                    int n = i;
                    cols[n] = cols[n] - (int)((float)cols[i] * (float)delta / (float)currentSum);
                }
                ++i;
            }
        }

        private void distributeLeftWidth(int[] cols, int avaWidth) {
            int i = 0;
            while (i < cols.length) {
                if (cols[i] < 0) {
                    cols[i] = avaWidth;
                }
                ++i;
            }
        }
    }

    class TableContext
    extends ContainerLayout.ContainerContext {
        TableAreaLayout layout;

        TableContext() {
        }
    }

    public class TableLayoutInfo {
        protected int columnNumber;
        protected int tableWidth;
        protected int[] colWidth = null;
        protected int[] xPositions = null;

        public TableLayoutInfo(int[] colWidth) {
            this.colWidth = colWidth;
            this.columnNumber = colWidth.length;
            this.xPositions = new int[this.columnNumber];
            this.tableWidth = 0;
            if (TableLayout.this.tableContent.isRTL()) {
                int parentMaxWidth = TableLayout.this.parent != null ? TableLayout.this.parent.getCurrentMaxContentWidth() : TableLayout.this.context.getMaxWidth();
                int i = 0;
                while (i < this.columnNumber) {
                    this.xPositions[i] = parentMaxWidth - this.tableWidth - colWidth[i];
                    this.tableWidth += colWidth[i];
                    ++i;
                }
                if (this.xPositions[this.columnNumber - 1] != 0) {
                    this.addDummyColumnForRTL(colWidth);
                }
            } else {
                int i = 0;
                while (i < this.columnNumber) {
                    this.xPositions[i] = this.tableWidth;
                    this.tableWidth += colWidth[i];
                    ++i;
                }
            }
        }

        public int getTableWidth() {
            return this.tableWidth;
        }

        public int getXPosition(int index) {
            return this.xPositions[index];
        }

        public int getCellWidth(int startColumn, int endColumn) {
            assert (startColumn < endColumn);
            assert (this.colWidth != null);
            int sum = 0;
            int i = startColumn;
            while (i < endColumn) {
                sum += this.colWidth[i];
                ++i;
            }
            return sum;
        }

        private void addDummyColumnForRTL(int[] colWidth) {
            this.colWidth = new int[this.columnNumber + 1];
            System.arraycopy(colWidth, 0, this.colWidth, 0, this.columnNumber);
            this.colWidth[this.columnNumber] = this.xPositions[this.columnNumber - 1];
            int[] newXPositions = new int[this.columnNumber + 1];
            System.arraycopy(this.xPositions, 0, newXPositions, 0, this.columnNumber);
            this.xPositions = newXPositions;
            this.xPositions[this.columnNumber] = 0;
            this.tableWidth += this.colWidth[this.columnNumber - 1];
            ++this.columnNumber;
        }
    }
}

