/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.birt.chart.util.SecurityUtil;

final class Palette {
    Vector<ColourEntry> colours = new Vector();
    int transparentIndex;
    private ColourEntry[][][] ces = new ColourEntry[256][][];

    Palette(BufferedImage[] images, Color[] extraColours, int size, boolean wantTransparent) {
        ColourEntry ce;
        int i;
        Hashtable<Integer, ColourEntry> tempHash = SecurityUtil.newHashtable();
        ColourEntry transparent = new ColourEntry();
        if (wantTransparent) {
            transparent.population = 0;
            transparent.argb = 0;
            this.colours.addElement(transparent);
            this.transparentIndex = 0;
        } else {
            this.transparentIndex = -1;
        }
        int imagePop = 0;
        int k = 0;
        while (k < images.length) {
            BufferedImage image = images[k];
            int w = image.getWidth();
            int h = image.getHeight();
            int[] row = new int[w];
            imagePop += h * w;
            int i2 = 0;
            while (i2 < h) {
                image.getRGB(0, i2, w, 1, row, 0, w);
                int j = 0;
                while (j < w) {
                    int col = row[j];
                    Integer x = col;
                    ColourEntry ce2 = (ColourEntry)tempHash.get(x);
                    if (ce2 == null) {
                        if (col >>> 24 != 255) {
                            ce2 = transparent;
                        } else {
                            ce2 = new ColourEntry();
                            ce2.argb = col;
                            ce2.population = 0;
                            this.colours.add(ce2);
                        }
                        tempHash.put(x, ce2);
                    }
                    ++ce2.population;
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
        if (extraColours != null) {
            i = 0;
            while (i < extraColours.length) {
                int col = extraColours[i].getRGB();
                Integer x = col;
                ColourEntry ce3 = (ColourEntry)tempHash.get(x);
                if (ce3 == null) {
                    if (col >>> 24 != 255) {
                        ce3 = transparent;
                    } else {
                        ce3 = new ColourEntry();
                        ce3.argb = col;
                        ce3.population = 0;
                        this.colours.add(ce3);
                    }
                    tempHash.put(x, ce3);
                }
                ce3.population += imagePop / extraColours.length;
                ++i;
            }
        }
        while (this.colours.size() > size) {
            int l = this.colours.size();
            ColourEntry minCe = this.colours.elementAt(1);
            int minPop = minCe.population;
            int minIndex = 1;
            int i3 = 2;
            while (i3 < l) {
                ColourEntry ce4 = this.colours.elementAt(i3);
                if (ce4.population < minPop) {
                    minPop = ce4.population;
                    minCe = ce4;
                    minIndex = i3;
                }
                ++i3;
            }
            int closeIndex = 1;
            if (minIndex == 1) {
                closeIndex = 2;
            }
            ColourEntry closeCe = this.colours.elementAt(closeIndex);
            int closeDiff = closeCe.compare(minCe);
            int i4 = closeIndex + 1;
            while (i4 < l) {
                ColourEntry ce5;
                int diff;
                if (i4 != minIndex && (diff = (ce5 = this.colours.elementAt(i4)).compare(minCe)) < closeDiff) {
                    closeDiff = diff;
                    closeCe = ce5;
                    closeIndex = i4;
                }
                ++i4;
            }
            int totalPop = closeCe.population + minCe.population;
            closeCe.setRed((closeCe.getRed() * closeCe.population + minCe.getRed() * minCe.population) / totalPop);
            closeCe.setGreen((closeCe.getGreen() * closeCe.population + minCe.getGreen() * minCe.population) / totalPop);
            closeCe.setBlue((closeCe.getBlue() * closeCe.population + minCe.getBlue() * minCe.population) / totalPop);
            closeCe.population = totalPop;
            this.colours.removeElementAt(minIndex);
        }
        if (wantTransparent) {
            int argb = -1;
            while ((ce = (ColourEntry)tempHash.get(argb)) != null) {
                --argb;
            }
            transparent.argb = argb & 0xFFFFFF;
        }
        i = 0;
        while (i < this.colours.size()) {
            ce = this.colours.elementAt(i);
            ce.index = i++;
            this.hashPut(ce.argb, ce);
        }
    }

    Palette(BufferedImage image, int size, boolean wantTransparent) {
        this(new BufferedImage[]{image}, null, size, wantTransparent);
    }

    int getRed(int index) {
        return this.colours.elementAt(index).getRed();
    }

    int getGreen(int index) {
        return this.colours.elementAt(index).getGreen();
    }

    int getBlue(int index) {
        return this.colours.elementAt(index).getBlue();
    }

    int getSize() {
        return this.colours.size();
    }

    int getTransparentIndex() {
        return this.transparentIndex;
    }

    byte[] getIndices(int[] argbs, int offset, int length) {
        byte[] ret = new byte[length];
        int index = offset;
        int l = 0;
        while (l < length) {
            ret[l] = (byte)this.getIndex(argbs[index]);
            ++index;
            ++l;
        }
        return ret;
    }

    int getIndex(int argb) {
        if (argb >>> 24 != 255 && this.transparentIndex != -1) {
            return this.transparentIndex;
        }
        ColourEntry ce = this.hashGet(argb);
        if (ce == null) {
            int minIndex = 0;
            int minDiff = Integer.MAX_VALUE;
            int i = 0;
            while (i < this.colours.size()) {
                ColourEntry entry;
                int diff;
                if (i != this.transparentIndex && (diff = (entry = this.colours.elementAt(i)).compare(argb)) < minDiff) {
                    minDiff = diff;
                    minIndex = i;
                }
                ++i;
            }
            ce = this.colours.elementAt(minIndex);
            this.hashPut(argb, ce);
        }
        return ce.index;
    }

    private ColourEntry hashGet(int argb) {
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        if (this.ces[red] == null || this.ces[red][green] == null) {
            return null;
        }
        return this.ces[red][green][blue];
    }

    private void hashPut(int argb, ColourEntry ce) {
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        if (this.ces[red] == null) {
            this.ces[red] = new ColourEntry[256][];
        }
        if (this.ces[red][green] == null) {
            this.ces[red][green] = new ColourEntry[256];
        }
        this.ces[red][green][blue] = ce;
    }

    private static class ColourEntry {
        int population;
        int argb;
        int index;

        private ColourEntry() {
        }

        int compare(ColourEntry ce) {
            int x = this.argb;
            int y = ce.argb;
            int ret = 0;
            int i = 0;
            while (i < 3) {
                int dist = (x & 0xFF) - (y & 0xFF);
                ret += dist * dist;
                x >>>= 8;
                y >>>= 8;
                ++i;
            }
            return ret;
        }

        int compare(int y) {
            int x = this.argb;
            int ret = 0;
            int i = 0;
            while (i < 3) {
                int dist = (x & 0xFF) - (y & 0xFF);
                ret += dist * dist;
                x >>>= 8;
                y >>>= 8;
                ++i;
            }
            return ret;
        }

        int getRed() {
            return this.argb >> 16 & 0xFF;
        }

        int getBlue() {
            return this.argb & 0xFF;
        }

        int getGreen() {
            return this.argb >> 8 & 0xFF;
        }

        void setRed(int red) {
            this.argb = this.argb & 0xFF00FFFF | red << 16;
        }

        void setGreen(int green) {
            this.argb = this.argb & 0xFFFF00FF | green << 8;
        }

        void setBlue(int blue) {
            this.argb = this.argb & 0xFFFFFF00 | blue;
        }
    }
}

