/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.impl;

import com.mongodb.BasicDBList;
import com.mongodb.DBCursor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.bson.Document;
import org.bson.types.BSONTimestamp;
import org.eclipse.birt.data.oda.mongodb.impl.MDbQuery;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSetMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.internal.impl.ResultDataHandler;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.impl.Blob;

public class MDbResultSet
implements IResultSet {
    private Iterator<Document> m_resultsIterator;
    private DBCursor m_mongoCursor;
    private MDbResultSetMetaData m_metadata;
    private QueryProperties m_queryProps;
    private Document m_currentRow;
    private int m_currentRowId = 0;
    private int m_maxRows = 0;
    private boolean m_wasNull = true;
    private ResultDataHandler m_dataHandler;
    private static Logger sm_logger = DriverUtil.getLogger();

    public MDbResultSet(Iterator<Document> resultsIterator, MDbResultSetMetaData rsmd, QueryProperties queryProps) {
        if (resultsIterator == null || rsmd == null) {
            throw new IllegalArgumentException("null DBCursor");
        }
        this.m_resultsIterator = resultsIterator;
        this.m_metadata = rsmd;
        QueryProperties queryProperties = this.m_queryProps = queryProps != null ? queryProps : QueryProperties.defaultValues();
        if (this.projectsFlattenedRows()) {
            this.m_dataHandler = new ResultDataHandler(this.m_metadata);
        }
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.m_metadata;
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
        if (this.m_maxRows > 0 && this.m_mongoCursor != null) {
            this.m_mongoCursor.limit(this.m_maxRows);
        }
    }

    protected int getMaxRows() {
        return this.m_maxRows >= 0 ? this.m_maxRows : 0;
    }

    private boolean hasNoMaxLimit() {
        return this.m_maxRows <= 0;
    }

    private boolean projectsFlattenedRows() {
        return this.m_queryProps.isAutoFlattening();
    }

    public boolean next() throws OdaException {
        if (this.projectsFlattenedRows() && this.m_dataHandler != null && this.m_dataHandler.next()) {
            return true;
        }
        this.m_currentRow = null;
        if (this.m_resultsIterator == null || !this.m_resultsIterator.hasNext()) {
            return false;
        }
        if (this.hasNoMaxLimit() || this.m_currentRowId < this.getMaxRows()) {
            this.m_currentRow = this.m_resultsIterator.next();
            ++this.m_currentRowId;
            return true;
        }
        return false;
    }

    public void close() throws OdaException {
        this.m_currentRow = null;
        this.m_currentRowId = 0;
        this.m_resultsIterator = null;
        if (this.m_mongoCursor != null) {
            this.m_mongoCursor.close();
            this.m_mongoCursor = null;
        }
    }

    public int getRow() throws OdaException {
        return this.m_currentRowId;
    }

    public String getString(int index) throws OdaException {
        return this.getString(this.findFieldName(index));
    }

    public String getString(String columnName) throws OdaException {
        List fromList;
        Object columnValue = this.getFieldValue(columnName);
        if (columnValue instanceof String) {
            return (String)columnValue;
        }
        if (columnValue instanceof List && !(columnValue instanceof BasicDBList) && !(fromList = (List)columnValue).isEmpty()) {
            BasicDBList fieldValuesList = new BasicDBList();
            int index = 0;
            while (index < fromList.size()) {
                fieldValuesList.put(index, fromList.get(index));
                ++index;
            }
            fieldValuesList.markAsPartialObject();
            return fieldValuesList.toString();
        }
        if (columnValue instanceof byte[]) {
            return MDbResultSet.convertToString((byte[])columnValue);
        }
        return columnValue != null ? columnValue.toString() : null;
    }

    public int getInt(int index) throws OdaException {
        return this.getInt(this.findFieldName(index));
    }

    public int getInt(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Integer.class)) instanceof List) {
            columnValue = this.getFirstFieldValue((List)columnValue, Integer.class, columnName);
        }
        if (columnValue instanceof Integer) {
            return (Integer)columnValue;
        }
        if (columnValue != null) {
            String errMsg = Messages.bind((String)Messages.mDbResultSet_cannotConvertFieldData, (Object[])new Object[]{columnName, columnValue, columnValue.getClass().getSimpleName(), "integer"});
            MDbResultSet.getLogger().severe(errMsg);
            throw new OdaException(errMsg);
        }
        return 0;
    }

    public double getDouble(int index) throws OdaException {
        return this.getDouble(this.findFieldName(index));
    }

    public double getDouble(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Double.class)) instanceof List) {
            columnValue = this.getFirstFieldValue((List)columnValue, Double.class, columnName);
        }
        if (columnValue instanceof Double) {
            return (Double)columnValue;
        }
        if (columnValue != null) {
            String errMsg = Messages.bind((String)Messages.mDbResultSet_cannotConvertFieldData, (Object[])new Object[]{columnName, columnValue, columnValue.getClass().getSimpleName(), "double"});
            MDbResultSet.getLogger().severe(errMsg);
            throw new OdaException(errMsg);
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        return this.getBigDecimal(this.findFieldName(index));
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, BigDecimal.class)) instanceof BigDecimal) {
            return (BigDecimal)columnValue;
        }
        if (columnValue instanceof List) {
            return (BigDecimal)this.getFirstFieldValue((List)columnValue, BigDecimal.class, columnName);
        }
        if (columnValue != null) {
            String errMsg = Messages.bind((String)Messages.mDbResultSet_cannotConvertFieldData, (Object[])new Object[]{columnName, columnValue, columnValue.getClass().getSimpleName(), "BigDecimal"});
            MDbResultSet.getLogger().severe(errMsg);
            throw new OdaException(errMsg);
        }
        return null;
    }

    public Date getDate(int index) throws OdaException {
        return this.getDate(this.findFieldName(index));
    }

    public Date getDate(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Date.class)) instanceof Date) {
            return (Date)columnValue;
        }
        if (columnValue instanceof List) {
            return (Date)this.getFirstFieldValue((List)columnValue, Date.class, columnName);
        }
        if (columnValue != null) {
            String errMsg = Messages.bind((String)Messages.mDbResultSet_cannotConvertFieldData, (Object[])new Object[]{columnName, columnValue, columnValue.getClass().getSimpleName(), "Date"});
            MDbResultSet.getLogger().severe(errMsg);
            throw new OdaException(errMsg);
        }
        return null;
    }

    public Time getTime(int index) throws OdaException {
        return this.getTime(this.findFieldName(index));
    }

    public Time getTime(String columnName) throws OdaException {
        Date dateValue = this.getDate(columnName);
        if (dateValue == null) {
            return null;
        }
        return new Time(dateValue.getTime());
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        return this.getTimestamp(this.findFieldName(index));
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Timestamp.class)) instanceof List) {
            columnValue = this.getFirstFieldValue((List)columnValue, Timestamp.class, columnName);
        }
        if (columnValue instanceof Timestamp) {
            return (Timestamp)columnValue;
        }
        if (columnValue != null) {
            String errMsg = Messages.bind((String)Messages.mDbResultSet_cannotConvertFieldData, (Object[])new Object[]{columnName, columnValue, columnValue.getClass().getSimpleName(), "Timestamp"});
            MDbResultSet.getLogger().severe(errMsg);
            throw new OdaException(errMsg);
        }
        return null;
    }

    public IBlob getBlob(int index) throws OdaException {
        return this.getBlob(this.findFieldName(index));
    }

    public IBlob getBlob(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, byte[].class)) instanceof List) {
            columnValue = this.getFirstFieldValue((List)columnValue, byte[].class, columnName);
        }
        if (columnValue instanceof byte[]) {
            return new Blob((byte[])columnValue);
        }
        if (columnValue != null) {
            String errMsg = Messages.bind((String)Messages.mDbResultSet_cannotConvertFieldData, (Object[])new Object[]{columnName, columnValue, columnValue.getClass().getSimpleName(), "Blob"});
            MDbResultSet.getLogger().severe(errMsg);
            throw new OdaException(errMsg);
        }
        return null;
    }

    public IClob getClob(int index) throws OdaException {
        throw MDbQuery.sm_unSupportedOpEx;
    }

    public IClob getClob(String columnName) throws OdaException {
        throw MDbQuery.sm_unSupportedOpEx;
    }

    public boolean getBoolean(int index) throws OdaException {
        return this.getBoolean(this.findFieldName(index));
    }

    public boolean getBoolean(String columnName) throws OdaException {
        Object columnValue = this.getFieldValue(columnName);
        if ((columnValue = MDbResultSet.tryConvertToDataType(columnValue, Boolean.class)) instanceof List) {
            columnValue = this.getFirstFieldValue((List)columnValue, Boolean.class, columnName);
        }
        if (columnValue instanceof Boolean) {
            return (Boolean)columnValue;
        }
        if (columnValue != null) {
            String errMsg = Messages.bind((String)Messages.mDbResultSet_cannotConvertFieldData, (Object[])new Object[]{columnName, columnValue, columnValue.getClass().getSimpleName(), "boolean"});
            MDbResultSet.getLogger().severe(errMsg);
            throw new OdaException(errMsg);
        }
        return false;
    }

    public Object getObject(int index) throws OdaException {
        return this.getObject(this.findFieldName(index));
    }

    public Object getObject(String columnName) throws OdaException {
        return this.getFieldValue(columnName);
    }

    public boolean wasNull() throws OdaException {
        return this.m_wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        return this.m_metadata.getColumnNumber(columnName);
    }

    private String findFieldName(int columnNumber) throws OdaException {
        return this.getMetaData().getColumnName(columnNumber);
    }

    private Object getFieldValue(String columnName) throws OdaException {
        Object fieldValue = this.doGetFieldValue(columnName);
        this.m_wasNull = fieldValue == null;
        return fieldValue;
    }

    private Object doGetFieldValue(String columnName) throws OdaException {
        if (!this.projectsFlattenedRows()) {
            MDbMetaData.FieldMetaData fieldMD = this.m_metadata.getColumnMetaData(columnName);
            return ResultDataHandler.fetchFieldValues(columnName, fieldMD, this.m_currentRow);
        }
        return this.m_dataHandler.getFieldValue(columnName, this.m_currentRow);
    }

    private Object getFirstFieldValue(List<?> valuesList, Class<?> valueDataType, String logColumnName) throws OdaException {
        Object value = MDbResultSet.getFirstElementFromList(valuesList, logColumnName);
        if (valueDataType.isInstance(value = MDbResultSet.tryConvertToDataType(value, valueDataType))) {
            return value;
        }
        if (value instanceof List) {
            return this.getFirstFieldValue((List)value, valueDataType, logColumnName);
        }
        if (value != null && MDbResultSet.getLogger().isLoggable(Level.FINE)) {
            MDbResultSet.getLogger().fine(Messages.bind((String)"Unable to get the '{0}' field's first array value ({1}) in {2} data type as a {3} value.", (Object[])new Object[]{logColumnName, value, value.getClass().getSimpleName(), valueDataType.getSimpleName()}));
        }
        this.m_wasNull = true;
        return null;
    }

    private static Object getFirstElementFromList(List<?> valuesList, String columnName) {
        if (valuesList.size() == 0) {
            return null;
        }
        Object firstValue = null;
        firstValue = valuesList instanceof BasicDBList ? ((BasicDBList)valuesList).get(String.valueOf(0)) : (Object)valuesList.get(0);
        MDbResultSet.logFetchedFirstElementFromArray(columnName, valuesList.size());
        return firstValue;
    }

    private static Object tryConvertToDataType(Object value, Class<?> toDataType) throws OdaException {
        if (value == null || toDataType.isInstance(value)) {
            return value;
        }
        try {
            if (value instanceof String) {
                String stringValue = (String)value;
                if (toDataType == Integer.class) {
                    return Integer.valueOf(stringValue);
                }
                if (toDataType == Double.class) {
                    return Double.valueOf(stringValue);
                }
                if (toDataType == BigDecimal.class) {
                    return new BigDecimal(stringValue);
                }
                if (toDataType == Boolean.class) {
                    return Boolean.valueOf(stringValue);
                }
                if (toDataType == Date.class) {
                    return Date.valueOf(stringValue);
                }
                if (toDataType == Timestamp.class) {
                    return Timestamp.valueOf(stringValue);
                }
                if (toDataType == byte[].class) {
                    return MDbResultSet.tryConvertToBytes(stringValue);
                }
            }
            if (value instanceof java.util.Date) {
                long msTime = ((java.util.Date)value).getTime();
                if (toDataType == Date.class) {
                    return new Date(msTime);
                }
                if (toDataType == Timestamp.class) {
                    return new Timestamp(msTime);
                }
            }
            if (value instanceof BSONTimestamp) {
                long msTime = (long)((BSONTimestamp)value).getTime() * 1000L;
                if (toDataType == Date.class) {
                    return new Date(msTime);
                }
                if (toDataType == Timestamp.class) {
                    return new Timestamp(msTime);
                }
            }
            if (toDataType == Integer.class) {
                return MDbResultSet.tryConvertToInteger(value);
            }
            if (toDataType == Double.class) {
                return MDbResultSet.tryConvertToDouble(value);
            }
            if (toDataType == Boolean.class) {
                return MDbResultSet.tryConvertToBoolean(value);
            }
        }
        catch (Exception ex) {
            String errMsg = Messages.bind((String)Messages.mDbResultSet_cannotConvertFieldData, (Object[])new Object[]{"", value, value.getClass().getSimpleName(), toDataType.getSimpleName()});
            MDbResultSet.getLogger().severe(errMsg);
            OdaException odaEx = new OdaException(errMsg);
            odaEx.initCause((Throwable)ex);
            throw odaEx;
        }
        return value;
    }

    private static Object tryConvertToInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        return value;
    }

    private static Object tryConvertToDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Double.valueOf(1.0) : Double.valueOf(0.0);
        }
        return value;
    }

    private static Object tryConvertToBoolean(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return value;
    }

    private static Object tryConvertToBytes(String stringValue) {
        try {
            return DatatypeConverter.parseBase64Binary((String)stringValue);
        }
        catch (Exception ex) {
            if (MDbResultSet.getLogger().isLoggable(Level.FINE)) {
                MDbResultSet.getLogger().fine(Messages.bind((String)"Unable to convert the String field value ({0}) to a bytes[] value.\n Cause: {1}", (Object)stringValue, (Object)ex.getMessage()));
            }
            return stringValue;
        }
    }

    private static String convertToString(byte[] value) {
        try {
            return DatatypeConverter.printBase64Binary((byte[])value);
        }
        catch (Exception ex) {
            return new String(Base64.encodeBase64(value));
        }
    }

    private static void logFetchedFirstElementFromArray(String columnName, int arraySize) {
        if (arraySize > 1 && MDbResultSet.getLogger().isLoggable(Level.FINER)) {
            MDbResultSet.getLogger().finer(Messages.bind((String)"Fetching only the first value out of {0} for the field {1}.", (Object)arraySize, (Object)columnName));
        }
    }

    private static Logger getLogger() {
        return sm_logger;
    }
}

