/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx.util;

import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ooxml.util.OOXmlUtil;

public class PPTXUtil {
    public static int convertToPointer(int milliPointerValue) {
        return milliPointerValue / 1000;
    }

    public static int convertToEnums(double milliPointerValue) {
        return (int)OOXmlUtil.convertPointerToEmus(milliPointerValue / 1000.0);
    }

    public static String parseStyle(int style) {
        switch (style) {
            case 22: {
                return "dash";
            }
            case 20: {
                return "dot";
            }
        }
        return "solid";
    }

    public static int pixelToEmu(int pixels, int dpi) {
        if (dpi <= 0) {
            dpi = 96;
        }
        return pixels * (int)(914400.0f / (float)dpi);
    }

    public static float parsePercentageOffset(int contianermeasure, int contianersubmeasure) {
        float diffpercentage = (float)(contianermeasure - contianersubmeasure) / (float)contianermeasure;
        return diffpercentage * 100000.0f;
    }

    public static int convertCssToEnum(String cssDimension) {
        if (cssDimension == null || "0".equals(cssDimension)) {
            return 0;
        }
        DimensionType dimensionType = DimensionType.parserUnit(cssDimension);
        return dimensionType != null ? PPTXUtil.convertToEnums(dimensionType.convertTo("pt") * 1000.0) : 0;
    }
}

