/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.script.IMeasure;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.simpleapi.IFilterConditionElement;
import org.eclipse.birt.report.model.api.simpleapi.ISimpleElementFactory;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;

public class MeasureImpl
implements IMeasure {
    private MeasureHandle mh;
    private MeasureViewHandle mv;

    public MeasureImpl(MeasureViewHandle mv) {
        this.mv = mv;
        if (mv != null) {
            this.mh = mv.getCubeMeasure();
        }
    }

    @Override
    public String getFunctionName() {
        if (this.mh != null) {
            return this.mh.getFunction();
        }
        return null;
    }

    @Override
    public String getMeasureExpression() {
        if (this.mh != null) {
            return this.mh.getMeasureExpression();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.mh != null) {
            return this.mh.getName();
        }
        if (this.mv != null) {
            return this.mv.getCubeMeasureName();
        }
        return null;
    }

    @Override
    public void addFilterCondition(IFilterConditionElement filter) throws SemanticException {
        if (this.mh != null) {
            FilterConditionElementHandle fceh = this.mv.getModelHandle().getElementFactory().newFilterConditionElement();
            fceh.setExpr(filter.getExpr());
            fceh.setFilterTarget(filter.getFilterTarget());
            fceh.setOperator(filter.getOperator());
            fceh.setValue1(filter.getValue1List());
            fceh.setValue2(filter.getValue2());
            fceh.setOptional(filter.isOptional());
            this.mv.getModelHandle().add("filter", fceh);
        }
    }

    @Override
    public List<IFilterConditionElement> getFilterConditions() {
        if (this.mh != null) {
            ArrayList<IFilterConditionElement> filters = new ArrayList<IFilterConditionElement>();
            ISimpleElementFactory factory = SimpleElementFactory.getInstance();
            Iterator itr = this.mv.filtersIterator();
            while (itr.hasNext()) {
                FilterConditionElementHandle feh = (FilterConditionElementHandle)itr.next();
                filters.add((IFilterConditionElement)factory.getElement(feh));
            }
            if (filters.size() > 0) {
                return filters;
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void removeAllFilterConditions() throws SemanticException {
        if (this.mh != null) {
            this.mv.getModelHandle().setProperty("filter", null);
        }
    }

    @Override
    public void removeFilterCondition(IFilterConditionElement filter) throws SemanticException {
        if (this.mh == null || filter == null) {
            return;
        }
        FilterConditionElementHandle handle = null;
        Iterator itr = this.mv.filtersIterator();
        while (itr.hasNext()) {
            FilterConditionElementHandle feh = (FilterConditionElementHandle)itr.next();
            if (!this.equalFilter(feh, filter)) continue;
            handle = feh;
            break;
        }
        if (handle != null) {
            this.mv.getModelHandle().drop("filter", handle);
        }
    }

    private boolean equalFilter(FilterConditionElementHandle fceh, IFilterConditionElement ifce) {
        List val1 = fceh.getValue1List();
        List val2 = ifce.getValue1List();
        if (val1 == null || val1.isEmpty() ? val2 != null && !val2.isEmpty() : !val1.equals(val2)) {
            return false;
        }
        return fceh.isOptional() == ifce.isOptional() && this.equalString(fceh.getExpr(), ifce.getExpr()) && this.equalString(fceh.getFilterTarget(), ifce.getFilterTarget()) && this.equalString(fceh.getOperator(), ifce.getOperator()) && this.equalString(fceh.getValue2(), ifce.getValue2());
    }

    private boolean equalString(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }
}

