/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.bson.AbstractBsonWriter;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;

public class JsonWriter
extends AbstractBsonWriter {
    private final Writer writer;
    private final JsonWriterSettings settings;

    public JsonWriter(Writer writer) {
        this(writer, new JsonWriterSettings());
    }

    public JsonWriter(Writer writer, JsonWriterSettings settings) {
        super(settings);
        this.settings = settings;
        this.writer = writer;
        this.setContext(new Context(null, BsonContextType.TOP_LEVEL, ""));
    }

    public Writer getWriter() {
        return this.writer;
    }

    @Override
    protected Context getContext() {
        return (Context)super.getContext();
    }

    @Override
    protected void doWriteStartDocument() {
        try {
            if (this.getState() == AbstractBsonWriter.State.VALUE || this.getState() == AbstractBsonWriter.State.SCOPE_DOCUMENT) {
                this.writeNameHelper(this.getName());
            }
            this.writer.write("{");
            BsonContextType contextType = this.getState() == AbstractBsonWriter.State.SCOPE_DOCUMENT ? BsonContextType.SCOPE_DOCUMENT : BsonContextType.DOCUMENT;
            this.setContext(new Context(this.getContext(), contextType, this.settings.getIndentCharacters()));
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    protected void doWriteEndDocument() {
        try {
            if (this.settings.isIndent() && this.getContext().hasElements) {
                this.writer.write(this.settings.getNewLineCharacters());
                if (this.getContext().getParentContext() != null) {
                    this.writer.write(this.getContext().getParentContext().indentation);
                }
                this.writer.write("}");
            } else {
                this.writer.write(" }");
            }
            if (this.getContext().getContextType() == BsonContextType.SCOPE_DOCUMENT) {
                this.setContext(this.getContext().getParentContext());
                this.writeEndDocument();
            } else {
                this.setContext(this.getContext().getParentContext());
            }
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    protected void doWriteStartArray() {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write("[");
            this.setContext(new Context(this.getContext(), BsonContextType.ARRAY, this.settings.getIndentCharacters()));
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    protected void doWriteEndArray() {
        try {
            this.writer.write("]");
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
        this.setContext(this.getContext().getParentContext());
    }

    @Override
    protected void doWriteBinaryData(BsonBinary binary) {
        try {
            switch (this.settings.getOutputMode()) {
                case SHELL: {
                    this.writeNameHelper(this.getName());
                    this.writer.write(String.format("new BinData(%s, \"%s\")", Integer.toString(binary.getType() & 0xFF), DatatypeConverter.printBase64Binary((byte[])binary.getData())));
                    break;
                }
                default: {
                    this.writeStartDocument();
                    this.writeString("$binary", DatatypeConverter.printBase64Binary((byte[])binary.getData()));
                    this.writeString("$type", Integer.toHexString(binary.getType() & 0xFF));
                    this.writeEndDocument();
                    break;
                }
            }
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    public void doWriteBoolean(boolean value) {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(value ? "true" : "false");
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    protected void doWriteDateTime(long value) {
        try {
            switch (this.settings.getOutputMode()) {
                case STRICT: {
                    this.writeStartDocument();
                    this.writeNameHelper("$date");
                    this.writer.write(Long.toString(value));
                    this.writeEndDocument();
                    break;
                }
                case SHELL: {
                    this.writeNameHelper(this.getName());
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    if (value >= -59014396800000L && value <= 253399536000000L) {
                        this.writer.write(String.format("ISODate(\"%s\")", dateFormat.format(new Date(value))));
                        break;
                    }
                    this.writer.write(String.format("new Date(%d)", value));
                    break;
                }
                default: {
                    throw new BSONException("Unexpected JSONMode.");
                }
            }
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    protected void doWriteDBPointer(BsonDbPointer value) {
        this.writeStartDocument();
        this.writeString("$ref", value.getNamespace());
        this.writeObjectId("$id", value.getId());
        this.writeEndDocument();
    }

    @Override
    protected void doWriteDouble(double value) {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(Double.toString(value));
            this.setState(this.getNextState());
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    protected void doWriteInt32(int value) {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write(Integer.toString(value));
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    protected void doWriteInt64(long value) {
        try {
            switch (this.settings.getOutputMode()) {
                case STRICT: {
                    this.writeStartDocument();
                    this.writeNameHelper("$numberLong");
                    this.writer.write(String.format("\"%d\"", value));
                    this.writeEndDocument();
                    break;
                }
                case SHELL: {
                    this.writeNameHelper(this.getName());
                    if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                        this.writer.write(String.format("NumberLong(%d)", value));
                        break;
                    }
                    this.writer.write(String.format("NumberLong(\"%d\")", value));
                    break;
                }
                default: {
                    this.writeNameHelper(this.getName());
                    this.writer.write(Long.toString(value));
                    break;
                }
            }
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    protected void doWriteJavaScript(String code) {
        this.writeStartDocument();
        this.writeString("$code", code);
        this.writeEndDocument();
    }

    @Override
    protected void doWriteJavaScriptWithScope(String code) {
        this.writeStartDocument();
        this.writeString("$code", code);
        this.writeName("$scope");
    }

    @Override
    protected void doWriteMaxKey() {
        this.writeStartDocument();
        this.writeInt32("$maxKey", 1);
        this.writeEndDocument();
    }

    @Override
    protected void doWriteMinKey() {
        this.writeStartDocument();
        this.writeInt32("$minKey", 1);
        this.writeEndDocument();
    }

    @Override
    public void doWriteNull() {
        try {
            this.writeNameHelper(this.getName());
            this.writer.write("null");
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    public void doWriteObjectId(ObjectId objectId) {
        try {
            switch (this.settings.getOutputMode()) {
                case STRICT: {
                    this.writeStartDocument();
                    this.writeString("$oid", objectId.toString());
                    this.writeEndDocument();
                    break;
                }
                case SHELL: {
                    this.writeNameHelper(this.getName());
                    this.writer.write(String.format("ObjectId(\"%s\")", objectId.toString()));
                    break;
                }
                default: {
                    throw new BSONException("Unknown output mode" + (Object)((Object)this.settings.getOutputMode()));
                }
            }
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    public void doWriteRegularExpression(BsonRegularExpression regularExpression) {
        try {
            switch (this.settings.getOutputMode()) {
                case STRICT: {
                    this.writeStartDocument();
                    this.writeString("$regex", regularExpression.getPattern());
                    this.writeString("$options", regularExpression.getOptions());
                    this.writeEndDocument();
                    break;
                }
                case SHELL: {
                    this.writeNameHelper(this.getName());
                    this.writer.write("/");
                    String escaped = regularExpression.getPattern().equals("") ? "(?:)" : regularExpression.getPattern().replace("/", "\\/");
                    this.writer.write(escaped);
                    this.writer.write("/");
                    this.writer.write(regularExpression.getOptions());
                    break;
                }
                default: {
                    throw new BSONException("Unknown output mode" + (Object)((Object)this.settings.getOutputMode()));
                }
            }
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    public void doWriteString(String value) {
        try {
            this.writeNameHelper(this.getName());
            this.writeStringHelper(value);
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    public void doWriteSymbol(String value) {
        this.writeStartDocument();
        this.writeString("$symbol", value);
        this.writeEndDocument();
    }

    @Override
    public void doWriteTimestamp(BsonTimestamp value) {
        try {
            switch (this.settings.getOutputMode()) {
                case STRICT: {
                    this.writeStartDocument();
                    this.writeStartDocument("$timestamp");
                    this.writeInt32("t", value.getTime());
                    this.writeInt32("i", value.getInc());
                    this.writeEndDocument();
                    this.writeEndDocument();
                    break;
                }
                case SHELL: {
                    this.writeNameHelper(this.getName());
                    this.writer.write(String.format("Timestamp(%d, %d)", value.getTime(), value.getInc()));
                    break;
                }
                default: {
                    throw new BSONException("Unknown output mode" + (Object)((Object)this.settings.getOutputMode()));
                }
            }
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    public void doWriteUndefined() {
        try {
            switch (this.settings.getOutputMode()) {
                case STRICT: {
                    this.writeStartDocument();
                    this.writeBoolean("$undefined", true);
                    this.writeEndDocument();
                    break;
                }
                case SHELL: {
                    this.writeNameHelper(this.getName());
                    this.writer.write("undefined");
                    break;
                }
                default: {
                    throw new BSONException("Unknown output mode" + (Object)((Object)this.settings.getOutputMode()));
                }
            }
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            this.throwBSONException(e);
        }
    }

    private void writeNameHelper(String name) throws IOException {
        switch (this.getContext().getContextType()) {
            case ARRAY: {
                if (!this.getContext().hasElements) break;
                this.writer.write(", ");
                break;
            }
            case DOCUMENT: 
            case SCOPE_DOCUMENT: {
                if (this.getContext().hasElements) {
                    this.writer.write(",");
                }
                if (this.settings.isIndent()) {
                    this.writer.write(this.settings.getNewLineCharacters());
                    this.writer.write(this.getContext().indentation);
                } else {
                    this.writer.write(" ");
                }
                this.writeStringHelper(name);
                this.writer.write(" : ");
                break;
            }
            case TOP_LEVEL: {
                break;
            }
            default: {
                throw new BSONException("Invalid contextType.");
            }
        }
        this.getContext().hasElements = true;
    }

    private void writeStringHelper(String str) throws IOException {
        this.writer.write(34);
        block12: for (char c : str.toCharArray()) {
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block12;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block12;
                }
                case '\b': {
                    this.writer.write("\\b");
                    continue block12;
                }
                case '\f': {
                    this.writer.write("\\f");
                    continue block12;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block12;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block12;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block12;
                }
                default: {
                    switch (Character.getType(c)) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            this.writer.write(c);
                            continue block12;
                        }
                    }
                    this.writer.write("\\u");
                    this.writer.write(Integer.toHexString((c & 0xF000) >> 12));
                    this.writer.write(Integer.toHexString((c & 0xF00) >> 8));
                    this.writer.write(Integer.toHexString((c & 0xF0) >> 4));
                    this.writer.write(Integer.toHexString(c & 0xF));
                }
            }
        }
        this.writer.write(34);
    }

    private void throwBSONException(IOException e) {
        throw new BSONException("Wrapping IOException", e);
    }

    public class Context
    extends AbstractBsonWriter.Context {
        private final String indentation;
        private boolean hasElements;

        public Context(Context parentContext, BsonContextType contextType, String indentChars) {
            super(JsonWriter.this, parentContext, contextType);
            this.indentation = parentContext == null ? indentChars : parentContext.indentation + indentChars;
        }

        @Override
        public Context getParentContext() {
            return (Context)super.getParentContext();
        }
    }
}

