/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.awt.Color;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.XMLEncodeUtil;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.IExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.NumberFormatValue;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ExcelXmlWriter
implements IExcelWriter {
    public static final int rightToLeftisTrue = 1;
    private final XMLWriterXLS writer = new XMLWriterXLS();
    private String pageHeader;
    private String pageFooter;
    protected static Logger logger = Logger.getLogger(ExcelXmlWriter.class.getName());
    ExcelContext context = null;

    public XMLWriterXLS getWriter() {
        return this.writer;
    }

    public ExcelXmlWriter(ExcelContext context) {
        this("UTF-8", context);
    }

    public ExcelXmlWriter(OutputStream out) {
        this.writer.open(out, "UTF-8");
    }

    public ExcelXmlWriter(OutputStream out, ExcelContext context) {
        this.context = context;
        this.writer.open(out, "UTF-8");
    }

    public ExcelXmlWriter(String encoding, ExcelContext context) {
        this(context.getOutputSteam(), context);
    }

    private void writeDocumentProperties(IReportContent reportContent) {
        if (reportContent == null) {
            return;
        }
        ReportDesignHandle reportDesign = reportContent.getDesign().getReportDesign();
        this.writer.openTag("DocumentProperties");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:office");
        this.writer.openTag("Author");
        this.writer.text(reportDesign.getStringProperty("author"));
        this.writer.closeTag("Author");
        this.writer.openTag("Title");
        this.writer.text(reportContent.getTitle());
        this.writer.closeTag("Title");
        this.writer.openTag("Description");
        this.writer.text(reportDesign.getComments());
        this.writer.closeTag("Description");
        this.writer.openTag("Subject");
        this.writer.text(reportDesign.getSubject());
        this.writer.closeTag("Subject");
        this.writer.closeTag("DocumentProperties");
    }

    private String format(Object value, int dataType) {
        if (value == null) {
            return "";
        }
        if (dataType == 0) {
            return ExcelUtil.formatDate(value, this.context.getTimeZone());
        }
        return ExcelUtil.format(value, dataType);
    }

    private void writeText(int type, Object value, StyleEntry style) {
        String txt = this.format(value, type);
        this.writer.openTag("Data");
        if (type == 1) {
            if (ExcelUtil.isNaN(value) || ExcelUtil.isBigNumber(value) || ExcelUtil.isInfinity(value)) {
                this.writer.attribute("ss:Type", "String");
            } else {
                this.writer.attribute("ss:Type", "Number");
            }
        } else if (type == 0) {
            this.writer.attribute("ss:Type", "DateTime");
        } else {
            this.writer.attribute("ss:Type", "String");
        }
        if (style != null) {
            String textTransform = (String)style.getProperty(26);
            if ("capitalize".equalsIgnoreCase(textTransform)) {
                txt = ExcelUtil.capitalize(txt);
            } else if ("uppercase".equalsIgnoreCase(textTransform)) {
                txt = txt.toUpperCase();
            } else if ("lowercase".equalsIgnoreCase(textTransform)) {
                txt = txt.toLowerCase();
            }
        }
        this.writer.text(ExcelUtil.truncateCellText(txt));
        this.writer.closeTag("Data");
    }

    @Override
    public void startRow(double rowHeight) {
        this.writer.openTag("Row");
        if (rowHeight > 0.0) {
            this.writer.attribute("ss:AutoFitHeight", 0);
            this.writer.attribute("ss:Height", rowHeight);
        } else {
            this.writer.attribute("ss:AutoFitHeight", 1);
        }
    }

    @Override
    public void endRow() {
        this.writer.closeTag("Row");
    }

    private void startCell(int cellIndex, int colspan, int rowspan, int styleId, HyperlinkDef hyperLink, BookmarkDef linkedBookmark) {
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", cellIndex);
        if (styleId > 0) {
            this.writer.attribute("ss:StyleID", styleId);
        }
        if (hyperLink != null) {
            String urlAddress = hyperLink.getUrl();
            if (hyperLink.getType() == 2) {
                if (linkedBookmark != null) {
                    urlAddress = "#" + linkedBookmark.getValidName();
                } else {
                    logger.log(Level.WARNING, "The bookmark: {" + urlAddress + "} is not defined!");
                }
            }
            if (urlAddress != null && urlAddress.length() >= 255) {
                logger.log(Level.WARNING, "The URL: {" + urlAddress + "} is too long!");
                urlAddress = urlAddress.substring(0, 254);
            }
            this.writer.attribute("ss:HRef", urlAddress);
            if (hyperLink.getToolTip() != null) {
                this.writer.attribute("x:HRefScreenTip", hyperLink.getToolTip());
            }
        }
        if (colspan > 0) {
            this.writer.attribute("ss:MergeAcross", colspan);
        }
        if (rowspan > 0) {
            this.writer.attribute("ss:MergeDown", rowspan);
        }
    }

    @Override
    public void outputData(String sheet, SheetData sheetData, StyleEntry style, int column, int colSpan) {
        this.outputData(sheetData, style, column, colSpan);
    }

    @Override
    public void outputData(SheetData sheetData, StyleEntry style, int column, int colSpan) {
        int rowSpan = sheetData.getRowSpan();
        int styleId = sheetData.getStyleId();
        int type = sheetData.getDataType();
        if (type == 5) {
            this.outputData(2, null, style, column, colSpan, sheetData.getRowSpan(), sheetData.getStyleId(), null, null);
        } else {
            Data d = (Data)sheetData;
            Object value = d.getValue();
            HyperlinkDef hyperLink = d.getHyperlinkDef();
            BookmarkDef linkedBookmark = d.getLinkedBookmark();
            this.outputData(type, value, style, column, colSpan, rowSpan, styleId, hyperLink, linkedBookmark);
        }
    }

    @Override
    public void outputData(int col, int row, int type, Object value) {
        this.outputData(type, value, null, col, 0, 0, -1, null, null);
    }

    private void outputData(int type, Object value, StyleEntry style, int column, int colSpan, int rowSpan, int styleId, HyperlinkDef hyperLink, BookmarkDef linkedBookmark) {
        this.startCell(column, colSpan, rowSpan, styleId, hyperLink, linkedBookmark);
        if (value != null) {
            this.writeText(type, value, style);
        }
        this.endCell();
    }

    protected void writeComments(HyperlinkDef linkDef) {
        String toolTip = linkDef.getToolTip();
        this.writer.openTag("Comment");
        this.writer.openTag("ss:Data");
        this.writer.attribute("xmlns", "http://www.w3.org/TR/REC-html40");
        this.writer.openTag("Font");
        this.writer.text(toolTip);
        this.writer.closeTag("Font");
        this.writer.closeTag("ss:Data");
        this.writer.closeTag("Comment");
    }

    private void endCell() {
        this.writer.closeTag("Cell");
    }

    private void writeAlignment(String horizontal, String vertical, float indent, String direction, boolean wrapText) {
        this.writer.openTag("Alignment");
        if (this.isValid(horizontal)) {
            this.writer.attribute("ss:Horizontal", horizontal);
        }
        if (this.isValid(vertical)) {
            this.writer.attribute("ss:Vertical", vertical);
        }
        if (indent != 0.0f) {
            this.writer.attribute("ss:Indent", indent);
        }
        if (this.isValid(direction)) {
            if ("rtl".equals(direction)) {
                this.writer.attribute("ss:ReadingOrder", "RightToLeft");
            } else {
                this.writer.attribute("ss:ReadingOrder", "LeftToRight");
            }
        }
        if (wrapText) {
            this.writer.attribute("ss:WrapText", "1");
        }
        this.writer.closeTag("Alignment");
    }

    private void writeBorder(String position, String lineStyle, Integer weight, Color color) {
        this.writer.openTag("Border");
        this.writer.attribute("ss:Position", position);
        if (this.isValid(lineStyle)) {
            this.writer.attribute("ss:LineStyle", lineStyle);
        }
        if (weight != null && weight > 0) {
            this.writer.attribute("ss:Weight", weight);
        }
        if (color != null) {
            this.writer.attribute("ss:Color", this.toString(color));
        }
        this.writer.closeTag("Border");
    }

    private void writeFont(String fontName, Float size, Boolean bold, Boolean italic, Boolean strikeThrough, Boolean underline, Color color) {
        this.writer.openTag("Font");
        if (this.isValid(fontName)) {
            fontName = this.getFirstFont(fontName);
            this.writer.attribute("ss:FontName", fontName);
        }
        if (size != null) {
            this.writer.attribute("ss:Size", size);
        }
        if (bold != null && bold.booleanValue()) {
            this.writer.attribute("ss:Bold", 1);
        }
        if (italic != null && italic.booleanValue()) {
            this.writer.attribute("ss:Italic", 1);
        }
        if (strikeThrough != null && strikeThrough.booleanValue()) {
            this.writer.attribute("ss:StrikeThrough", 1);
        }
        if (underline != null && underline.booleanValue()) {
            this.writer.attribute("ss:Underline", "Single");
        }
        if (color != null) {
            this.writer.attribute("ss:Color", this.toString(color));
        }
        this.writer.closeTag("Font");
    }

    private void writeBackGroudColor(StyleEntry style) {
        Color bgColor = (Color)style.getProperty(6);
        if (bgColor != null) {
            this.writer.openTag("Interior");
            this.writer.attribute("ss:Color", this.toString(bgColor));
            this.writer.attribute("ss:Pattern", "Solid");
            this.writer.closeTag("Interior");
        }
    }

    private boolean isValid(String value) {
        return !StyleEntry.isNull(value);
    }

    private String getFirstFont(String fontName) {
        int firstSeperatorIndex = fontName.indexOf(44);
        if (firstSeperatorIndex != -1) {
            return fontName.substring(0, firstSeperatorIndex);
        }
        return fontName;
    }

    private void declareStyle(StyleEntry style, int id) {
        boolean wrapText = this.context.getWrappingText();
        String whiteSpace = (String)style.getProperty(29);
        if ("nowrap".equals(whiteSpace)) {
            wrapText = false;
        }
        this.writer.openTag("Style");
        this.writer.attribute("ss:ID", id);
        if (style.isHyperlink()) {
            this.writer.attribute("ss:Parent", "HyperlinkId");
        }
        if (id >= 20) {
            String direction = (String)style.getProperty(28);
            String horizontalAlign = (String)style.getProperty(8);
            String verticalAlign = (String)style.getProperty(9);
            float indent = ExcelUtil.convertTextIndentToEM((FloatValue)style.getProperty(27), ((Float)style.getProperty(1)).floatValue());
            this.writeAlignment(horizontalAlign, verticalAlign, indent, direction, wrapText);
            this.writer.openTag("Borders");
            Color bottomColor = (Color)style.getProperty(10);
            String bottomLineStyle = (String)style.getProperty(11);
            Integer bottomWeight = (Integer)style.getProperty(12);
            this.writeBorder("Bottom", bottomLineStyle, bottomWeight, bottomColor);
            Color topColor = (Color)style.getProperty(13);
            String topLineStyle = (String)style.getProperty(14);
            Integer topWeight = (Integer)style.getProperty(15);
            this.writeBorder("Top", topLineStyle, topWeight, topColor);
            Color leftColor = (Color)style.getProperty(16);
            String leftLineStyle = (String)style.getProperty(17);
            Integer leftWeight = (Integer)style.getProperty(18);
            this.writeBorder("Left", leftLineStyle, leftWeight, leftColor);
            Color rightColor = (Color)style.getProperty(19);
            String rightLineStyle = (String)style.getProperty(20);
            Integer rightWeight = (Integer)style.getProperty(21);
            this.writeBorder("Right", rightLineStyle, rightWeight, rightColor);
            Color diagonalColor = (Color)style.getProperty(30);
            String diagonalStyle = (String)style.getProperty(31);
            Integer diagonalWidth = (Integer)style.getProperty(32);
            this.writeBorder("DiagonalLeft", diagonalStyle, diagonalWidth, diagonalColor);
            this.writer.closeTag("Borders");
            String fontName = (String)style.getProperty(0);
            Float size = (Float)style.getProperty(1);
            Boolean fontStyle = (Boolean)style.getProperty(2);
            Boolean fontWeight = (Boolean)style.getProperty(3);
            Boolean strikeThrough = (Boolean)style.getProperty(4);
            Boolean underline = (Boolean)style.getProperty(5);
            Color color = (Color)style.getProperty(7);
            this.writeFont(fontName, size, fontWeight, fontStyle, strikeThrough, underline, color);
            this.writeBackGroudColor(style);
        }
        this.writeDataFormat(style);
        this.writer.closeTag("Style");
    }

    private String toString(Color color) {
        if (color == null) {
            return null;
        }
        return "#" + ExcelXmlWriter.toHexString(color.getRed()) + ExcelXmlWriter.toHexString(color.getGreen()) + ExcelXmlWriter.toHexString(color.getBlue());
    }

    private static String toHexString(int c) {
        String result = Integer.toHexString(c);
        if (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    private void writeDataFormat(StyleEntry style) {
        NumberFormatValue numberFormat;
        String format;
        Integer type = (Integer)style.getProperty(25);
        if (type == null) {
            return;
        }
        if (type == 0 && style.getProperty(22) != null) {
            this.writer.openTag("NumberFormat");
            this.writer.attribute("ss:Format", style.getProperty(22));
            this.writer.closeTag("NumberFormat");
        } else if (type == 1 && style.getProperty(23) != null && (format = (numberFormat = (NumberFormatValue)style.getProperty(23)).getFormat()) != null) {
            this.writer.openTag("NumberFormat");
            this.writer.attribute("ss:Format", format);
            this.writer.closeTag("NumberFormat");
        }
    }

    private void writeDeclarations() {
        this.writer.startWriter();
        this.writer.println();
        this.writer.println("<?mso-application progid=\"Excel.Sheet\"?>");
        this.writer.openTag("Workbook");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        this.writer.attribute("xmlns:x", "urn:schemas-microsoft-com:office:excel");
        this.writer.attribute("xmlns:ss", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:html", "http://www.w3.org/TR/REC-html40");
    }

    private void declareStyles(Map<StyleEntry, Integer> style2id) {
        this.writer.openTag("Styles");
        this.declareHyperlinkStyle();
        Set<Map.Entry<StyleEntry, Integer>> entrySet = style2id.entrySet();
        for (Map.Entry<StyleEntry, Integer> entry : entrySet) {
            this.declareStyle(entry.getKey(), entry.getValue());
        }
        this.writer.closeTag("Styles");
    }

    private void declareHyperlinkStyle() {
        this.writer.openTag("Style");
        this.writer.attribute("ss:ID", "HyperlinkId");
        this.writer.attribute("ss:Name", "Hyperlink");
        this.writer.openTag("Font");
        this.writer.attribute("ss:Color", "#0000ff");
        this.writer.closeTag("Font");
        this.writer.closeTag("Style");
    }

    private void defineName(String name, String refer) {
        this.writer.openTag("NamedRange");
        this.writer.attribute("ss:Name", name);
        this.writer.attribute("ss:RefersTo", refer);
        this.writer.closeTag("NamedRange");
    }

    @Override
    public void startSheet(String name) {
        this.startSheet(name, null);
    }

    public void startSheet(String name, double[] coordinates) {
        this.writer.openTag("Worksheet");
        this.writer.attribute("ss:Name", name);
        if (this.context.isRTL()) {
            this.writer.attribute("ss:RightToLeft", 1);
        }
        this.outputColumns(coordinates);
    }

    public void closeSheet() {
        this.writer.closeTag("Worksheet");
        this.writer.endWriter();
    }

    public void outputColumns(double[] width) {
        this.writer.openTag("ss:Table");
        if (width == null) {
            return;
        }
        int i = 0;
        while (i < width.length) {
            this.writer.openTag("ss:Column");
            this.writer.attribute("ss:Width", width[i] / 1000.0);
            this.writer.attribute("ss:AutoFitWidth", 0);
            this.writer.closeTag("ss:Column");
            ++i;
        }
    }

    public void endTable() {
        this.writer.closeTag("ss:Table");
    }

    public void insertHorizontalMargin(int height, int span) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", height);
        this.writer.openTag("Cell");
        this.writer.attribute(" ss:MergeAcross", span);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    public void insertVerticalMargin(int start, int end, int length) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", 1);
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", start);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", end);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    private void declareWorkSheetOptions(String orientation, int pageWidth, int pageHeight, float leftMargin, float rightMargin, float topMargin, float bottomMargin) {
        this.writer.openTag("WorksheetOptions");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:excel");
        if (this.context.getHideGridlines()) {
            this.writer.openTag("DoNotDisplayGridlines");
            this.writer.closeTag("DoNotDisplayGridlines");
        }
        this.writer.openTag("PageSetup");
        this.writer.openTag("PageMargins");
        this.writer.attribute("x:Bottom", bottomMargin / 72.0f);
        this.writer.attribute("x:Left", leftMargin / 72.0f);
        this.writer.attribute("x:Right", rightMargin / 72.0f);
        this.writer.attribute("x:Top", topMargin / 72.0f);
        this.writer.closeTag("PageMargins");
        if (orientation != null) {
            this.writer.openTag("Layout");
            this.writer.attribute("x:Orientation", orientation);
            this.writer.closeTag("Layout");
        }
        if (this.pageHeader != null) {
            this.writer.openTag("Header");
            this.writer.attribute("x:Data", this.pageHeader);
            this.writer.closeTag("Header");
        }
        if (this.pageFooter != null) {
            this.writer.openTag("Footer");
            this.writer.attribute("x:Data", this.pageFooter);
            this.writer.closeTag("Footer");
        }
        this.writer.closeTag("PageSetup");
        this.writer.openTag("Print");
        this.writer.openTag("PaperSizeIndex");
        int index = ExcelUtil.getPageSizeIndex(pageWidth / 1000, pageHeight / 1000);
        this.writer.text(String.valueOf(index));
        this.writer.closeTag("PaperSizeIndex");
        this.writer.closeTag("Print");
        this.writer.closeTag("WorksheetOptions");
    }

    @Override
    public void startSheet(double[] coordinates, String pageHeader, String pageFooter, String name) {
        this.pageHeader = pageHeader;
        this.pageFooter = pageFooter;
        this.startSheet(name, coordinates);
    }

    @Override
    public void endSheet(double[] coordinates, String orientation, int pageWidth, int pageHeight, float leftMargin, float rightMargin, float topMargin, float bottomMargin) {
        this.endTable();
        this.declareWorkSheetOptions(orientation, pageWidth, pageHeight, leftMargin, rightMargin, topMargin, bottomMargin);
        this.closeSheet();
    }

    @Override
    public void start(IReportContent report, Map<StyleEntry, Integer> styles, HashMap<String, BookmarkDef> bookmarkList) {
        this.writeDeclarations();
        this.writeDocumentProperties(report);
        this.declareStyles(styles);
        this.outputBookmarks(bookmarkList);
    }

    private void outputBookmarks(HashMap<String, BookmarkDef> bookmarkList) {
        if (!bookmarkList.isEmpty()) {
            this.writer.openTag("Names");
            for (Map.Entry<String, BookmarkDef> entry : bookmarkList.entrySet()) {
                BookmarkDef bookmark = entry.getValue();
                this.defineName(bookmark.getValidName(), this.getRefer(bookmark));
            }
            this.writer.closeTag("Names");
        }
    }

    private String getRefer(BookmarkDef bookmark) {
        StringBuffer buffer = new StringBuffer(61);
        buffer.append(bookmark.getSheetName());
        buffer.append("!");
        int startColumn = bookmark.getStartColumn();
        int startRow = bookmark.getStartRow();
        this.addCellPosition(buffer, startColumn, startRow);
        int endColumn = bookmark.getEndColumn();
        int endRow = bookmark.getEndRow();
        if (endRow != -1 && endColumn != -1 && startRow != endRow && startColumn != endColumn) {
            buffer.append(':');
            this.addCellPosition(buffer, endColumn, endRow);
        }
        return buffer.toString();
    }

    private void addCellPosition(StringBuffer buffer, int column, int row) {
        buffer.append("R");
        buffer.append(String.valueOf(row));
        buffer.append("C");
        buffer.append(String.valueOf(column));
    }

    @Override
    public void end() {
        this.writer.closeTag("Workbook");
        this.close();
    }

    public void close() {
        this.writer.endWriter();
        this.writer.close();
    }

    public void setSheetIndex(int sheetIndex) {
    }

    @Override
    public void endSheet() {
        this.endSheet(null, null, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void startRow() {
        this.startRow(-1.0);
    }

    @Override
    public String defineName(String cells) {
        return null;
    }

    static class XLSEncodeUtil
    extends XMLEncodeUtil {
        protected static final char[] XLS_TEXT_ENCODE = new char[]{'&', '<', '\r', '\n'};

        XLSEncodeUtil() {
        }

        static String encodeXLSText(String s) {
            char[] chars = s.toCharArray();
            int length = chars.length;
            int index = XLSEncodeUtil.testEscape((char[])chars, (char[])XLS_TEXT_ENCODE);
            if (index >= length) {
                return s;
            }
            StringBuilder sb = new StringBuilder(2 * length);
            sb.append(chars, 0, index);
            while (index < length) {
                char c;
                if (Character.isHighSurrogate(c = chars[index++])) {
                    index += XLSEncodeUtil.decodeSurrogate((char)c, (char[])chars, (int)index, (StringBuilder)sb);
                    continue;
                }
                if (XLSEncodeUtil.isValidCodePoint((int)c)) {
                    if (c == '&') {
                        sb.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        sb.append("&lt;");
                        continue;
                    }
                    if (c == '\r') {
                        char nc;
                        if (index < length && (nc = chars[index]) == '\n') {
                            ++index;
                        }
                        sb.append("&#10;");
                        continue;
                    }
                    if (c == '\n') {
                        sb.append("&#10;");
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                logger.log(Level.WARNING, "Invalid XML character:0x{0}", c);
            }
            return sb.toString();
        }
    }

    public static class XMLWriterXLS
    extends XMLWriter {
        protected String encodeText(String text) {
            return XLSEncodeUtil.encodeXLSText(text);
        }
    }
}

