/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.ICollectionConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.impl.CachedAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggrMeasureFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggregationFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.impl.query.AddingNestAggregations;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.filter.AggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFacttableFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.JSFacttableFilterEvalHelper;

public class NoUpdateAggregateFilterHelper {
    IAggregationResultSet[] applyNoAggrUpdateFilters(List finalFilters, CubeQueryExecutor executor, IAggregationResultSet[] rs, ICube cube, IBindingValueFetcher fetcher, boolean fromCubeOperation) throws DataException, IOException {
        if (!(finalFilters = this.getNoAggrUpdateFilters(finalFilters)).isEmpty()) {
            ArrayList<AggrMeasureFilterEvalHelper> aggrEvalList = new ArrayList<AggrMeasureFilterEvalHelper>();
            ArrayList<IJSFilterHelper> dimEvalList = new ArrayList<IJSFilterHelper>();
            ArrayList<IFilterDefinition> drillFilterList = new ArrayList<IFilterDefinition>();
            int i = 0;
            while (i < finalFilters.size()) {
                IFilterDefinition filter = (IFilterDefinition)finalFilters.get(i);
                boolean find = false;
                String bindingName = OlapExpressionCompiler.getReferencedScriptObject(filter.getExpression(), "data");
                if (executor.getCubeQueryDefinition().getCubeOperations().length > 0) {
                    ICubeOperation[] operations = executor.getCubeQueryDefinition().getCubeOperations();
                    int j = 0;
                    while (j < operations.length) {
                        if (operations[j] instanceof AddingNestAggregations) {
                            AddingNestAggregations aggr = (AddingNestAggregations)operations[j];
                            IBinding[] bindings = aggr.getNewBindings();
                            int k = 0;
                            while (k < bindings.length) {
                                if (bindings[k].getBindingName().equals(bindingName)) {
                                    find = true;
                                    break;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                if (find == fromCubeOperation) {
                    int type = executor.getFilterType(filter, executor.getDimLevelsDefinedInCubeQuery());
                    if (type == 0) {
                        dimEvalList.add(BaseDimensionFilterEvalHelper.createFilterHelper(executor.getOuterResults(), executor.getScope(), executor.getCubeQueryDefinition(), filter, executor.getSession().getEngineContext().getScriptContext()));
                    } else if (type == 1) {
                        aggrEvalList.add(new AggrMeasureFilterEvalHelper(executor.getOuterResults(), executor.getScope(), executor.getCubeQueryDefinition(), filter, executor.getSession().getEngineContext().getScriptContext()));
                    } else if (type == 2) {
                        drillFilterList.add(filter);
                    }
                }
                ++i;
            }
            ArrayList<Integer> affectedAggrResultSetIndex = new ArrayList<Integer>();
            if (aggrEvalList.size() > 0) {
                AggrMeasureFilterHelper aggrFilterHelper = new AggrMeasureFilterHelper(cube, rs);
                aggrFilterHelper.setQueryExecutor(executor);
                aggrFilterHelper.setBindingValueFetcher(fetcher);
                rs = aggrFilterHelper.removeInvalidAggrRows(aggrEvalList, affectedAggrResultSetIndex);
            }
            if (dimEvalList.size() > 0) {
                AggregationFilterHelper helper = new AggregationFilterHelper((Cube)cube, dimEvalList, fetcher);
                rs = helper.generateFilteredAggregationResultSet(rs, affectedAggrResultSetIndex);
            }
            Map<DimLevel, IJSFacttableFilterEvalHelper> edgeDrillFilterMap = this.populateEdgeDrillFilterMap(executor, drillFilterList);
            List<IAggregationResultSet> edgeResultSet = this.populateAndFilterEdgeResultSet(rs, edgeDrillFilterMap);
            int i2 = 0;
            while (i2 < edgeResultSet.size()) {
                int j = 0;
                while (j < affectedAggrResultSetIndex.size()) {
                    this.applyJoin(edgeResultSet.get(i2), rs[(Integer)affectedAggrResultSetIndex.get(j)]);
                    ++j;
                }
                ++i2;
            }
            if (edgeResultSet.size() > 1) {
                this.combineEdgeResultSetsInfo(edgeResultSet);
            }
        }
        return rs;
    }

    private void combineEdgeResultSetsInfo(List<IAggregationResultSet> edgeResultSet) {
        IAggregationResultSet rs;
        int index = -1;
        int i = 0;
        while (i < edgeResultSet.size()) {
            rs = edgeResultSet.get(i);
            if (rs.length() == 0) {
                index = i;
            }
            ++i;
        }
        if (index >= 0) {
            i = 0;
            while (i < edgeResultSet.size()) {
                if (i != index) {
                    rs = edgeResultSet.get(i);
                    BufferedStructureArray newRsRows = new BufferedStructureArray(AggregationResultRow.getCreator(), rs.length());
                    if (rs instanceof AggregationResultSet) {
                        ((AggregationResultSet)rs).setAggregationResultRows(newRsRows);
                    } else if (rs instanceof CachedAggregationResultSet) {
                        ((CachedAggregationResultSet)rs).setAggregationResultRows(newRsRows);
                    }
                }
                ++i;
            }
        }
    }

    List<IAggregationResultSet> populateAndFilterEdgeResultSet(IAggregationResultSet[] rs, Map<DimLevel, IJSFacttableFilterEvalHelper> edgeDrillFilterMap) throws IOException, DataException {
        ArrayList<IAggregationResultSet> edgeResultSet = new ArrayList<IAggregationResultSet>();
        int i = 0;
        while (i < rs.length) {
            if (rs[i].getAggregationDefinition().getAggregationFunctions() == null) {
                edgeResultSet.add(rs[i]);
                if (edgeDrillFilterMap != null && !edgeDrillFilterMap.isEmpty()) {
                    this.filterEdgeAggrSet(edgeDrillFilterMap, rs[i]);
                }
            }
            ++i;
        }
        return edgeResultSet;
    }

    private void filterEdgeAggrSet(Map<DimLevel, IJSFacttableFilterEvalHelper> edgeDrillFilterMap, IAggregationResultSet edgeAggrSet) throws IOException, DataException {
        IJSFacttableFilterEvalHelper drillFilterHelper = null;
        DimLevel[] dimLevelArray = edgeAggrSet.getAllLevels();
        int n = dimLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            DimLevel dimLevel = dimLevelArray[n2];
            drillFilterHelper = edgeDrillFilterMap.get(dimLevel);
            if (drillFilterHelper != null) {
                AggregateRowWrapper aggrRowWrapper = new AggregateRowWrapper(edgeAggrSet);
                BufferedStructureArray newRs = new BufferedStructureArray(AggregationResultRow.getCreator(), 2000);
                int j = 0;
                while (j < edgeAggrSet.length()) {
                    edgeAggrSet.seek(j);
                    if (drillFilterHelper.evaluateFilter(aggrRowWrapper)) {
                        newRs.add(edgeAggrSet.getCurrentRow());
                    }
                    ++j;
                }
                this.reSetAggregationResultSetDiskArray(edgeAggrSet, newRs);
            }
            ++n2;
        }
    }

    private void reSetAggregationResultSetDiskArray(IAggregationResultSet edgeAggrSet, IDiskArray newRs) {
        if (edgeAggrSet instanceof AggregationResultSet) {
            ((AggregationResultSet)edgeAggrSet).setAggregationResultRows(newRs);
        } else if (edgeAggrSet instanceof CachedAggregationResultSet) {
            ((CachedAggregationResultSet)edgeAggrSet).setAggregationResultRows(newRs);
            ((CachedAggregationResultSet)edgeAggrSet).setLength(newRs.size());
        }
    }

    private Map<DimLevel, IJSFacttableFilterEvalHelper> populateEdgeDrillFilterMap(CubeQueryExecutor executor, List<IFilterDefinition> drillFilterList) throws DataException {
        HashMap<DimLevel, IJSFacttableFilterEvalHelper> result = new HashMap<DimLevel, IJSFacttableFilterEvalHelper>();
        for (IFilterDefinition filterDefn : drillFilterList) {
            assert (filterDefn instanceof ICollectionConditionalExpression);
            Collection<IScriptExpression> exprs = ((ICollectionConditionalExpression)((Object)filterDefn.getExpression())).getExpr();
            Iterator<IScriptExpression> exprsIterator = exprs.iterator();
            DimLevel containedDimLevel = null;
            while (exprsIterator.hasNext()) {
                Iterator dimLevels = OlapExpressionCompiler.getReferencedDimLevel(exprsIterator.next(), new ArrayList()).iterator();
                if (dimLevels.hasNext()) {
                    containedDimLevel = (DimLevel)dimLevels.next();
                }
                if (containedDimLevel != null) break;
            }
            if (containedDimLevel == null) continue;
            result.put(containedDimLevel, new JSFacttableFilterEvalHelper(executor.getScope(), executor.getSession().getEngineContext().getScriptContext(), filterDefn, null, null));
        }
        return result;
    }

    private int getPos(String[][] joinLevelKeys, String[][] detailLevelKeys) {
        int i = 0;
        while (i < detailLevelKeys.length) {
            if (CompareUtil.compare(joinLevelKeys[0], detailLevelKeys[i]) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void applyJoin(IAggregationResultSet joinRS, IAggregationResultSet detailRS) throws IOException {
        String[][] detailLevelKeys = detailRS.getLevelKeys();
        ArrayList<Members> detailMember = new ArrayList<Members>();
        Member[] members = null;
        IDiskArray aggregationResultRows = null;
        String[][] joinLevelKeys = joinRS.getLevelKeys();
        if (detailLevelKeys == null) {
            return;
        }
        int pos = this.getPos(joinLevelKeys, detailLevelKeys);
        if (pos < 0) {
            int detailLevelKeyslen = detailLevelKeys.length;
            if (detailLevelKeyslen == 0 && detailRS.length() == 0) {
                BufferedStructureArray emptyRows = new BufferedStructureArray(AggregationResultRow.getCreator(), 0);
                this.reSetAggregationResultSetDiskArray(joinRS, emptyRows);
            }
            return;
        }
        int index = 0;
        while (index < detailRS.length()) {
            detailRS.seek(index);
            members = detailRS.getCurrentRow().getLevelMembers();
            if (members != null) {
                ArrayList<Member> tmpMembers = new ArrayList<Member>();
                int j = pos;
                while (j < pos + joinLevelKeys.length) {
                    if (j > members.length - 1) break;
                    if (CompareUtil.compare(joinLevelKeys[j - pos], detailLevelKeys[j]) == 0) {
                        tmpMembers.add(members[j]);
                    }
                    ++j;
                }
                detailMember.add(new Members(tmpMembers.toArray(new Member[0])));
            }
            ++index;
        }
        Collections.sort(detailMember);
        if (joinRS instanceof AggregationResultSet) {
            aggregationResultRows = ((AggregationResultSet)joinRS).getAggregationResultRows();
        } else if (joinRS instanceof CachedAggregationResultSet) {
            aggregationResultRows = ((CachedAggregationResultSet)joinRS).getAggregationResultRows();
        }
        BufferedStructureArray newRsRows = new BufferedStructureArray(AggregationResultRow.getCreator(), aggregationResultRows.size());
        int index2 = 0;
        while (index2 < joinRS.length()) {
            joinRS.seek(index2);
            int result = Collections.binarySearch(detailMember, new Members(joinRS.getCurrentRow().getLevelMembers()));
            if (result >= 0) {
                newRsRows.add(aggregationResultRows.get(index2));
            }
            ++index2;
        }
        this.reSetAggregationResultSetDiskArray(joinRS, newRsRows);
        detailMember.clear();
    }

    List getNoAggrUpdateFilters(List filters) {
        ArrayList NoAggrUpdateFilters = new ArrayList();
        int i = 0;
        while (i < filters.size()) {
            if (!((IFilterDefinition)filters.get(i)).updateAggregation()) {
                NoAggrUpdateFilters.add(filters.get(i));
            }
            ++i;
        }
        return NoAggrUpdateFilters;
    }

    private class AggregateRowWrapper
    implements IFacttableRow {
        private IAggregationResultSet aggrResultSet;

        public AggregateRowWrapper(IAggregationResultSet aggrResultSet) {
            this.aggrResultSet = aggrResultSet;
        }

        @Override
        public Object getMeasureValue(String measureName) throws DataException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] getLevelKeyValue(String dimensionName, String levelName) throws DataException, IOException {
            return this.aggrResultSet.getLevelKeyValue(this.aggrResultSet.getLevelIndex(new DimLevel(dimensionName, levelName)));
        }

        @Override
        public Object getLevelAttributeValue(String dimensionName, String levelName, String attributeName) throws DataException, IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class Members
    implements Comparable<Members> {
        public Member[] members;

        public Members(Member[] members) {
            this.members = members;
        }

        @Override
        public int compareTo(Members other) {
            int i = 0;
            while (i < this.members.length) {
                int result = this.members[i].compareTo(other.members[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }
    }
}

