/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.dom;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.css.dom.AbstractStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.w3c.dom.css.CSSValue;

public class StyleDeclaration
extends AbstractStyle {
    protected CSSValue[] values;
    protected boolean shared;
    protected int propertyCount = 0;

    @Override
    public void setProperty(int index, CSSValue value) {
        if (this.values[index] != value) {
            if (this.shared) {
                this.decouple();
            }
            if (this.values[index] == null) {
                ++this.propertyCount;
            } else if (value == null) {
                --this.propertyCount;
            }
            this.values[index] = value;
        }
    }

    @Override
    public CSSValue getProperty(int index) {
        assert (index >= 0 && index < 61);
        return this.values[index];
    }

    public StyleDeclaration(StyleDeclaration style) {
        super(style.engine);
        this.values = style.values;
        this.propertyCount = style.propertyCount;
        this.shared = true;
    }

    public StyleDeclaration(CSSEngine engine) {
        super(engine);
        this.values = new CSSValue[61];
        this.shared = false;
    }

    protected void decouple() {
        CSSValue[] newValues = new CSSValue[61];
        System.arraycopy(this.values, 0, newValues, 0, 61);
        this.values = newValues;
        this.shared = false;
    }

    @Override
    public boolean isEmpty() {
        return this.propertyCount == 0;
    }

    @Override
    public int getLength() {
        return this.propertyCount;
    }

    public boolean equals(Object aStyle) {
        if (aStyle instanceof StyleDeclaration) {
            StyleDeclaration style = (StyleDeclaration)aStyle;
            if (this.propertyCount == style.propertyCount) {
                int i = 0;
                while (i < 61) {
                    CSSValue value1 = this.values[i];
                    CSSValue value2 = style.values[i];
                    if (!(value1 == value2 || value1 != null && value1.equals(value2))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        IOUtil.writeInt((OutputStream)out, (int)this.propertyCount);
        int i = 0;
        while (i < this.values.length) {
            CSSValue value = this.values[i];
            if (value != null) {
                String propertyName = this.engine.getPropertyName(i);
                IOUtil.writeString((DataOutputStream)out, (String)propertyName);
                this.writeCSSValue(out, propertyName, value);
            }
            ++i;
        }
    }
}

