/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.AbstractSerializer;

public class CharSerializer
extends AbstractSerializer<Character> {
    private static final CharSerializer instance = new CharSerializer();

    public static CharSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Character obj) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putChar(obj.charValue());
        buffer.rewind();
        return buffer;
    }

    @Override
    public Character fromByteBuffer(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        return Character.valueOf(bytes.getChar());
    }
}

