/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LocalProperties;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;
import org.w3c.dom.css.CSSValue;

public class BlockContainerArea
extends ContainerArea
implements IContainerArea {
    public BlockContainerArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
        this.isInInlineStacking = parent == null ? false : parent.isInlineStacking || parent.isInInlineStacking;
    }

    public BlockContainerArea() {
    }

    BlockContainerArea(BlockContainerArea area) {
        super(area);
    }

    @Override
    public void add(AbstractArea area) {
        this.children.add(area);
        area.setAllocatedPosition(this.currentIP + this.getOffsetX(), this.currentBP + this.getOffsetY());
    }

    @Override
    public void update(AbstractArea area) throws BirtException {
        int aHeight = area.getAllocatedHeight();
        this.currentBP += aHeight;
        this.height += aHeight;
        if (this.currentIP + area.getAllocatedWidth() > this.maxAvaWidth) {
            this.setNeedClip(true);
        }
    }

    @Override
    public void close() throws BirtException {
        if (this.hasStyle) {
            int height = this.currentBP + this.localProperties.getPaddingTop() + this.boxStyle.getTopBorderWidth() + this.localProperties.getPaddingBottom() + this.boxStyle.getBottomBorderWidth();
            if (this.specifiedHeight > height) {
                if (IStyle.BOTTOM_VALUE.equals(this.vAlign)) {
                    int offset = this.specifiedHeight - height;
                    Iterator<IArea> iter = this.getChildren();
                    while (iter.hasNext()) {
                        AbstractArea child = (AbstractArea)iter.next();
                        child.setY(offset + child.getY());
                    }
                } else if (IStyle.MIDDLE_VALUE.equals(this.vAlign)) {
                    int offset = (this.specifiedHeight - height) / 2;
                    Iterator<IArea> iter = this.getChildren();
                    while (iter.hasNext()) {
                        AbstractArea child = (AbstractArea)iter.next();
                        child.setY(child.getY() + offset);
                    }
                }
                height = this.specifiedHeight;
            }
            this.height = height;
            this.updateBackgroundImage();
        } else {
            this.height = this.specifiedHeight > this.currentBP ? this.specifiedHeight : this.currentBP;
        }
        this.update();
        this.finished = true;
        this.checkDisplayNone();
    }

    protected void update() throws BirtException {
        if (this.context.isFixedLayout() && this.getContentHeight() > this.specifiedHeight && this.specifiedHeight > 0) {
            this.setContentHeight(this.specifiedHeight);
            this.setNeedClip(true);
        }
        if (this.parent != null) {
            this.checkPageBreak();
            this.parent.update(this);
        }
    }

    @Override
    public void initialize() throws BirtException {
        if (this.content == null) {
            this.maxAvaWidth = this.width;
            return;
        }
        IStyle style = this.content.getStyle();
        this.calculateSpecifiedWidth(this.content);
        this.calculateSpecifiedHeight(this.content);
        if (style == null || style.isEmpty()) {
            this.hasStyle = false;
            this.boxStyle = BoxStyle.DEFAULT;
            this.localProperties = LocalProperties.DEFAULT;
            if (this.specifiedWidth > 0) {
                this.setContentWidth(this.specifiedWidth);
            } else if (this.parent != null) {
                this.width = this.parent.getMaxAvaWidth();
            }
            this.maxAvaWidth = this.width;
        } else {
            this.validateBoxProperty(this.content.getComputedStyle(), this.parent == null ? this.context.getMaxWidth() : this.parent.getMaxAvaWidth(), this.context.getMaxHeight());
            this.buildProperties(this.content, this.context);
            if (this.specifiedHeight > 0) {
                this.setContentHeight(this.specifiedHeight);
            }
            if (this.specifiedWidth > 0) {
                this.setContentWidth(this.specifiedWidth);
            } else if (this.parent != null) {
                this.setAllocatedWidth(this.parent.getMaxAvaWidth());
            }
            this.maxAvaWidth = this.getContentWidth();
        }
        this.textAlign = this.content.getComputedStyle().getProperty(23);
        this.bookmark = this.content.getBookmark();
        this.action = this.content.getHyperlinkAction();
        this.parent.add(this);
    }

    @Override
    public BlockContainerArea cloneArea() {
        return new BlockContainerArea(this);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ContainerArea.SplitResult splitLines(int lineCount) throws BirtException {
        if (this.isPageBreakInsideAvoid()) {
            if (this.isPageBreakBeforeAvoid()) {
                return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
            }
            return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
        }
        contentHeight = this.getContentHeight();
        result = new LinkedList<ContainerArea>();
        size = this.children.size();
        childSplit = null;
        status = 2;
        i = size - 1;
        while (i >= 0) {
            block11: {
                block10: {
                    child = (ContainerArea)this.children.get(i);
                    ah = child.getAllocatedHeight();
                    childSplit = child.splitLines(lineCount);
                    if (childSplit.status != 2) break block10;
                    result.addFirst(child);
                    contentHeight -= ah;
                    break block11;
                }
                if (childSplit.status != 1) ** GOTO lbl44
                result.addFirst(child);
                contentHeight -= ah;
                if (i > 0) {
                    preChild = (ContainerArea)this.children.get(i - 1);
                    if (!preChild.isPageBreakAfterAvoid()) {
                        status = 0;
                        contentHeight = contentHeight - ah + child.getAllocatedHeight();
                        newContainer = this.cloneArea();
                        newContainer.updateContentHeight(contentHeight);
                        iter = this.children.iterator();
                        while (iter.hasNext()) {
                            childArea = (ContainerArea)iter.next();
                            if (result.contains(childArea)) continue;
                            iter.remove();
                            newContainer.addChild(childArea);
                            newContainer.setParent(newContainer);
                        }
                        this.updateChildrenPosition();
                        return new ContainerArea.SplitResult(newContainer, 0);
                    }
                } else {
                    if (this.isPageBreakBeforeAvoid()) {
                        return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
                    }
                    return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
lbl44:
                    // 1 sources

                    if (childSplit.status == 0) {
                        result.addFirst(child);
                        splitChildArea = childSplit.getResult();
                        contentHeight = contentHeight - ah + splitChildArea.getAllocatedHeight();
                        newContainer = this.cloneArea();
                        newContainer.updateContentHeight(contentHeight);
                        iter = this.children.iterator();
                        while (iter.hasNext()) {
                            childArea = (ContainerArea)iter.next();
                            if (result.contains(childArea)) continue;
                            iter.remove();
                            newContainer.addChild(childArea);
                            newContainer.setParent(newContainer);
                        }
                        newContainer.addChild(splitChildArea);
                        this.addRepeatedItem();
                        this.updateChildrenPosition();
                        return new ContainerArea.SplitResult(newContainer, 0);
                    }
                }
            }
            --i;
        }
        return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
    }

    @Override
    public ContainerArea.SplitResult split(int height, boolean force) throws BirtException {
        if (force) {
            return this._split(height, true);
        }
        if (this.isPageBreakInsideAvoid()) {
            if (this.isPageBreakBeforeAvoid()) {
                return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
            }
            return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
        }
        return this._split(height, false);
    }

    protected ContainerArea.SplitResult _split(int height, boolean force) throws BirtException {
        int ah;
        if (this.children.size() == 0) {
            if (this.isPageBreakBeforeAvoid() && !force) {
                this.updateChildrenPosition();
                return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
            }
            this.updateChildrenPosition();
            return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
        }
        BlockContainerArea newContainer = null;
        int status = 2;
        int cheight = this.getContentHeight(height);
        ListIterator iter = this.children.listIterator();
        int contentHeight = 0;
        ArrayList<ContainerArea> result = new ArrayList<ContainerArea>();
        ContainerArea current = null;
        ContainerArea previous = null;
        while (iter.hasNext()) {
            previous = current;
            current = (ContainerArea)iter.next();
            ah = current.getAllocatedHeight();
            if ((contentHeight += ah) <= cheight && current.finished) {
                result.add(current);
                continue;
            }
            int childSplitHeight = cheight - (contentHeight -= ah);
            ContainerArea.SplitResult splitResult = current.split(childSplitHeight, force && !this.isValidResult(result));
            if (splitResult.status == 0) {
                ContainerArea splitChildArea = splitResult.getResult();
                result.add(splitChildArea);
                status = 0;
                contentHeight += splitChildArea.getAllocatedHeight();
                break;
            }
            if (splitResult.status == 2) {
                if (!force || result.size() <= 0) break;
                status = 0;
                break;
            }
            if (splitResult.status != 1) continue;
            if (this.isValidResult(result)) {
                if (force) {
                    status = 0;
                    break;
                }
                if (previous.isPageBreakAfterAvoid()) {
                    status = 2;
                    break;
                }
                status = 0;
                break;
            }
            if (force) {
                status = 0;
                break;
            }
            if (this.isPageBreakBeforeAvoid()) {
                return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
            }
            return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
        }
        if (result.size() == this.children.size()) {
            status = 0;
        }
        if (!force && status == 2) {
            if (result.size() == 0) {
                return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
            }
            iter.previous();
            while (iter.hasPrevious()) {
                current = (ContainerArea)iter.previous();
                ah = current.getAllocatedHeight();
                ContainerArea.SplitResult splitResult = current.splitLines(1);
                if (splitResult.status == 2) {
                    result.remove(current);
                    contentHeight -= ah;
                    continue;
                }
                if (splitResult.status == 0) {
                    result.remove(current);
                    ContainerArea splitChildArea = splitResult.getResult();
                    contentHeight = contentHeight - ah + splitChildArea.getAllocatedHeight();
                    result.add(splitChildArea);
                    status = 0;
                    break;
                }
                if (splitResult.status != 1) continue;
                result.remove(current);
                contentHeight -= ah;
                int preIndex = iter.previousIndex();
                if (preIndex >= 0) {
                    ContainerArea prev = (ContainerArea)this.children.get(preIndex);
                    if (prev.isPageBreakAfterAvoid()) continue;
                    status = 0;
                    break;
                }
                if (this.isPageBreakBeforeAvoid()) {
                    return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
                }
                return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
            }
            if (result.size() == 0) {
                return ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL;
            }
        }
        if (status == 0) {
            if (this.isValidResult(result) || force) {
                newContainer = this.getSplitArea(result, contentHeight);
            } else {
                return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
            }
        }
        if (newContainer != null) {
            this.addRepeatedItem();
            this.updateChildrenPosition();
        }
        return new ContainerArea.SplitResult(newContainer, status);
    }

    protected BlockContainerArea getSplitArea(ArrayList ablatedChildren, int newHeight) {
        BlockContainerArea newContainer = this.cloneArea();
        int i = 0;
        while (i < ablatedChildren.size()) {
            ContainerArea child = (ContainerArea)ablatedChildren.get(i);
            child.setParent(newContainer);
            newContainer.addChild(child);
            this.children.remove(child);
            if (this.children.isEmpty()) {
                this.isChildrenRemoved = true;
            }
            ++i;
        }
        newContainer.updateContentHeight(newHeight);
        this.applyAlignment(newContainer);
        return newContainer;
    }

    private void applyAlignment(BlockContainerArea area) {
        IContent content = area.getContent();
        if (content == null) {
            return;
        }
        CSSValue align = content.getComputedStyle().getProperty(23);
        boolean isRightAligned = BidiAlignmentResolver.isRightAligned(content, align, false);
        if (isRightAligned || IStyle.CENTER_VALUE.equals(align)) {
            Iterator<IArea> iter = area.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                int spacing = area.getContentWidth() - child.getAllocatedWidth();
                if (spacing <= 0) continue;
                if (isRightAligned) {
                    child.setAllocatedX(spacing + area.getOffsetX());
                    continue;
                }
                if (!IStyle.CENTER_VALUE.equals(align)) continue;
                child.setAllocatedX(spacing / 2 + area.getOffsetX());
            }
        }
    }

    protected void addRepeatedItem() throws BirtException {
    }

    protected boolean isValidResult(List result) {
        return result.size() > 0;
    }

    @Override
    public int getBaseLine() {
        if (this.baseLine == 0) {
            if (this.children.size() > 0) {
                AbstractArea child = (AbstractArea)this.children.get(this.children.size() - 1);
                this.baseLine = child.getY() + child.getBaseLine();
            } else {
                this.baseLine = this.height;
            }
        }
        return this.baseLine;
    }

    @Override
    public boolean isPageBreakInsideAvoid() {
        if (this.context.isFixedLayout() && this.specifiedHeight > 0) {
            return true;
        }
        return super.isPageBreakInsideAvoid();
    }

    @Override
    public void updateChildrenPosition() throws BirtException {
        this.first = false;
        this.currentBP = 0;
        if (this.children.size() > 0) {
            Iterator iter = this.children.iterator();
            int y = this.getOffsetY();
            int h = 0;
            while (iter.hasNext()) {
                ContainerArea area = (ContainerArea)iter.next();
                area.setAllocatedPosition(this.getOffsetX(), y);
                int ah = area.getAllocatedHeight();
                y += ah;
                h += ah;
                if (!area.finished) continue;
                this.currentBP += ah;
            }
            this.setContentHeight(h);
        } else {
            this.setContentHeight(0);
        }
    }
}

