/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.NoSuchElementException;
import me.prettyprint.cassandra.service.ExceptionsTranslator;
import me.prettyprint.hector.api.exceptions.HCassandraInternalException;
import me.prettyprint.hector.api.exceptions.HInactivePoolException;
import me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import me.prettyprint.hector.api.exceptions.HNotFoundException;
import me.prettyprint.hector.api.exceptions.HPoolExhaustedException;
import me.prettyprint.hector.api.exceptions.HPoolRecoverableException;
import me.prettyprint.hector.api.exceptions.HTimedOutException;
import me.prettyprint.hector.api.exceptions.HUnavailableException;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import me.prettyprint.hector.api.exceptions.PoolIllegalStateException;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;

public final class ExceptionsTranslatorImpl
implements ExceptionsTranslator {
    @Override
    public HectorException translate(Throwable original) {
        if (original instanceof HectorException) {
            return (HectorException)original;
        }
        if (original instanceof TApplicationException) {
            return new HCassandraInternalException(((TApplicationException)original).getType(), original.getMessage());
        }
        if (original instanceof TTransportException) {
            return new HectorTransportException(original);
        }
        if (original instanceof TimedOutException) {
            return new HTimedOutException(original);
        }
        if (original instanceof InvalidRequestException) {
            String why = ((InvalidRequestException)original).getWhy();
            if (why != null && why.contains("bootstrap")) {
                return new HUnavailableException(original);
            }
            HInvalidRequestException e = new HInvalidRequestException(original);
            e.setWhy(why);
            return e;
        }
        if (original instanceof HPoolExhaustedException) {
            return (HPoolExhaustedException)original;
        }
        if (original instanceof HPoolRecoverableException) {
            return (HPoolRecoverableException)original;
        }
        if (original instanceof HInactivePoolException) {
            return (HInactivePoolException)original;
        }
        if (original instanceof TProtocolException) {
            return new HInvalidRequestException(original);
        }
        if (original instanceof NotFoundException) {
            return new HNotFoundException(original);
        }
        if (original instanceof UnavailableException) {
            return new HUnavailableException(original);
        }
        if (original instanceof TException) {
            return new HectorTransportException(original);
        }
        if (original instanceof NoSuchElementException) {
            return new HPoolExhaustedException(original);
        }
        if (original instanceof IllegalStateException) {
            return new PoolIllegalStateException(original);
        }
        return new HectorException(original);
    }
}

