/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.context;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.ParameterAttributeBean;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class BaseAttributeBean {
    protected String category;
    protected Exception exception = null;
    protected HashMap parameters = null;
    protected boolean missingParameter = false;
    protected ParameterAttributeBean parameterBean = null;
    protected IViewerReportDesignHandle reportDesignHandle = null;
    protected String reportDesignName = null;
    protected String reportDocumentName = null;
    protected String reportTitle = null;
    protected int reportPage;
    protected String reportPageRange;
    protected Locale locale = null;
    protected TimeZone timeZone = null;
    protected boolean masterPageContent = true;
    protected boolean isDesigner = false;
    protected String bookmark = null;
    protected String reportletId = null;
    protected String format = "html";
    protected String emitterId = null;
    protected Map configMap = null;
    protected Map parameterMap = null;
    protected boolean rtl = false;
    protected boolean isToc = false;
    protected boolean documentInUrl = false;
    protected String taskId;
    protected boolean isShowTitle = true;
    protected boolean isShowToolbar = true;
    protected boolean isShowNavigationbar = true;
    protected boolean isShowParameterPage = false;
    protected boolean isDocumentProcessing = false;
    protected String action = null;

    protected abstract void __init(HttpServletRequest var1) throws Exception;

    protected abstract IViewerReportService getReportService();

    protected void init(HttpServletRequest request) throws Exception {
        this.locale = ParameterAccessor.getLocale(request);
        this.timeZone = ParameterAccessor.getTimeZone(request);
        this.rtl = ParameterAccessor.isRtl(request);
        this.reportletId = ParameterAccessor.getReportletId(request);
        this.__init(request);
    }

    public ParameterAttributeBean getParameterBean() {
        return this.parameterBean;
    }

    public void setParameterBean(ParameterAttributeBean parameterBean) {
        this.parameterBean = parameterBean;
    }

    public String getReportTitle() throws ReportServiceException {
        return this.reportTitle;
    }

    public int getReportPage() {
        return this.reportPage;
    }

    public String getReportPageRange() {
        return this.reportPageRange;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isDesigner() {
        return this.isDesigner;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getReportDocumentName() {
        return this.reportDocumentName;
    }

    public void setReportDocumentName(String reportDocumentName) {
        this.reportDocumentName = reportDocumentName;
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public HashMap getParameters() {
        return this.parameters;
    }

    public boolean isMasterPageContent() {
        return this.masterPageContent;
    }

    public boolean isMissingParameter() {
        return this.missingParameter;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public String getReportDesignName() {
        return this.reportDesignName;
    }

    public String getFormat() {
        return this.format;
    }

    public String getEmitterId() {
        return this.emitterId;
    }

    public boolean isRtl() {
        return this.rtl;
    }

    protected Object getParamValueObject(HttpServletRequest request, ParameterDefinition parameterObj) throws ReportServiceException {
        String paramName = parameterObj.getName();
        String format = parameterObj.getDisplayFormat();
        if (ParameterAccessor.isReportParameterExist(request, paramName)) {
            ReportParameterConverter converter = new ReportParameterConverter(format, this.locale);
            String paramValue = ParameterAccessor.getReportParameter(request, paramName, null);
            return converter.parse(paramValue, parameterObj.getDataType());
        }
        return null;
    }

    public IViewerReportDesignHandle getReportDesignHandle(HttpServletRequest request) {
        return this.reportDesignHandle;
    }

    public boolean isToc() {
        return this.isToc;
    }

    public String getReportletId() {
        return this.reportletId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public boolean isShowNavigationbar() {
        return this.isShowNavigationbar;
    }

    public boolean isShowTitle() {
        return this.isShowTitle;
    }

    public boolean isShowToolbar() {
        return this.isShowToolbar;
    }

    public boolean isShowParameterPage() {
        return this.isShowParameterPage;
    }

    public boolean isDocumentProcessing() {
        return this.isDocumentProcessing;
    }

    public String getAction() {
        return this.action;
    }

    public boolean isDocumentInUrl() {
        return this.documentInUrl;
    }

    public void setDocumentInUrl(boolean documentInUrl) {
        this.documentInUrl = documentInUrl;
    }

    public String getClientInitialize() {
        IReportRunnable r;
        try {
            r = (IReportRunnable)this.reportDesignHandle.getDesignObject();
        }
        catch (ReportServiceException e) {
            return "";
        }
        if (r.getDesignHandle() instanceof ReportDesignHandle) {
            ReportDesignHandle handle = (ReportDesignHandle)r.getDesignHandle();
            return handle.getClientInitialize();
        }
        return "";
    }
}

