/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.internal.util.EclipseUtil;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ReportGraphicsViewPainter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.graphics.ImageCanvas;
import org.eclipse.birt.report.designer.internal.ui.wizards.ExtensionTemplateListProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public class WizardTemplateChoicePage
extends WizardPage
implements ExtensionTemplateListProvider.TemplateUICallback {
    protected static final Logger logger = Logger.getLogger(WizardTemplateChoicePage.class.getName());
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};
    private static final String MESSAGE_DESCRIPTION = Messages.getString((String)"WizardTemplateChoicePage.label.Description");
    private static final String MESSAGE_PREVIEW = Messages.getString((String)"WizardTemplateChoicePage.label.Preview");
    private static final String MESSAGE_REPORT_TEMPLATES = Messages.getString((String)"WizardTemplateChoicePage.label.ReportTemplates");
    private static final String MESSAGE_SHOW_CHEATSHEET = Messages.getString((String)"WizardTemplateChoicePage.label.ShowCheatSheets");
    private static final String ENABLED = "true";
    private ImageCanvas previewCanvas;
    private Button chkBox;
    private Button useDefaultLibraryBox;
    private LibraryHandle defaultLibraryHandle;
    private static final String MESSAGE_RTL_BIDI = Messages.getString((String)"WizardTemplateChoicePage.label.rtlBiDiOrientation");
    private static final String MESSAGE_LTR_BIDI = Messages.getString((String)"WizardTemplateChoicePage.label.ltrBiDiOrientation");
    private static final String MESSAGE_CHOOSE_BIDI_DIR = Messages.getString((String)"WizardTemplateChoicePage.label.chooseBiDiDirection");
    public final int LTR_DIRECTION_INDX = 0;
    public final int RTL_DIRECTION_INDX = 1;
    private Label directionLabel;
    private Combo directionCombo;
    boolean isLTRDirection = ReportPlugin.getDefault().getLTRReportDirection();
    private int predefinedCount;
    private ExtensionTemplateListProvider provider;
    private boolean isModified = false;
    private Label description;
    Image thumbnailImage;
    protected List<ReportDesignHandle> templates = new ArrayList<ReportDesignHandle>();
    protected Map<String, Image> imageMap;
    private Composite previewPane;
    private TreeViewer templateList;
    private static final Object TreeRoot = new Object();
    private static final String RootDisplayName = Messages.getString((String)"WizardTemplateChoicePage.RootDisplayName");
    private ISelectionChangedListener templateListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ReportDesignHandle handle = WizardTemplateChoicePage.this.getSelectionHandle();
            WizardTemplateChoicePage.this.processSelectionReportDesignHandle(handle);
        }
    };

    public void setLTRDirection(boolean isLTRDirection) {
        if (!this.isModified) {
            this.isLTRDirection = isLTRDirection;
            this.reSelectDirectionCombo();
        }
    }

    public WizardTemplateChoicePage(String pageName) {
        super(pageName);
        this.provider = new ExtensionTemplateListProvider(this);
        this.imageMap = new HashMap<String, Image>();
        if (UIUtil.getFragmentDirectory() == null) {
            return;
        }
        ReportDesignHandle[] predefinedTemplateArray = this.getAllTemplates(UIUtil.getFragmentDirectory(), "/templates/");
        this.SortPredefinedTemplates(predefinedTemplateArray);
        if (predefinedTemplateArray != null && predefinedTemplateArray.length > 0) {
            this.templates.addAll(Arrays.asList(predefinedTemplateArray));
        }
    }

    protected ReportDesignHandle[] getAllTemplates(String root) {
        return this.getAllTemplates(root, null);
    }

    protected ReportDesignHandle[] getAllTemplates(String root, String path) {
        if (root == null || root.trim().length() <= 0) {
            return null;
        }
        ReportDesignHandle[] templateArray = null;
        File templateDirectory = null;
        templateDirectory = path == null ? new File(root, File.separator) : new File(root, String.valueOf(path) + File.separator);
        if (templateDirectory.isDirectory()) {
            boolean createSucc;
            if (!templateDirectory.exists() && !(createSucc = templateDirectory.mkdirs())) {
                return new ReportDesignHandle[0];
            }
            File[] filesArray = templateDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".rpttemplate");
                }
            });
            ArrayList<ReportDesignHandle> reportDesingHandleList = new ArrayList<ReportDesignHandle>();
            int i = 0;
            while (i < filesArray.length) {
                try {
                    ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getSessionHandle().openModule(filesArray[i].getAbsolutePath());
                    if (moduleHandle instanceof ReportDesignHandle) {
                        reportDesingHandleList.add((ReportDesignHandle)moduleHandle);
                    }
                }
                catch (Exception moduleHandle) {
                    // empty catch block
                }
                ++i;
            }
            int count = reportDesingHandleList.size();
            templateArray = new ReportDesignHandle[count];
            int i2 = 0;
            while (i2 < count) {
                templateArray[i2] = (ReportDesignHandle)reportDesingHandleList.get(i2);
                ++i2;
            }
        }
        return templateArray;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.NewReportCopyWizard_ID");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Label label0 = new Label(composite, 0);
        label0.setText(MESSAGE_REPORT_TEMPLATES);
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText(MESSAGE_PREVIEW);
        GridData data = new GridData(1);
        previewLabel.setLayoutData((Object)data);
        this.templateList = new TreeViewer(composite, 2052);
        this.predefinedCount = this.templates.size();
        this.createCustomTemplateList();
        data = new GridData(1041);
        data.widthHint = 250;
        data.heightHint = 300;
        this.templateList.getTree().setLayoutData((Object)data);
        this.previewPane = new Composite(composite, 0);
        data = new GridData(1808);
        this.previewPane.setLayoutData((Object)data);
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        this.previewPane.setLayout((Layout)gridLayout);
        Composite previewComposite = new Composite(this.previewPane, 2048);
        data = new GridData(1);
        data.heightHint = 229;
        data.widthHint = 184;
        previewComposite.setLayoutData((Object)data);
        previewComposite.setLayout((Layout)new FormLayout());
        this.previewCanvas = new ImageCanvas(previewComposite);
        FormData formData = new FormData(184, 229);
        formData.left = new FormAttachment((Control)previewComposite);
        formData.top = new FormAttachment((Control)previewComposite);
        this.previewCanvas.setLayoutData(formData);
        Label descriptionTitle = new Label(this.previewPane, 0);
        descriptionTitle.setText(MESSAGE_DESCRIPTION);
        data = new GridData(768);
        descriptionTitle.setLayoutData((Object)data);
        this.description = new Label(this.previewPane, 64);
        data = new GridData(768);
        data.widthHint = 184;
        data.horizontalIndent = 20;
        this.description.setLayoutData((Object)data);
        new Label(this.previewPane, 0);
        this.chkBox = new Button(composite, 32);
        this.chkBox.setText(MESSAGE_SHOW_CHEATSHEET);
        this.chkBox.setSelection(ReportPlugin.readCheatSheetPreference());
        this.chkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReportPlugin.writeCheatSheetPreference(WizardTemplateChoicePage.this.chkBox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ReportPlugin.writeCheatSheetPreference(WizardTemplateChoicePage.this.chkBox.getSelection());
            }
        });
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.chkBox.setLayoutData((Object)data);
        this.defaultLibraryHandle = this.getDefaultLibraryHandleFromResource();
        String value = ReportPlugin.getDefault().getPreferenceStore().getString("designer.library.preference.libraries.enable.default.theme.preferencestore");
        if (this.defaultLibraryHandle != null && ENABLED.equals(value)) {
            String state = ReportPlugin.getDefault().getPreferenceStore().getString("designer.library.preference.libraries.include.default.theme.preferencestore");
            this.useDefaultLibraryBox = new Button(composite, 32);
            this.useDefaultLibraryBox.setText(Messages.getString((String)"WizardTemplateChoicePage.label.EnableDefaultThemes"));
            this.useDefaultLibraryBox.setSelection(ENABLED.equals(state));
        }
        this.hookListeners();
        this.initTreeViewer();
        if (this.templates.size() > 0) {
            this.templateList.setSelection((ISelection)new StructuredSelection((Object)this.templates.get(0)));
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
        this.setControl((Control)composite);
    }

    private void reSelectDirectionCombo() {
        if (this.directionCombo != null) {
            this.directionCombo.select(this.isLTRDirection ? 0 : 1);
        }
    }

    private void createCustomTemplateList() {
        String templateRoot = ReportPlugin.getDefault().getTemplatePreference();
        if (templateRoot == null || templateRoot.trim().length() == 0) {
            return;
        }
        File preTemplateDirectory = new File(UIUtil.getFragmentDirectory(), "/templates/");
        File cusTemplateDirectory = new File(templateRoot.trim());
        if (preTemplateDirectory != null && cusTemplateDirectory != null && preTemplateDirectory.equals(cusTemplateDirectory)) {
            return;
        }
        ReportDesignHandle[] customTmplateArray = this.getAllTemplates(templateRoot.trim());
        if (customTmplateArray != null) {
            this.templates.addAll(Arrays.asList(customTmplateArray));
        }
    }

    private void hookListeners() {
    }

    private void processSelectionReportDesignHandle(ReportDesignHandle handle) {
        String ReprotDescription;
        if (handle == null) {
            this.previewCanvas.clear();
            this.description.setText("");
            this.chkBox.setSelection(false);
            this.chkBox.setEnabled(false);
            this.setPageComplete(false);
            if (this.directionCombo != null) {
                this.directionCombo.setEnabled(false);
            }
            return;
        }
        if (this.directionCombo != null) {
            this.directionCombo.setEnabled(true);
        }
        if ((ReprotDescription = handle.getDescription()) != null && ReprotDescription.trim().length() != 0) {
            if (this.isPredifinedTemplate(handle.getFileName())) {
                this.description.setText(Messages.getString((String)ReprotDescription));
            } else {
                this.description.setText(Messages.getString((String)ReprotDescription));
            }
        } else {
            this.description.setText("");
        }
        this.previewPane.layout();
        String key = handle.getIconFile();
        if (key != null && key.trim().length() != 0 && !this.checkExtensions(key)) {
            key = null;
        }
        Image img = null;
        if (handle.getThumbnail() != null && handle.getThumbnail().length != 0) {
            byte[] thumbnailData = handle.getThumbnail();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(thumbnailData);
            if (this.thumbnailImage != null) {
                this.thumbnailImage.dispose();
                this.thumbnailImage = null;
            }
            this.thumbnailImage = new Image(null, (InputStream)inputStream);
            this.previewCanvas.clear();
            this.previewCanvas.loadImage(this.thumbnailImage);
        } else if (key != null && !"".equals(key.trim())) {
            URL url = this.getPreviewImageURL(handle.getFileName(), key);
            if (url != null) {
                try {
                    key = FileLocator.resolve((URL)url).getPath();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                img = this.imageMap.get(key);
                if (img == null) {
                    try {
                        url = new URL("file://" + key);
                        img = ImageManager.getInstance().loadImage(url);
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    if (img != null) {
                        this.imageMap.put(key, img);
                    }
                }
                if (img != null) {
                    this.previewCanvas.clear();
                    this.previewCanvas.loadImage(img);
                }
            } else {
                key = null;
            }
        }
        if ((handle.getThumbnail() == null || handle.getThumbnail().length == 0) && key == null) {
            if (this.thumbnailImage != null) {
                this.thumbnailImage.dispose();
                this.thumbnailImage = null;
            }
            Rectangle rect = this.previewCanvas.getBounds();
            this.thumbnailImage = new Image(null, rect.width, rect.height);
            ReportGraphicsViewPainter painter = new ReportGraphicsViewPainter(handle);
            painter.paint((Drawable)this.thumbnailImage, (Device)this.previewCanvas.getDisplay(), rect);
            painter.dispose();
            this.previewCanvas.clear();
            this.previewCanvas.loadImage(this.thumbnailImage);
        }
        if (handle.getCheatSheet() != null && handle.getCheatSheet().trim().length() != 0) {
            this.chkBox.setEnabled(!handle.getCheatSheet().equals("") && !handle.getCheatSheet().equals("org.eclipse.birt.report.designer.ui.cheatsheet.firstreport"));
            this.chkBox.setSelection(true);
        } else {
            this.chkBox.setSelection(false);
            this.chkBox.setEnabled(false);
        }
        this.setPageComplete(true);
    }

    public ReportDesignHandle getTemplate() {
        return this.getSelectionHandle();
    }

    public boolean getShowCheatSheet() {
        ReportDesignHandle handle = this.getSelectionHandle();
        if (handle != null && handle.getCheatSheet() != null && handle.getCheatSheet().equals("org.eclipse.birt.report.designer.ui.cheatsheet.firstreport")) {
            return true;
        }
        return this.chkBox.getSelection();
    }

    public void dispose() {
        super.dispose();
        for (ReportDesignHandle item : this.templates) {
            if (!(item instanceof ReportDesignHandle)) continue;
            item.close();
        }
        if (this.thumbnailImage != null) {
            this.thumbnailImage.dispose();
            this.thumbnailImage = null;
        }
        if (this.defaultLibraryHandle != null) {
            this.defaultLibraryHandle.close();
            this.defaultLibraryHandle = null;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().setFocus();
        }
    }

    private boolean isPredifinedTemplate(String sourceFileName) {
        String predifinedDir = UIUtil.getFragmentDirectory();
        if (predifinedDir == null || predifinedDir.length() <= 0) {
            return false;
        }
        File predifinedFile = new File(predifinedDir);
        File sourceFile = new File(sourceFileName);
        return sourceFile.getAbsolutePath().startsWith(predifinedFile.getAbsolutePath());
    }

    private void SortPredefinedTemplates(ReportDesignHandle[] predefinedTemplateArray) {
        if (predefinedTemplateArray == null || predefinedTemplateArray.length <= 1) {
            return;
        }
        String[] predefinedTemplateFileName = new String[]{"blank_report.rpttemplate", "my_first_report.rpttemplate", "simple_listing.rpttemplate", "grouped_listing.rpttemplate", "grouped_listing_column_heading.rpttemplate", "dual_column_listing.rpttemplate", "chart_listing.rpttemplate", "dual_column_chart_listing.rpttemplate", "sidebyside_chart_listing.rpttemplate"};
        int predefinedTemplateCount = predefinedTemplateFileName.length;
        ReportDesignHandle swapHandle = null;
        String templateName = null;
        int index = 0;
        int i = 0;
        while (i < predefinedTemplateCount) {
            templateName = predefinedTemplateFileName[i];
            int j = index;
            while (j < predefinedTemplateArray.length) {
                if (predefinedTemplateArray[j].getFileName().endsWith(templateName)) {
                    if (index != j) {
                        swapHandle = predefinedTemplateArray[j];
                        predefinedTemplateArray[j] = predefinedTemplateArray[index];
                        predefinedTemplateArray[index] = swapHandle;
                    }
                    ++index;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private URL getPreviewImageURL(String reportFileName, String key) {
        String path;
        Bundle bundle = EclipseUtil.getBundle((String)"org.eclipse.birt.resources");
        if (bundle == null) {
            return null;
        }
        URL url = bundle.getResource(key);
        if (url == null && (url = this.resolveURL(new File(path = ReportPlugin.getDefault().getResourceFolder(), key))) == null) {
            url = this.resolveURL(new File(key));
        }
        return url;
    }

    private URL resolveURL(File file) {
        if (file.exists() && file.isFile()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    private boolean checkExtensions(String fileName) {
        int i = 0;
        while (i < IMAGE_TYPES.length) {
            if (fileName.toLowerCase().endsWith(IMAGE_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLTRDirection() {
        return this.isLTRDirection;
    }

    private void initTreeViewer() {
        TemplateListProvider treeProvider = new TemplateListProvider();
        this.templateList.setLabelProvider((IBaseLabelProvider)treeProvider);
        this.templateList.setContentProvider((IContentProvider)treeProvider);
        this.templateList.addSelectionChangedListener(this.templateListener);
        Object[] objs = this.provider.getRootElements();
        Object[] roots = new Object[1 + objs.length];
        roots[0] = TreeRoot;
        System.arraycopy(objs, 0, roots, 1, objs.length);
        this.templateList.setInput((Object)roots);
        this.templateList.expandAll();
    }

    @Override
    public void contentChanged() {
        if (this.templateList != null && this.templateList.getTree() != null && !this.templateList.getTree().isDisposed()) {
            ISelection oldSel = this.templateList.getSelection();
            Object[] objs = this.provider.getRootElements();
            Object[] roots = new Object[1 + objs.length];
            roots[0] = TreeRoot;
            System.arraycopy(objs, 0, roots, 1, objs.length);
            this.templateList.setInput((Object)roots);
            this.templateList.expandToLevel(2);
            this.templateList.setSelection(oldSel);
        }
    }

    private ReportDesignHandle getSelectionHandle() {
        IStructuredSelection selection = (IStructuredSelection)this.templateList.getSelection();
        List list = selection.toList();
        if (list.size() != 1) {
            return null;
        }
        Object data = list.get(0);
        if (data instanceof ReportDesignHandle) {
            return (ReportDesignHandle)data;
        }
        ReportDesignHandle handle = this.provider.getReportDesignHandle(data);
        return handle;
    }

    private LibraryHandle getDefaultLibraryHandleFromResource() {
        return DEUtil.getDefaultLibraryHandle();
    }

    public boolean isUseDefaultLibrary() {
        if (this.useDefaultLibraryBox == null) {
            return false;
        }
        return this.useDefaultLibraryBox.getSelection();
    }

    public LibraryHandle getDefaultLibraryHandle() {
        return this.defaultLibraryHandle;
    }

    private class TemplateListProvider
    implements ILabelProvider,
    ITreeContentProvider {
        private TemplateListProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ReportDesignHandle) {
                return ReportPlatformUIImages.getImage("Template");
            }
            if (element == TreeRoot) {
                return ReportPlatformUIImages.getImage("IMG_OBJ_FOLDER");
            }
            Image image = WizardTemplateChoicePage.this.provider.getImage(element);
            return image;
        }

        public String getText(Object element) {
            String displayName = null;
            if (element instanceof ReportDesignHandle) {
                int index;
                displayName = WizardTemplateChoicePage.this.templates.contains(element) ? ((index = WizardTemplateChoicePage.this.templates.indexOf(element)) + 1 <= WizardTemplateChoicePage.this.predefinedCount ? ((displayName = ((ReportDesignHandle)element).getDisplayName()) != null ? Messages.getString((String)displayName) : Messages.getString((String)((ReportDesignHandle)element).getFileName())) : ((ReportDesignHandle)element).getDisplayName()) : ((ReportDesignHandle)element).getDisplayName();
                return displayName;
            }
            if (element == TreeRoot) {
                return RootDisplayName;
            }
            displayName = WizardTemplateChoicePage.this.provider.getText(element);
            if (displayName == null) {
                displayName = element.toString();
            }
            return displayName;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            WizardTemplateChoicePage.this.provider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            if (parentElement == TreeRoot) {
                return WizardTemplateChoicePage.this.templates.toArray();
            }
            Object[] objs = WizardTemplateChoicePage.this.provider.getChildren(parentElement);
            if (objs == null) {
                objs = new Object[]{};
            }
            return objs;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

