/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.draw2d.geometry.Dimension;

public class ListHandleAdapter
extends ReportItemtHandleAdapter {
    private static final String TRANS_LABEL_INSERT_GROUP = Messages.getString("ListHandleAdapt.transLabel.insertGroup");
    List children = new ArrayList();
    public static final int HEADER = 0;
    public static final int DETAIL = 2;
    public static final int FOOTER = 3;

    public ListHandleAdapter(ListHandle handle, IModelAdapterHelper mark) {
        super((ReportItemHandle)handle, mark);
    }

    @Override
    public List getChildren() {
        ListHandle handle = this.getListHandle();
        SlotHandle slotHandle = handle.getHeader();
        this.addChild(new ListBandProxy(slotHandle, ListBandProxy.LIST_HEADER));
        SlotHandle group = handle.getGroups();
        int number = 0;
        for (ListGroupHandle listGroup : group) {
            SlotHandle groupHeaders = listGroup.getHeader();
            this.addChild(new ListBandProxy(groupHeaders, String.valueOf(ListBandProxy.LIST_GROUP_HEADER) + ++number));
        }
        slotHandle = handle.getDetail();
        this.addChild(new ListBandProxy(slotHandle, ListBandProxy.LIST_DETAIL));
        Iterator it = this.convertIteratorToListIterator(group.iterator());
        while (it.hasPrevious()) {
            ListGroupHandle listGroup;
            listGroup = (ListGroupHandle)it.previous();
            SlotHandle groupFooters = listGroup.getFooter();
            this.addChild(new ListBandProxy(groupFooters, String.valueOf(ListBandProxy.LIST_GROUP_FOOTER) + number));
            --number;
        }
        slotHandle = handle.getFooter();
        this.addChild(new ListBandProxy(slotHandle, ListBandProxy.LIST_FOOTER));
        Comparator com = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof ListBandProxy && o2 instanceof ListBandProxy) {
                    ListBandProxy band1 = (ListBandProxy)o1;
                    ListBandProxy band2 = (ListBandProxy)o2;
                    if (band1.getType() != band2.getType()) {
                        return band1.getType() - band2.getType();
                    }
                    if (band1.getType() == 4) {
                        return band2.getDisplayName().compareToIgnoreCase(band1.getDisplayName());
                    }
                    return band1.getDisplayName().compareToIgnoreCase(band2.getDisplayName());
                }
                return 0;
            }
        };
        Collections.sort(this.children, com);
        return this.children;
    }

    private ListIterator convertIteratorToListIterator(Iterator iterator) {
        ArrayList list = new ArrayList();
        Iterator it = iterator;
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.listIterator(list.size());
    }

    private ListHandle getListHandle() {
        return (ListHandle)this.getHandle();
    }

    private void addChild(Object obj) {
        if (!this.children.contains(obj)) {
            this.children.add(obj);
        } else if (obj instanceof ListBandProxy) {
            int index = this.children.indexOf(obj);
            ListBandProxy proxy = (ListBandProxy)this.children.get(index);
            proxy.setDisplayName(((ListBandProxy)obj).getDisplayName());
        }
    }

    public ListGroupHandle insertGroup() throws ContentException, NameException {
        this.transStar(TRANS_LABEL_INSERT_GROUP);
        ListGroupHandle groupHandle = this.getListHandle().getElementFactory().newListGroup();
        SlotHandle handle = this.getListHandle().getGroups();
        handle.add((DesignElementHandle)groupHandle);
        this.transEnd();
        return groupHandle;
    }

    public void remove(Object model) {
        if (model instanceof ListGroupHandle) {
            ListGroupHandle group = (ListGroupHandle)model;
            this.children.remove(new ListBandProxy(group.getSlot(0)));
            this.children.remove(new ListBandProxy(group.getSlot(1)));
        }
        this.children.remove(model);
    }

    public void removeGroup(Object group) throws SemanticException {
        assert (group instanceof ListBandProxy);
        ((ListBandProxy)group).getElemtHandle().drop();
    }

    public Object getChild(int id) {
        int index = this.children.indexOf(new ListBandProxy(this.getListHandle().getSlot(id)));
        return this.children.get(index);
    }

    @Override
    public Dimension getSize() {
        DimensionHandle widthHandle = this.getListHandle().getWidth();
        int px = (int)DEUtil.convertoToPixel(widthHandle);
        DimensionHandle heightHandle = this.getListHandle().getHeight();
        int py = (int)DEUtil.convertoToPixel(heightHandle);
        if (DEUtil.isFixLayout(this.getHandle())) {
            if (px == 0 && widthHandle.isSet()) {
                px = 1;
            }
            if (py == 0 && heightHandle.isSet()) {
                py = 1;
            }
        }
        return new Dimension(px, py);
    }
}

