/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSetBindingSelector;
import org.eclipse.birt.report.designer.internal.ui.dialogs.TableOptionDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class TableOptionBindingDialog
extends TableOptionDialog {
    private DataSetBindingSelector selector;

    public TableOptionBindingDialog(Shell parentShell) {
        super(parentShell, true);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.loadPreference();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TableOptionBindingDialog.applyDialogFont((Control)composite);
        new Label(composite, 0).setText(MSG_DATA_SET);
        this.dataSetCombo = new Combo(composite, 2060);
        this.dataSetCombo.setLayoutData((Object)new GridData(768));
        this.dataSetCombo.setVisibleItemCount(30);
        String[] dataSets = ChoiceSetFactory.getDataSets();
        String[] newList = new String[dataSets.length + 1];
        System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
        newList[0] = NONE;
        this.dataSetCombo.setItems(newList);
        this.dataSetCombo.select(0);
        this.autoChk = new Button(composite, 32);
        this.autoChk.setText(Messages.getString((String)"TableOptionDialog.text.AutoSummary"));
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        gdata.verticalIndent = 10;
        gdata.horizontalIndent = 10;
        this.autoChk.setLayoutData((Object)gdata);
        this.autoChk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableOptionBindingDialog.this.dataSetCombo.getSelectionIndex() == 0) {
                    TableOptionBindingDialog.this.rowEditor.setEnabled(!TableOptionBindingDialog.this.autoChk.getSelection());
                }
            }
        });
        final Composite contentPane = new Composite(composite, 0);
        gdata = new GridData(1808);
        gdata.horizontalSpan = 2;
        gdata.minimumWidth = 400;
        gdata.minimumHeight = 250;
        contentPane.setLayoutData((Object)gdata);
        contentPane.setLayout((Layout)new GridLayout());
        this.createStaticUI(contentPane);
        this.dataSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableOptionBindingDialog.this.dataSetCombo.getSelectionIndex() > 0) {
                    TableOptionBindingDialog.this.createBindingUI(contentPane);
                } else {
                    TableOptionBindingDialog.this.createStaticUI(contentPane);
                }
                contentPane.layout();
            }
        });
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.TableOptionDialog_ID");
        return composite;
    }

    private void createStaticUI(Composite parent) {
        this.disposeChildren(parent);
        new Label(parent, 0).setText(MSG_TABLE_SIZE);
        Label sp = new Label(parent, 258);
        sp.setLayoutData((Object)new GridData(768));
        Composite innerPane = new Composite(parent, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        innerPane.setLayoutData((Object)gdata);
        GridLayout glayout = new GridLayout(2, false);
        glayout.marginWidth = 10;
        glayout.marginHeight = 10;
        innerPane.setLayout((Layout)glayout);
        new Label(innerPane, 0).setText(MSG_NUMBER_OF_COLUMNS);
        this.columnEditor = new Spinner(innerPane, 2048);
        this.columnEditor.setMinimum(1);
        this.columnEditor.setMaximum(Integer.MAX_VALUE);
        this.columnEditor.setIncrement(1);
        this.columnEditor.setSelection(this.columnCount);
        this.columnEditor.setLayoutData((Object)new GridData(768));
        new Label(innerPane, 0).setText(this.insertTable ? MSG_NUMBER_OF_TABLE_ROWS : MSG_NUMBER_OF_GRID_ROWS);
        this.rowEditor = new Spinner(innerPane, 2048);
        this.rowEditor.setMinimum(1);
        this.rowEditor.setMaximum(Integer.MAX_VALUE);
        this.rowEditor.setIncrement(1);
        this.rowEditor.setSelection(this.rowCount);
        this.rowEditor.setLayoutData((Object)new GridData(768));
        this.chkbox = new Button(innerPane, 32);
        this.chkbox.setText(this.insertTable ? MSG_REMEMBER_DIMENSIONS_FOR_NEW_TABLES : MSG_REMEMBER_DIMENSIONS_FOR_NEW_GRIDS);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.chkbox.setLayoutData((Object)gdata);
    }

    private void createBindingUI(Composite parent) {
        this.disposeChildren(parent);
        this.selector = new DataSetBindingSelector(UIUtil.getDefaultShell(), Messages.getString((String)"DataSetBindingSelectorPage.Title"));
        String dsName = this.dataSetCombo.getItem(this.dataSetCombo.getSelectionIndex());
        boolean isDataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(dsName) != null;
        this.selector.setDataSet(dsName, isDataSet);
        Control control = this.selector.createDialogArea(parent);
        control.setLayoutData((Object)new GridData(1808));
    }

    private void disposeChildren(Composite parent) {
        Control[] cc = parent.getChildren();
        if (cc != null) {
            Control[] controlArray = cc;
            int n = cc.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
        }
    }

    @Override
    protected void okPressed() {
        if (this.dataSetCombo.getSelectionIndex() == 0) {
            this.rowCount = this.rowEditor.getSelection();
            this.columnCount = this.columnEditor.getSelection();
            if (this.columnCount <= 0) {
                this.columnCount = 3;
            }
            if (this.rowCount <= 0) {
                this.rowCount = this.insertTable ? 1 : 3;
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = new Object[]{this.rowCount, this.columnCount, this.autoChk.getSelection()};
            this.setResult(objectArray);
            if (this.chkbox.getSelection()) {
                this.savePreference();
            }
        } else {
            this.selector.okPressed();
            this.setResult(new Object[]{new Object[]{1, 3, this.autoChk.getSelection()}, this.selector.getResult()});
        }
        this.setReturnCode(0);
        this.close();
    }
}

