/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.BorderInfomation;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.SortMap;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BorderCanvas
extends Canvas {
    private static final String INHERITED = Messages.getString((String)"BorderCanvas.Label.Inherited");
    private boolean mouseIn = false;
    private int mouseInArea = 0;
    private Listener listener;
    private SortMap borderInfoMap = new SortMap();

    public BorderCanvas(Composite parent, int style) {
        super(parent, 0);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                BorderCanvas.this.paintControl(e);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int width = BorderCanvas.this.getSize().x;
                int height = BorderCanvas.this.getSize().y;
                int x = (width - 100) / 2;
                int y = (height - 100) / 2;
                Region top = new Region();
                Region bottom = new Region();
                Region left = new Region();
                Region right = new Region();
                top.add(new Rectangle(x, y - 11, 100, 11));
                bottom.add(new Rectangle(x, y + 100, 100, 11));
                left.add(new Rectangle(x - 11, y, 11, 100));
                right.add(new Rectangle(x + 100, y, 11, 100));
                top.add(new int[]{x, y, x + 100, y, x + 50, y + 50});
                bottom.add(new int[]{x, y + 100, x + 100, y + 100, x + 50, y + 50});
                left.add(new int[]{x, y, x, y + 100, x + 50, y + 50});
                right.add(new int[]{x + 100, y, x + 100, y + 100, x + 50, y + 50});
                if (top.contains(e.x, e.y)) {
                    BorderCanvas.this.mouseIn = true;
                    BorderCanvas.this.mouseInArea = 128;
                } else if (bottom.contains(e.x, e.y)) {
                    BorderCanvas.this.mouseIn = true;
                    BorderCanvas.this.mouseInArea = 1024;
                } else if (left.contains(e.x, e.y)) {
                    BorderCanvas.this.mouseIn = true;
                    BorderCanvas.this.mouseInArea = 16384;
                } else if (right.contains(e.x, e.y)) {
                    BorderCanvas.this.mouseIn = true;
                    BorderCanvas.this.mouseInArea = 131072;
                } else {
                    BorderCanvas.this.mouseIn = false;
                    BorderCanvas.this.mouseInArea = 0;
                }
                top.dispose();
                bottom.dispose();
                right.dispose();
                left.dispose();
                if (BorderCanvas.this.mouseIn && BorderCanvas.this.listener != null) {
                    Event event = new Event();
                    event.detail = BorderCanvas.this.mouseInArea;
                    BorderCanvas.this.listener.handleEvent(event);
                }
            }
        });
    }

    public void setBorderInfomation(BorderInfomation info) {
        this.borderInfoMap.put(info.getPosition(), info);
    }

    private String resolveEmptyWidth(BorderInfomation info) {
        String width = info.getWidth();
        if ("".equals(width)) {
            return "medium";
        }
        return width;
    }

    protected void paintControl(PaintEvent e) {
        GC gc = e.gc;
        gc.setLineStyle(3);
        gc.setLineWidth(1);
        int width = this.getSize().x;
        int height = this.getSize().y;
        int x = (width - 100) / 2;
        int y = (height - 100) / 2;
        gc.drawLine(x - 10 - 1, y - 1, x - 1, y - 1);
        gc.drawLine(x + 100 + 1, y - 1, x + 100 + 10 + 1, y - 1);
        gc.drawLine(x - 10 - 1, y + 100 + 1, x - 1, y + 100 + 1);
        gc.drawLine(x + 100 + 1, y + 100 + 1, x + 100 + 10 + 1, y + 100 + 1);
        gc.drawLine(x - 1, y - 10 - 1, x - 1, y - 1);
        gc.drawLine(x - 1, y + 100 + 1, x - 1, y + 100 + 10 + 1);
        gc.drawLine(x + 100 + 1, y - 10 - 1, x + 100 + 1, y - 1);
        gc.drawLine(x + 100 + 1, y + 100 + 1, x + 100 + 1, y + 100 + 10 + 1);
        int i = 0;
        while (i < this.borderInfoMap.size()) {
            BorderInfomation info = (BorderInfomation)this.borderInfoMap.get(i);
            if (info.getStyle() != null && !info.getStyle().equals("")) {
                if (info.getColor() == null) {
                    gc.setForeground(this.getDisplay().getSystemColor(2));
                } else {
                    gc.setForeground(ColorManager.getColor((RGB)info.getColor()));
                }
                if (!info.getStyle().equals("double")) {
                    if ("dotted".equals(info.getStyle())) {
                        gc.setLineStyle(3);
                    } else if ("dashed".equals(info.getStyle())) {
                        gc.setLineStyle(2);
                    } else if ("solid".equals(info.getStyle())) {
                        gc.setLineStyle(1);
                    }
                    if (!"none".equals(info.getStyle())) {
                        this.drawLine(gc, width, height, info, true);
                    } else {
                        this.drawLine(gc, width, height, info, false);
                    }
                } else {
                    gc.setLineStyle(1);
                    int gcWidth = 1;
                    int gcSeperator = 1;
                    int gcInnerWidth = 1;
                    int customWidth = -1;
                    String infoWidth = this.resolveEmptyWidth(info);
                    if (!("thin".equals(infoWidth) || "medium".equals(infoWidth) || "thick".equals(infoWidth) || infoWidth == null)) {
                        try {
                            customWidth = (int)DimensionValue.parse((String)infoWidth).getMeasure();
                            if (DimensionValue.parse((String)infoWidth).getUnits().equals("px")) {
                                if (customWidth % 3 == 0) {
                                    gcSeperator = gcInnerWidth = customWidth / 3;
                                    gcWidth = gcInnerWidth;
                                } else if (customWidth % 3 == 1) {
                                    gcWidth = customWidth / 3 + 1;
                                    gcSeperator = gcInnerWidth = customWidth / 3;
                                } else {
                                    gcWidth = gcSeperator = customWidth / 3 + 1;
                                    gcInnerWidth = customWidth / 3;
                                }
                            }
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle(e1);
                        }
                    }
                    if (customWidth > 3) {
                        gc.setLineWidth(gcWidth);
                        if (info.getPosition().equals("left")) {
                            gc.drawLine((width - 100) / 2 + gc.getLineWidth() / 2, (height - 100) / 2, (width - 100) / 2 + gc.getLineWidth() / 2, (height - 100) / 2 + 100 + 1);
                        } else if (info.getPosition().equals("top")) {
                            gc.drawLine((width - 100) / 2, (height - 100) / 2 + gc.getLineWidth() / 2, (width - 100) / 2 + 100 + 1, (height - 100) / 2 + gc.getLineWidth() / 2);
                        } else if (info.getPosition().equals("right")) {
                            gc.drawLine((width - 100) / 2 + 100 - gc.getLineWidth() / 2 + 1, (height - 100) / 2, (width - 100) / 2 + 100 - gc.getLineWidth() / 2 + 1, (height - 100) / 2 + 100 + 1);
                        } else if (info.getPosition().equals("bottom")) {
                            gc.drawLine((width - 100) / 2, (height - 100) / 2 + 100 - gc.getLineWidth() / 2 + 1, (width - 100) / 2 + 100 + 1, (height - 100) / 2 + 100 - gc.getLineWidth() / 2 + 1);
                        }
                        gc.setLineWidth(gcInnerWidth);
                        if (info.getPosition().equals("left")) {
                            gc.drawLine((width - 100) / 2 + (gcWidth + gcSeperator) + gc.getLineWidth() / 2, (height - 100) / 2 + (gcWidth + gcSeperator), (width - 100) / 2 + (gcWidth + gcSeperator) + gc.getLineWidth() / 2, (height - 100) / 2 + 100 - (gcWidth + gcSeperator));
                        } else if (info.getPosition().equals("top")) {
                            gc.drawLine((width - 100) / 2 + (gcWidth + gcSeperator), (height - 100) / 2 + (gcWidth + gcSeperator) + gc.getLineWidth() / 2, (width - 100) / 2 + 100 - (gcWidth + gcSeperator), (height - 100) / 2 + (gcWidth + gcSeperator) + gc.getLineWidth() / 2);
                        } else if (info.getPosition().equals("right")) {
                            gc.drawLine((width - 100) / 2 + 100 - (gcWidth + gcSeperator) - gc.getLineWidth() / 2, (height - 100) / 2 + (gcWidth + gcSeperator), (width - 100) / 2 + 100 - (gcWidth + gcSeperator) - gc.getLineWidth() / 2, (height - 100) / 2 + 100 - (gcWidth + gcSeperator));
                        } else if (info.getPosition().equals("bottom")) {
                            gc.drawLine((width - 100) / 2 + (gcWidth + gcSeperator), (height - 100) / 2 + 100 - (gcWidth + gcSeperator) - gc.getLineWidth() / 2, (width - 100) / 2 + 100 - (gcWidth + gcSeperator), (height - 100) / 2 + 100 - (gcWidth + gcSeperator) - gc.getLineWidth() / 2);
                        }
                    } else if (customWidth == 3 || "thick".equals(info.getWidth())) {
                        gc.setLineWidth(1);
                        if (info.getPosition().equals("left")) {
                            gc.drawLine((width - 100) / 2, (height - 100) / 2, (width - 100) / 2, (height - 100) / 2 + 100);
                            gc.drawLine((width - 100) / 2 + 2, (height - 100) / 2 + 2, (width - 100) / 2 + 2, (height - 100) / 2 + 100 - 2);
                        } else if (info.getPosition().equals("top")) {
                            gc.drawLine((width - 100) / 2, (height - 100) / 2, (width - 100) / 2 + 100, (height - 100) / 2);
                            gc.drawLine((width - 100) / 2 + 2, (height - 100) / 2 + 2, (width - 100) / 2 + 100 - 2, (height - 100) / 2 + 2);
                        } else if (info.getPosition().equals("right")) {
                            gc.drawLine((width - 100) / 2 + 100, (height - 100) / 2, (width - 100) / 2 + 100, (height - 100) / 2 + 100);
                            gc.drawLine((width - 100) / 2 + 100 - 2, (height - 100) / 2 + 2, (width - 100) / 2 + 100 - 2, (height - 100) / 2 + 100 - 2);
                        } else if (info.getPosition().equals("bottom")) {
                            gc.drawLine((width - 100) / 2, (height - 100) / 2 + 100, (width - 100) / 2 + 100, (height - 100) / 2 + 100);
                            gc.drawLine((width - 100) / 2 + 2, (height - 100) / 2 + 100 - 2, (width - 100) / 2 + 100 - 2, (height - 100) / 2 + 100 - 2);
                        }
                    } else {
                        gc.setLineStyle(1);
                        gc.setLineWidth(1);
                        this.drawLine(gc, width, height, info, true);
                    }
                }
            }
            ++i;
        }
    }

    private void drawLine(GC gc, int width, int height, BorderInfomation info, boolean drawLine) {
        String infoWidth = this.resolveEmptyWidth(info);
        if ("thin".equals(infoWidth)) {
            gc.setLineWidth(1);
        } else if ("medium".equals(infoWidth)) {
            gc.setLineWidth(2);
        } else if ("thick".equals(infoWidth)) {
            gc.setLineWidth(3);
        } else {
            try {
                if (infoWidth != null) {
                    int customWidth = (int)DimensionValue.parse((String)infoWidth).getMeasure();
                    if (DimensionValue.parse((String)infoWidth).getUnits().equals("px")) {
                        gc.setLineWidth(customWidth);
                    }
                }
            }
            catch (Exception e1) {
                ExceptionHandler.handle(e1);
            }
        }
        if (info.getPosition().equals("left")) {
            if (drawLine) {
                gc.drawLine((width - 100) / 2 + gc.getLineWidth() / 2, (height - 100) / 2, (width - 100) / 2 + gc.getLineWidth() / 2, (height - 100) / 2 + 100);
            }
            if (this.isInheritedInfo(info)) {
                gc.setAdvanced(true);
                FontData fontData = this.getFont().getFontData()[0];
                fontData.setHeight(9);
                Font font = new Font(gc.getDevice(), fontData);
                gc.setFont(font);
                gc.setForeground(ColorConstants.darkGreen);
                Point size = gc.stringExtent(INHERITED);
                Transform transform = new Transform(gc.getDevice());
                transform.translate(-1.0f, (float)(height + (height - 100) / 2 - size.y));
                transform.rotate(-90.0f);
                gc.setTransform(transform);
                gc.drawText(INHERITED, (width - size.x) / 2, (height - 100) / 2 - size.y);
                font.dispose();
                transform.dispose();
                gc.setTransform(null);
                gc.setAdvanced(false);
            }
        } else if (info.getPosition().equals("top")) {
            if (drawLine) {
                gc.drawLine((width - 100) / 2, (height - 100) / 2 + gc.getLineWidth() / 2, (width - 100) / 2 + 100, (height - 100) / 2 + gc.getLineWidth() / 2);
            }
            if (this.isInheritedInfo(info)) {
                FontData fontData = this.getFont().getFontData()[0];
                fontData.setHeight(9);
                Font font = new Font(gc.getDevice(), fontData);
                gc.setFont(font);
                gc.setForeground(ColorConstants.darkGreen);
                Point size = gc.stringExtent(INHERITED);
                gc.drawText(INHERITED, (width - size.x) / 2, (height - 100) / 2 - size.y - 1);
                font.dispose();
            }
        } else if (info.getPosition().equals("right")) {
            if (drawLine) {
                gc.drawLine((width - 100) / 2 + 100 - gc.getLineWidth() / 2, (height - 100) / 2, (width - 100) / 2 + 100 - gc.getLineWidth() / 2, (height - 100) / 2 + 100);
            }
            if (this.isInheritedInfo(info)) {
                gc.setAdvanced(true);
                FontData fontData = this.getFont().getFontData()[0];
                fontData.setHeight(9);
                Font font = new Font(gc.getDevice(), fontData);
                gc.setFont(font);
                gc.setForeground(ColorConstants.darkGreen);
                Point size = gc.stringExtent(INHERITED);
                Transform transform = new Transform(gc.getDevice());
                transform.translate((float)(width + 2), 0.0f);
                transform.rotate(90.0f);
                gc.setTransform(transform);
                gc.drawText(INHERITED, (width - size.x) / 2, (height - 100) / 2 - size.y);
                font.dispose();
                transform.dispose();
                gc.setTransform(null);
                gc.setAdvanced(false);
            }
        } else if (info.getPosition().equals("bottom")) {
            if (drawLine) {
                gc.drawLine((width - 100) / 2, (height - 100) / 2 + 100 - gc.getLineWidth() / 2, (width - 100) / 2 + 100, (height - 100) / 2 + 100 - gc.getLineWidth() / 2);
            }
            if (this.isInheritedInfo(info)) {
                FontData fontData = this.getFont().getFontData()[0];
                fontData.setHeight(9);
                Font font = new Font(gc.getDevice(), fontData);
                gc.setFont(font);
                gc.setForeground(ColorConstants.darkGreen);
                Point size = gc.stringExtent(INHERITED);
                gc.drawText(INHERITED, (width - size.x) / 2, (height - 100) / 2 + 100 + 1);
                font.dispose();
            }
        }
    }

    protected boolean isInheritedInfo(BorderInfomation info) {
        return info.isInheritedColor() && info.isInheritedStyle() && info.isInheritedWidth();
    }

    public void removeBorderInfomation(String position) {
        this.borderInfoMap.remove(position);
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }
}

