/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.InputParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.InputParameterSelectionChoice;
import org.eclipse.birt.report.designer.ui.dialogs.SelectionParameterControlHelper;
import org.eclipse.birt.report.designer.ui.parameters.ComboBoxParameter;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

class ComboParameterControlHelper
extends SelectionParameterControlHelper {
    private Combo combo;

    public ComboParameterControlHelper(InputParameterDialog dialog) {
        super(dialog);
    }

    @Override
    Control getControl() {
        return this.combo;
    }

    @Override
    protected void createParameterControl() {
        this.createCombo();
    }

    private void createCombo() {
        this.createRawCombo();
        this.initCombo();
    }

    private void createRawCombo() {
        int style = 2048;
        if (!(this.parameter instanceof ComboBoxParameter)) {
            style |= 8;
        }
        this.combo = new Combo(this.parent, style);
        this.combo.setLayoutData((Object)new GridData(768));
        this.combo.setVisibleItemCount(30);
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!(ComboParameterControlHelper.this.parameter instanceof ComboBoxParameter)) {
                    return;
                }
                Combo combo = (Combo)e.getSource();
                if (combo.indexOf(combo.getText()) < 0) {
                    try {
                        ComboParameterControlHelper.this.putConfigValue(ComboParameterControlHelper.this.paramterHandleName, ComboParameterControlHelper.this.parameter.converToDataType(combo.getText()));
                    }
                    catch (BirtException e1) {
                        MessageDialog.openError((Shell)combo.getShell(), (String)Messages.getString((String)"InputParameterDialog.err.invalidValueTitle"), (String)Messages.getFormattedString((String)"InputParameterDialog.err.invalidValue", (Object[])new String[]{combo.getText(), ComboParameterControlHelper.this.parameter.getHandle().getDataType()}));
                        return;
                    }
                } else {
                    ComboParameterControlHelper.this.putConfigValue(ComboParameterControlHelper.this.paramterHandleName, combo.getData(String.valueOf(combo.indexOf(combo.getText()))));
                }
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                if (combo.getSelectionIndex() != -1) {
                    ComboParameterControlHelper.this.putConfigValue(ComboParameterControlHelper.this.paramterHandleName, combo.getData(String.valueOf(combo.getSelectionIndex())));
                }
                ComboParameterControlHelper.this.doWithCascadeGroup();
            }
        });
    }

    private void initCombo() {
        int selectIndex = -1;
        boolean nullAdded = false;
        for (IParameterSelectionChoice choice : this.valueList) {
            String label = this.getFormatLabelString(choice, this.parameter);
            if (choice.getValue() == null && choice.getLabel() == null) {
                if (this.isRequired || nullAdded) continue;
                this.combo.add(NULL_VALUE_STR);
                this.combo.setData(String.valueOf(this.combo.getItemCount() - 1), null);
                this.addItemForControlReset(NULL_VALUE_STR);
                nullAdded = true;
                continue;
            }
            this.combo.add(label);
            this.combo.setData(String.valueOf(this.combo.getItemCount() - 1), choice.getValue());
            this.addItemForControlReset(label);
            if (choice.getValue() == null || !choice.getValue().equals(this.defaultValue) || choice.getLabel() == null || choice.getLabel().equals(InputParameterSelectionChoice.BLANKVALUECHOICE.getValue())) continue;
            selectIndex = this.combo.getItemCount() - 1;
        }
        if (this.defaultValue == null) {
            if (!this.isRequired) {
                this.combo.select(this.combo.getItemCount() - 1);
            }
            this.parameter.setSelectionValue(null);
            this.putConfigValue(this.paramterHandleName, null);
        } else {
            this.setSelectValueAfterInitCombo(selectIndex, this.combo);
        }
        this.addCascadeParamterRelation();
    }
}

