/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.util.ResourceLocatorUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XMLFileSchemaTreePopulator;
import org.w3c.dom.ls.LSInput;

final class XSDFileSchemaTreePopulator {
    private static final String ROOT_LITERAL = "ROOT";

    XSDFileSchemaTreePopulator() {
    }

    public static ATreeNode getSchemaTree(String schemafileName, String xmlFileName, String xmlEncoding, Object resourceIdentifiers) throws OdaException, MalformedURLException, URISyntaxException {
        ATreeNode xmlRoot = new XMLFileSchemaTreePopulator(2).getSchemaTree(xmlFileName, xmlEncoding, resourceIdentifiers);
        XSNamedMap map = XSDFileSchemaTreePopulator.loadSchema(schemafileName, xmlEncoding, resourceIdentifiers);
        ATreeNode xsdRoot = new ATreeNode();
        xsdRoot.setValue(ROOT_LITERAL);
        int i = 0;
        while (i < map.getLength()) {
            XSElementDecl element = (XSElementDecl)map.item(i);
            ATreeNode node = new ATreeNode(element);
            xsdRoot.addChild(node);
            if (xmlRoot != null && node.getValue().equals(((ATreeNode)xmlRoot.getChildren()[0]).getValue())) {
                xsdRoot = new ATreeNode();
                xsdRoot.setValue(ROOT_LITERAL);
                xsdRoot.addChild(node);
                break;
            }
            ++i;
        }
        return xsdRoot;
    }

    private static XSNamedMap loadSchema(String schemafileName, String xmlEncoding, Object resourceIdentifiers) throws MalformedURLException, URISyntaxException, OdaException {
        if (xmlEncoding == null || xmlEncoding.length() == 0) {
            return XSDFileSchemaTreePopulator.loadSchema(schemafileName, resourceIdentifiers);
        }
        return XSDFileSchemaTreePopulator.loadSchemaWithEncoding(schemafileName, xmlEncoding, resourceIdentifiers);
    }

    private static XSNamedMap loadSchema(String schemafileName, Object resourceIdentifiers) throws MalformedURLException, URISyntaxException, OdaException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLSchemaLoader xsLoader = new XMLSchemaLoader();
        XSModel xsModel = null;
        URI uri = ResourceLocatorUtil.resolvePath(resourceIdentifiers, schemafileName);
        if (uri == null) {
            throw new OdaException(String.valueOf(Messages.getString("ui.xsdFileNotFound")) + schemafileName);
        }
        xsModel = xsLoader.loadURI(uri.toString());
        if (xsModel == null) {
            throw new OdaException(Messages.getString("ui.invalidXSDFile"));
        }
        return xsModel.getComponents((short)2);
    }

    private static XSNamedMap loadSchemaWithEncoding(String schemafileName, String xmlEncoding, Object resourceIdentifiers) throws MalformedURLException, URISyntaxException, OdaException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        XMLSchemaLoader xsLoader = new XMLSchemaLoader();
        DOMInputImpl input = new DOMInputImpl();
        try {
            input.setCharacterStream(new BufferedReader(new InputStreamReader(ResourceLocatorUtil.getInputStream(resourceIdentifiers, schemafileName))));
        }
        catch (OdaException e) {
            throw new OdaException(String.valueOf(Messages.getString("ui.invalidXSDFile")) + e.getLocalizedMessage());
        }
        input.setEncoding(xmlEncoding);
        XSModel xsModel = xsLoader.load((LSInput)input);
        if (xsModel == null) {
            throw new OdaException(Messages.getString("ui.invalidXSDFile"));
        }
        return xsModel.getComponents((short)2);
    }

    public static ATreeNode getSchemaTree(String xsdFileName, String xmlEncoding, Object resourceIdentifiers) throws OdaException, MalformedURLException, URISyntaxException {
        XSNamedMap map = XSDFileSchemaTreePopulator.loadSchema(xsdFileName, xmlEncoding, resourceIdentifiers);
        ATreeNode root = new ATreeNode();
        root.setValue(ROOT_LITERAL);
        int i = 0;
        while (i < map.getLength()) {
            XSElementDecl element = (XSElementDecl)map.item(i);
            ATreeNode node = new ATreeNode(element);
            node.setValue(element.getName());
            node.setType(1);
            node.setDataType(element.getName());
            root.addChild(node);
            ++i;
        }
        return root;
    }

    public static ATreeNode getSchemaTree(String xsdFileName, Object resourceIdentifiers) throws OdaException, MalformedURLException, URISyntaxException {
        return XSDFileSchemaTreePopulator.getSchemaTree(xsdFileName, null, resourceIdentifiers);
    }
}

