/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.PublishAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Description;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.DiscoveryURL;
import org.uddi4j.util.DiscoveryURLs;
import org.uddi4j.util.IdentifierBag;
import org.uddi4j.util.KeyedReference;

public class RegPublishBusinessAdvancedAction
extends PublishAction {
    public RegPublishBusinessAdvancedAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(0));
        this.propertyTable_.put("queryStyleBusinesses", String.valueOf(1));
    }

    @Override
    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        int i;
        String[] parameters;
        String[] nameLanguages = parser.getParameterValues("advancedNameLanguage");
        String[] names = parser.getParameterValues("advancedName");
        String[] descriptionLanguages = parser.getParameterValues("advancedDescriptionLanguage");
        String[] descriptions = parser.getParameterValues("advancedDescription");
        String[] idTypes = parser.getParameterValues("advancedIdentifierType");
        String[] idKeyNames = parser.getParameterValues("advancedIdentifierKeyName");
        String[] idKeyValues = parser.getParameterValues("advancedIdentifierKeyValue");
        String[] catTypes = parser.getParameterValues("advancedCategoryType");
        String[] catKeyNames = parser.getParameterValues("advancedCategoryKeyName");
        String[] catKeyValues = parser.getParameterValues("advancedCategoryKeyValue");
        String[] discoveryURLValues = parser.getParameterValues("advancedDiscoveryURL");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        Hashtable<String, Boolean> languageHash = new Hashtable<String, Boolean>();
        if (nameLanguages != null && names != null) {
            Vector<Name> nameVector = new Vector<Name>();
            parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_NAME");
            i = 0;
            while (i < names.length) {
                Name uddi4jName;
                parameters[1] = String.valueOf(i + 1);
                if (nameLanguages[i].length() > 0) {
                    uddi4jName = new Name(names[i], nameLanguages[i]);
                } else {
                    uddi4jName = new Name(names[i]);
                    if (i != 0 && !this.subQueryInitiated_) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedBusinessNames", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(nameLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessNames", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(nameLanguages[i], Boolean.TRUE);
                }
                if (names[i].trim().length() < 1) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessNames", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                nameVector.addElement(uddi4jName);
                ++i;
            }
            this.propertyTable_.put("advancedBusinessNames", nameVector);
        } else {
            this.removeProperty("advancedBusinessNames");
            if (!this.subQueryInitiated_) {
                inputsValid = false;
                formToolPI.flagError("advancedBusinessNames");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_NO_NAMES"));
            }
        }
        if (descriptionLanguages != null && descriptions != null) {
            Vector<Description> descriptionVector = new Vector<Description>();
            parameters = new String[2];
            parameters[0] = uddiPerspective.getMessage("FORM_LABEL_DESCRIPTION");
            languageHash.clear();
            i = 0;
            while (i < descriptions.length) {
                Description uddi4jDescription;
                parameters[1] = String.valueOf(i + 1);
                if (descriptionLanguages[i].length() > 0) {
                    uddi4jDescription = new Description(descriptions[i], descriptionLanguages[i]);
                } else {
                    uddi4jDescription = new Description(descriptions[i]);
                    if (i != 0 && !this.subQueryInitiated_) {
                        inputsValid = false;
                        formToolPI.flagRowError((Object)"advancedBusinessDescriptions", i);
                        messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_BLANK_LANGUAGE", parameters));
                    }
                }
                if (languageHash.get(descriptionLanguages[i]) != null) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_DUPLICATE_LANGUAGE", parameters));
                } else {
                    languageHash.put(descriptionLanguages[i], Boolean.TRUE);
                }
                if (descriptions[i].trim().length() < 1) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessDescriptions", i);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters));
                }
                descriptionVector.addElement(uddi4jDescription);
                ++i;
            }
            this.propertyTable_.put("advancedBusinessDescriptions", descriptionVector);
        } else {
            this.removeProperty("advancedBusinessDescriptions");
        }
        if (idTypes != null && idKeyNames != null && idKeyValues != null) {
            IdentifierBag idBag = new IdentifierBag();
            int i2 = 0;
            while (i2 < idKeyNames.length) {
                KeyedReference kr = new KeyedReference(idKeyNames[i2], idKeyValues[i2], idTypes[i2]);
                idBag.add(kr);
                ++i2;
            }
            this.propertyTable_.put("advancedBusinessIdentifiers", idBag);
        } else {
            this.removeProperty("advancedBusinessIdentifiers");
        }
        if (catTypes != null && catKeyNames != null && catKeyValues != null) {
            CategoryBag catBag = new CategoryBag();
            int i3 = 0;
            while (i3 < catTypes.length) {
                KeyedReference kr = new KeyedReference(catKeyNames[i3], catKeyValues[i3], catTypes[i3]);
                catBag.add(kr);
                ++i3;
            }
            this.propertyTable_.put("advancedBusinessCategories", catBag);
        } else {
            this.removeProperty("advancedBusinessCategories");
        }
        if (discoveryURLValues != null) {
            DiscoveryURLs discoveryURLs = new DiscoveryURLs();
            String[] parameters2 = new String[2];
            parameters2[0] = uddiPerspective.getMessage("FORM_LABEL_DISCOVERYURL");
            int i4 = 0;
            while (i4 < discoveryURLValues.length) {
                parameters2[1] = String.valueOf(i4 + 1);
                if (!this.subQueryInitiated_ && !Validator.validateURL(discoveryURLValues[i4])) {
                    inputsValid = false;
                    formToolPI.flagRowError((Object)"advancedBusinessDiscoveryURLs", i4);
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_ROW_INVALID_TEXT", parameters2));
                }
                discoveryURLs.add(new DiscoveryURL(discoveryURLValues[i4], ""));
                ++i4;
            }
            this.propertyTable_.put("advancedBusinessDiscoveryURLs", discoveryURLs);
        } else {
            this.removeProperty("advancedBusinessDiscoveryURLs");
        }
        return inputsValid;
    }

    @Override
    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            String userId = (String)this.propertyTable_.get("advancedUserId");
            String password = (String)this.propertyTable_.get("advancedPassword");
            Vector nameVector = (Vector)this.propertyTable_.get("advancedBusinessNames");
            Vector descriptionVector = (Vector)this.propertyTable_.get("advancedBusinessDescriptions");
            IdentifierBag identifierBag = (IdentifierBag)this.propertyTable_.get("advancedBusinessIdentifiers");
            CategoryBag categoryBag = (CategoryBag)this.propertyTable_.get("advancedBusinessCategories");
            DiscoveryURLs discoveryURLs = (DiscoveryURLs)this.propertyTable_.get("advancedBusinessDiscoveryURLs");
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            if (!regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            UDDIProxy proxy = regElement.getProxy();
            BusinessEntity be = new BusinessEntity();
            be.setBusinessKey("");
            be.setNameVector(nameVector);
            be.setDescriptionVector(descriptionVector);
            be.setIdentifierBag(identifierBag);
            be.setCategoryBag(categoryBag);
            be.setDiscoveryURLs(discoveryURLs);
            Vector<BusinessEntity> beVector = new Vector<BusinessEntity>();
            beVector.add(be);
            be = (BusinessEntity)proxy.save_business(regElement.getAuthInfoString(), beVector).getBusinessEntityVector().get(0);
            this.addPublishedItemNode(be, regElement);
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_BUSINESS_PUBLISHED", be.getDefaultNameString()));
            return true;
        }
        catch (TransportException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (MalformedURLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("MalformedURLException");
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

