/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment;

import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentMapper;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleAtomicDateTimeFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleAtomicDateTimeRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleAtomicEnumFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleAtomicEnumRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleAtomicFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleAtomicFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleAtomicRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleListFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleListRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleUnionFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDSimpleUnionRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.util.OptionVector;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.util.XSDTypeDefinitionUtil;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.xsd.WSDLPartsToXSDTypeMapper;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDSimpleTypeToFragmentMapper
extends XSDToFragmentMapper {
    public XSDSimpleTypeToFragmentMapper(XSDToFragmentController controller, WSDLPartsToXSDTypeMapper wsdlToXSDMapper) {
        super(controller, wsdlToXSDMapper);
    }

    @Override
    public IXSDFragment getFragment(XSDToFragmentConfiguration config, String id, String name) {
        XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)config.getXSDComponent();
        if (simpleType != null && simpleType.getVariety() != null) {
            switch (simpleType.getVariety().getValue()) {
                case 0: {
                    return this.getXSDSimpleAtomicFragment(config, id, name);
                }
                case 1: {
                    return this.getXSDSimpleListFragment(config, id, name);
                }
                case 2: {
                    return this.getXSDSimpleUnionFragment(config, id, name);
                }
            }
            return this.getXSDDefaultFragment(config, id, name);
        }
        return this.getXSDDefaultFragment(config, id, name);
    }

    private IXSDFragment getXSDSimpleAtomicFragment(XSDToFragmentConfiguration config, String id, String name) {
        boolean isFixed = config.getMinOccurs() == config.getMaxOccurs() && config.getMaxOccurs() != -1;
        XSDSimpleTypeDefinition xsdSimpleTypeDef = (XSDSimpleTypeDefinition)config.getXSDComponent();
        XSDSimpleTypeDefinition xsdBaseSimpleTypeDef = (XSDSimpleTypeDefinition)XSDTypeDefinitionUtil.resolveToXSDBuiltInTypeDefinition((XSDTypeDefinition)xsdSimpleTypeDef);
        String baseSimpleTypeDefNS = null;
        String baseSimpleTypeDefName = null;
        if (xsdBaseSimpleTypeDef != null) {
            baseSimpleTypeDefNS = xsdBaseSimpleTypeDef.getTargetNamespace();
            baseSimpleTypeDefName = xsdBaseSimpleTypeDef.getName();
        }
        boolean isEnum = this.isSimpleTypeEnumeration(xsdSimpleTypeDef);
        if ("http://www.w3.org/2001/XMLSchema".equals(baseSimpleTypeDefNS)) {
            if (baseSimpleTypeDefName.equals("date")) {
                return this.getXSDSimpleDateTimeFragment(id, name, config, 0, xsdSimpleTypeDef, isEnum, isFixed);
            }
            if (baseSimpleTypeDefName.equals("dateTime")) {
                return this.getXSDSimpleDateTimeFragment(id, name, config, 1, xsdSimpleTypeDef, isEnum, isFixed);
            }
            if (baseSimpleTypeDefName.equals("gYearMonth")) {
                return this.getXSDSimpleDateTimeFragment(id, name, config, 2, xsdSimpleTypeDef, isEnum, isFixed);
            }
            if (baseSimpleTypeDefName.equals("gMonthDay")) {
                return this.getXSDSimpleDateTimeFragment(id, name, config, 4, xsdSimpleTypeDef, isEnum, isFixed);
            }
            if (baseSimpleTypeDefName.equals("gDay")) {
                return this.getXSDSimpleGDayFragment(id, name, config, xsdSimpleTypeDef, isEnum, isFixed);
            }
            if (baseSimpleTypeDefName.equals("boolean")) {
                return this.getXSDSimpleBooleanFragment(id, name, config, xsdSimpleTypeDef, isEnum, isFixed);
            }
        }
        if (isEnum) {
            if (isFixed) {
                return new XSDSimpleAtomicEnumFixFragment(id, name, config, xsdSimpleTypeDef.getEnumerationFacets());
            }
            return new XSDSimpleAtomicEnumRangeFragment(id, name, config, xsdSimpleTypeDef.getEnumerationFacets());
        }
        if (isFixed) {
            return new XSDSimpleAtomicFixFragment(id, name, config);
        }
        return new XSDSimpleAtomicRangeFragment(id, name, config);
    }

    private XSDSimpleAtomicFragment getXSDSimpleDateTimeFragment(String id, String name, XSDToFragmentConfiguration config, int calendarType, XSDSimpleTypeDefinition xsdDateTimeType, boolean isEnum, boolean isFixed) {
        if (isEnum) {
            if (isFixed) {
                return new XSDSimpleAtomicEnumFixFragment(id, name, config, xsdDateTimeType.getEnumerationFacets());
            }
            return new XSDSimpleAtomicEnumRangeFragment(id, name, config, xsdDateTimeType.getEnumerationFacets());
        }
        if (isFixed) {
            return new XSDSimpleAtomicDateTimeFixFragment(id, name, config, calendarType);
        }
        return new XSDSimpleAtomicDateTimeRangeFragment(id, name, config, calendarType);
    }

    private XSDSimpleAtomicFragment getXSDSimpleGDayFragment(String id, String name, XSDToFragmentConfiguration config, XSDSimpleTypeDefinition xsdDateTimeType, boolean isEnum, boolean isFixed) {
        if (isEnum) {
            return null;
        }
        OptionVector optionVector = new OptionVector();
        StringBuffer value = new StringBuffer();
        int i = 1;
        while (i <= 31) {
            value.setLength(0);
            value.append("---");
            if (i < 10) {
                value.append(0);
            }
            value.append(i);
            optionVector.addOption(String.valueOf(i), value.toString());
            ++i;
        }
        if (isFixed) {
            return new XSDSimpleAtomicEnumFixFragment(id, name, config, optionVector);
        }
        return new XSDSimpleAtomicEnumRangeFragment(id, name, config, optionVector);
    }

    private XSDSimpleAtomicFragment getXSDSimpleBooleanFragment(String id, String name, XSDToFragmentConfiguration config, XSDSimpleTypeDefinition xsdBooleanType, boolean isEnum, boolean isFixed) {
        if (isEnum) {
            return null;
        }
        OptionVector optionVector = new OptionVector();
        optionVector.addOption("true", "true");
        optionVector.addOption("false", "false");
        if (isFixed) {
            return new XSDSimpleAtomicEnumFixFragment(id, name, config, optionVector);
        }
        return new XSDSimpleAtomicEnumRangeFragment(id, name, config, optionVector);
    }

    private IXSDFragment getXSDSimpleListFragment(XSDToFragmentConfiguration config, String id, String name) {
        boolean isFixed;
        boolean bl = isFixed = config.getMinOccurs() == config.getMaxOccurs() && config.getMaxOccurs() != -1;
        if (isFixed) {
            return new XSDSimpleListFixFragment(id, name, config, this.getController());
        }
        return new XSDSimpleListRangeFragment(id, name, config, this.getController());
    }

    private IXSDFragment getXSDSimpleUnionFragment(XSDToFragmentConfiguration config, String id, String name) {
        boolean isFixed;
        boolean bl = isFixed = config.getMinOccurs() == config.getMaxOccurs() && config.getMaxOccurs() != -1;
        if (isFixed) {
            return new XSDSimpleUnionFixFragment(id, name, config, this.getController());
        }
        return new XSDSimpleUnionRangeFragment(id, name, config, this.getController());
    }

    private boolean isSimpleTypeEnumeration(XSDSimpleTypeDefinition simpleType) {
        EList e = simpleType.getEnumerationFacets();
        return e != null && e.size() > 0;
    }
}

