/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard;

import java.text.MessageFormat;
import java.util.Vector;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskChangeListener;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class ChartAdapter
extends EContentAdapter {
    private Vector<ITaskChangeListener> vListeners = new Vector();
    private static boolean bIgnoreNotifications = false;
    private static boolean needUpdateApply = false;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui/swt");
    private transient WizardBase wizardContainer;

    public ChartAdapter(WizardBase wizardContainer) {
        this.wizardContainer = wizardContainer;
    }

    public void notifyChanged(Notification notification) {
        if (needUpdateApply && this.wizardContainer instanceof ChartWizard) {
            ((ChartWizard)this.wizardContainer).updateApplyButton();
        }
        if (bIgnoreNotifications || notification.isTouch()) {
            needUpdateApply = false;
            return;
        }
        logger.log(1, new MessageFormat(Messages.getString("ChartAdapter.Info.NotificationRecieved")).format(new Object[]{notification.getNotifier().getClass().getName()}));
        logger.log(1, new MessageFormat(Messages.getString("ChartAdapter.Info.NewValue")).format(new Object[]{notification.getNewValue()}));
        int iC = 0;
        while (iC < this.vListeners.size()) {
            ITaskChangeListener changeLs = this.vListeners.elementAt(iC);
            if (this.wizardContainer.getCurrentTask() == changeLs || !(this.wizardContainer.getCurrentTask() instanceof ITaskChangeListener)) {
                changeLs.changeTask(notification);
            }
            ++iC;
        }
        if (!needUpdateApply && this.wizardContainer instanceof ChartWizard) {
            ((ChartWizard)this.wizardContainer).updateApplyButton();
        } else {
            needUpdateApply = false;
        }
    }

    public static void notifyUpdateApply() {
        needUpdateApply = true;
    }

    public static void ignoreNotifications(boolean bIgnoreNotifications) {
        ChartAdapter.bIgnoreNotifications = bIgnoreNotifications;
    }

    public static boolean isNotificationIgnored() {
        return bIgnoreNotifications;
    }

    public static void beginIgnoreNotifications() {
        bIgnoreNotifications = true;
    }

    public static void endIgnoreNotifications() {
        bIgnoreNotifications = false;
    }

    public void addListener(ITaskChangeListener listener) {
        if (!this.vListeners.contains(listener)) {
            this.vListeners.add(listener);
        }
    }

    public void clearListeners() {
        if (this.vListeners != null) {
            this.vListeners.removeAllElements();
        }
    }
}

