/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.project.PDEProject;

public class JavaElementChangeListener
implements IElementChangedListener {
    private static final String FILENAME = "clean-cache.properties";
    private final Properties fTable = new Properties();

    public void start() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        this.load();
    }

    public void elementChanged(ElementChangedEvent event) {
        this.handleDelta(event.getDelta());
    }

    public void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.save();
    }

    private void handleDelta(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (element instanceof IJavaModel) {
            this.handleChildDeltas(delta);
        } else if (element instanceof IJavaProject) {
            if (this.isInterestingProject((IJavaProject)element)) {
                if (delta.getKind() == 4) {
                    this.handleChildDeltas(delta);
                } else if (delta.getKind() == 1) {
                    this.updateTable(element);
                }
            }
        } else if (element instanceof IPackageFragmentRoot) {
            this.handleChildDeltas(delta);
        }
    }

    private void handleChildDeltas(IJavaElementDelta delta) {
        IJavaElementDelta[] deltas;
        IJavaElementDelta[] iJavaElementDeltaArray = deltas = delta.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            if (!this.ignoreDelta(childDelta)) {
                if (this.isInterestingDelta(childDelta)) {
                    this.updateTable(childDelta.getElement());
                    break;
                }
                this.handleDelta(childDelta);
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInterestingDelta(IJavaElementDelta delta) {
        IJavaElement iJavaElement;
        boolean interestingElement;
        int kind = delta.getKind();
        boolean interestingKind = kind == 1 || kind == 2;
        IJavaElement element = delta.getElement();
        boolean bl = interestingElement = element instanceof IPackageFragment || element instanceof IPackageFragmentRoot;
        if (interestingElement && interestingKind) {
            return true;
        }
        if (kind == 4 && (iJavaElement = element) instanceof IPackageFragmentRoot) {
            void root;
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
            IPackageFragmentRoot cfr_ignored_0 = (IPackageFragmentRoot)iJavaElement;
            return root.isArchive();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean ignoreDelta(IJavaElementDelta delta) {
        try {
            IJavaElement element;
            IJavaElement iJavaElement = element = delta.getElement();
            if (iJavaElement instanceof IPackageFragmentRoot) {
                void root;
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                IPackageFragmentRoot cfr_ignored_0 = (IPackageFragmentRoot)iJavaElement;
                IClasspathEntry entry = root.getRawClasspathEntry();
                if (entry != null && entry.getEntryKind() == 5) {
                    return true;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private boolean isInterestingProject(IJavaProject jProject) {
        IProject project = jProject.getProject();
        return WorkspaceModelManager.isPluginProject(project) && !WorkspaceModelManager.isBinaryProject(project) && !PDEProject.getManifest(project).exists();
    }

    private void updateTable(IJavaElement element) {
        String id;
        IProject project;
        IPluginModelBase model;
        IJavaProject jProject = (IJavaProject)element.getAncestor(2);
        if (jProject != null && (model = PluginRegistry.findModel(project = jProject.getProject())) != null && (id = model.getPluginBase().getId()) != null) {
            this.fTable.put(id, Long.toString(System.currentTimeMillis()));
        }
    }

    private void save() {
        Object id;
        Enumeration<Object> keys = this.fTable.keys();
        while (keys.hasMoreElements()) {
            id = keys.nextElement().toString();
            IPluginModelBase model = PluginRegistry.findModel((String)id);
            if (model != null && model.getUnderlyingResource() != null) continue;
            this.fTable.remove(id);
        }
        try {
            id = null;
            Object var3_5 = null;
            try (FileOutputStream stream = new FileOutputStream(new File(this.getDirectory(), FILENAME));){
                this.fTable.store(stream, "Cached timestamps");
                stream.flush();
            }
            catch (Throwable throwable) {
                if (id == null) {
                    id = throwable;
                } else if (id != throwable) {
                    ((Throwable)id).addSuppressed(throwable);
                }
                throw id;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    private File getDirectory() {
        IPath path = PDECore.getDefault().getStateLocation().append(".cache");
        File directory = new File(path.toOSString());
        if (!directory.exists() || !directory.isDirectory()) {
            directory.mkdirs();
        }
        return directory;
    }

    private void load() {
        File file = new File(this.getDirectory(), FILENAME);
        if (file.exists() && file.isFile()) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileInputStream is = new FileInputStream(file);){
                    this.fTable.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void synchronizeManifests(File cacheDirectory) {
        Enumeration<Object> keys = this.fTable.keys();
        while (keys.hasMoreElements()) {
            File file;
            String id = keys.nextElement().toString();
            IPluginModelBase model = PluginRegistry.findModel(id);
            if (model == null || !(file = new File(cacheDirectory, id + "_" + model.getPluginBase().getVersion() + ".MF")).exists() || !file.isFile() || file.lastModified() >= Long.parseLong(this.fTable.get(id).toString())) continue;
            file.delete();
        }
    }
}

