/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.IPlatformEntry;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.SourceFeatureWriter;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.BuildDirector;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.PDEState;
import org.osgi.framework.Version;

public class SourceGenerator
implements IPDEBuildConstants,
IBuildPropertiesConstants {
    private static final String COMMENT_START_TAG = "<!--";
    private static final String COMMENT_END_TAG = "-->";
    private static final String FEATURE_START_TAG = "<feature";
    private static final String VERSION = "version";
    private static final String TEMPLATE = "data";
    private String featureRootLocation;
    private String sourceFeatureId;
    private String brandingPlugin;
    private Properties buildProperties;
    private boolean individualSourceBundles = false;
    private BuildDirector director;
    private String[] extraEntries;
    private Map<String, List<Version>> excludedEntries;

    public void setSourceFeatureId(String id) {
        this.sourceFeatureId = id;
    }

    public void setExtraEntries(String[] extraEntries) {
        this.extraEntries = extraEntries;
    }

    public void setDirector(BuildDirector director) {
        this.director = director;
    }

    public void setIndividual(boolean individual) {
        this.individualSourceBundles = individual;
    }

    private void initialize(BuildTimeFeature feature, String sourceFeatureName) throws CoreException {
        this.featureRootLocation = feature.getRootLocation();
        this.setSourceFeatureId(sourceFeatureName);
        this.collectSourceEntries(feature);
    }

    private BuildTimeSite getSite() throws CoreException {
        return this.director.getSite(false);
    }

    private String getWorkingDirectory() {
        return AbstractScriptGenerator.getWorkingDirectory();
    }

    private Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = AbstractScriptGenerator.readProperties(this.featureRootLocation, "build.properties", 0);
        }
        return this.buildProperties;
    }

    protected Properties getBuildProperties(BundleDescription model) throws CoreException {
        return AbstractScriptGenerator.readProperties(model.getLocation(), "build.properties", 0);
    }

    private String getSourcePluginName(FeatureEntry plugin, boolean versionSuffix) {
        return plugin.getId() + (String)(versionSuffix ? "_" + plugin.getVersion() : "");
    }

    private void collectSourceEntries(BuildTimeFeature feature) throws CoreException {
        FeatureEntry[] pluginList;
        FeatureEntry[] featureEntryArray = pluginList = feature.getPluginEntries();
        int n = pluginList.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry entry = featureEntryArray[n2];
            if (this.director.selectConfigs((IPlatformEntry)entry).size() != 0) {
                String versionRequested = entry.getVersion();
                BundleDescription model = this.getSite().getRegistry().getResolvedBundle(entry.getId(), versionRequested);
                if (model != null) {
                    this.collectSourcePlugins(feature, entry, model);
                }
            }
            ++n2;
        }
    }

    private void collectSourcePlugins(BuildTimeFeature feature, FeatureEntry pluginEntry, BundleDescription model) throws CoreException {
        if (this.individualSourceBundles) {
            return;
        }
        String sourceId = this.computeSourceFeatureName(feature, false);
        if (pluginEntry.getOS() == null && pluginEntry.getWS() == null && pluginEntry.getArch() == null) {
            this.director.sourceToGather.addElementEntry(sourceId, model);
            return;
        }
        List<Config> correctConfigs = this.director.selectConfigs((IPlatformEntry)pluginEntry);
        for (Config configInfo : correctConfigs) {
            this.director.sourceToGather.addElementEntry(sourceId + "." + configInfo.toString("."), model);
        }
    }

    public BuildTimeFeature generateSourceFeature(BuildTimeFeature feature, String sourceFeatureName) throws CoreException {
        this.initialize(feature, sourceFeatureName);
        BuildTimeFeature sourceFeature = this.createSourceFeature(feature);
        this.associateExtraEntries(sourceFeature);
        if (this.individualSourceBundles) {
            FeatureEntry[] plugins;
            this.brandingPlugin = feature.getBrandingPlugin();
            if (this.brandingPlugin != null) {
                this.brandingPlugin = String.valueOf(this.brandingPlugin) + ".source";
                sourceFeature.setBrandingPlugin(this.brandingPlugin);
            } else {
                this.brandingPlugin = sourceFeature.getId();
            }
            FeatureEntry[] featureEntryArray = plugins = feature.getPluginEntries();
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureEntry plugin2 = featureEntryArray[n2];
                if (this.director.selectConfigs((IPlatformEntry)plugin2).size() != 0) {
                    this.createSourceBundle(sourceFeature, plugin2);
                }
                ++n2;
            }
        } else {
            FeatureEntry sourcePlugin = this.create30SourcePlugin(sourceFeature);
            this.generateSourceFragments(sourceFeature, sourcePlugin);
        }
        this.writeSourceFeature(sourceFeature);
        return sourceFeature;
    }

    private void associateExtraEntries(BuildTimeFeature sourceFeature) throws CoreException {
        int i = 1;
        while (i < this.extraEntries.length) {
            Map<String, Object> items = Utils.parseExtraBundlesString(this.extraEntries[i], true);
            String id = (String)items.get("id");
            Version version = (Version)items.get(VERSION);
            if (this.extraEntries[i].startsWith("feature@")) {
                entry = new FeatureEntry(id, version.toString(), false);
                if (items.containsKey("optional")) {
                    entry.setOptional(((Boolean)items.get("optional")).booleanValue());
                }
                entry.setEnvironment((String)items.get("os"), (String)items.get("ws"), (String)items.get("arch"), null);
                sourceFeature.addEntry(entry);
            } else if (this.extraEntries[i].startsWith("plugin@")) {
                BundleDescription model = this.getSite().getRegistry().getResolvedBundle((String)items.get("id"), ((Version)items.get(VERSION)).toString());
                if (model == null) {
                    IStatus status = this.getSite().missingPlugin(id, version.toString(), null, false);
                    BundleHelper.getDefault().getLog().log(status);
                } else {
                    entry = new FeatureEntry(model.getSymbolicName(), model.getVersion().toString(), true);
                    entry.setUnpack(((Boolean)items.get("unpack")).booleanValue());
                    entry.setEnvironment((String)items.get("os"), (String)items.get("ws"), (String)items.get("arch"), null);
                    sourceFeature.addEntry(entry);
                }
            } else if (this.extraEntries[i].startsWith("exclude@")) {
                if (this.excludedEntries == null) {
                    this.excludedEntries = new HashMap<String, List<Version>>();
                }
                if (this.excludedEntries.containsKey(id)) {
                    this.excludedEntries.get(id).add(version);
                } else {
                    ArrayList<Version> versionList = new ArrayList<Version>();
                    versionList.add(version);
                    this.excludedEntries.put(id, versionList);
                }
            }
            ++i;
        }
    }

    private void generateSourceFragments(BuildTimeFeature sourceFeature, FeatureEntry sourcePlugin) throws CoreException {
        Map<String, Set<BundleDescription>> fragments = this.director.sourceToGather.getElementEntries();
        for (Config configInfo : AbstractScriptGenerator.getConfigInfos()) {
            String sourceFragmentId;
            Set<BundleDescription> fragmentEntries;
            if (configInfo.equals(Config.genericConfig()) || (fragmentEntries = fragments.get(sourceFragmentId = sourceFeature.getId() + "." + configInfo.toString("."))) == null || fragmentEntries.size() == 0) continue;
            FeatureEntry sourceFragment = new FeatureEntry(sourceFragmentId, sourceFeature.getVersion(), true);
            sourceFragment.setEnvironment(configInfo.getOs(), configInfo.getWs(), configInfo.getArch(), null);
            sourceFragment.setFragment(true);
            this.create30SourceFragment(sourceFragment, sourcePlugin);
            sourceFeature.addEntry(sourceFragment);
        }
    }

    private String computeSourceFeatureName(Feature featureForName, boolean withNumber) throws CoreException {
        Object sourceFeatureName = this.getBuildProperties().getProperty("sourceFeature.name");
        if (sourceFeatureName == null) {
            sourceFeatureName = this.sourceFeatureId;
        }
        if (sourceFeatureName == null) {
            sourceFeatureName = featureForName.getId() + ".source";
        }
        return (String)sourceFeatureName + (String)(withNumber ? "_" + featureForName.getVersion() : "");
    }

    private BuildTimeFeature createSourceFeature(Feature featureExample) throws CoreException {
        URLEntry[] siteEntries;
        String id = this.computeSourceFeatureName(featureExample, false);
        String version = featureExample.getVersion();
        BuildTimeFeature result = new BuildTimeFeature(id, version);
        result.setLabel(featureExample.getLabel());
        result.setProviderName(featureExample.getProviderName());
        result.setImage(featureExample.getImage());
        result.setInstallHandler(featureExample.getInstallHandler());
        result.setInstallHandlerLibrary(featureExample.getInstallHandlerLibrary());
        result.setInstallHandlerURL(featureExample.getInstallHandlerURL());
        result.setDescription(featureExample.getDescription());
        result.setDescriptionURL(featureExample.getDescriptionURL());
        result.setCopyright(featureExample.getCopyright());
        result.setCopyrightURL(featureExample.getCopyrightURL());
        result.setLicense(featureExample.getLicense());
        result.setLicenseURL(featureExample.getLicenseURL());
        result.setLicenseFeature(featureExample.getLicenseFeature());
        result.setLicenseFeatureVersion(featureExample.getLicenseFeatureVersion());
        result.setUpdateSiteLabel(featureExample.getUpdateSiteLabel());
        result.setUpdateSiteURL(featureExample.getUpdateSiteURL());
        URLEntry[] uRLEntryArray = siteEntries = featureExample.getDiscoverySites();
        int n = siteEntries.length;
        int n2 = 0;
        while (n2 < n) {
            URLEntry siteEntry = uRLEntryArray[n2];
            result.addDiscoverySite(siteEntry.getAnnotation(), siteEntry.getURL());
            ++n2;
        }
        result.setEnvironment(featureExample.getOS(), featureExample.getWS(), featureExample.getArch(), null);
        int contextLength = featureExample instanceof BuildTimeFeature ? ((BuildTimeFeature)featureExample).getContextQualifierLength() : -1;
        result.setContextQualifierLength(contextLength);
        return result;
    }

    private void create30SourceFragment(FeatureEntry fragment, FeatureEntry plugin) throws CoreException {
        File sourceFragmentDir;
        block29: {
            IPath sourceFragmentDirURL = IPath.fromOSString((String)(this.getWorkingDirectory() + "/plugins/" + this.getSourcePluginName(fragment, true)));
            sourceFragmentDir = new File(sourceFragmentDirURL.toOSString());
            new File(sourceFragmentDir, "META-INF").mkdirs();
            try {
                File buildProperty;
                StringBuilder buffer;
                InputStream fragmentXML22;
                IPath fragmentPath = IPath.fromOSString((String)"data/30/fragment/META-INF/MANIFEST.MF");
                URL templateLocation = BundleHelper.getDefault().find(fragmentPath);
                if (templateLocation == null) {
                    Status status = new Status(2, "org.eclipse.pde.build", 10, NLS.bind((String)Messages.error_readingDirectory, (Object)fragmentPath), null);
                    BundleHelper.getDefault().getLog().log((IStatus)status);
                    return;
                }
                Path dest = sourceFragmentDirURL.append("fragment.xml").toPath();
                try {
                    Throwable throwable = null;
                    Object var9_13 = null;
                    try {
                        fragmentXML22 = BundleHelper.getDefault().getBundle().getEntry("data/30/fragment/fragment.xml").openStream();
                        try {
                            Files.copy(fragmentXML22, dest, StandardCopyOption.REPLACE_EXISTING);
                        }
                        finally {
                            if (fragmentXML22 != null) {
                                fragmentXML22.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e1) {
                    String message = NLS.bind((String)Messages.exception_readingFile, (Object)"data/30/fragment/fragment.xml");
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e1));
                }
                Throwable message = null;
                fragmentXML22 = null;
                try (InputStream locationContent = templateLocation.openStream();){
                    buffer = new StringBuilder(new String(locationContent.readAllBytes()));
                }
                catch (Throwable fragmentXML22) {
                    if (message == null) {
                        message = fragmentXML22;
                    } else if (message != fragmentXML22) {
                        message.addSuppressed(fragmentXML22);
                    }
                    throw message;
                }
                int beginId = buffer.indexOf("FRAGMENT_ID", 0);
                buffer.replace(beginId, beginId + "FRAGMENT_ID".length(), fragment.getId());
                beginId = buffer.indexOf("FRAGMENT_VERSION", beginId);
                buffer.replace(beginId, beginId + "FRAGMENT_VERSION".length(), fragment.getVersion());
                beginId = buffer.indexOf("PLUGIN_ID", beginId);
                buffer.replace(beginId, beginId + "PLUGIN_ID".length(), plugin.getId());
                BundleDescription effectivePlugin = this.getSite().getRegistry().getResolvedBundle(plugin.getId(), plugin.getVersion());
                beginId = buffer.indexOf("PLUGIN_VERSION", beginId);
                buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), effectivePlugin.getVersion().toString());
                beginId = buffer.indexOf("PLATFORM_FILTER", beginId);
                buffer.replace(beginId, beginId + "PLATFORM_FILTER".length(), "(& (osgi.ws=" + fragment.getWS() + ") (osgi.os=" + fragment.getOS() + ") (osgi.arch=" + fragment.getArch() + "))");
                Path destManifest = sourceFragmentDirURL.append("META-INF/MANIFEST.MF").toPath();
                Files.writeString(destManifest, (CharSequence)buffer.toString(), new OpenOption[0]);
                Collection<String> copiedFiles = Utils.copyFiles(this.featureRootLocation + "/sourceTemplateFragment", sourceFragmentDir.getAbsolutePath());
                if (copiedFiles.contains("META-INF/MANIFEST.MF")) {
                    this.replaceManifestValue(sourceFragmentDirURL.append("META-INF/MANIFEST.MF").toOSString(), "Bundle-Version", fragment.getVersion());
                    String host = plugin.getId() + ";Bundle-Version=" + effectivePlugin.getVersion().toString();
                    this.replaceManifestValue(sourceFragmentDirURL.append("META-INF/MANIFEST.MF").toOSString(), "Fragment-Host", host);
                }
                if ((buildProperty = sourceFragmentDirURL.append("build.properties").toFile()).exists()) break block29;
                copiedFiles.add("fragment.xml");
                copiedFiles.add("src/**");
                copiedFiles.add("META-INF/MANIFEST.MF");
                Properties sourceBuildProperties = new Properties();
                sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
                sourceBuildProperties.put("sourcePlugin", "true");
                try {
                    Utils.writeProperties(sourceBuildProperties, buildProperty, null);
                }
                catch (IOException e) {
                    String message2 = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message2, (Throwable)e));
                }
            }
            catch (IOException iOException) {
                String message = NLS.bind((String)Messages.exception_writingFile, (Object)sourceFragmentDir.getName());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, null));
            }
        }
        PDEState state = this.getSite().getRegistry();
        BundleDescription oldBundle = state.getResolvedBundle(fragment.getId());
        if (oldBundle != null) {
            state.getState().removeBundle(oldBundle);
        }
        state.addBundle(sourceFragmentDir);
    }

    private void writeSourceFeature(BuildTimeFeature sourceFeature) throws CoreException {
        File buildProperty;
        String sourceFeatureDir = this.getWorkingDirectory() + "/features/" + this.sourceFeatureId;
        File sourceDir = new File(sourceFeatureDir);
        sourceDir.mkdirs();
        File file = new File(sourceFeatureDir + "/feature.xml");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (SourceFeatureWriter writer = new SourceFeatureWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), sourceFeature, this.getSite());){
                writer.printFeature();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.error_creatingFeature, (Object)sourceFeature.getId());
            throw new CoreException((IStatus)new Status(0, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        Collection<String> copiedFiles = Utils.copyFiles(this.featureRootLocation + "/sourceTemplateFeature", sourceFeatureDir);
        if (copiedFiles.contains("feature.xml")) {
            this.replaceXMLAttribute(sourceFeatureDir + "/feature.xml", FEATURE_START_TAG, VERSION, sourceFeature.getVersion());
        }
        if ((buildProperty = new File(sourceFeatureDir + "/build.properties")).exists()) {
            this.getSite().addFeatureReferenceModel(sourceDir);
            return;
        }
        copiedFiles.add("feature.xml");
        Properties sourceBuildProperties = new Properties();
        sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection(copiedFiles, ","));
        try {
            Utils.writeProperties(sourceBuildProperties, buildProperty, null);
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        this.getSite().addFeatureReferenceModel(sourceDir);
    }

    private void replaceXMLAttribute(String location, String tag, String attr, String newValue) {
        Charset fileCharset;
        Path featureFile = Path.of(location, new String[0]);
        if (!Files.isRegularFile(featureFile, new LinkOption[0])) {
            return;
        }
        StringBuilder buffer = null;
        try {
            fileCharset = SourceGenerator.getFileEncoding(featureFile);
            buffer = new StringBuilder(Files.readString(featureFile, fileCharset));
        }
        catch (IOException | XMLStreamException exception) {
            return;
        }
        int startComment = buffer.indexOf(COMMENT_START_TAG, 0);
        int endComment = startComment > -1 ? buffer.indexOf(COMMENT_END_TAG, startComment) : -1;
        int startTag = buffer.indexOf(tag, 0);
        while (startComment != -1 && startTag > startComment && startTag < endComment) {
            startTag = buffer.indexOf(tag, endComment);
            startComment = buffer.indexOf(COMMENT_START_TAG, endComment);
            int n = endComment = startComment > -1 ? buffer.indexOf(COMMENT_END_TAG, startComment) : -1;
        }
        if (startTag == -1) {
            return;
        }
        int endTag = buffer.indexOf(">", startTag);
        boolean attrFound = false;
        while (!attrFound) {
            int startAttributeWord = buffer.indexOf(attr, startTag);
            if (startAttributeWord == -1 || startAttributeWord > endTag) {
                return;
            }
            if (!Character.isWhitespace(buffer.charAt(startAttributeWord - 1))) {
                startTag = startAttributeWord + attr.length();
                continue;
            }
            int endAttributeWord = startAttributeWord + attr.length();
            while (Character.isWhitespace(buffer.charAt(endAttributeWord)) && endAttributeWord < endTag) {
                ++endAttributeWord;
            }
            if (endAttributeWord > endTag) {
                return;
            }
            if (buffer.charAt(endAttributeWord) != '=') {
                startTag = endAttributeWord;
                continue;
            }
            int startVersionId = buffer.indexOf("\"", startAttributeWord + 1);
            int endVersionId = buffer.indexOf("\"", startVersionId + 1);
            buffer.replace(startVersionId + 1, endVersionId, newValue);
            attrFound = true;
        }
        if (attrFound) {
            try {
                Files.writeString(featureFile, (CharSequence)buffer.toString(), fileCharset, new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static Charset getFileEncoding(Path file) throws IOException, XMLStreamException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            String encoding = factory.createXMLStreamReader(is).getEncoding();
            return Charset.forName(encoding);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private FeatureEntry createSourceBundle(BuildTimeFeature sourceFeature, FeatureEntry pluginEntry) throws CoreException {
        Properties bundleProperties;
        BundleDescription bundle = this.getSite().getRegistry().getBundle(pluginEntry.getId(), pluginEntry.getVersion(), true);
        if (bundle == null) {
            this.getSite().missingPlugin(pluginEntry.getId(), pluginEntry.getVersion(), null, true);
        }
        if (this.excludedEntries != null && this.excludedEntries.containsKey(bundle.getSymbolicName())) {
            List<Version> excludedVersions = this.excludedEntries.get(bundle.getSymbolicName());
            for (Version version : excludedVersions) {
                if (!Utils.matchVersions(bundle.getVersion().toString(), version.toString())) continue;
                return null;
            }
        }
        if (!Boolean.valueOf((bundleProperties = this.getBuildProperties(bundle)).getProperty("generateSourceBundle", "true")).booleanValue()) {
            return null;
        }
        FeatureEntry sourceEntry = new FeatureEntry(pluginEntry.getId() + ".source", bundle.getVersion().toString(), true);
        sourceEntry.setEnvironment(pluginEntry.getOS(), pluginEntry.getWS(), pluginEntry.getArch(), pluginEntry.getNL());
        sourceEntry.setUnpack(false);
        if (Utils.isBinary(bundle)) {
            Map<String, Map<String, String>> headerMap;
            Map<String, String> entryMap;
            BundleDescription sourceBundle = this.getSite().getRegistry().getResolvedBundle(sourceEntry.getId(), sourceEntry.getVersion());
            if (sourceBundle != null && Utils.isSourceBundle(sourceBundle) && (entryMap = (headerMap = Utils.parseSourceBundleEntry(sourceBundle)).get(bundle.getSymbolicName())) != null && bundle.getVersion().toString().equals(entryMap.get(VERSION))) {
                sourceEntry.setUnpack(new File(sourceBundle.getLocation()).isDirectory());
                FeatureEntry existingEntry = sourceFeature.findPluginEntry(sourceEntry.getId(), sourceEntry.getVersion());
                if (existingEntry == null || existingEntry.getVersion() == "0.0.0") {
                    if (existingEntry != null) {
                        sourceFeature.removeEntry(existingEntry);
                    }
                    sourceFeature.addEntry(sourceEntry);
                    return sourceEntry;
                }
                return existingEntry;
            }
            return null;
        }
        sourceFeature.addEntry(sourceEntry);
        this.generateSourcePlugin(sourceEntry, bundle);
        return sourceEntry;
    }

    private String getSourceRoot(ModelBuildScriptGenerator.CompiledEntry entry) {
        String jarName = entry.getName(false);
        if (jarName.equals(".")) {
            return jarName;
        }
        String srcName = ModelBuildScriptGenerator.getSRCName(entry.getName(false));
        return srcName.substring(0, srcName.length() - 4);
    }

    public void generateSourcePlugin(FeatureEntry sourceEntry, BundleDescription originalBundle) throws CoreException {
        File localizationFile;
        Properties localizationProperties;
        String nameKey;
        IPath sourcePluginDirURL = IPath.fromOSString((String)(this.getWorkingDirectory() + "/plugins/" + sourceEntry.getId() + "_" + String.valueOf(originalBundle.getVersion())));
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(new Attributes.Name("Bundle-ManifestVersion"), "2");
        attributes.put(new Attributes.Name("Bundle-SymbolicName"), sourceEntry.getId());
        attributes.put(new Attributes.Name("Bundle-Version"), originalBundle.getVersion().toString());
        if (originalBundle.getPlatformFilter() != null) {
            attributes.put(new Attributes.Name("Eclipse-PlatformFilter"), originalBundle.getPlatformFilter());
        }
        Properties origBuildProperties = this.getBuildProperties(originalBundle);
        String extraRoots = (String)origBuildProperties.get("src.additionalRoots");
        String sourceHeader = originalBundle.getSymbolicName() + ";version=\"" + originalBundle.getVersion().toString() + "\"";
        ModelBuildScriptGenerator.CompiledEntry[] entries = ModelBuildScriptGenerator.extractEntriesToCompile(origBuildProperties, originalBundle);
        if (entries.length > 0 || extraRoots != null) {
            sourceHeader = sourceHeader + ";roots:=\"";
            int i = 0;
            while (i < entries.length) {
                if (i > 0) {
                    sourceHeader = sourceHeader + ",";
                }
                sourceHeader = sourceHeader + this.getSourceRoot(entries[i]);
                ++i;
            }
            if (extraRoots != null) {
                if (entries.length > 0) {
                    sourceHeader = sourceHeader + ",";
                }
                sourceHeader = sourceHeader + extraRoots;
            }
            sourceHeader = sourceHeader + "\"";
        }
        attributes.put(new Attributes.Name("Eclipse-SourceBundle"), sourceHeader);
        String localizationEntry = null;
        String localization = null;
        String vendor = null;
        Object name = null;
        Properties bundleProperties = (Properties)originalBundle.getUserObject();
        if (bundleProperties != null) {
            localization = (String)bundleProperties.get("Bundle-Localization");
            vendor = (String)bundleProperties.get("Bundle-Vendor");
            name = (String)bundleProperties.get("Bundle-Name");
        }
        String vendorKey = vendor != null && vendor.startsWith("%") ? vendor.substring(1) : null;
        String string = nameKey = name != null && ((String)name).startsWith("%") ? ((String)name).substring(1) : null;
        if (localization == null) {
            localization = "plugin";
        } else {
            localizationProperties = null;
            localizationFile = new File(originalBundle.getLocation(), localization + ".properties");
            if (!localizationFile.exists() && originalBundle.getHost() != null) {
                BundleDescription host = (BundleDescription)originalBundle.getHost().getSupplier();
                localizationProperties = AbstractScriptGenerator.readProperties(host.getLocation(), localization + ".properties", 0);
            } else if (localizationFile.exists()) {
                localizationProperties = AbstractScriptGenerator.readProperties(originalBundle.getLocation(), localization + ".properties", 0);
            }
            if (localizationProperties != null) {
                if (vendorKey != null) {
                    vendor = localizationProperties.getProperty(vendorKey);
                }
                if (nameKey != null) {
                    name = localizationProperties.getProperty(nameKey);
                }
            }
        }
        name = name == null ? sourceEntry.getId() : (String)name + " Source";
        if (nameKey == null) {
            nameKey = "pluginName";
        }
        if (vendor != null && vendorKey == null) {
            vendorKey = "providerName";
        }
        attributes.put(new Attributes.Name("Bundle-Localization"), localization);
        attributes.put(new Attributes.Name("Bundle-Name"), "%" + nameKey);
        localizationProperties = new Properties();
        localizationProperties.put(nameKey, name);
        if (vendorKey != null && vendor != null) {
            attributes.put(new Attributes.Name("Bundle-Vendor"), "%" + vendorKey);
            localizationProperties.put(vendorKey, vendor);
        }
        localizationEntry = localization + ".properties";
        localizationFile = new File(sourcePluginDirURL.toFile(), localizationEntry);
        try {
            Utils.writeProperties(localizationProperties, localizationFile, "#Source Bundle Localization");
        }
        catch (IOException iOException) {}
        File manifestFile = new File(sourcePluginDirURL.toFile(), "META-INF/MANIFEST.MF");
        manifestFile.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var21_24 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(manifestFile));){
                manifest.write(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)manifestFile.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        String template = sourceEntry.getId().equals(this.brandingPlugin) ? "sourceTemplatePlugin" : "sourceTemplateBundle";
        this.generateSourceFiles(sourcePluginDirURL, sourceEntry, template, localizationEntry, originalBundle);
        PDEState state = this.getSite().getRegistry();
        BundleDescription oldBundle = state.getResolvedBundle(sourceEntry.getId(), sourceEntry.getVersion());
        if (oldBundle != null) {
            state.getState().removeBundle(oldBundle);
        }
        state.addBundle(sourcePluginDirURL.toFile());
        this.director.sourceToGather.addElementEntry(sourceEntry.getId(), originalBundle);
    }

    private FeatureEntry create30SourcePlugin(BuildTimeFeature sourceFeature) throws CoreException {
        StringBuilder buffer;
        FeatureEntry result = new FeatureEntry(sourceFeature.getId(), sourceFeature.getVersion(), true);
        sourceFeature.addEntry(result);
        IPath sourcePluginDirURL = IPath.fromOSString((String)(this.getWorkingDirectory() + "/plugins/" + this.getSourcePluginName(result, true)));
        File sourcePluginDir = sourcePluginDirURL.toFile();
        new File(sourcePluginDir, "META-INF").mkdirs();
        IPath templateManifest = IPath.fromOSString((String)"data/30/plugin/META-INF/MANIFEST.MF");
        URL templateManifestURL = BundleHelper.getDefault().find(templateManifest);
        if (templateManifestURL == null) {
            Status status = new Status(2, "org.eclipse.pde.build", 10, NLS.bind((String)Messages.error_readingDirectory, (Object)templateManifest), null);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return null;
        }
        try {
            Throwable status = null;
            Object var9_12 = null;
            try (InputStream manifestStream = templateManifestURL.openStream();){
                buffer = new StringBuilder(new String(manifestStream.readAllBytes()));
            }
            catch (Throwable throwable) {
                if (status == null) {
                    status = throwable;
                } else if (status != throwable) {
                    status.addSuppressed(throwable);
                }
                throw status;
            }
        }
        catch (IOException e1) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)templateManifestURL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        int beginId = buffer.indexOf("PLUGIN_ID", 0);
        buffer.replace(beginId, beginId + "PLUGIN_ID".length(), result.getId());
        beginId = buffer.indexOf("PLUGIN_VERSION", beginId);
        buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), result.getVersion());
        Path destName = sourcePluginDirURL.append("META-INF/MANIFEST.MF").toPath();
        try {
            Files.writeString(destName, (CharSequence)buffer.toString(), new OpenOption[0]);
        }
        catch (IOException e1) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)templateManifestURL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        Path dest = sourcePluginDirURL.append("plugin.xml").toPath();
        try {
            Throwable message = null;
            Object var12_22 = null;
            try (InputStream pluginXML = BundleHelper.getDefault().getBundle().getEntry("data/30/plugin/plugin.xml").openStream();){
                Files.copy(pluginXML, dest, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                if (message == null) {
                    message = throwable;
                } else if (message != throwable) {
                    message.addSuppressed(throwable);
                }
                throw message;
            }
        }
        catch (IOException e1) {
            String message = NLS.bind((String)Messages.exception_readingFile, (Object)"data/30/plugin/plugin.xml");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e1));
        }
        this.generateSourceFiles(sourcePluginDirURL, result, "sourceTemplatePlugin", null, null);
        PDEState state = this.getSite().getRegistry();
        BundleDescription oldBundle = state.getResolvedBundle(result.getId());
        String oldBundleLocation = null;
        if (oldBundle != null) {
            oldBundleLocation = oldBundle.getLocation();
            state.getState().removeBundle(oldBundle);
        }
        state.addBundle(sourcePluginDir);
        if (oldBundleLocation != null) {
            state.getState().resolve(true);
            BundleDescription newBundle = state.getResolvedBundle(result.getId(), result.getVersion());
            if (newBundle != null && !newBundle.getLocation().equals(oldBundleLocation)) {
                Properties bundleProperties = (Properties)newBundle.getUserObject();
                if (bundleProperties == null) {
                    bundleProperties = new Properties();
                    newBundle.setUserObject((Object)bundleProperties);
                }
                bundleProperties.setProperty("oldBundleLocation", oldBundleLocation);
            }
        }
        return result;
    }

    private void generateSourceFiles(IPath sourcePluginDirURL, FeatureEntry sourceEntry, String templateDir, String extraFiles, BundleDescription originalBundle) throws CoreException {
        Collection<String> copiedFiles = Utils.copyFiles(this.featureRootLocation + "/" + templateDir, sourcePluginDirURL.toFile().getAbsolutePath());
        if (copiedFiles.contains("META-INF/MANIFEST.MF")) {
            this.replaceManifestValue(sourcePluginDirURL.append("META-INF/MANIFEST.MF").toOSString(), "Bundle-Version", sourceEntry.getVersion());
        }
        String original = originalBundle != null ? originalBundle.getSymbolicName() + ";" + originalBundle.getVersion().toString() : "true";
        File buildProperty = sourcePluginDirURL.append("build.properties").toFile();
        if (!buildProperty.exists()) {
            copiedFiles.add("plugin.xml");
            copiedFiles.add("src/**");
            copiedFiles.add("META-INF/MANIFEST.MF");
            Properties sourceBuildProperties = new Properties();
            Object binIncludes = Utils.getStringFromCollection(copiedFiles, ",");
            if (extraFiles != null) {
                binIncludes = (String)binIncludes + "," + extraFiles;
            }
            sourceBuildProperties.put("bin.includes", binIncludes);
            sourceBuildProperties.put("sourcePlugin", original);
            try {
                Utils.writeProperties(sourceBuildProperties, buildProperty, null);
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.exception_writingFile, (Object)buildProperty.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
            }
        }
        if (originalBundle != null) {
            Properties props = AbstractScriptGenerator.readProperties(sourcePluginDirURL.toOSString(), "build.properties", 0);
            props.put("sourcePlugin", original);
            try {
                Utils.writeProperties(props, buildProperty, null);
            }
            catch (IOException iOException) {}
        }
    }

    private void replaceManifestValue(String location, String attribute, String newVersion) {
        Object var6_8;
        Throwable throwable;
        Manifest manifest = null;
        try {
            throwable = null;
            var6_8 = null;
            try (SequenceInputStream is = new SequenceInputStream(new BufferedInputStream(new FileInputStream(location)), new ByteArrayInputStream(new byte[]{10}));){
                manifest = new Manifest(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return;
        }
        manifest.getMainAttributes().put(new Attributes.Name(attribute), newVersion);
        try {
            throwable = null;
            var6_8 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(location));){
                manifest.write(os);
                ((OutputStream)os).write(new byte[]{10});
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }
}

