/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.internal.IValidationSelectionHandler;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValidationSelectionHandlerRegistryReader {
    public static final String VALIDATION_SELECTION_HANDLER = "validationSelectionHandler";
    static final String ATT_ID = "id";
    static final String ATT_HANDLER_CLASS = "handlerClass";
    static final String ATT_SELECTION_TYPE = "selectionType";
    private static ValidationSelectionHandlerRegistryReader INSTANCE;
    private List<IValidationSelectionHandler> _validationSelectionHandlers;

    public static ValidationSelectionHandlerRegistryReader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ValidationSelectionHandlerRegistryReader();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public void readRegistry() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.validation", VALIDATION_SELECTION_HANDLER);
        if (point == null) {
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.internalReadElement(elements[i]);
            ++i;
        }
    }

    private void internalReadElement(IConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (!recognized) {
            this.logError(element, "Error processing extension: " + element);
        }
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        ValidationPlugin.getPlugin().logMessage(4, buf.toString());
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(VALIDATION_SELECTION_HANDLER)) {
            return false;
        }
        String selectionType = element.getAttribute(ATT_SELECTION_TYPE);
        IValidationSelectionHandler handler = null;
        try {
            handler = (IValidationSelectionHandler)element.createExecutableExtension(ATT_HANDLER_CLASS);
            handler.setValidationTypeString(selectionType);
            this.getValidationSelectionHandlers().add(handler);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private List<IValidationSelectionHandler> getValidationSelectionHandlers() {
        if (this._validationSelectionHandlers == null) {
            this._validationSelectionHandlers = new ArrayList<IValidationSelectionHandler>();
        }
        return this._validationSelectionHandlers;
    }

    public Object getExtendedType(Object selection) {
        IResource result = null;
        for (IValidationSelectionHandler handler : this.getValidationSelectionHandlers()) {
            result = handler.getBaseValidationType(selection);
            if (result != null) break;
        }
        return result;
    }
}

