/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.BirtUtility;

public class BirtRunReportActionHandler
extends AbstractBaseActionHandler {
    public BirtRunReportActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    @Override
    public void __execute() throws Exception {
        HashMap displayTexts;
        ViewerAttributeBean attrBean = (ViewerAttributeBean)this.context.getBean();
        assert (attrBean != null);
        HashMap parameterMap = attrBean.getParameters();
        if (parameterMap == null) {
            parameterMap = new HashMap();
        }
        if ((displayTexts = attrBean.getDisplayTexts()) == null) {
            displayTexts = new HashMap();
        }
        String docName = attrBean.getReportDocumentName();
        IViewerReportDesignHandle designHandle = attrBean.getReportDesignHandle(this.context.getRequest());
        InputOptions options = new InputOptions();
        options.setOption("request", this.context.getRequest());
        options.setOption("locale", attrBean.getLocale());
        options.setOption("timeZone", attrBean.getTimeZone());
        options.setOption("isDesigner", attrBean.isDesigner());
        BirtUtility.handleOperation(this.operation, attrBean, parameterMap, displayTexts);
        ArrayList<Exception> errorList = new ArrayList<Exception>();
        this.getReportService().runReport(designHandle, docName, options, parameterMap, displayTexts, errorList);
        if (errorList != null && !errorList.isEmpty()) {
            File doc = new File(docName);
            if (doc != null) {
                doc.delete();
            }
            throw BirtUtility.makeAxisFault("BirtRunReportActionHandler.__execute()", errorList);
        }
    }

    @Override
    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }
}

