/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.editors;

import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.preview.editors.SWTAbstractViewer;
import org.eclipse.birt.report.designer.ui.preview.extension.IViewer;
import org.eclipse.birt.report.designer.ui.preview.extension.ViewerExtensionManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.EditorPart;

public class ReportPreviewFormPage
extends EditorPart
implements IReportEditorPage {
    public static final String ID = "org.eclipse.birt.report.designer.ui.editors.preview";
    private static final String VIEWER_ID = "org.eclipse.birt.report.designer.ui.preview.static_html";
    private int staleType;
    private FormEditor editor;
    private final IViewer reportViewer;

    public ReportPreviewFormPage() throws FrameworkException {
        ViewerExtensionManager manager = (ViewerExtensionManager)Platform.createFactoryObject((String)"org.eclipse.birt.report.designer.ui.preview.ViewerExtensionManager");
        this.reportViewer = manager.createViewer(VIEWER_ID);
    }

    public boolean onBroughtToTop(IReportEditorPage prePage) {
        this.startRender();
        return true;
    }

    public Control getPartControl() {
        if (this.reportViewer instanceof SWTAbstractViewer) {
            return ((SWTAbstractViewer)this.reportViewer).getUI();
        }
        return null;
    }

    public String getId() {
        return ID;
    }

    public void createPartControl(Composite parent) {
        if (this.reportViewer instanceof SWTAbstractViewer) {
            ((SWTAbstractViewer)this.reportViewer).createUI(parent);
        }
    }

    private void startRender() {
        if (this.reportViewer == null) {
            return;
        }
        this.reportViewer.setInput(this.getReportDesignFilePath());
        this.reportViewer.render();
    }

    public void markPageStale(int type) {
        this.staleType = type;
    }

    public int getStaleType() {
        return this.staleType;
    }

    public boolean isDirty() {
        return false;
    }

    protected IReportProvider getProvider() {
        return (IReportProvider)this.editor.getAdapter(IReportProvider.class);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ActionRegistry.class)) {
            return new ActionRegistry();
        }
        return super.getAdapter(adapter);
    }

    public void initialize(FormEditor editor) {
        this.editor = editor;
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
    }

    public boolean isActive() {
        return false;
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public int getIndex() {
        return 0;
    }

    public void setIndex(int index) {
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.editor.editorDirtyStateChanged();
        } else {
            super.firePropertyChange(type);
        }
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report preview page finalized");
        }
        super.finalize();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    private String getReportDesignFilePath() {
        IReportProvider provider;
        IEditorInput input = this.getEditorInput();
        if (input != null && (provider = this.getProvider()) != null) {
            return provider.getInputPath(input).toOSString();
        }
        return null;
    }
}

