/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntryOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveWriter
implements IDocArchiveWriter {
    boolean shareArchive;
    IArchiveFile archive;

    public ArchiveWriter(String archiveName) throws IOException {
        this.archive = new ArchiveFile(archiveName, "rw");
        this.shareArchive = false;
    }

    public ArchiveWriter(IArchiveFile archive) throws IOException {
        this.archive = archive;
        this.shareArchive = true;
    }

    @Deprecated
    public IArchiveFile getArchive() {
        return this.archive;
    }

    @Override
    public IArchiveFile getArchiveFile() {
        return this.archive;
    }

    @Override
    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        if (!((String)relativePath).startsWith("/")) {
            relativePath = "/" + (String)relativePath;
        }
        ArchiveEntry entry = this.archive.createEntry((String)relativePath);
        return new ArchiveEntryOutputStream(entry);
    }

    @Override
    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        if (!((String)relativePath).startsWith("/")) {
            relativePath = "/" + (String)relativePath;
        }
        ArchiveEntry entry = this.archive.exists((String)relativePath) ? this.archive.openEntry((String)relativePath) : this.archive.createEntry((String)relativePath);
        return new ArchiveEntryOutputStream(entry);
    }

    @Override
    public RAOutputStream createOutputStream(String relativePath) throws IOException {
        return this.createRandomAccessStream(relativePath);
    }

    @Override
    public RAOutputStream getOutputStream(String relativePath) throws IOException {
        return this.openRandomAccessStream(relativePath);
    }

    @Override
    public RAInputStream getInputStream(String relativePath) throws IOException {
        if (!((String)relativePath).startsWith("/")) {
            relativePath = "/" + (String)relativePath;
        }
        ArchiveEntry entry = this.archive.openEntry((String)relativePath);
        return new ArchiveEntryInputStream(entry);
    }

    @Override
    public boolean dropStream(String relativePath) {
        if (!((String)relativePath).startsWith("/")) {
            relativePath = "/" + (String)relativePath;
        }
        try {
            return this.archive.removeEntry((String)relativePath);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean exists(String relativePath) {
        if (!((String)relativePath).startsWith("/")) {
            relativePath = "/" + (String)relativePath;
        }
        return this.archive.exists((String)relativePath);
    }

    @Override
    public void finish() throws IOException {
        try {
            this.archive.flush();
        }
        finally {
            if (!this.shareArchive) {
                this.archive.close();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.archive.flush();
    }

    @Override
    public String getName() {
        return this.archive.getName();
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public void setStreamSorter(IStreamSorter streamSorter) {
    }

    @Override
    public Object lock(String relativePath) throws IOException {
        if (!((String)relativePath).startsWith("/")) {
            relativePath = "/" + (String)relativePath;
        }
        return this.archive.lockEntry((String)relativePath);
    }

    @Override
    public void unlock(Object locker) {
        try {
            this.archive.unlockEntry(locker);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public List<String> listAllStreams() throws IOException {
        ArrayList<String> list = new ArrayList<String>(this.archive.listEntries("/"));
        return list;
    }

    @Override
    public List<String> listStreams(String namePattern) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        List<String> archiveEntries = this.archive.listEntries(namePattern);
        for (String name : archiveEntries) {
            String diffString;
            if (!name.startsWith(namePattern) || name.equalsIgnoreCase(namePattern) || (diffString = ArchiveUtil.getRelativePath(namePattern, name)).lastIndexOf("/") != 0) continue;
            list.add(name);
        }
        return list;
    }
}

