/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx.writer;

import java.io.IOException;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Component;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Presentation;
import org.eclipse.birt.report.engine.ooxml.IPartContainer;
import org.eclipse.birt.report.engine.ooxml.Package;

public class Core
extends Component {
    private static final String TAG_DESCRIPTION = "dc:description";
    private static final String TAG_TITLE = "dc:title";
    private static final String TAG_CREATOR = "dc:creator";
    private static final String TAG_SUBJECT = "dc:subject";
    private static final String TAG_CORE_PROPERTIES = "cp:coreProperties";

    public Core(Presentation presentation, String author, String title, String description, String subject) throws IOException {
        String uri = "docProps/core.xml";
        Package pkg = presentation.getPackage();
        super.initialize((IPartContainer)pkg, uri, "application/vnd.openxmlformats-package.core-properties+xml", "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties", false);
        this.start();
        this.writeCoreProperty(author, title, description, subject);
        this.close();
    }

    private void start() {
        this.writer.startWriter();
        this.writer.openTag(TAG_CORE_PROPERTIES);
        this.writer.nameSpace("cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
        this.writer.nameSpace("dc", "http://purl.org/dc/elements/1.1/");
        this.writer.nameSpace("dcterms", "http://purl.org/dc/terms/");
        this.writer.nameSpace("dcmitype", "http://purl.org/dc/dcmitype/");
        this.writer.nameSpace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    private void close() {
        this.writer.closeTag(TAG_CORE_PROPERTIES);
        this.writer.close();
        this.writer = null;
    }

    private void writeCoreProperty(String creator, String title, String description, String subject) {
        this.writeProperty(TAG_CREATOR, creator);
        this.writeProperty(TAG_TITLE, title);
        this.writeProperty(TAG_DESCRIPTION, description);
        this.writeProperty(TAG_SUBJECT, subject);
    }

    private void writeProperty(String tag, String property) {
        if (property != null) {
            this.writer.openTag(tag);
            this.writer.text(property);
            this.writer.closeTag(tag);
        }
    }
}

