/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.wizards;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.ide.wizards.ResourceAndContainerGroup;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class WizardSaveAsPage
extends WizardPage {
    private static String EXTENSIONS = ".rptdesign";
    private static final String WRONG_DESIGN_EXTENSION;
    private static final String WRONG_EXTENSION;
    private ResourceAndContainerGroup resourceGroup;
    private IResource originalFile;
    private String originalName;
    private ModuleHandle model;

    static {
        List extensionList = ReportPlugin.getDefault().getReportExtensionNameList();
        if (!extensionList.isEmpty()) {
            EXTENSIONS = "." + String.valueOf(extensionList.get(0));
        }
        int i = 1;
        while (i < extensionList.size()) {
            EXTENSIONS = String.valueOf(EXTENSIONS) + ", ." + String.valueOf(extensionList.get(i));
            ++i;
        }
        WRONG_DESIGN_EXTENSION = MessageFormat.format(Messages.getString((String)"WizardReportSettingPage.Error.ReportorTemplate"), ".rptdesign");
        WRONG_EXTENSION = MessageFormat.format(Messages.getString((String)"WizardReportSettingPage.Error.ReportorTemplate"), EXTENSIONS);
    }

    public WizardSaveAsPage(String pageName) {
        super(pageName);
    }

    public boolean canFlipToNextPage() {
        if (!this.validatePage()) {
            return false;
        }
        return this.resourceGroup.getResource().endsWith(".rpttemplate");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                WizardSaveAsPage.this.validatePage();
                try {
                    WizardSaveAsPage.this.getContainer().updateButtons();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        this.resourceGroup = new ResourceAndContainerGroup(composite, listener, Messages.getString((String)"WizardSaveAsPage.FileLabel"), "file", false, 200);
        this.resourceGroup.setAllowExistingResources(true);
        this.setControl((Control)composite);
        this.initializeControls();
        UIUtil.bindHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.SaveReportAsWizard_ID");
    }

    private void initializeControls() {
        if (this.originalFile != null) {
            this.resourceGroup.setContainerFullPath(this.originalFile.getParent().getFullPath());
            this.resourceGroup.setResource(this.originalFile.getName());
        } else if (this.originalName != null) {
            this.resourceGroup.setResource(this.originalName);
        }
    }

    public void setOriginalFile(IFile originalFile) {
        this.originalFile = originalFile;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public void setModel(ModuleHandle model) {
        this.model = model;
    }

    public boolean validatePage() {
        this.setErrorMessage(null);
        if (!this.resourceGroup.areAllValuesValid()) {
            if (!this.resourceGroup.getResource().equals("")) {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            return false;
        }
        if (this.resourceGroup.getResource() != null && this.model instanceof LibraryHandle && !this.resourceGroup.getResource().endsWith(".rptlibrary")) {
            this.setErrorMessage(Messages.getString((String)"WizardReportSettingPage.Error.Library"));
            return false;
        }
        if (this.resourceGroup.getResource() != null && this.model instanceof ReportDesignHandle) {
            if (this.model.getFileName().endsWith(".rptdesign") && !this.resourceGroup.getResource().endsWith(".rptdesign") && !this.resourceGroup.getResource().endsWith(".rpttemplate")) {
                this.setErrorMessage(WRONG_DESIGN_EXTENSION);
            } else if (!ReportPlugin.getDefault().isReportDesignFile(this.resourceGroup.getResource()) && !this.resourceGroup.getResource().endsWith(".rpttemplate")) {
                this.setErrorMessage(WRONG_EXTENSION);
                return false;
            }
        }
        return true;
    }

    public IPath getResult() {
        IFile file;
        IPath path = this.resourceGroup.getContainerFullPath().append(this.resourceGroup.getResource());
        if (path.getFileExtension() == null) {
            if (this.originalFile != null && this.originalFile.getFileExtension() != null) {
                path = path.addFileExtension(this.originalFile.getFileExtension());
            } else if (this.originalName != null) {
                int pos = this.originalName.lastIndexOf(46);
                if (++pos > 0 && pos < this.originalName.length()) {
                    path = path.addFileExtension(this.originalName.substring(pos));
                }
            }
        }
        if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = Messages.getFormattedString((String)"WizardSaveAsPage.OverwriteQuestion", (Object[])new Object[]{path.toOSString()});
            MessageDialog d = new MessageDialog(this.getShell(), Messages.getString((String)"WizardSaveAsPage.Question"), null, question, 3, buttons, 0);
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                default: {
                    return Path.EMPTY;
                }
            }
        }
        return path;
    }
}

