/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.IOdaDataSourceModel;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.extension.oda.ODAProviderFactory;
import org.eclipse.birt.report.model.extension.oda.OdaDummyProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;

public class OdaDataSource
extends DataSource
implements IExtendableElement,
IOdaDataSourceModel,
IOdaExtendableElementModel {
    protected String extensionID = null;
    private ODAProvider provider = null;

    public OdaDataSource() {
    }

    public OdaDataSource(String theName) {
        super(theName);
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitOdaDataSource(this);
    }

    @Override
    public String getElementName() {
        return "OdaDataSource";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public OdaDataSourceHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new OdaDataSourceHandle(module, this);
        }
        return (OdaDataSourceHandle)this.handle;
    }

    @Override
    public ExtensionElementDefn getExtDefn() {
        if (this.provider != null) {
            return this.provider.getExtDefn();
        }
        return null;
    }

    @Override
    public List<IElementPropertyDefn> getPropertyDefns() {
        if (this.provider != null && !(this.provider instanceof OdaDummyProvider)) {
            return this.provider.getPropertyDefns();
        }
        return super.getPropertyDefns();
    }

    @Override
    public ElementPropertyDefn getPropertyDefn(String propName) {
        assert (propName != null);
        ElementPropertyDefn propDefn = super.getPropertyDefn(propName);
        if (propDefn != null) {
            return propDefn;
        }
        if (this.provider != null && !(this.provider instanceof OdaDummyProvider)) {
            return (ElementPropertyDefn)this.provider.getPropertyDefn(propName);
        }
        return propDefn;
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if ("extensionID".equals(propName)) {
            return this.extensionID;
        }
        return super.getIntrinsicProperty(propName);
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if ("extensionID".equals(propName)) {
            this.extensionID = (String)value;
            if (this.extensionID != null) {
                this.provider = ODAProviderFactory.getInstance().createODAProvider(this, this.extensionID);
                if (this.provider == null) {
                    return;
                }
                if (!this.provider.isValidExtensionID()) {
                    this.provider = new OdaDummyProvider(this.extensionID);
                }
            } else {
                this.provider = null;
            }
            if (this.provider != null && this.provider.getExtDefn() != null) {
                this.cachedDefn = this.provider.getExtDefn();
            }
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    @Override
    public void checkExtends(DesignElement parent) throws ExtendsException {
        super.checkExtends(parent);
        if (this.provider != null && !(this.provider instanceof OdaDummyProvider)) {
            this.provider.checkExtends(parent);
        } else {
            OdaDataSource odaParent = (OdaDataSource)parent;
            if (odaParent.extensionID != null && !odaParent.extensionID.equals(this.extensionID) || this.extensionID != null && !this.extensionID.equals(odaParent.extensionID)) {
                throw new WrongTypeException((DesignElement)this, parent, "Error.WrongTypeException.WRONG_EXTENSION_TYPE");
            }
        }
    }

    public ODAProvider getProvider() {
        return this.provider;
    }
}

