/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.content;

import java.util.Collection;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.ReportItemExecutorBase;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.content.BlockStackingExecutor;
import org.eclipse.birt.report.engine.layout.content.ItemExecutorWrapper;
import org.eclipse.birt.report.engine.layout.content.RunInContainerExecutor;

public class ListContainerExecutor
extends BlockStackingExecutor
implements IReportItemExecutor {
    protected boolean repeat = false;

    public ListContainerExecutor(IContent content, IReportItemExecutor executor) {
        super(content, null);
        this.executor = new ExecutorList(executor, content);
        if (content instanceof IGroupContent) {
            this.repeat = ((IGroupContent)content).isHeaderRepeat();
        } else if (content instanceof IListContent) {
            this.repeat = ((IListContent)content).isHeaderRepeat();
        }
    }

    private void add(Collection collection, IContent content) {
        if (!collection.contains(content)) {
            collection.add(content);
        }
    }

    protected class ExecutorList
    extends ReportItemExecutorBase {
        protected IReportItemExecutor currentRunIn = null;
        protected IReportItemExecutor executor = null;
        protected IContent content = null;
        protected IReportItemExecutor childExecutor = null;
        protected IContent childContent = null;
        protected boolean hasNext = false;
        protected boolean needUpdate = true;
        protected IContent currentRunInContent = null;

        public ExecutorList(IReportItemExecutor executor, IContent content) {
            this.content = content;
            this.executor = executor;
        }

        @Override
        public void close() throws BirtException {
            if (this.currentRunIn != null) {
                this.currentRunIn.close();
            }
            this.executor.close();
        }

        @Override
        public IContent execute() {
            return this.content;
        }

        @Override
        public IReportItemExecutor getNextChild() throws BirtException {
            if (this.childContent != null) {
                ItemExecutorWrapper ret = new ItemExecutorWrapper(this.childExecutor, this.childContent);
                this.childContent = null;
                this.childExecutor = null;
                this.needUpdate = true;
                return ret;
            }
            if (this.currentRunIn != null) {
                this.needUpdate = true;
                if (this.currentRunIn.hasNextChild()) {
                    return this.currentRunIn.getNextChild();
                }
            }
            return null;
        }

        @Override
        public boolean hasNextChild() throws BirtException {
            if (!this.needUpdate) {
                return this.hasNext;
            }
            if (this.currentRunIn != null) {
                if (this.currentRunIn.hasNextChild()) {
                    this.hasNext = true;
                    this.needUpdate = false;
                    return this.hasNext;
                }
                this.currentRunIn.close();
            }
            this.currentRunIn = null;
            while (this.executor.hasNextChild()) {
                IReportItemExecutor next = this.executor.getNextChild();
                IContent nextContent = next.execute();
                if (nextContent instanceof IListBandContent) {
                    IListBandContent band = (IListBandContent)nextContent;
                    if (ListContainerExecutor.this.repeat && (band.getBandType() == 1 || band.getBandType() == 3)) {
                        this.executeHeader(next, nextContent);
                        next.close();
                        next = new DOMReportItemExecutor(nextContent);
                        next.execute();
                        ListContainerExecutor.this.add(nextContent.getParent().getChildren(), nextContent);
                    } else {
                        next = new RunInContainerExecutor(next, nextContent);
                    }
                    if (!next.hasNextChild()) continue;
                    this.currentRunIn = next;
                    this.currentRunInContent = nextContent;
                    break;
                }
                this.childExecutor = next;
                this.childContent = nextContent;
                break;
            }
            this.hasNext = this.currentRunIn != null || this.childContent != null;
            this.needUpdate = false;
            return this.hasNext;
        }

        protected void execute(IReportItemExecutor executor, IContent content) throws BirtException {
            while (executor.hasNextChild()) {
                IReportItemExecutor childExecutor = executor.getNextChild();
                if (childExecutor == null) continue;
                IContent childContent = childExecutor.execute();
                ListContainerExecutor.this.add(content.getChildren(), childContent);
                this.execute(childExecutor, childContent);
                childExecutor.close();
            }
        }

        protected void executeHeader(IReportItemExecutor executor, IContent content) throws BirtException {
            while (executor.hasNextChild()) {
                IReportItemExecutor childExecutor = executor.getNextChild();
                if (childExecutor == null) continue;
                IContent childContent = childExecutor.execute();
                this.removePageBreak(childContent);
                ListContainerExecutor.this.add(content.getChildren(), childContent);
                this.execute(childExecutor, childContent);
                childExecutor.close();
            }
        }

        protected void removePageBreak(IContent content) {
            IStyle style = content.getStyle();
            if (style != null) {
                style.setProperty(66, IStyle.AUTO_VALUE);
                style.setProperty(30, IStyle.AUTO_VALUE);
            }
        }
    }
}

