/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.PDFLayoutEmitter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.WrappedPDFLayoutEmitter;

public class PDFLayoutEmitterProxy
extends LayoutEmitterAdapter
implements IContentEmitter {
    private LayoutEmitterAdapter layoutEmitterImpl = null;
    private IContentEmitter outputEmitter = null;
    private IReportExecutor executor;
    private LayoutEngineContext context;

    public PDFLayoutEmitterProxy(IReportExecutor executor, IContentEmitter emitter, IRenderOption renderOptions, Locale locale, long totalPage) {
        this.executor = executor;
        this.outputEmitter = emitter;
        this.context = new LayoutEngineContext();
        this.setupLayoutOptions(renderOptions);
        if (renderOptions != null) {
            String format = renderOptions.getOutputFormat();
            this.context.setFormat(format);
        }
        this.context.setLocale(locale);
        this.context.totalPage = totalPage;
        this.createLayoutEmitterImpl(this.context);
        this.context.setEmitter(this.layoutEmitterImpl);
    }

    @Override
    public void initialize(IEmitterServices service) throws BirtException {
        this.layoutEmitterImpl.initialize(service);
    }

    private void createLayoutEmitterImpl(LayoutEngineContext context) {
        this.layoutEmitterImpl = context.autoPageBreak ? new WrappedPDFLayoutEmitter(this.executor, this.outputEmitter, context) : new PDFLayoutEmitter(this.executor, this.outputEmitter, context);
    }

    @Override
    public String getOutputFormat() {
        return this.layoutEmitterImpl.getOutputFormat();
    }

    @Override
    public void setPageHandler(ILayoutPageHandler pageHandler) {
        this.layoutEmitterImpl.setPageHandler(pageHandler);
    }

    protected void setupLayoutOptions(IRenderOption renderOptions) {
        Map<String, Object> options = null;
        if (renderOptions != null) {
            options = renderOptions.getOptions();
        }
        if (options != null) {
            Object dpi;
            Object wordbreak;
            Object bidiProcessing;
            Object fontSubstitution;
            Object pageOverflow;
            Object pageBreakOnly;
            Object fitToPage = options.get("pdfRenderOption.fitToPage");
            if (fitToPage instanceof Boolean && ((Boolean)fitToPage).booleanValue()) {
                this.context.setFitToPage(true);
            }
            if ((pageBreakOnly = options.get("pdfRenderOption.pagebreakPaginationOnly")) instanceof Boolean && ((Boolean)pageBreakOnly).booleanValue()) {
                this.context.setPagebreakPaginationOnly(true);
            }
            if ((pageOverflow = options.get("pdfRenderOption.pageOverflow")) instanceof Integer) {
                int pageOverflowType = (Integer)pageOverflow;
                this.context.setPageOverflow(pageOverflowType);
                if (pageOverflowType == 4) {
                    this.context.setPagebreakPaginationOnly(false);
                } else {
                    this.context.setPagebreakPaginationOnly(true);
                }
            } else if (this.context.fitToPage()) {
                this.context.setPageOverflow(2);
                this.context.setPagebreakPaginationOnly(true);
            }
            Object textWrapping = options.get("pdfRenderOption.textWrapping");
            if (textWrapping instanceof Boolean && !((Boolean)textWrapping).booleanValue()) {
                this.context.setTextWrapping(false);
            }
            if ((fontSubstitution = options.get("pdfRenderOption.fontSubstitution")) instanceof Boolean && !((Boolean)fontSubstitution).booleanValue()) {
                this.context.setFontSubstitution(false);
            }
            if ((bidiProcessing = options.get("pdfRenderOption.bidiProcessing")) instanceof Boolean && !((Boolean)bidiProcessing).booleanValue()) {
                this.context.setBidiProcessing(false);
            }
            if ((wordbreak = options.get("pdfRenderOption.wordBreak")) instanceof Boolean && ((Boolean)wordbreak).booleanValue()) {
                this.context.setEnableWordbreak(true);
            }
            if ((dpi = options.get("RenderDpi")) instanceof Integer) {
                int screenDpi = (Integer)dpi;
                this.context.setDpi(screenDpi);
            }
        }
    }

    @Override
    public void start(IReportContent report) throws BirtException {
        this.layoutEmitterImpl.start(report);
    }

    @Override
    public void end(IReportContent report) throws BirtException {
        this.layoutEmitterImpl.end(report);
    }

    @Override
    public void startTable(ITableContent table) throws BirtException {
        this.layoutEmitterImpl.startTable(table);
    }

    @Override
    public void endTable(ITableContent table) throws BirtException {
        this.layoutEmitterImpl.endTable(table);
    }

    @Override
    public void startContainer(IContainerContent container) throws BirtException {
        this.layoutEmitterImpl.startContainer(container);
    }

    @Override
    public void endContainer(IContainerContent container) throws BirtException {
        this.layoutEmitterImpl.endContainer(container);
    }

    @Override
    public void startContent(IContent content) throws BirtException {
        this.layoutEmitterImpl.startContent(content);
    }

    @Override
    public void endContent(IContent content) throws BirtException {
        this.layoutEmitterImpl.endContent(content);
    }

    @Override
    public void startListBand(IListBandContent listBand) throws BirtException {
        this.layoutEmitterImpl.startListBand(listBand);
    }

    @Override
    public void startListGroup(IListGroupContent listGroup) throws BirtException {
        this.layoutEmitterImpl.startListGroup(listGroup);
    }

    @Override
    public void endListBand(IListBandContent listBand) throws BirtException {
        this.layoutEmitterImpl.endListBand(listBand);
    }

    @Override
    public void outputPage(IPageContent page) throws BirtException {
        this.layoutEmitterImpl.outputPage(page);
    }

    @Override
    public void startPage(IPageContent page) throws BirtException {
        this.layoutEmitterImpl.startPage(page);
    }

    @Override
    public void endPage(IPageContent page) throws BirtException {
        this.layoutEmitterImpl.endPage(page);
    }

    @Override
    public void startRow(IRowContent row) throws BirtException {
        this.layoutEmitterImpl.startRow(row);
    }

    @Override
    public void endRow(IRowContent row) throws BirtException {
        this.layoutEmitterImpl.endRow(row);
    }

    @Override
    public void startTableBand(ITableBandContent band) throws BirtException {
        this.layoutEmitterImpl.startTableBand(band);
    }

    @Override
    public void startTableGroup(ITableGroupContent group) throws BirtException {
        this.layoutEmitterImpl.startTableGroup(group);
    }

    @Override
    public void endTableBand(ITableBandContent band) throws BirtException {
        this.layoutEmitterImpl.endTableBand(band);
    }

    @Override
    public void endTableGroup(ITableGroupContent group) throws BirtException {
        this.layoutEmitterImpl.endTableGroup(group);
    }

    @Override
    public void startCell(ICellContent cell) throws BirtException {
        this.layoutEmitterImpl.startCell(cell);
    }

    @Override
    public void endCell(ICellContent cell) throws BirtException {
        this.layoutEmitterImpl.endCell(cell);
    }

    @Override
    public void startForeign(IForeignContent foreign) throws BirtException {
        this.layoutEmitterImpl.startForeign(foreign);
    }

    @Override
    public ILayoutPageHandler getPageHandler() {
        return this.layoutEmitterImpl.getPageHandler();
    }
}

