/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.AdditionalInfoController;
import org.eclipse.jface.text.contentassist.CompletionProposalPopup;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.JFaceTextMessages;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

class AsyncCompletionProposalPopup
extends CompletionProposalPopup {
    private static final int MAX_WAIT_IN_MS = 50;
    private CompletableFuture<?> fAggregatedPopulateFuture;
    private Collection<CompletableFuture<?>> toCancelFutures = new LinkedList();
    private PopupVisibleTimer fPopupVisibleTimer = new PopupVisibleTimer();

    public AsyncCompletionProposalPopup(ContentAssistant contentAssistant, IContentAssistSubjectControl contentAssistSubjectControl, AdditionalInfoController infoController) {
        super(contentAssistant, contentAssistSubjectControl, infoController);
    }

    public AsyncCompletionProposalPopup(ContentAssistant contentAssistant, ITextViewer viewer, AdditionalInfoController infoController) {
        super(contentAssistant, viewer, infoController);
    }

    @Override
    public String showProposals(boolean autoActivated) {
        if (this.fKeyListener == null) {
            this.fKeyListener = new CompletionProposalPopup.ProposalSelectionListener();
        }
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        if (!Util.isValid((Widget)this.fProposalShell) && control != null && !control.isDisposed()) {
            this.fContentAssistSubjectControlAdapter.addKeyListener(this.fKeyListener);
            this.fLastCompletionOffset = this.fFilterOffset = (this.fInvocationOffset = this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
            this.computeAndPopulateProposals(this.fInvocationOffset, null, true, autoActivated, true);
        } else {
            this.fLastCompletionOffset = this.fFilterOffset;
            this.handleRepeatedInvocation();
        }
        return this.getErrorMessage();
    }

    @Override
    void handleRepeatedInvocation() {
        this.cancelFutures();
        this.computeAndPopulateProposals(this.fInvocationOffset, null, false, false, false);
    }

    private void computeAndPopulateProposals(int offset, Consumer<List<ICompletionProposal>> callback, boolean createSelector, boolean autoActivated, boolean autoInsert) {
        List<CompletableFuture<List<ICompletionProposal>>> computationFutures = this.buildCompletionFuturesOrJobs(offset);
        this.toCancelFutures.addAll(computationFutures);
        this.fComputedProposals = Collections.synchronizedList(new ArrayList());
        List<CompletableFuture> populateFutures = computationFutures.stream().map(future -> future.thenAccept(this.fComputedProposals::addAll)).collect(Collectors.toList());
        this.toCancelFutures.addAll(populateFutures);
        CompletableFuture<Void> aggregatedPopulateFuture = CompletableFuture.allOf(populateFutures.toArray(new CompletableFuture[populateFutures.size()]));
        this.toCancelFutures.add(aggregatedPopulateFuture);
        boolean useAsyncMode = false;
        try {
            aggregatedPopulateFuture.get(50L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            useAsyncMode = true;
        }
        catch (InterruptedException | ExecutionException exception) {}
        if (!useAsyncMode) {
            int count = this.fComputedProposals.size();
            if (count == 0 && this.hideWhenNoProposals(autoActivated)) {
                return;
            }
            if (autoInsert && count == 1 && !autoActivated && this.fContentAssistant.isAutoActivateCompletionOnType() && this.canAutoInsert((ICompletionProposal)this.fComputedProposals.get(0))) {
                this.insertProposal((ICompletionProposal)this.fComputedProposals.get(0), '\u0000', 0, offset);
                this.hide();
            } else {
                if (createSelector) {
                    this.createProposalSelector();
                }
                if (callback != null) {
                    callback.accept(this.fComputedProposals);
                } else {
                    this.setProposals(this.fComputedProposals, false);
                    this.displayProposals();
                }
            }
        } else {
            if (createSelector) {
                this.createProposalSelector();
            }
            ComputingProposal computingProposal = new ComputingProposal(offset, populateFutures.size());
            this.fComputedProposals.add(0, computingProposal);
            this.setProposals(this.fComputedProposals, false);
            AtomicInteger remaining = new AtomicInteger(populateFutures.size());
            List requestSpecificProposals = this.fComputedProposals;
            populateFutures = populateFutures.stream().map(future -> future.thenRun(() -> {
                Control control;
                computingProposal.setRemaining(remaining.decrementAndGet());
                if (remaining.get() == 0) {
                    requestSpecificProposals.remove(computingProposal);
                }
                if (!(control = this.fContentAssistSubjectControlAdapter.getControl()).isDisposed() && offset == this.fInvocationOffset) {
                    control.getDisplay().asyncExec(() -> {
                        if (offset != this.fInvocationOffset || this.fComputedProposals != requestSpecificProposals) {
                            return;
                        }
                        boolean stillComputing = this.fComputedProposals.contains(computingProposal);
                        if (autoInsert && !autoActivated && !stillComputing && this.fComputedProposals.size() == 1 && remaining.get() == 0 && this.canAutoInsert((ICompletionProposal)this.fComputedProposals.get(0))) {
                            if (Util.isValid((Widget)this.fProposalShell)) {
                                this.insertProposal((ICompletionProposal)this.fComputedProposals.get(0), '\u0000', 0, offset);
                                this.hide();
                            }
                            return;
                        }
                        if (!stillComputing && callback != null) {
                            callback.accept(this.fComputedProposals);
                        } else {
                            boolean hasProposals;
                            boolean bl3 = hasProposals = stillComputing && this.fComputedProposals.size() > 1 || !stillComputing && !this.fComputedProposals.isEmpty();
                            if (autoActivated && hasProposals || !autoActivated) {
                                this.setProposals(this.fComputedProposals, false);
                                this.displayProposals(true);
                            } else if (!(!Util.isValid((Widget)this.fProposalShell) || this.fProposalShell.isVisible() && hasProposals || remaining.get() != 0)) {
                                this.hide();
                            }
                        }
                    });
                }
            })).collect(Collectors.toList());
            this.toCancelFutures.addAll(populateFutures);
            this.fAggregatedPopulateFuture = CompletableFuture.allOf(populateFutures.toArray(new CompletableFuture[populateFutures.size()]));
            this.toCancelFutures.add(this.fAggregatedPopulateFuture);
        }
        this.displayProposals(!autoActivated);
    }

    @Override
    void displayProposals(boolean showPopup) {
        if (showPopup) {
            this.fPopupVisibleTimer.stop();
        }
        super.displayProposals(showPopup);
        if (!showPopup) {
            this.fPopupVisibleTimer.start();
        }
    }

    @Override
    public String incrementalComplete() {
        this.cancelFutures();
        if (Util.isValid((Widget)this.fProposalShell) && this.fFilteredProposals != null) {
            return super.incrementalComplete();
        }
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        if (this.fKeyListener == null) {
            this.fKeyListener = new CompletionProposalPopup.ProposalSelectionListener();
        }
        if (!Util.isValid((Widget)this.fProposalShell) && !control.isDisposed()) {
            this.fContentAssistSubjectControlAdapter.addKeyListener(this.fKeyListener);
        }
        this.fLastCompletionOffset = this.fFilterOffset = (this.fInvocationOffset = this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
        this.computeAndPopulateProposals(this.fInvocationOffset, proposals -> {
            this.ensureDocumentListenerInstalled();
            this.fFilteredProposals = proposals;
            if (!proposals.isEmpty() && this.completeCommonPrefix()) {
                this.hide();
            } else {
                this.setProposals((List<ICompletionProposal>)proposals, false);
                this.displayProposals();
            }
        }, true, false, true);
        return this.getErrorMessage();
    }

    @Override
    List<ICompletionProposal> computeProposals(int offset) {
        if (this.fProposalShell != null) {
            this.fProposalShell.dispose();
        }
        this.showProposals(true);
        return this.fComputedProposals;
    }

    @Override
    void createProposalSelector() {
        super.createProposalSelector();
        this.fProposalShell.addDisposeListener(e -> this.cancelFutures());
    }

    void cancelFutures() {
        this.toCancelFutures.forEach(future -> {
            boolean bl = future.cancel(true);
        });
        this.toCancelFutures.clear();
    }

    @Override
    protected List<ICompletionProposal> computeFilteredProposals(int offset, DocumentEvent event) {
        if (this.fAggregatedPopulateFuture != null && !this.fAggregatedPopulateFuture.isDone()) {
            this.fAggregatedPopulateFuture.thenRun(this::filterProposals);
            return this.fComputedProposals;
        }
        return super.computeFilteredProposals(offset, event);
    }

    @Override
    public void hide() {
        this.fPopupVisibleTimer.stop();
        super.hide();
        this.cancelFutures();
    }

    protected List<CompletableFuture<List<ICompletionProposal>>> buildCompletionFuturesOrJobs(int invocationOffset) {
        Set<IContentAssistProcessor> processors = null;
        try {
            processors = this.fContentAssistant.getContentAssistProcessors(this.getTokenContentType(invocationOffset));
        }
        catch (BadLocationException badLocationException) {}
        if (processors == null) {
            return Collections.emptyList();
        }
        ArrayList<CompletableFuture<List<ICompletionProposal>>> futures = new ArrayList<CompletableFuture<List<ICompletionProposal>>>(processors.size());
        for (IContentAssistProcessor processor : processors) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                AtomicReference result = new AtomicReference();
                SafeRunner.run(() -> {
                    ICompletionProposal[] proposals = processor.computeCompletionProposals(this.fViewer, invocationOffset);
                    if (proposals == null) {
                        result.set(Collections.emptyList());
                    } else {
                        result.set(Arrays.asList(proposals));
                    }
                });
                List proposals = (List)result.get();
                if (proposals == null) {
                    return Collections.emptyList();
                }
                return proposals;
            }));
        }
        return futures;
    }

    private String getTokenContentType(int invocationOffset) throws BadLocationException {
        if (this.fContentAssistSubjectControl != null) {
            IDocument document = this.fContentAssistSubjectControl.getDocument();
            if (document != null) {
                return TextUtilities.getContentType((IDocument)document, (String)this.fContentAssistant.getDocumentPartitioning(), (int)invocationOffset, (boolean)true);
            }
        } else {
            return TextUtilities.getContentType((IDocument)this.fViewer.getDocument(), (String)this.fContentAssistant.getDocumentPartitioning(), (int)invocationOffset, (boolean)true);
        }
        return "__dftl_partition_content_type";
    }

    private static final class ComputingProposal
    implements ICompletionProposal,
    ICompletionProposalExtension {
        private final int fOffset;
        private final int fSize;
        private int fRemaining;

        ComputingProposal(int offset, int size) {
            this.fSize = size;
            this.fRemaining = size;
            this.fOffset = offset;
        }

        @Override
        public void apply(IDocument document) {
        }

        @Override
        public Point getSelection(IDocument document) {
            return new Point(this.fOffset, 0);
        }

        @Override
        public IContextInformation getContextInformation() {
            return null;
        }

        @Override
        public Image getImage() {
            return null;
        }

        @Override
        public String getDisplayString() {
            return NLS.bind((String)JFaceTextMessages.getString("AsyncCompletionProposalPopup.computing"), (Object)Math.round(100.0 * (double)(this.fSize - this.fRemaining) / (double)this.fSize));
        }

        @Override
        public String getAdditionalProposalInfo() {
            return NLS.bind((String)JFaceTextMessages.getString("AsyncCompletionProposalPopup.computingDetails"), (Object[])new Object[]{this.fSize, this.fSize - this.fRemaining, this.fRemaining});
        }

        @Override
        public void apply(IDocument document, char trigger, int offset) {
        }

        @Override
        public boolean isValidFor(IDocument document, int offset) {
            return false;
        }

        @Override
        public char[] getTriggerCharacters() {
            return null;
        }

        @Override
        public int getContextInformationPosition() {
            return -1;
        }

        void setRemaining(int size) {
            this.fRemaining = size;
        }
    }

    private class PopupVisibleTimer
    implements Runnable {
        private Thread fThread;
        private Object fMutex = new Object();
        private int fAutoActivationDelay = 500;

        private PopupVisibleTimer() {
        }

        protected void start() {
            this.fThread = new Thread((Runnable)this, JFaceTextMessages.getString("ContentAssistant.assist_delay_timer_name"));
            this.fThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this.fMutex;
                synchronized (object) {
                    if (this.fAutoActivationDelay != 0) {
                        this.fMutex.wait(this.fAutoActivationDelay);
                    }
                }
                Optional<Display> display = Optional.ofNullable(AsyncCompletionProposalPopup.this.fContentAssistSubjectControlAdapter.getControl()).map(Widget::getDisplay);
                display.ifPresent(d -> d.asyncExec(() -> AsyncCompletionProposalPopup.this.displayProposals(true)));
            }
            catch (InterruptedException interruptedException) {}
            this.fThread = null;
        }

        protected void stop() {
            Thread threadToStop = this.fThread;
            if (threadToStop != null && threadToStop.isAlive()) {
                threadToStop.interrupt();
            }
        }
    }
}

