/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.i18n;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceHandle {
    protected UResourceBundle resources;
    private static final String BUNDLE_NAME = "Messages";

    public ResourceHandle(ULocale locale) {
        String className = this.getClass().getName();
        Object bundleName = "";
        int index = className.lastIndexOf(46);
        if (index > -1) {
            bundleName = className.substring(0, index) + ".";
        }
        bundleName = (String)bundleName + BUNDLE_NAME;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        this.resources = UResourceBundle.getBundleInstance((String)bundleName, (String)locale.toString(), (ClassLoader)this.getClass().getClassLoader());
        assert (this.resources != null) : "ResourceBundle : Messages for " + String.valueOf(locale) + " not found";
    }

    @Deprecated
    public ResourceHandle(Locale locale) {
        this(ULocale.forLocale((Locale)locale));
    }

    public String getMessage(String key) {
        if (key == null) {
            return null;
        }
        try {
            return this.resources.getString(key);
        }
        catch (MissingResourceException e) {
            assert (false) : key + " not found in resource bundle";
            return key;
        }
    }

    public String getMessage(String key, Object[] arguments) {
        String message = this.getMessage(key);
        return MessageFormat.format((String)message, (Object[])arguments);
    }

    public UResourceBundle getUResourceBundle() {
        return this.resources;
    }

    @Deprecated
    public ResourceBundle getResourceBundle() {
        return this.getUResourceBundle();
    }
}

