/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class StylePropertyMapping {
    protected static final HashMap<String, Integer> nameMapping = new HashMap();
    protected static IElementDefn styleDefn;

    static {
        nameMapping.put("fontFamily", 67);
        nameMapping.put("fontStyle", 54);
        nameMapping.put("fontVariant", 45);
        nameMapping.put("fontWeight", 44);
        nameMapping.put("fontSize", 53);
        nameMapping.put("color", 64);
        nameMapping.put("backgroundColor", 40);
        nameMapping.put("backgroundImage", 59);
        nameMapping.put("backgroundImageType", 60);
        nameMapping.put("backgroundRepeat", 25);
        nameMapping.put("backgroundAttachment", 68);
        nameMapping.put("backgroundPositionX", 55);
        nameMapping.put("backgroundPositionY", 61);
        nameMapping.put("wordSpacing", 35);
        nameMapping.put("letterSpacing", 69);
        nameMapping.put("textUnderline", 62);
        nameMapping.put("textOverline", 51);
        nameMapping.put("textLineThrough", 36);
        nameMapping.put("verticalAlign", 43);
        nameMapping.put("textTransform", 32);
        nameMapping.put("textAlign", 39);
        nameMapping.put("textIndent", 29);
        nameMapping.put("lineHeight", 63);
        nameMapping.put("whiteSpace", 57);
        nameMapping.put("marginTop", 6);
        nameMapping.put("marginBottom", 2);
        nameMapping.put("marginLeft", 0);
        nameMapping.put("marginRight", 1);
        nameMapping.put("paddingTop", 19);
        nameMapping.put("paddingBottom", 13);
        nameMapping.put("paddingLeft", 12);
        nameMapping.put("paddingRight", 16);
        nameMapping.put("borderTopWidth", 27);
        nameMapping.put("borderBottomWidth", 10);
        nameMapping.put("borderLeftWidth", 50);
        nameMapping.put("borderRightWidth", 9);
        nameMapping.put("borderTopColor", 24);
        nameMapping.put("borderBottomColor", 5);
        nameMapping.put("borderLeftColor", 47);
        nameMapping.put("borderRightColor", 4);
        nameMapping.put("borderTopStyle", 49);
        nameMapping.put("borderBottomStyle", 21);
        nameMapping.put("borderLeftStyle", 58);
        nameMapping.put("borderRightStyle", 20);
        nameMapping.put("display", 65);
        nameMapping.put("orphans", 41);
        nameMapping.put("widows", 52);
        nameMapping.put("pageBreakAfter", 66);
        nameMapping.put("pageBreakBefore", 30);
        nameMapping.put("pageBreakInside", 56);
        nameMapping.put("masterPage", 46);
        nameMapping.put("showIfBlank", 48);
        nameMapping.put("canShrink", 33);
        nameMapping.put("numberAlign", 37);
        nameMapping.put("bidiTextDirection", 17);
        nameMapping.put("data-format", 3);
    }

    protected static IElementDefn getStyleDefn() {
        if (styleDefn != null) {
            return styleDefn;
        }
        styleDefn = MetaDataDictionary.getInstance().getElement("Style");
        assert (styleDefn != null);
        return styleDefn;
    }

    public static boolean canInherit(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.canInherit();
        }
        return false;
    }

    public static Object getDefaultValue(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.getDefault();
        }
        return null;
    }

    public static Object getDefaultValue(String name, ReportDesignHandle handle) {
        Object value = StylePropertyMapping.getDefaultValue(name);
        if (value == null && handle != null && handle.isDirectionRTL() && "bidiTextDirection".equals(name)) {
            return "rtl";
        }
        return value;
    }

    public static Object getDefaultValue(int index) {
        return StylePropertyMapping.getDefaultValue(nameMapping.get(index).toString());
    }

    public static int getPropertyID(String name) {
        int id = -1;
        Integer obj = nameMapping.get(name);
        if (obj instanceof Integer) {
            id = obj;
        }
        return id;
    }

    public static Set<?> getPropertyMapping() {
        return nameMapping.entrySet();
    }
}

