/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.filer;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.AptCompilationParticipant;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.apt.pluggable.core.Apt6Plugin;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeAnnotationProcessorManager;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeProcessingEnvImpl;
import org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeInputFileObject;
import org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeOutputClassFileObject;
import org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeOutputJavaFileObject;
import org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeOutputNonSourceFileObject;

public class IdeFilerImpl
implements Filer {
    private final IdeProcessingEnvImpl _env;

    public IdeFilerImpl(IdeAnnotationProcessorManager dispatchManager, IdeProcessingEnvImpl env) {
        this._env = env;
    }

    @Override
    public JavaFileObject createClassFile(CharSequence name, Element ... originatingElements) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        String nameAsString = name.toString();
        IFile file = this._env.getAptProject().getGeneratedFileManager(this._env.isTestCode()).getIFileForTypeName(nameAsString);
        GeneratedSourceFolderManager gsfm = this._env.getAptProject().getGeneratedSourceFolderManager(this._env.isTestCode());
        IPath path = null;
        try {
            path = gsfm.getBinaryOutputLocation();
        }
        catch (JavaModelException e) {
            Apt6Plugin.log(e, "Failure getting the binary output location");
            throw new IOException(e);
        }
        int index = nameAsString.lastIndexOf(46);
        String pkg = null;
        if (index != -1) {
            name = nameAsString.substring(index + 1);
            pkg = nameAsString.substring(0, index);
        } else {
            pkg = "";
        }
        file = this.getFileFromOutputLocation(StandardLocation.CLASS_OUTPUT, pkg, String.valueOf(name) + ".class");
        path = path.append(nameAsString);
        path = new Path(path.toString() + ".class");
        return new IdeOutputClassFileObject(this._env, file, nameAsString);
    }

    @Override
    public FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
        Set<IFile> parentFiles;
        if (location == null) {
            throw new IllegalArgumentException("Location is null");
        }
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException("Location " + location.getName() + " is not an output location");
        }
        if (pkg == null) {
            throw new IllegalArgumentException("Package is null");
        }
        if (relativeName == null) {
            throw new IllegalArgumentException("Relative name is null");
        }
        if (relativeName.length() == 0) {
            throw new IllegalArgumentException("Relative name is zero length");
        }
        IFile file = this.getFileFromOutputLocation(location, pkg, relativeName);
        if (AptCompilationParticipant.getInstance().getJava6GeneratedFiles().contains(file)) {
            throw new FilerException("Source file already created: " + String.valueOf(file.getFullPath()));
        }
        if (originatingElements != null && originatingElements.length > 0) {
            parentFiles = new HashSet(originatingElements.length);
            Element[] elementArray = originatingElements;
            int n = originatingElements.length;
            int n2 = 0;
            while (n2 < n) {
                Element elem = elementArray[n2];
                IFile enclosing = this._env.getEnclosingIFile(elem);
                if (enclosing != null) {
                    parentFiles.add(enclosing);
                }
                ++n2;
            }
        } else {
            parentFiles = Collections.emptySet();
        }
        return new IdeOutputNonSourceFileObject(this._env, file, parentFiles);
    }

    @Override
    public JavaFileObject createSourceFile(CharSequence name, Element ... originatingElements) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        IFile file = this._env.getAptProject().getGeneratedFileManager(this._env.isTestCode()).getIFileForTypeName(name.toString());
        if (AptCompilationParticipant.getInstance().getJava6GeneratedFiles().contains(file)) {
            throw new FilerException("Source file already created: " + String.valueOf(file.getFullPath()));
        }
        Set<IFile> parentFiles = Collections.emptySet();
        if (originatingElements != null && originatingElements.length > 0) {
            parentFiles = new HashSet<IFile>(originatingElements.length);
            Element[] elementArray = originatingElements;
            int n = originatingElements.length;
            int n2 = 0;
            while (n2 < n) {
                Element elem = elementArray[n2];
                IFile enclosing = this._env.getEnclosingIFile(elem);
                if (enclosing != null) {
                    parentFiles.add(enclosing);
                }
                ++n2;
            }
        }
        return new IdeOutputJavaFileObject(this._env, name, parentFiles);
    }

    @Override
    public FileObject getResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName) throws IOException {
        IFile file = this.getFileFromOutputLocation(location, pkg, relativeName);
        return new IdeInputFileObject(file);
    }

    protected IFile getFileFromOutputLocation(JavaFileManager.Location loc, CharSequence pkg, CharSequence relPath) throws IOException {
        GeneratedSourceFolderManager gsfm = this._env.getAptProject().getGeneratedSourceFolderManager(this._env.isTestCode());
        IPath path = null;
        if (loc == StandardLocation.CLASS_OUTPUT) {
            try {
                path = gsfm.getBinaryOutputLocation();
            }
            catch (JavaModelException e) {
                Apt6Plugin.log(e, "Failure getting the binary output location");
                throw new IOException(e);
            }
        } else if (loc == StandardLocation.SOURCE_OUTPUT) {
            path = gsfm.getFolder().getProjectRelativePath();
        } else {
            throw new IllegalArgumentException("Unsupported location: " + String.valueOf(loc));
        }
        if (pkg.length() > 0) {
            path = path.append(pkg.toString().replace('.', File.separatorChar));
        }
        path = path.append(relPath.toString());
        IFile file = this._env.getProject().getFile(path);
        this.validatePath(file);
        return file;
    }

    private void validatePath(IFile file) throws IOException {
        IStatus status = this._env.getProject().getWorkspace().validatePath(file.getFullPath().toOSString(), 1);
        if (!status.isOK()) {
            CoreException ce = new CoreException(status);
            throw new IOException("Invalid path: " + file.toString(), (Throwable)ce);
        }
    }
}

